/* tp-backend.c generated by valac 0.11.2.11-bbde6, the Vala compiler
 * generated from tp-backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <telepathy-glib/telepathy-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks-telepathy.h>


#define FOLKS_BACKENDS_TP_TYPE_BACKEND (folks_backends_tp_backend_get_type ())
#define FOLKS_BACKENDS_TP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_TP_TYPE_BACKEND, FolksBackendsTpBackend))
#define FOLKS_BACKENDS_TP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_TP_TYPE_BACKEND, FolksBackendsTpBackendClass))
#define FOLKS_BACKENDS_TP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_TP_TYPE_BACKEND))
#define FOLKS_BACKENDS_TP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_TP_TYPE_BACKEND))
#define FOLKS_BACKENDS_TP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_TP_TYPE_BACKEND, FolksBackendsTpBackendClass))

typedef struct _FolksBackendsTpBackend FolksBackendsTpBackend;
typedef struct _FolksBackendsTpBackendClass FolksBackendsTpBackendClass;
typedef struct _FolksBackendsTpBackendPrivate FolksBackendsTpBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _FolksBackendsTpBackendPrepareData FolksBackendsTpBackendPrepareData;
typedef struct _FolksBackendsTpBackendUnprepareData FolksBackendsTpBackendUnprepareData;

struct _FolksBackendsTpBackend {
	FolksBackend parent_instance;
	FolksBackendsTpBackendPrivate * priv;
};

struct _FolksBackendsTpBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsTpBackendPrivate {
	TpAccountManager* account_manager;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	GHashTable* _persona_stores;
};

struct _FolksBackendsTpBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsTpBackend* self;
	TpAccountManager* _tmp0_;
	TpAccountManager* _tmp1_;
	GList* _tmp2_;
	GList* accounts;
	GList* account_collection;
	GList* account_it;
	TpAccount* _tmp3_;
	TpAccount* account;
	GError * _inner_error_;
};

struct _FolksBackendsTpBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsTpBackend* self;
	guint _tmp0_;
	guint _tmp1_;
	TpAccountManager* _tmp2_;
};


static gpointer folks_backends_tp_backend_parent_class = NULL;

GType folks_backends_tp_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_TP_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_TP_TYPE_BACKEND, FolksBackendsTpBackendPrivate))
enum  {
	FOLKS_BACKENDS_TP_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_TP_BACKEND_NAME,
	FOLKS_BACKENDS_TP_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_TP_BACKEND_IS_PREPARED
};
FolksBackendsTpBackend* folks_backends_tp_backend_new (void);
FolksBackendsTpBackend* folks_backends_tp_backend_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void folks_backends_tp_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_tp_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_backends_tp_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backends_tp_backend_real_prepare_co (FolksBackendsTpBackendPrepareData* data);
static void folks_backends_tp_backend_account_enabled_cb (FolksBackendsTpBackend* self, TpAccount* account);
static void _folks_backends_tp_backend_account_enabled_cb_tp_account_manager_account_enabled (TpAccountManager* _sender, TpAccount* object, gpointer self);
static void _lambda0_ (TpAccount* a, gboolean valid, FolksBackendsTpBackend* self);
static void __lambda0__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* object, gboolean p0, gpointer self);
static void folks_backends_tp_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_tp_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_backends_tp_backend_unprepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backends_tp_backend_real_unprepare_co (FolksBackendsTpBackendUnprepareData* data);
static void folks_backends_tp_backend_account_validity_changed_cb (FolksBackendsTpBackend* self, TpAccount* account, gboolean valid);
static void _folks_backends_tp_backend_account_validity_changed_cb_tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* object, gboolean p0, gpointer self);
static void _lambda1_ (const gchar* k, FolksPersonaStore* v, FolksBackendsTpBackend* self);
static void __lambda1__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_backends_tp_backend_store_removed_cb (FolksBackendsTpBackend* self, FolksPersonaStore* store);
static void _folks_backends_tp_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_tp_backend_finalize (GObject* obj);
static void _vala_folks_backends_tp_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
   * {@inheritDoc}
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


FolksBackendsTpBackend* folks_backends_tp_backend_construct (GType object_type) {
	FolksBackendsTpBackend * self = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	self = (FolksBackendsTpBackend*) folks_backend_construct (object_type);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	_g_hash_table_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp1_;
	return self;
}


FolksBackendsTpBackend* folks_backends_tp_backend_new (void) {
	return folks_backends_tp_backend_construct (FOLKS_BACKENDS_TP_TYPE_BACKEND);
}


static void folks_backends_tp_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsTpBackendPrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsTpBackendPrepareData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_tp_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsTpBackend * self;
	FolksBackendsTpBackendPrepareData* _data_;
	self = (FolksBackendsTpBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsTpBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_tp_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_tp_backend_real_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_tp_backend_real_prepare_co (_data_);
}


static void folks_backends_tp_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsTpBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backends_tp_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsTpBackendPrepareData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backends_tp_backend_real_prepare_co (data);
}


/**
   * {@inheritDoc}
   */
static void _folks_backends_tp_backend_account_enabled_cb_tp_account_manager_account_enabled (TpAccountManager* _sender, TpAccount* object, gpointer self) {
	folks_backends_tp_backend_account_enabled_cb (self, object);
}


static void _lambda0_ (TpAccount* a, gboolean valid, FolksBackendsTpBackend* self) {
	g_return_if_fail (a != NULL);
	if (valid) {
		folks_backends_tp_backend_account_enabled_cb (self, a);
	}
}


static void __lambda0__tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* object, gboolean p0, gpointer self) {
	_lambda0_ (object, p0, self);
}


static gboolean folks_backends_tp_backend_real_prepare_co (FolksBackendsTpBackendPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			data->_tmp0_ = NULL;
			data->_tmp0_ = tp_account_manager_dup ();
			data->_tmp1_ = data->_tmp0_;
			_g_object_unref0 (data->self->priv->account_manager);
			data->self->priv->account_manager = data->_tmp1_;
			data->_state_ = 1;
			tp_proxy_prepare_async ((TpProxy*) data->self->priv->account_manager, NULL, folks_backends_tp_backend_prepare_ready, data);
			return FALSE;
			_state_1:
			tp_proxy_prepare_finish ((TpProxy*) data->self->priv->account_manager, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __finally0;
			}
			g_signal_connect_object (data->self->priv->account_manager, "account-enabled", (GCallback) _folks_backends_tp_backend_account_enabled_cb_tp_account_manager_account_enabled, data->self, 0);
			g_signal_connect_object (data->self->priv->account_manager, "account-validity-changed", (GCallback) __lambda0__tp_account_manager_account_validity_changed, data->self, 0);
			data->_tmp2_ = NULL;
			data->_tmp2_ = tp_account_manager_get_valid_accounts (data->self->priv->account_manager);
			data->accounts = data->_tmp2_;
			{
				data->account_collection = data->accounts;
				for (data->account_it = data->account_collection; data->account_it != NULL; data->account_it = data->account_it->next) {
					data->_tmp3_ = _g_object_ref0 ((TpAccount*) data->account_it->data);
					data->account = data->_tmp3_;
					{
						folks_backends_tp_backend_account_enabled_cb (data->self, data->account);
						_g_object_unref0 (data->account);
					}
				}
			}
			data->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) data->self, "is-prepared");
			_g_list_free0 (data->accounts);
		}
		__finally0:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_tp_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsTpBackendUnprepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsTpBackendUnprepareData, data);
}


static void folks_backends_tp_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsTpBackend * self;
	FolksBackendsTpBackendUnprepareData* _data_;
	self = (FolksBackendsTpBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsTpBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_tp_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_tp_backend_real_unprepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_tp_backend_real_unprepare_co (_data_);
}


static void folks_backends_tp_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsTpBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backends_tp_backend_unprepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsTpBackendUnprepareData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backends_tp_backend_real_unprepare_co (data);
}


/**
   * {@inheritDoc}
   */
static void _folks_backends_tp_backend_account_validity_changed_cb_tp_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* object, gboolean p0, gpointer self) {
	folks_backends_tp_backend_account_validity_changed_cb (self, object, p0);
}


static void _lambda1_ (const gchar* k, FolksPersonaStore* v, FolksBackendsTpBackend* self) {
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", FOLKS_PERSONA_STORE (v));
}


static void __lambda1__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda1_ (key, value, self);
}


static gboolean folks_backends_tp_backend_real_unprepare_co (FolksBackendsTpBackendUnprepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_signal_parse_name ("account-enabled", TP_TYPE_ACCOUNT_MANAGER, &data->_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (data->self->priv->account_manager, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, data->_tmp0_, 0, NULL, (GCallback) _folks_backends_tp_backend_account_enabled_cb_tp_account_manager_account_enabled, data->self);
	g_signal_parse_name ("account-validity-changed", TP_TYPE_ACCOUNT_MANAGER, &data->_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (data->self->priv->account_manager, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, data->_tmp1_, 0, NULL, (GCallback) _folks_backends_tp_backend_account_validity_changed_cb_tp_account_manager_account_validity_changed, data->self);
	data->_tmp2_ = NULL;
	_g_object_unref0 (data->self->priv->account_manager);
	data->self->priv->account_manager = data->_tmp2_;
	g_hash_table_foreach (data->self->priv->_persona_stores, __lambda1__gh_func, data->self);
	g_hash_table_remove_all (data->self->priv->_persona_stores);
	g_object_notify ((GObject*) data->self, "persona-stores");
	data->self->priv->_is_prepared = FALSE;
	g_object_notify ((GObject*) data->self, "is-prepared");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_tp_backend_account_validity_changed_cb (FolksBackendsTpBackend* self, TpAccount* account, gboolean valid) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	if (valid) {
		folks_backends_tp_backend_account_enabled_cb (self, account);
	}
}


static void _folks_backends_tp_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	folks_backends_tp_backend_store_removed_cb (self, _sender);
}


static void folks_backends_tp_backend_account_enabled_cb (FolksBackendsTpBackend* self, TpAccount* account) {
	const gchar* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* store;
	TpfPersonaStore* _tmp3_ = NULL;
	FolksPersonaStore* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	FolksPersonaStore* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = tp_proxy_get_object_path ((TpProxy*) account);
	_tmp1_ = g_hash_table_lookup (self->priv->_persona_stores, _tmp0_);
	_tmp2_ = _g_object_ref0 ((FolksPersonaStore*) _tmp1_);
	store = _tmp2_;
	if (store != NULL) {
		_g_object_unref0 (store);
		return;
	}
	_tmp3_ = tpf_persona_store_new (account);
	_tmp4_ = (FolksPersonaStore*) _tmp3_;
	_g_object_unref0 (store);
	store = _tmp4_;
	_tmp5_ = folks_persona_store_get_id (store);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _g_object_ref0 (store);
	g_hash_table_insert (self->priv->_persona_stores, _tmp6_, _tmp7_);
	g_signal_connect_object (store, "removed", (GCallback) _folks_backends_tp_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	g_object_notify ((GObject*) self, "persona-stores");
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", store);
	_g_object_unref0 (store);
}


static void folks_backends_tp_backend_store_removed_cb (FolksBackendsTpBackend* self, FolksPersonaStore* store) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", store);
	_tmp0_ = folks_persona_store_get_id (store);
	g_hash_table_remove (self->priv->_persona_stores, _tmp0_);
	g_object_notify ((GObject*) self, "persona-stores");
}


static const gchar* folks_backends_tp_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsTpBackend* self;
	self = (FolksBackendsTpBackend*) base;
	result = "telepathy";
	return result;
}


static GHashTable* folks_backends_tp_backend_real_get_persona_stores (FolksBackend* base) {
	GHashTable* result;
	FolksBackendsTpBackend* self;
	self = (FolksBackendsTpBackend*) base;
	result = self->priv->_persona_stores;
	return result;
}


static gboolean folks_backends_tp_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsTpBackend* self;
	self = (FolksBackendsTpBackend*) base;
	result = self->priv->_is_prepared;
	return result;
}


static void folks_backends_tp_backend_class_init (FolksBackendsTpBackendClass * klass) {
	folks_backends_tp_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsTpBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_tp_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_tp_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_tp_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_tp_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_tp_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_tp_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_tp_backend_real_get_is_prepared;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_tp_backend_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_tp_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TP_BACKEND_NAME, "name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TP_BACKEND_PERSONA_STORES, "persona-stores");
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TP_BACKEND_IS_PREPARED, "is-prepared");
}


static void folks_backends_tp_backend_instance_init (FolksBackendsTpBackend * self) {
	self->priv = FOLKS_BACKENDS_TP_BACKEND_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_backends_tp_backend_finalize (GObject* obj) {
	FolksBackendsTpBackend * self;
	self = FOLKS_BACKENDS_TP_BACKEND (obj);
	_g_object_unref0 (self->priv->account_manager);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_hash_table_unref0 (self->priv->_persona_stores);
	G_OBJECT_CLASS (folks_backends_tp_backend_parent_class)->finalize (obj);
}


/**
 * A backend which connects to the Telepathy accounts service and creates a
 * {@link PersonaStore} for each valid account known to Telepathy.
 */
GType folks_backends_tp_backend_get_type (void) {
	static volatile gsize folks_backends_tp_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_tp_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsTpBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_tp_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsTpBackend), 0, (GInstanceInitFunc) folks_backends_tp_backend_instance_init, NULL };
		GType folks_backends_tp_backend_type_id;
		folks_backends_tp_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsTpBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_tp_backend_type_id__volatile, folks_backends_tp_backend_type_id);
	}
	return folks_backends_tp_backend_type_id__volatile;
}


static void _vala_folks_backends_tp_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsTpBackend * self;
	self = FOLKS_BACKENDS_TP_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_TP_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_TP_BACKEND_PERSONA_STORES:
		g_value_set_boxed (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_TP_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



