/* folks.vapi generated by valac 0.11.6, do not modify. */

[CCode (cprefix = "Folks", lower_case_cprefix = "folks_")]
namespace Folks {
	[CCode (cheader_filename = "folks.h")]
	public abstract class Backend : GLib.Object {
		public Backend ();
		public abstract async void prepare () throws GLib.Error;
		public abstract async void unprepare () throws GLib.Error;
		public abstract bool is_prepared { get; }
		public abstract string name { get; }
		public abstract GLib.HashTable<string,Folks.PersonaStore> persona_stores { get; }
		public signal void persona_store_added (Folks.PersonaStore store);
		public signal void persona_store_removed (Folks.PersonaStore store);
	}
	[CCode (cheader_filename = "folks.h")]
	public class BackendStore : GLib.Object {
		public void add_backend (Folks.Backend backend);
		public async void disable_backend (string name);
		public static Folks.BackendStore dup ();
		public Folks.Backend? dup_backend_by_name (string name);
		public async void enable_backend (string name);
		public Gee.Collection<Folks.Backend> list_backends ();
		public async void load_backends () throws GLib.Error;
		public async void prepare ();
		public GLib.List<Folks.Backend> enabled_backends {
		[CCode (cname = "folks_backend_store_dup_enabled_backends")] owned get; private set; }
		public bool is_prepared { get; private set; }
		public signal void backend_available (Folks.Backend backend);
	}
	[CCode (cheader_filename = "folks.h")]
	public class FieldDetails : GLib.Object {
		public FieldDetails (string value);
		public void add_parameter (string parameter_name, string parameter_value);
		public void extend_parameters (GLib.HashTable<string,GLib.List<string>> additional);
		public unowned GLib.List<string> get_parameter_values (string parameter_name);
		public void remove_parameter_all (string parameter_name);
		public void set_parameter (string parameter_name, string parameter_value);
		public GLib.HashTable<string,GLib.List<string>> parameters { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public class Individual : GLib.Object, Folks.Aliasable, Folks.Emailable, Folks.Favouritable, Folks.GenderOwner, Folks.Groupable, Folks.AvatarOwner, Folks.PresenceOwner, Folks.IMable, Folks.NameOwner, Folks.Phoneable, Folks.Urlable {
		public Individual (GLib.List<Folks.Persona>? personas);
		public string id { get; private set; }
		public bool is_user { get; private set; }
		public GLib.List<Folks.Persona> personas { get; set; }
		public Folks.TrustLevel trust_level { get; private set; }
		public signal void personas_changed (GLib.List<Folks.Persona>? added, GLib.List<Folks.Persona>? removed);
		public signal void removed (Folks.Individual? replacement_individual);
	}
	[CCode (cheader_filename = "folks.h")]
	public class IndividualAggregator : GLib.Object {
		public IndividualAggregator ();
		public async Folks.Persona? add_persona_from_details (Folks.Individual? parent, Folks.PersonaStore persona_store, GLib.HashTable<string,GLib.Value?> details) throws Folks.IndividualAggregatorError;
		public async void link_personas (void* personas_in) throws Folks.IndividualAggregatorError;
		public async void prepare () throws GLib.Error;
		public async void remove_individual (Folks.Individual individual) throws GLib.Error;
		public async void remove_persona (Folks.Persona persona) throws GLib.Error;
		public async void unlink_individual (Folks.Individual individual) throws GLib.Error;
		public GLib.HashTable<string,Folks.Individual> individuals { get; private set; }
		public bool is_prepared { get; }
		public Folks.Individual user { get; private set; }
		public signal void individuals_changed (GLib.List<Folks.Individual>? added, GLib.List<Folks.Individual>? removed, string? message, Folks.Persona? actor, Folks.Groupable.ChangeReason reason);
	}
	[CCode (cheader_filename = "folks.h")]
	public class LinkedHashSet<G> : Gee.AbstractList<G>, Gee.Set<G> {
		public LinkedHashSet (GLib.HashFunc? hash_func = null, GLib.EqualFunc? equal_func = null);
		public override bool add (G item);
		public override bool add_all (Gee.Collection<G> collection);
		public override void clear ();
		public override bool contains (G item);
		public override G first ();
		public override G @get (int index);
		public override int index_of (G item);
		public override void insert (int index, G item);
		public override Gee.Iterator<G> iterator ();
		public override G last ();
		public override Gee.ListIterator<G> list_iterator ();
		public override bool remove (G item);
		public override G remove_at (int index);
		public override void @set (int index, G item);
		public override Gee.List<G>? slice (int start, int stop);
		public override int size { get; }
	}
	[CCode (cheader_filename = "folks.h")]
	public abstract class Persona : GLib.Object {
		[CCode (cheader_filename = "folks.h")]
		public delegate void LinkablePropertyCallback (string link);
		public Persona ();
		public static string build_uid (string backend_name, string persona_store_id, string persona_id);
		public virtual void linkable_property_to_links (string prop_name, Folks.Persona.LinkablePropertyCallback callback);
		public static void split_uid (string uid, out string backend_name, out string persona_store_id, out string persona_id);
		public string display_id { get; construct; }
		public string iid { get; construct; }
		public bool is_user { get; construct; }
		public abstract string[] linkable_properties { get; }
		public Folks.PersonaStore store { get; construct; }
		public string uid { get; construct; }
	}
	[CCode (cheader_filename = "folks.h")]
	public abstract class PersonaStore : GLib.Object {
		public PersonaStore ();
		public abstract async Folks.Persona? add_persona_from_details (GLib.HashTable<string,GLib.Value?> details) throws Folks.PersonaStoreError;
		public virtual async void flush ();
		public abstract async void prepare () throws GLib.Error;
		public abstract async void remove_persona (Folks.Persona persona) throws GLib.Error;
		public abstract Folks.MaybeBool can_add_personas { get; }
		public abstract Folks.MaybeBool can_alias_personas { get; }
		public abstract Folks.MaybeBool can_group_personas { get; }
		public abstract Folks.MaybeBool can_remove_personas { get; }
		public string display_name { get; construct; }
		public string id { get; construct; }
		public abstract bool is_prepared { get; }
		public bool is_writeable { get; set; }
		public abstract GLib.HashTable<string,Folks.Persona> personas { get; }
		public Folks.PersonaStoreTrust trust_level { get; set; }
		public abstract string type_id { get; }
		public signal void personas_changed (GLib.List<Folks.Persona>? added, GLib.List<Folks.Persona>? removed, string? message, Folks.Persona? actor, Folks.Groupable.ChangeReason reason);
		public signal void removed ();
	}
	[CCode (cheader_filename = "folks.h")]
	public class StructuredName : GLib.Object {
		public StructuredName (string? family_name, string? given_name, string? additional_names, string? prefixes, string? suffixes);
		public bool is_empty ();
		public StructuredName.simple (string? family_name, string? given_name);
		public string additional_names { get; set construct; }
		public string family_name { get; set construct; }
		public string given_name { get; set construct; }
		public string prefixes { get; set construct; }
		public string suffixes { get; set construct; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Aliasable : GLib.Object {
		public abstract string alias { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface AvatarOwner : GLib.Object {
		public abstract GLib.File avatar { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Emailable : GLib.Object {
		public abstract GLib.List<Folks.FieldDetails> email_addresses { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Favouritable : GLib.Object {
		public abstract bool is_favourite { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface GenderOwner : GLib.Object {
		public abstract Folks.Gender gender { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Groupable : GLib.Object {
		[CCode (cprefix = "FOLKS_GROUPABLE_CHANGE_REASON_", cheader_filename = "folks.h")]
		public enum ChangeReason {
			NONE,
			OFFLINE,
			KICKED,
			BUSY,
			INVITED,
			BANNED,
			ERROR,
			INVALID_MEMBER,
			NO_ANSWER,
			RENAMED,
			PERMISSION_DENIED,
			SEPARATED
		}
		public abstract async void change_group (string group, bool is_member) throws GLib.Error;
		public abstract GLib.HashTable<string,bool> groups { get; set; }
		public signal void group_changed (string group, bool is_member);
	}
	[CCode (cheader_filename = "folks.h")]
	public interface IMable : GLib.Object {
		public static string normalise_im_address (string im_address, string protocol) throws Folks.IMableError;
		public abstract GLib.HashTable<string,Folks.LinkedHashSet<string>> im_addresses { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface NameOwner : GLib.Object {
		public abstract string full_name { get; set; }
		public abstract string nickname { get; }
		public abstract Folks.StructuredName structured_name { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Phoneable : GLib.Object {
		public abstract GLib.List<Folks.FieldDetails> phone_numbers { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface PresenceOwner : GLib.Object {
		public bool is_online ();
		public static int typecmp (Folks.PresenceType type_a, Folks.PresenceType type_b);
		public abstract string presence_message { get; set; }
		public abstract Folks.PresenceType presence_type { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Urlable : GLib.Object {
		public abstract GLib.List<Folks.FieldDetails> urls { get; set; }
	}
	[CCode (cprefix = "FOLKS_GENDER_", cheader_filename = "folks.h")]
	public enum Gender {
		UNSPECIFIED,
		MALE,
		FEMALE
	}
	[CCode (cprefix = "FOLKS_MAYBE_BOOL_", cheader_filename = "folks.h")]
	public enum MaybeBool {
		UNSET,
		FALSE,
		TRUE
	}
	[CCode (cprefix = "FOLKS_PERSONA_STORE_TRUST_", cheader_filename = "folks.h")]
	public enum PersonaStoreTrust {
		NONE,
		PARTIAL,
		FULL
	}
	[CCode (cprefix = "FOLKS_PRESENCE_TYPE_", cheader_filename = "folks.h")]
	public enum PresenceType {
		UNSET,
		OFFLINE,
		AVAILABLE,
		AWAY,
		EXTENDED_AWAY,
		HIDDEN,
		BUSY,
		UNKNOWN,
		ERROR
	}
	[CCode (cprefix = "FOLKS_TRUST_LEVEL_", cheader_filename = "folks.h")]
	public enum TrustLevel {
		NONE,
		PERSONAS
	}
	[CCode (cprefix = "FOLKS_IMABLE_ERROR_", cheader_filename = "folks.h")]
	public errordomain IMableError {
		INVALID_IM_ADDRESS,
	}
	[CCode (cprefix = "FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_", cheader_filename = "folks.h")]
	public errordomain IndividualAggregatorError {
		ADD_FAILED,
		NO_WRITEABLE_STORE,
		STORE_OFFLINE,
	}
	[CCode (cprefix = "FOLKS_PERSONA_STORE_ERROR_", cheader_filename = "folks.h")]
	public errordomain PersonaStoreError {
		INVALID_ARGUMENT,
		CREATE_FAILED,
		UNSUPPORTED_ON_USER,
		STORE_OFFLINE,
		READ_ONLY,
	}
}
