// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gnome.Vfs {

	using System;
	using System.Collections;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public class Uri : GLib.Opaque {

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_make_full_from_relative(string base_uri, string relative_uri);

		public static string MakeFullFromRelative(string base_uri, string relative_uri) {
			IntPtr raw_ret = gnome_vfs_uri_make_full_from_relative(base_uri, relative_uri);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_get_password(IntPtr raw);

		[DllImport("libgnomevfs-2-0.dll")]
		static extern void gnome_vfs_uri_set_password(IntPtr raw, string password);

		public string Password { 
			get {
				IntPtr raw_ret = gnome_vfs_uri_get_password(Handle);
				string ret = Marshal.PtrToStringAnsi(raw_ret);
				return ret;
			}
			set {
				gnome_vfs_uri_set_password(Handle, value);
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_get_fragment_identifier(IntPtr raw);

		public string FragmentIdentifier { 
			get {
				IntPtr raw_ret = gnome_vfs_uri_get_fragment_identifier(Handle);
				string ret = Marshal.PtrToStringAnsi(raw_ret);
				return ret;
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern uint gnome_vfs_uri_get_host_port(IntPtr raw);

		[DllImport("libgnomevfs-2-0.dll")]
		static extern void gnome_vfs_uri_set_host_port(IntPtr raw, uint host_port);

		public uint HostPort { 
			get {
				uint raw_ret = gnome_vfs_uri_get_host_port(Handle);
				uint ret = raw_ret;
				return ret;
			}
			set {
				gnome_vfs_uri_set_host_port(Handle, value);
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_resolve_relative(IntPtr raw, string relative_reference);

		public Gnome.Vfs.Uri ResolveRelative(string relative_reference) {
			IntPtr raw_ret = gnome_vfs_uri_resolve_relative(Handle, relative_reference);
			Gnome.Vfs.Uri ret;
			if (raw_ret == IntPtr.Zero)
				ret = null;
			else
				ret = new Gnome.Vfs.Uri(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_extract_short_name(IntPtr raw);

		public string ExtractShortName() {
			IntPtr raw_ret = gnome_vfs_uri_extract_short_name(Handle);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_append_file_name(IntPtr raw, string filename);

		public Gnome.Vfs.Uri AppendFileName(string filename) {
			IntPtr raw_ret = gnome_vfs_uri_append_file_name(Handle, filename);
			Gnome.Vfs.Uri ret;
			if (raw_ret == IntPtr.Zero)
				ret = null;
			else
				ret = new Gnome.Vfs.Uri(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_get_path(IntPtr raw);

		public string Path { 
			get {
				IntPtr raw_ret = gnome_vfs_uri_get_path(Handle);
				string ret = Marshal.PtrToStringAnsi(raw_ret);
				return ret;
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern bool gnome_vfs_uri_is_local(IntPtr raw);

		public bool IsLocal { 
			get {
				bool raw_ret = gnome_vfs_uri_is_local(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern bool gnome_vfs_uri_is_parent(IntPtr raw, IntPtr possible_child, bool recursive);

		public bool IsParent(Gnome.Vfs.Uri possible_child, bool recursive) {
			bool raw_ret = gnome_vfs_uri_is_parent(Handle, possible_child.Handle, recursive);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_get_user_name(IntPtr raw);

		[DllImport("libgnomevfs-2-0.dll")]
		static extern void gnome_vfs_uri_set_user_name(IntPtr raw, string user_name);

		public string UserName { 
			get {
				IntPtr raw_ret = gnome_vfs_uri_get_user_name(Handle);
				string ret = Marshal.PtrToStringAnsi(raw_ret);
				return ret;
			}
			set {
				gnome_vfs_uri_set_user_name(Handle, value);
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_dup(IntPtr raw);

		public Gnome.Vfs.Uri Clone() {
			IntPtr raw_ret = gnome_vfs_uri_dup(Handle);
			Gnome.Vfs.Uri ret;
			if (raw_ret == IntPtr.Zero)
				ret = null;
			else
				ret = new Gnome.Vfs.Uri(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_append_path(IntPtr raw, string path);

		public Gnome.Vfs.Uri AppendPath(string path) {
			IntPtr raw_ret = gnome_vfs_uri_append_path(Handle, path);
			Gnome.Vfs.Uri ret;
			if (raw_ret == IntPtr.Zero)
				ret = null;
			else
				ret = new Gnome.Vfs.Uri(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_extract_short_path_name(IntPtr raw);

		public string ExtractShortPathName() {
			IntPtr raw_ret = gnome_vfs_uri_extract_short_path_name(Handle);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_get_host_name(IntPtr raw);

		[DllImport("libgnomevfs-2-0.dll")]
		static extern void gnome_vfs_uri_set_host_name(IntPtr raw, string host_name);

		public string HostName { 
			get {
				IntPtr raw_ret = gnome_vfs_uri_get_host_name(Handle);
				string ret = Marshal.PtrToStringAnsi(raw_ret);
				return ret;
			}
			set {
				gnome_vfs_uri_set_host_name(Handle, value);
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_get_scheme(IntPtr raw);

		public string Scheme { 
			get {
				IntPtr raw_ret = gnome_vfs_uri_get_scheme(Handle);
				string ret = Marshal.PtrToStringAnsi(raw_ret);
				return ret;
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_extract_dirname(IntPtr raw);

		public string ExtractDirname() {
			IntPtr raw_ret = gnome_vfs_uri_extract_dirname(Handle);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern bool gnome_vfs_uri_exists(IntPtr raw);

		public bool Exists { 
			get {
				bool raw_ret = gnome_vfs_uri_exists(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_to_string(IntPtr raw, int hide_options);

		public string ToString(Gnome.Vfs.UriHideOptions hide_options) {
			IntPtr raw_ret = gnome_vfs_uri_to_string(Handle, (int) hide_options);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_append_string(IntPtr raw, string uri_fragment);

		public Gnome.Vfs.Uri AppendString(string uri_fragment) {
			IntPtr raw_ret = gnome_vfs_uri_append_string(Handle, uri_fragment);
			Gnome.Vfs.Uri ret;
			if (raw_ret == IntPtr.Zero)
				ret = null;
			else
				ret = new Gnome.Vfs.Uri(raw_ret);
			return ret;
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_get_parent(IntPtr raw);

		public Gnome.Vfs.Uri Parent { 
			get {
				IntPtr raw_ret = gnome_vfs_uri_get_parent(Handle);
				Gnome.Vfs.Uri ret;
				if (raw_ret == IntPtr.Zero)
					ret = null;
				else
					ret = new Gnome.Vfs.Uri(raw_ret);
				return ret;
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern bool gnome_vfs_uri_has_parent(IntPtr raw);

		public bool HasParent { 
			get {
				bool raw_ret = gnome_vfs_uri_has_parent(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		public Uri(IntPtr raw) : base(raw) {}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_new(string text_uri);

		public Uri (string text_uri) 
		{
			Raw = gnome_vfs_uri_new(text_uri);
		}

#endregion
#region Customized extensions
#line 1 "Uri.custom"
//  Uri.custom - Uri class customizations.
//
//  Authors:  Jeroen Zwartepoorte  <jeroen@xs4all.nl>
//
//  Copyright (c) 2004 Jeroen Zwartepoorte
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the Lesser GNU General
// Public License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

		public MimeType MimeType {
			get {
				return new MimeType (this);
			}
		}
		
		[DllImport("libgnomevfs-2-0.dll")]
		static extern Result gnome_vfs_get_volume_free_space (IntPtr raw, out long size);

		public long VolumeFreeSpace {
			get {
				long size = 0L;
				Result result = gnome_vfs_get_volume_free_space (Handle, out size);
				Vfs.ThrowException (this, result);
				return size;
			}
		}

		public FileInfo GetFileInfo ()
		{
			return GetFileInfo (FileInfoOptions.Default);
		}

		public FileInfo GetFileInfo (FileInfoOptions options)
		{
			return new FileInfo (this, options);
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern Result gnome_vfs_set_file_info_uri (IntPtr raw, ref FileInfo.FileInfoNative info, SetFileInfoMask mask);

		public Result SetFileInfo (FileInfo info, SetFileInfoMask mask)
		{
			return gnome_vfs_set_file_info_uri (Handle, ref info.info, mask);
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern bool gnome_vfs_uri_equal(IntPtr raw, IntPtr b);

		public override bool Equals (object o) {
			if (o is Uri) {
				Uri uri = o as Uri;
				return gnome_vfs_uri_equal (Handle, uri.Handle);
			} else {
				return false;
			}
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern uint gnome_vfs_uri_hash(IntPtr p);

		public override int GetHashCode () {
			return checked ((int)gnome_vfs_uri_hash (Handle));
		}

		public override string ToString ()
		{
			return ToString (UriHideOptions.None);
		}

		[DllImport ("libgnomevfs-2-0.dll")]
		private static extern Result gnome_vfs_truncate_uri (IntPtr raw, ulong length);
		
		public Result Truncate (ulong length)
		{
			return gnome_vfs_truncate_uri (Handle, length);
		}
		
		[DllImport ("libgnomevfs-2-0.dll")]
		private static extern Result gnome_vfs_unlink_from_uri (IntPtr raw);
		
		public Result Unlink ()
		{
			return gnome_vfs_unlink_from_uri (Handle);
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern string gnome_vfs_get_local_path_from_uri (string uri);

		public static string GetLocalPathFromUri (string uri)
		{
			return gnome_vfs_get_local_path_from_uri (uri);
		}
		
		[DllImport("libgnomevfs-2-0.dll")]
		static extern string gnome_vfs_get_uri_from_local_path (string path);

		public static string GetUriFromLocalPath (string path)
		{
			return gnome_vfs_get_uri_from_local_path (path);
		}

		[DllImport("libgnomevfs-2-0.dll")]
		static extern IntPtr gnome_vfs_uri_list_parse(string uri_list);

		public static Uri[] ParseList (string uri_list) {
			IntPtr raw_ret = gnome_vfs_uri_list_parse(uri_list);
			GLib.List list = new GLib.List(raw_ret);
			Uri[] uris = new Uri [list.Count];
			for (int i = 0; i < list.Count; i++)
				uris[i] = list[i] as Uri;
			list.Dispose ();
			return uris;
		}

#endregion
	}
}
