using System;
using System.Collections;
using System.Runtime.InteropServices;

namespace Evolution {


	[StructLayout(LayoutKind.Sequential)]
	public class CalComponentDateTime {

		private IntPtr _value;

		public Icaltimetype value {
			get { 
				return new Icaltimetype (_value); }
			set {
				_value = value.Handle;
			}
		}
		public string Tzid;

		public static CalComponentDateTime Zero = new CalComponentDateTime ();

		public CalComponentDateTime () {
			_value = CalUtil.e_cal_alloc_icaltimetype ();
		}
		
		~CalComponentDateTime () {
		 	CalUtil.e_cal_free_icaltimetype (_value);
		}

		public static CalComponentDateTime New(IntPtr raw) {
			if (raw == IntPtr.Zero) 
				return CalComponentDateTime.Zero;
			
			return (CalComponentDateTime) Marshal.PtrToStructure (raw, typeof (CalComponentDateTime));
		}

		private static GLib.GType GType {
			get { return GLib.GType.Pointer; }
		}
	}
}
