/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* server-interface-check.h
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Author: Sivaiah Nallagatla <snallagatla@novell.com>
 */

/**
 * SECTION: e-offline-listener
 * @short_description: Tracks Evolution's online/offline state
 *
 * An #EOfflineListener basically just tracks Evolution's online/offline
 * state and emits a #EOfflineListener:changed signal when a state change
 * is detected.
 *
 * This class is highly Evolution-centric and probably not suitable for
 * general purpose use.  Frankly it should be deprecated and replaced
 * with a D-Bus method.
 **/

/*Note : Copied from src/offline_listener.c . This should be replaced */
/* with network manager code */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "e-offline-listener.h"
#include <gconf/gconf-client.h>

#define E_OFFLINE_LISTENER_GET_PRIVATE(obj) \
	(G_TYPE_INSTANCE_GET_PRIVATE \
	((obj), E_TYPE_OFFLINE_LISTENER, EOfflineListenerPrivate))

G_DEFINE_TYPE (EOfflineListener, e_offline_listener, G_TYPE_OBJECT)

enum {
	CHANGED,
	NUM_SIGNALS
};

static guint signals[NUM_SIGNALS] = { 0 };

struct _EOfflineListenerPrivate {
	GConfClient *default_client;
	gboolean is_offline_now;
};

static void
set_online_status (EOfflineListener *eol,
                   gboolean is_offline)
{
	g_signal_emit (eol, signals[CHANGED], 0);
}

static void
online_status_changed (GConfClient *client,
                       gint cnxn_id,
                       GConfEntry *entry,
                       gpointer data)
{
	GConfValue *value;
	gboolean offline;
	EOfflineListener *eol;
	EOfflineListenerPrivate *priv;

	eol = E_OFFLINE_LISTENER (data);
	g_return_if_fail (eol != NULL);

	priv = eol->priv;
	offline = FALSE;
	value = gconf_entry_get_value (entry);
	if (value)
		offline = gconf_value_get_bool (value);

	if (priv->is_offline_now != offline) {
		priv->is_offline_now = offline;

		set_online_status (eol, offline);
	}
}

static void
setup_offline_listener (EOfflineListener *eol)
{
	EOfflineListenerPrivate *priv = eol->priv;

	priv->default_client = gconf_client_get_default ();

	gconf_client_add_dir (
		priv->default_client,
		"/apps/evolution/shell",
		GCONF_CLIENT_PRELOAD_RECURSIVE, NULL);

	gconf_client_notify_add (
		priv->default_client,
		"/apps/evolution/shell/start_offline",
		(GConfClientNotifyFunc) online_status_changed,
		eol, NULL, NULL);

	priv->is_offline_now = gconf_client_get_bool (
		priv->default_client,
		"/apps/evolution/shell/start_offline", NULL);

	set_online_status (eol, priv->is_offline_now);
}

/**
 * e_offline_listener_new:
 *
 * Returns a new #EOfflineListener.
 *
 * Returns: a new #EOfflineListener
 *
 * Since: 2.30
 **/
EOfflineListener *
e_offline_listener_new (void)
{
	EOfflineListener *eol = g_object_new (E_TYPE_OFFLINE_LISTENER, NULL);

	setup_offline_listener (eol);

	return eol;
}

static void
offline_listener_dispose (GObject *object)
{
	EOfflineListenerPrivate *priv;

	priv = E_OFFLINE_LISTENER_GET_PRIVATE (object);

	if (priv->default_client) {
		g_object_unref (priv->default_client);
		priv->default_client = NULL;
	}

	/* Chain up to parent's dispose() method. */
	G_OBJECT_CLASS (e_offline_listener_parent_class)->dispose (object);
}

static void
e_offline_listener_init (EOfflineListener *eol)
{
	eol->priv = E_OFFLINE_LISTENER_GET_PRIVATE (eol);
}

static void
e_offline_listener_class_init (EOfflineListenerClass *class)
{
	GObjectClass *object_class;

	g_type_class_add_private (class, sizeof (EOfflineListenerPrivate));

	object_class = G_OBJECT_CLASS (class);
	object_class->dispose = offline_listener_dispose;

	/**
	 * EOfflineListener::changed:
	 * @listener: the #EOfflineListener that received the signal
	 *
	 * Emitted when Evolution's online/offline state changes.
	 **/
	signals[CHANGED] = g_signal_new (
		"changed",
		G_OBJECT_CLASS_TYPE (object_class),
		G_SIGNAL_RUN_LAST,
		G_STRUCT_OFFSET (EOfflineListenerClass, changed),
		NULL, NULL,
		g_cclosure_marshal_VOID__VOID,
		G_TYPE_NONE, 0);
}

/**
 * e_offline_listener_get_state:
 * @eol: an #EOfflineListener
 *
 * FIXME Document me!
 *
 * Returns: #EOL_STATE_OFFLINE or #EOL_STATE_ONLINE
 *
 * Since: 2.30
 **/
EOfflineListenerState
e_offline_listener_get_state (EOfflineListener *eol)
{
	g_return_val_if_fail (E_IS_OFFLINE_LISTENER (eol), EOL_STATE_OFFLINE);

	return eol->priv->is_offline_now ? EOL_STATE_OFFLINE : EOL_STATE_ONLINE;
}
