/* File:       e-gdbus-egdbusbookview.c
 *
 * GType name: EGdbusBookView
 * D-Bus name: org.gnome.evolution.dataserver.addressbook.BookView
 *
 * Generated by GDBus Binding Tool 0.1. DO NOT EDIT.
 */

/**
 * SECTION:e-gdbus-egdbusbookview
 * @title: EGdbusBookView
 * @short_description: Wraps the org.gnome.evolution.dataserver.addressbook.BookView D-Bus interface
 * @include: gio/gio.h
 *
 * The abstract #EGdbusBookView interface type wraps the <literal>org.gnome.evolution.dataserver.addressbook.BookView</literal> D-Bus interface. Two concrete implementations of this type are included: #EGdbusBookViewProxy and #EGdbusBookViewStub.
 *
 * The generated proxy type #EGdbusBookViewProxy is typically used with the generated constructors e_gdbus_book_view_proxy_new(), e_gdbus_book_view_proxy_new_sync() and e_gdbus_book_view_proxy_new_for_bus(), e_gdbus_book_view_proxy_new_for_bus_sync().
 *
 * The generated stub type #EGdbusBookViewStub takes care of handling properties, method invocations and signal emissions. Simply use e_gdbus_book_view_stub_new(), set some properties and connect to any of the handle-* signals to handle method invocations. Finally use e_gdbus_book_view_register_object() to export the object on a #GDBusConnection.
 * |[
 * /<!-- -->* You can also use g_object_new() with E_GDBUS_TYPE_BOOK_VIEW_STUB
 *  * to set properties at construction time.
 *  *<!-- -->/
 * object = e_gdbus_book_view_stub_new ();
 * e_gdbus_book_view_set_&lt;property_name&gt; (object, &lt;value_for_property&gt;);
 * [...]
 *
 * g_signal_connect (object,
 *                   "handle-&lt;method-name&gt;",
 *                   G_CALLBACK (on_handle_&lt;method_name&gt;),
 *                   some_user_data);
 * [...]
 *
 * error = NULL;
 * id = e_gdbus_book_view_register_object (object,
 *                                         connection,
 *                                         "/path/of/object",
 *                                         &error);
 * ]|
 *
 * You don't <emphasis>have</emphasis> to use the generated stub type to export
 * objects. Any type implementing the #EGdbusBookView interface may be used with
 * e_gdbus_book_view_register_object().
 *
 * Once exported, you can make the exported object emit D-Bus signals by simply
 * emitting the corresponding GType signals. For better type-safety, you can use,
 * the provided e_gdbus_book_view_emit_*() helpers.
 *
 * For property changes, #GObject::notify signal emissions on exported objects
 * will be intercepted and queued. In an idle handler, the queued notifications
 * are processed and a single <literal>PropertiesChanged</literal> signal (on the
 * <literal>org.freedesktop.DBus.Properties</literal> interface) will be emitted
 * for all the properties that changed (possibly containing several properties).
 * Use e_gdbus_book_view_drain_notify() to drain the queue immediately.
 */

#include "e-gdbus-egdbusbookview.h"
#include "e-gdbus-typemappers.h"
#include "e-gdbus-marshallers.h"

typedef EGdbusBookViewIface EGdbusBookViewInterface;
G_DEFINE_INTERFACE (EGdbusBookView, e_gdbus_book_view, G_TYPE_OBJECT);

enum
{
  _0_SIGNAL,
  __CONTACTS_ADDED_SIGNAL,
  __CONTACTS_CHANGED_SIGNAL,
  __CONTACTS_REMOVED_SIGNAL,
  __STATUS_MESSAGE_SIGNAL,
  __COMPLETE_SIGNAL,
  __START_METHOD,
  __STOP_METHOD,
  __DISPOSE_METHOD,
  __LAST_SIGNAL
};

static guint signals[__LAST_SIGNAL] = {0};

enum
{
  PROP_0,
};

/* ------------------------------------------------------------------------- */

/* Various lookup tables */

static GHashTable *_method_name_to_id = NULL;
static GHashTable *_signal_name_to_id = NULL;
static GHashTable *_property_name_to_id = NULL;
static GHashTable *_property_gname_to_name = NULL;
static GHashTable *_property_name_to_gname = NULL;

static guint
lookup_method_id_from_method_name (const gchar *method_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_method_name_to_id, method_name));
}

static guint
lookup_signal_id_from_signal_name (const gchar *signal_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_signal_name_to_id, signal_name));
}

static guint
lookup_property_id_from_property_name (const gchar *property_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_property_name_to_id, property_name));
}

static const gchar *
lookup_property_name_from_property_gname (const gchar *property_gname)
{
  return g_hash_table_lookup (_property_gname_to_name, property_gname);
}

static const gchar *
lookup_property_gname_from_property_name (const gchar *property_name)
{
  return g_hash_table_lookup (_property_name_to_gname, property_name);
}

/* ------------------------------------------------------------------------- */
static gboolean
signal_emission_hook_cb_contacts_added (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new ("^as", g_value_get_boxed (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
                                 NULL,
                                 path,
                                 "org.gnome.evolution.dataserver.addressbook.BookView",
                                 "ContactsAdded",
                                 params,
                                 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_contacts_changed (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new ("^as", g_value_get_boxed (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
                                 NULL,
                                 path,
                                 "org.gnome.evolution.dataserver.addressbook.BookView",
                                 "ContactsChanged",
                                 params,
                                 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_contacts_removed (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new ("^as", g_value_get_boxed (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
                                 NULL,
                                 path,
                                 "org.gnome.evolution.dataserver.addressbook.BookView",
                                 "ContactsRemoved",
                                 params,
                                 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_status_message (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new ("s", g_value_get_string (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
                                 NULL,
                                 path,
                                 "org.gnome.evolution.dataserver.addressbook.BookView",
                                 "StatusMessage",
                                 params,
                                 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_complete (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 2);
  param_values++;
  item = g_variant_new_uint32 (g_value_get_uint (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  item = g_variant_new ("s", g_value_get_string (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
                                 NULL,
                                 path,
                                 "org.gnome.evolution.dataserver.addressbook.BookView",
                                 "Complete",
                                 params,
                                 NULL);
out:
  return TRUE;
}

static void
e_gdbus_book_view_default_init (EGdbusBookViewIface *iface)
{

  /* Build lookup structures */
  _method_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _signal_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _property_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _property_gname_to_name = g_hash_table_new (g_str_hash, g_str_equal);
  _property_name_to_gname = g_hash_table_new (g_str_hash, g_str_equal);
  g_hash_table_insert (_method_name_to_id, (gpointer) "start", GUINT_TO_POINTER (__START_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "stop", GUINT_TO_POINTER (__STOP_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "dispose", GUINT_TO_POINTER (__DISPOSE_METHOD));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "ContactsAdded", GUINT_TO_POINTER (__CONTACTS_ADDED_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "ContactsChanged", GUINT_TO_POINTER (__CONTACTS_CHANGED_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "ContactsRemoved", GUINT_TO_POINTER (__CONTACTS_REMOVED_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "StatusMessage", GUINT_TO_POINTER (__STATUS_MESSAGE_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "Complete", GUINT_TO_POINTER (__COMPLETE_SIGNAL));

  /* GObject signals definitions for D-Bus signals: */
  /**
   * EGdbusBookView::contacts-added:
   * @object: The object emitting the signal.
   * @vcards: Parameter.
   *
   * Represents the D-Bus signal <literal>ContactsAdded</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_book_view_emit_contacts_added() to do this.
   */  signals[__CONTACTS_ADDED_SIGNAL] =
    g_signal_new ("contacts-added",
                  G_TYPE_FROM_INTERFACE (iface),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (EGdbusBookViewIface, contacts_added),
                  NULL,
                  NULL,
                  _e_gdbus_gdbus_cclosure_marshaller_VOID__BOXED,
                  G_TYPE_NONE,
                  1,
                  G_TYPE_STRV);
  g_signal_add_emission_hook (signals[__CONTACTS_ADDED_SIGNAL],
                              0,
                              signal_emission_hook_cb_contacts_added,
                              (gpointer) "ContactsAdded",
                              NULL);

  /**
   * EGdbusBookView::contacts-changed:
   * @object: The object emitting the signal.
   * @vcards: Parameter.
   *
   * Represents the D-Bus signal <literal>ContactsChanged</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_book_view_emit_contacts_changed() to do this.
   */  signals[__CONTACTS_CHANGED_SIGNAL] =
    g_signal_new ("contacts-changed",
                  G_TYPE_FROM_INTERFACE (iface),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (EGdbusBookViewIface, contacts_changed),
                  NULL,
                  NULL,
                  _e_gdbus_gdbus_cclosure_marshaller_VOID__BOXED,
                  G_TYPE_NONE,
                  1,
                  G_TYPE_STRV);
  g_signal_add_emission_hook (signals[__CONTACTS_CHANGED_SIGNAL],
                              0,
                              signal_emission_hook_cb_contacts_changed,
                              (gpointer) "ContactsChanged",
                              NULL);

  /**
   * EGdbusBookView::contacts-removed:
   * @object: The object emitting the signal.
   * @ids: Parameter.
   *
   * Represents the D-Bus signal <literal>ContactsRemoved</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_book_view_emit_contacts_removed() to do this.
   */  signals[__CONTACTS_REMOVED_SIGNAL] =
    g_signal_new ("contacts-removed",
                  G_TYPE_FROM_INTERFACE (iface),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (EGdbusBookViewIface, contacts_removed),
                  NULL,
                  NULL,
                  _e_gdbus_gdbus_cclosure_marshaller_VOID__BOXED,
                  G_TYPE_NONE,
                  1,
                  G_TYPE_STRV);
  g_signal_add_emission_hook (signals[__CONTACTS_REMOVED_SIGNAL],
                              0,
                              signal_emission_hook_cb_contacts_removed,
                              (gpointer) "ContactsRemoved",
                              NULL);

  /**
   * EGdbusBookView::status-message:
   * @object: The object emitting the signal.
   * @message: Parameter.
   *
   * Represents the D-Bus signal <literal>StatusMessage</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_book_view_emit_status_message() to do this.
   */  signals[__STATUS_MESSAGE_SIGNAL] =
    g_signal_new ("status-message",
                  G_TYPE_FROM_INTERFACE (iface),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (EGdbusBookViewIface, status_message),
                  NULL,
                  NULL,
                  _e_gdbus_gdbus_cclosure_marshaller_VOID__STRING,
                  G_TYPE_NONE,
                  1,
                  G_TYPE_STRING);
  g_signal_add_emission_hook (signals[__STATUS_MESSAGE_SIGNAL],
                              0,
                              signal_emission_hook_cb_status_message,
                              (gpointer) "StatusMessage",
                              NULL);

  /**
   * EGdbusBookView::complete:
   * @object: The object emitting the signal.
   * @status: Parameter.
   * @message: Parameter.
   *
   * Represents the D-Bus signal <literal>Complete</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_book_view_emit_complete() to do this.
   */  signals[__COMPLETE_SIGNAL] =
    g_signal_new ("complete",
                  G_TYPE_FROM_INTERFACE (iface),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (EGdbusBookViewIface, complete),
                  NULL,
                  NULL,
                  _e_gdbus_gdbus_cclosure_marshaller_VOID__UINT_STRING,
                  G_TYPE_NONE,
                  2,
                  G_TYPE_UINT,
                  G_TYPE_STRING);
  g_signal_add_emission_hook (signals[__COMPLETE_SIGNAL],
                              0,
                              signal_emission_hook_cb_complete,
                              (gpointer) "Complete",
                              NULL);

  /* GObject signals definitions for D-Bus methods: */
  /**
   * EGdbusBookView::handle-start:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>start</literal> D-Bus method on @object. Use e_gdbus_book_view_complete_start() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_view_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__START_METHOD] =
    g_signal_new ("handle-start",
                  G_TYPE_FROM_INTERFACE (iface),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (EGdbusBookViewIface, handle_start),
                  g_signal_accumulator_true_handled,
                  NULL,
                  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
                  G_TYPE_BOOLEAN,
                  1,
                  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusBookView::handle-stop:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>stop</literal> D-Bus method on @object. Use e_gdbus_book_view_complete_stop() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_view_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__STOP_METHOD] =
    g_signal_new ("handle-stop",
                  G_TYPE_FROM_INTERFACE (iface),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (EGdbusBookViewIface, handle_stop),
                  g_signal_accumulator_true_handled,
                  NULL,
                  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
                  G_TYPE_BOOLEAN,
                  1,
                  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusBookView::handle-dispose:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>dispose</literal> D-Bus method on @object. Use e_gdbus_book_view_complete_dispose() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_view_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__DISPOSE_METHOD] =
    g_signal_new ("handle-dispose",
                  G_TYPE_FROM_INTERFACE (iface),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (EGdbusBookViewIface, handle_dispose),
                  g_signal_accumulator_true_handled,
                  NULL,
                  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
                  G_TYPE_BOOLEAN,
                  1,
                  G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject property definitions for D-Bus properties: */
}

/* C Bindings for properties */

/**
 * e_gdbus_book_view_call_start:
 * @proxy: A #EGdbusBookView.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.addressbook.BookView.start</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_view_call_start_finish() to get the result of the operation.
 *
 * See e_gdbus_book_view_call_start_sync() for the synchronous version of this method.
 */
void e_gdbus_book_view_call_start (
        EGdbusBookView *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "start",
                     _params,
                     G_DBUS_CALL_FLAGS_NONE,
                     -1,
                     cancellable,
                     callback,
                     user_data);
}

/**
 * e_gdbus_book_view_call_start_finish:
 * @proxy: A #EGdbusBookView.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_view_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.addressbook.BookView.start</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_view_call_start_finish (
        EGdbusBookView *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_view_call_start_sync:
 * @proxy: A #EGdbusBookView.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.addressbook.BookView.start</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_view_call_start() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_view_call_start_sync (
        EGdbusBookView *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "start",
                                   _params,
                                   G_DBUS_CALL_FLAGS_NONE,
                                   -1,
                                   cancellable,
                                   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_view_call_stop:
 * @proxy: A #EGdbusBookView.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.addressbook.BookView.stop</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_view_call_stop_finish() to get the result of the operation.
 *
 * See e_gdbus_book_view_call_stop_sync() for the synchronous version of this method.
 */
void e_gdbus_book_view_call_stop (
        EGdbusBookView *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "stop",
                     _params,
                     G_DBUS_CALL_FLAGS_NONE,
                     -1,
                     cancellable,
                     callback,
                     user_data);
}

/**
 * e_gdbus_book_view_call_stop_finish:
 * @proxy: A #EGdbusBookView.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_view_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.addressbook.BookView.stop</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_view_call_stop_finish (
        EGdbusBookView *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_view_call_stop_sync:
 * @proxy: A #EGdbusBookView.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.addressbook.BookView.stop</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_view_call_stop() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_view_call_stop_sync (
        EGdbusBookView *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "stop",
                                   _params,
                                   G_DBUS_CALL_FLAGS_NONE,
                                   -1,
                                   cancellable,
                                   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_view_call_dispose:
 * @proxy: A #EGdbusBookView.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.addressbook.BookView.dispose</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_view_call_dispose_finish() to get the result of the operation.
 *
 * See e_gdbus_book_view_call_dispose_sync() for the synchronous version of this method.
 */
void e_gdbus_book_view_call_dispose (
        EGdbusBookView *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "dispose",
                     _params,
                     G_DBUS_CALL_FLAGS_NONE,
                     -1,
                     cancellable,
                     callback,
                     user_data);
}

/**
 * e_gdbus_book_view_call_dispose_finish:
 * @proxy: A #EGdbusBookView.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_view_call_dispose().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.addressbook.BookView.dispose</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_view_call_dispose_finish (
        EGdbusBookView *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_view_call_dispose_sync:
 * @proxy: A #EGdbusBookView.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.addressbook.BookView.dispose</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_view_call_dispose() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_view_call_dispose_sync (
        EGdbusBookView *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "dispose",
                                   _params,
                                   G_DBUS_CALL_FLAGS_NONE,
                                   -1,
                                   cancellable,
                                   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_view_complete_start:
 * @object: A #EGdbusBookView.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.addressbook.BookView.start</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_view_complete_start (
        EGdbusBookView *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_view_complete_stop:
 * @object: A #EGdbusBookView.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.addressbook.BookView.stop</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_view_complete_stop (
        EGdbusBookView *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_view_complete_dispose:
 * @object: A #EGdbusBookView.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.addressbook.BookView.dispose</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_view_complete_dispose (
        EGdbusBookView *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_view_emit_contacts_added:
 * @object: A #EGdbusBookView.
 * @arg_vcards: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.addressbook.BookView.ContactsAdded</literal>
 * D-Bus signal.
 */
void e_gdbus_book_view_emit_contacts_added (
        EGdbusBookView *object,
        const gchar * const *arg_vcards)
{
  g_signal_emit (object, signals[__CONTACTS_ADDED_SIGNAL], 0, arg_vcards);
}

/**
 * e_gdbus_book_view_emit_contacts_changed:
 * @object: A #EGdbusBookView.
 * @arg_vcards: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.addressbook.BookView.ContactsChanged</literal>
 * D-Bus signal.
 */
void e_gdbus_book_view_emit_contacts_changed (
        EGdbusBookView *object,
        const gchar * const *arg_vcards)
{
  g_signal_emit (object, signals[__CONTACTS_CHANGED_SIGNAL], 0, arg_vcards);
}

/**
 * e_gdbus_book_view_emit_contacts_removed:
 * @object: A #EGdbusBookView.
 * @arg_ids: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.addressbook.BookView.ContactsRemoved</literal>
 * D-Bus signal.
 */
void e_gdbus_book_view_emit_contacts_removed (
        EGdbusBookView *object,
        const gchar * const *arg_ids)
{
  g_signal_emit (object, signals[__CONTACTS_REMOVED_SIGNAL], 0, arg_ids);
}

/**
 * e_gdbus_book_view_emit_status_message:
 * @object: A #EGdbusBookView.
 * @arg_message: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.addressbook.BookView.StatusMessage</literal>
 * D-Bus signal.
 */
void e_gdbus_book_view_emit_status_message (
        EGdbusBookView *object,
        const gchar *arg_message)
{
  g_signal_emit (object, signals[__STATUS_MESSAGE_SIGNAL], 0, arg_message);
}

/**
 * e_gdbus_book_view_emit_complete:
 * @object: A #EGdbusBookView.
 * @arg_status: Signal parameter.
 * @arg_message: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.addressbook.BookView.Complete</literal>
 * D-Bus signal.
 */
void e_gdbus_book_view_emit_complete (
        EGdbusBookView *object,
        guint arg_status,
        const gchar *arg_message)
{
  g_signal_emit (object, signals[__COMPLETE_SIGNAL], 0, arg_status, arg_message);
}

static const GDBusArgInfo e_gdbus_book_view_signal_ContactsAdded_vcards =
{
  -1,
  (gchar *) "vcards",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_view_signal_ContactsAdded_arg_pointers[] =
{
  &e_gdbus_book_view_signal_ContactsAdded_vcards,
  NULL
};

static const GDBusSignalInfo e_gdbus_book_view_signal_ContactsAdded =
{
  -1,
  (gchar *) "ContactsAdded",
  (GDBusArgInfo **) &e_gdbus_book_view_signal_ContactsAdded_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_view_signal_ContactsChanged_vcards =
{
  -1,
  (gchar *) "vcards",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_view_signal_ContactsChanged_arg_pointers[] =
{
  &e_gdbus_book_view_signal_ContactsChanged_vcards,
  NULL
};

static const GDBusSignalInfo e_gdbus_book_view_signal_ContactsChanged =
{
  -1,
  (gchar *) "ContactsChanged",
  (GDBusArgInfo **) &e_gdbus_book_view_signal_ContactsChanged_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_view_signal_ContactsRemoved_ids =
{
  -1,
  (gchar *) "ids",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_view_signal_ContactsRemoved_arg_pointers[] =
{
  &e_gdbus_book_view_signal_ContactsRemoved_ids,
  NULL
};

static const GDBusSignalInfo e_gdbus_book_view_signal_ContactsRemoved =
{
  -1,
  (gchar *) "ContactsRemoved",
  (GDBusArgInfo **) &e_gdbus_book_view_signal_ContactsRemoved_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_view_signal_StatusMessage_message =
{
  -1,
  (gchar *) "message",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_view_signal_StatusMessage_arg_pointers[] =
{
  &e_gdbus_book_view_signal_StatusMessage_message,
  NULL
};

static const GDBusSignalInfo e_gdbus_book_view_signal_StatusMessage =
{
  -1,
  (gchar *) "StatusMessage",
  (GDBusArgInfo **) &e_gdbus_book_view_signal_StatusMessage_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_view_signal_Complete_status =
{
  -1,
  (gchar *) "status",
  (gchar *) "u",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_book_view_signal_Complete_message =
{
  -1,
  (gchar *) "message",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_view_signal_Complete_arg_pointers[] =
{
  &e_gdbus_book_view_signal_Complete_status,
  &e_gdbus_book_view_signal_Complete_message,
  NULL
};

static const GDBusSignalInfo e_gdbus_book_view_signal_Complete =
{
  -1,
  (gchar *) "Complete",
  (GDBusArgInfo **) &e_gdbus_book_view_signal_Complete_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusSignalInfo * const e_gdbus_book_view_signal_info_pointers[] =
{
  &e_gdbus_book_view_signal_ContactsAdded,
  &e_gdbus_book_view_signal_ContactsChanged,
  &e_gdbus_book_view_signal_ContactsRemoved,
  &e_gdbus_book_view_signal_StatusMessage,
  &e_gdbus_book_view_signal_Complete,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_view_method_start =
{
  -1,
  (gchar *) "start",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_book_view_method_stop =
{
  -1,
  (gchar *) "stop",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_book_view_method_dispose =
{
  -1,
  (gchar *) "dispose",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo * const e_gdbus_book_view_method_info_pointers[] =
{
  &e_gdbus_book_view_method_start,
  &e_gdbus_book_view_method_stop,
  &e_gdbus_book_view_method_dispose,
  NULL
};

static const GDBusInterfaceInfo _e_gdbus_book_view_interface_info =
{
  -1,
  (gchar *) "org.gnome.evolution.dataserver.addressbook.BookView",
  (GDBusMethodInfo **) &e_gdbus_book_view_method_info_pointers,
  (GDBusSignalInfo **) &e_gdbus_book_view_signal_info_pointers,
  (GDBusPropertyInfo **) NULL,
};

static void
handle_method_call (GDBusConnection       *connection,
                    const gchar           *sender,
                    const gchar           *object_path,
                    const gchar           *interface_name,
                    const gchar           *method_name,
                    GVariant              *parameters,
                    GDBusMethodInvocation *invocation,
                    gpointer               user_data)
{
  guint method_id;
  method_id = lookup_method_id_from_method_name (method_name);
  switch (method_id)
    {
    case __START_METHOD:
      {
        EGdbusBookView *object = E_GDBUS_BOOK_VIEW (user_data);
        gboolean handled;
        g_signal_emit (object,
                       signals[method_id],
                       0, invocation, &handled);
        if (!handled)
          goto not_implemented;
      }
      break;

    case __STOP_METHOD:
      {
        EGdbusBookView *object = E_GDBUS_BOOK_VIEW (user_data);
        gboolean handled;
        g_signal_emit (object,
                       signals[method_id],
                       0, invocation, &handled);
        if (!handled)
          goto not_implemented;
      }
      break;

    case __DISPOSE_METHOD:
      {
        EGdbusBookView *object = E_GDBUS_BOOK_VIEW (user_data);
        gboolean handled;
        g_signal_emit (object,
                       signals[method_id],
                       0, invocation, &handled);
        if (!handled)
          goto not_implemented;
      }
      break;

    default:
not_implemented:
      g_dbus_method_invocation_return_error (invocation,
                                             G_DBUS_ERROR,
                                             G_DBUS_ERROR_NOT_SUPPORTED,
                                             "Method `%s' is not implemented",
                                             method_name);
      break;
    }
};

static GVariant *
get_property (GDBusConnection  *connection,
              const gchar      *sender,
              const gchar      *object_path,
              const gchar      *interface_name,
              const gchar      *property_name,
              GError          **error,
              gpointer          user_data)
{
  GVariant *ret;
  guint prop_id;
  prop_id = lookup_property_id_from_property_name (property_name);
  ret = NULL;
  switch (prop_id)
    {
    default:
      g_set_error (error,
                   G_DBUS_ERROR,
                   G_DBUS_ERROR_NOT_SUPPORTED,
                   "This implementation does not support property `%s'",
                   property_name);
      break;
    }

  return ret;
};

static gboolean
set_property (GDBusConnection  *connection,
              const gchar      *sender,
              const gchar      *object_path,
              const gchar      *interface_name,
              const gchar      *property_name,
              GVariant         *value,
              GError          **error,
              gpointer          user_data)
{
  gboolean ret;
  guint prop_id;
  prop_id = lookup_property_id_from_property_name (property_name);
  ret = TRUE;
  switch (prop_id)
    {
    default:
      g_set_error (error,
                   G_DBUS_ERROR,
                   G_DBUS_ERROR_NOT_SUPPORTED,
                   "This implementation does not support property `%s'",
                   property_name);
      ret = FALSE;
      break;
    }

  return ret;
};

static const GDBusInterfaceVTable e_gdbus_book_view_interface_vtable =
{
  handle_method_call,
  get_property,
  set_property,
};

static gboolean
emit_notifications_in_idle (gpointer user_data)
{
  GObject *object = G_OBJECT (user_data);
  GDBusConnection *connection;
  const gchar *path;
  GHashTable *notification_queue;
  GHashTableIter iter;
  const gchar *property_name;
  GVariant *value;
  GVariantBuilder *builder;
  GVariantBuilder *invalidated_builder;
  GHashTable *pvc;
  gboolean has_changes;

  notification_queue = g_object_get_data (object, "gdbus-codegen-notification-queue");
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  pvc = g_object_get_data (object, "gdbus-codegen-pvc");
  g_assert (notification_queue != NULL && path != NULL && connection != NULL && pvc != NULL);

  builder = g_variant_builder_new (G_VARIANT_TYPE_ARRAY);
  invalidated_builder = g_variant_builder_new (G_VARIANT_TYPE ("as"));
  g_hash_table_iter_init (&iter, notification_queue);
  has_changes = FALSE;
  while (g_hash_table_iter_next (&iter, (gpointer) &property_name, (gpointer) &value))
    {
      GVariant *cached_value;
      cached_value = g_hash_table_lookup (pvc, property_name);
      if (cached_value == NULL || !g_variant_equal (cached_value, value))
        {
          g_hash_table_insert (pvc, (gpointer) property_name, (gpointer) g_variant_ref (value));
          g_variant_builder_add (builder, "{sv}", property_name, value);
          has_changes = TRUE;
        }
    }

  if (has_changes)
    {
      g_dbus_connection_emit_signal (connection,
                                     NULL,
                                     path,
                                     "org.freedesktop.DBus.Properties",
                                     "PropertiesChanged",
                                     g_variant_new ("(sa{sv}as)",
                                                    "org.gnome.evolution.dataserver.addressbook.BookView",
                                                    builder,
                                                    invalidated_builder),
                                     NULL);
    }
  else
    {
      g_variant_builder_unref (builder);
      g_variant_builder_unref (invalidated_builder);
    }

  g_hash_table_remove_all (notification_queue);
  g_object_set_data (object, "gdbus-codegen-notification-idle-id", GUINT_TO_POINTER (0));
  return FALSE;
}

static void
queue_notification (GObject     *object,
                    const gchar *property_name,
                    GVariant    *value)
{
  GHashTable *notification_queue;
  guint idle_id;
  notification_queue = g_object_get_data (object, "gdbus-codegen-notification-queue");
  if (notification_queue == NULL)
    {
      notification_queue = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_variant_unref);
      g_object_set_data_full (object, "gdbus-codegen-notification-queue", notification_queue, (GDestroyNotify) g_hash_table_unref);
    }
  g_hash_table_insert (notification_queue, (gpointer) property_name, (gpointer) value); /* adopts value */
  idle_id = GPOINTER_TO_UINT (g_object_get_data (object, "gdbus-codegen-notification-idle-id"));
  if (idle_id == 0)
    {
      GSource *idle_source;
      idle_source = g_idle_source_new ();
      g_source_set_priority (idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (idle_source,
                             emit_notifications_in_idle,
                             g_object_ref (object),
                             (GDestroyNotify) g_object_unref);
      idle_id = g_source_attach (idle_source, g_main_context_get_thread_default ());
      g_source_unref (idle_source);
      g_object_set_data (object, "gdbus-codegen-notification-idle-id", GUINT_TO_POINTER (idle_id));
    }
}

/**
 * e_gdbus_book_view_drain_notify:
 * @object: A #EGdbusBookView that is exported.
 *
 * If @object has queued notifications, empty the queue forcing
 * the <literal>PropertiesChanged</literal> signal to be emitted.
 * See <xref linkend="EGdbusBookView.description"/> for more background information.
 */
void
e_gdbus_book_view_drain_notify (EGdbusBookView *object)
{
  gint idle_id;
  idle_id = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (object), "gdbus-codegen-notification-idle-id"));
  if (idle_id > 0)
    {
      emit_notifications_in_idle (object);
      g_source_remove (idle_id);
    }
}

static void
on_notify (GObject    *object,
           GParamSpec *pspec,
           gpointer    user_data)
{
  GDBusConnection *connection;
  const gchar *path;
  GVariant *value;
  const gchar *property_name;
  guint prop_id;

  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  property_name = lookup_property_name_from_property_gname (pspec->name);
  if (property_name == NULL)
    goto out;
  prop_id = lookup_property_id_from_property_name (property_name);

  value = NULL;
  switch (prop_id)
    {
  }

  if (value != NULL && property_name != NULL)
    {
      queue_notification (object, property_name, g_variant_ref_sink (value));
    }
out:
  ;
}

static void
on_object_unregistered (GObject *object)
{
  gint idle_id;
  idle_id = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (object), "gdbus-codegen-notification-idle-id"));
  if (idle_id > 0)
    {
      g_source_remove (idle_id);
    }
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-path", NULL);
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-connection", NULL);
  g_signal_handlers_disconnect_by_func (object, on_notify, NULL);
}

/**
 * e_gdbus_book_view_register_object:
 * @object: An instance of a #GObject<!-- -->-derived type implementing the #EGdbusBookView interface.
 * @connection: A #GDBusConnection.
 * @object_path: The object to register the object at.
 * @error: Return location for error or %NULL.
 *
 * Registers @object at @object_path on @connection.
 *
 * See <xref linkend="EGdbusBookView.description"/>
 * for how properties, methods and signals are handled.
 *
 * Returns: 0 if @error is set, otherwise a registration id (never 0) that can be used with g_dbus_connection_unregister_object().
 */
guint
e_gdbus_book_view_register_object (EGdbusBookView *object,
           GDBusConnection *connection,
           const gchar *object_path,
           GError **error)
{
  G_GNUC_UNUSED GVariant *value;
  GHashTable *pvc;

  pvc = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_variant_unref);

  g_object_set_data_full (G_OBJECT (object), "gdbus-codegen-path", (gpointer) g_strdup (object_path), g_free);
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-connection", (gpointer) connection);
  g_object_set_data_full (G_OBJECT (object), "gdbus-codegen-pvc", (gpointer) pvc, (GDestroyNotify) g_hash_table_unref);
  g_signal_connect (object, "notify", G_CALLBACK (on_notify), NULL);
  return g_dbus_connection_register_object (connection,
          object_path,
          (GDBusInterfaceInfo *) &_e_gdbus_book_view_interface_info,
          &e_gdbus_book_view_interface_vtable,
          object,
          (GDestroyNotify) on_object_unregistered,
          error);
}

/**
 * e_gdbus_book_view_interface_info:
 *
 * Gets interface description for the <literal>org.gnome.evolution.dataserver.addressbook.BookView</literal> D-Bus interface.
 *
 * Returns: A #GDBusInterfaceInfo. Do not free, the object is statically allocated.
 */
const GDBusInterfaceInfo *
e_gdbus_book_view_interface_info (void)
{
  return &_e_gdbus_book_view_interface_info;
}

/* ---------------------------------------------------------------------- */

static void proxy_iface_init (EGdbusBookViewIface *iface);

G_DEFINE_TYPE_WITH_CODE (EGdbusBookViewProxy, e_gdbus_book_view_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (E_GDBUS_TYPE_BOOK_VIEW, proxy_iface_init));

static void
e_gdbus_book_view_proxy_init (EGdbusBookViewProxy *proxy)
{
  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy),
                                   (GDBusInterfaceInfo *) &_e_gdbus_book_view_interface_info);
}

static void
g_signal (GDBusProxy  *proxy,
          const gchar *sender_name,
          const gchar *signal_name,
          GVariant    *parameters)
{
  guint signal_id;
  signal_id = lookup_signal_id_from_signal_name (signal_name);
  switch (signal_id)
    {
    case __CONTACTS_ADDED_SIGNAL:
      {
        const gchar * const *arg_vcards;
        g_variant_get (parameters,
                       "(^a&s)",
                       &arg_vcards);
        g_signal_emit (proxy,
                       signals[signal_id],
                       0, arg_vcards);
        g_free ((gpointer) arg_vcards);
      }
      break;

    case __CONTACTS_CHANGED_SIGNAL:
      {
        const gchar * const *arg_vcards;
        g_variant_get (parameters,
                       "(^a&s)",
                       &arg_vcards);
        g_signal_emit (proxy,
                       signals[signal_id],
                       0, arg_vcards);
        g_free ((gpointer) arg_vcards);
      }
      break;

    case __CONTACTS_REMOVED_SIGNAL:
      {
        const gchar * const *arg_ids;
        g_variant_get (parameters,
                       "(^a&s)",
                       &arg_ids);
        g_signal_emit (proxy,
                       signals[signal_id],
                       0, arg_ids);
        g_free ((gpointer) arg_ids);
      }
      break;

    case __STATUS_MESSAGE_SIGNAL:
      {
        const gchar *arg_message;
        g_variant_get (parameters,
                       "(&s)",
                       &arg_message);
        g_signal_emit (proxy,
                       signals[signal_id],
                       0, arg_message);
      }
      break;

    case __COMPLETE_SIGNAL:
      {
        guint arg_status;
        const gchar *arg_message;
        g_variant_get (parameters,
                       "(u&s)",
                       &arg_status,
                       &arg_message);
        g_signal_emit (proxy,
                       signals[signal_id],
                       0, arg_status, arg_message);
      }
      break;

    }
}

static void
e_gdbus_book_view_proxy_get_property (GObject      *object,
                       guint         prop_id,
                       GValue       *value,
                       GParamSpec   *pspec)
{
  G_GNUC_UNUSED GVariant *cached;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
property_set_cb (GDBusProxy   *proxy,
                 GAsyncResult *res,
                 gpointer      user_data)
{
  const gchar *property_name = user_data;
  GError *error;
  GVariant *result;

  error = NULL;
  result = g_dbus_proxy_call_finish (proxy, res, &error);
  if (result == NULL)
    {
      g_warning ("Error setting property `%s': %s", property_name, error->message);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (result);
    }
}

static void
e_gdbus_book_view_proxy_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  GVariant *new_value;
  const gchar *property_name;
  new_value = NULL;
  property_name = NULL;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }

  if (new_value != NULL)
    {
      g_variant_ref_sink (new_value);
      g_dbus_proxy_call (G_DBUS_PROXY (object),
                         "org.freedesktop.DBus.Properties.Set",
                         g_variant_new ("(ssv)",
                                        "org.gnome.evolution.dataserver.addressbook.BookView",
                                        property_name,
                                        new_value),
                         G_DBUS_CALL_FLAGS_NONE,
                         -1,
                         NULL,
                         (GAsyncReadyCallback) property_set_cb,
                         (gpointer) property_name);
      g_variant_unref (new_value);
    }

}

static void
g_properties_changed (GDBusProxy         *proxy,
                      GVariant           *changed_properties,
                      const gchar * const *invalidated_properties)
{
  guint n;
  const gchar *key;
  GVariantIter *iter;
  const gchar *gname;

  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      gname = lookup_property_gname_from_property_name (key);
      if (gname != NULL)
        g_object_notify (G_OBJECT (proxy), gname);
    }

  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      gname = lookup_property_gname_from_property_name (invalidated_properties[n]);
      if (gname != NULL)
        g_object_notify (G_OBJECT (proxy), gname);
    }

}

static void
e_gdbus_book_view_proxy_class_init (EGdbusBookViewProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->get_property = e_gdbus_book_view_proxy_get_property;
  gobject_class->set_property = e_gdbus_book_view_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = g_signal;
  proxy_class->g_properties_changed = g_properties_changed;

}

static void
proxy_iface_init (EGdbusBookViewIface *iface)
{
}

/**
 * e_gdbus_book_view_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Like g_dbus_proxy_new() but returns a #EGdbusBookViewProxy.
 *
 * This is a failable asynchronous constructor - when the proxy is ready, callback will be invoked and you can use e_gdbus_book_view_proxy_new_finish() to get the result.
 */
void e_gdbus_book_view_proxy_new (GDBusConnection     *connection,
                   GDBusProxyFlags      flags,
                   const gchar         *name,
                   const gchar         *object_path,
                   GCancellable        *cancellable,
                   GAsyncReadyCallback  callback,
                   gpointer             user_data)
{
  g_async_initable_new_async (E_GDBUS_TYPE_BOOK_VIEW_PROXY,
                              G_PRIORITY_DEFAULT,
                              cancellable,
                              callback,
                              user_data,
                              "g-flags", flags,
                              "g-name", name,
                              "g-connection", connection,
                              "g-object-path", object_path,
                              "g-interface-name", "org.gnome.evolution.dataserver.addressbook.BookView",
                              NULL);
}

/**
 * e_gdbus_book_view_proxy_new_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to e_gdbus_book_view_proxy_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #EGdbusBookViewProxy.
 *
 * Returns: A #EGdbusBookViewProxy or %NULL if @error is set. Free with g_object_unref().
 */
EGdbusBookView *e_gdbus_book_view_proxy_new_finish (GAsyncResult  *res,
                        GError       **error)
{
  GObject *object;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  g_assert (source_object != NULL);
  object = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object),
                                        res,
                                        error);
  g_object_unref (source_object);
  if (object != NULL)
    return E_GDBUS_BOOK_VIEW (object);
  else
    return NULL;
}

/**
 * e_gdbus_book_view_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_new_sync() but returns a #EGdbusBookViewProxy.
 *
 * This is a synchronous failable constructor. See e_gdbus_book_view_proxy_new() and e_gdbus_book_view_proxy_new_finish() for the asynchronous version.
 *
 * Returns: A #EGdbusBookViewProxy or %NULL if error is set. Free with g_object_unref().
 */
EGdbusBookView *e_gdbus_book_view_proxy_new_sync (GDBusConnection     *connection,
                       GDBusProxyFlags      flags,
                       const gchar         *name,
                       const gchar         *object_path,
                       GCancellable        *cancellable,
                       GError             **error)
{
  GInitable *initable;
  initable = g_initable_new (E_GDBUS_TYPE_BOOK_VIEW_PROXY,
                             cancellable,
                             error,
                             "g-flags", flags,
                             "g-name", name,
                             "g-connection", connection,
                             "g-object-path", object_path,
                             "g-interface-name", "org.gnome.evolution.dataserver.addressbook.BookView",
                             NULL);
  if (initable != NULL)
    return E_GDBUS_BOOK_VIEW (initable);
  else
    return NULL;
}

/**
 * e_gdbus_book_view_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Like g_dbus_proxy_new_for_bus() but returns a #EGdbusBookViewProxy.
 *
 * This is a failable asynchronous constructor - when the proxy is ready, callback will be invoked and you can use e_gdbus_book_view_proxy_new_for_bus_finish() to get the result.
 */
void e_gdbus_book_view_proxy_new_for_bus (GBusType             bus_type,
                           GDBusProxyFlags      flags,
                           const gchar         *name,
                           const gchar         *object_path,
                           GCancellable        *cancellable,
                           GAsyncReadyCallback  callback,
                           gpointer             user_data)
{
  g_async_initable_new_async (E_GDBUS_TYPE_BOOK_VIEW_PROXY,
                              G_PRIORITY_DEFAULT,
                              cancellable,
                              callback,
                              user_data,
                              "g-flags", flags,
                              "g-name", name,
                              "g-bus-type", bus_type,
                              "g-object-path", object_path,
                              "g-interface-name", "org.gnome.evolution.dataserver.addressbook.BookView",
                              NULL);
}

/**
 * e_gdbus_book_view_proxy_new_for_bus_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to e_gdbus_book_view_proxy_new_for_bus().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #EGdbusBookViewProxy.
 *
 * Returns: A #EGdbusBookViewProxy or %NULL if @error is set. Free with g_object_unref().
 */
EGdbusBookView *e_gdbus_book_view_proxy_new_for_bus_finish (GAsyncResult  *res,
                                GError       **error)
{
  GObject *object;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  g_assert (source_object != NULL);
  object = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object),
                                        res,
                                        error);
  g_object_unref (source_object);
  if (object != NULL)
    return E_GDBUS_BOOK_VIEW (object);
  else
    return NULL;
}

/**
 * e_gdbus_book_view_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_new_for_bus_sync() but returns a #EGdbusBookViewProxy.
 *
 * This is a synchronous failable constructor. See e_gdbus_book_view_proxy_new_for_bus() and e_gdbus_book_view_proxy_new_for_bus_finish() for the asynchronous version.
 *
 * Returns: A #EGdbusBookViewProxy or %NULL if error is set. Free with g_object_unref().
 */
EGdbusBookView *e_gdbus_book_view_proxy_new_for_bus_sync (GBusType             bus_type,
                               GDBusProxyFlags      flags,
                               const gchar         *name,
                               const gchar         *object_path,
                               GCancellable        *cancellable,
                               GError             **error)
{
  GInitable *initable;
  initable = g_initable_new (E_GDBUS_TYPE_BOOK_VIEW_PROXY,
                             cancellable,
                             error,
                             "g-flags", flags,
                             "g-name", name,
                             "g-bus-type", bus_type,
                             "g-object-path", object_path,
                             "g-interface-name", "org.gnome.evolution.dataserver.addressbook.BookView",
                             NULL);
  if (initable != NULL)
    return E_GDBUS_BOOK_VIEW (initable);
  else
    return NULL;
}

/* ---------------------------------------------------------------------- */

struct _EGdbusBookViewStubPrivate
{
  gint foo;
};

static void stub_iface_init (EGdbusBookViewIface *iface);

G_DEFINE_TYPE_WITH_CODE (EGdbusBookViewStub, e_gdbus_book_view_stub, G_TYPE_OBJECT,
                         G_IMPLEMENT_INTERFACE (E_GDBUS_TYPE_BOOK_VIEW, stub_iface_init));

static void
e_gdbus_book_view_stub_finalize (GObject *object)
{
  G_GNUC_UNUSED EGdbusBookViewStub *stub = (EGdbusBookViewStub *) object;
  if (G_OBJECT_CLASS (e_gdbus_book_view_stub_parent_class)->finalize != NULL)
    G_OBJECT_CLASS (e_gdbus_book_view_stub_parent_class)->finalize (object);
}

static void
e_gdbus_book_view_stub_get_property (GObject      *object,
                      guint         prop_id,
                      GValue       *value,
                      GParamSpec   *pspec)
{
  G_GNUC_UNUSED static gchar **strv_of_len_zero = {NULL};
  G_GNUC_UNUSED EGdbusBookViewStub *stub = (EGdbusBookViewStub *) object;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
e_gdbus_book_view_stub_set_property (GObject      *object,
                      guint         prop_id,
                      const GValue *value,
                      GParamSpec   *pspec)
{
  G_GNUC_UNUSED EGdbusBookViewStub *stub = (EGdbusBookViewStub *) object;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
e_gdbus_book_view_stub_init (EGdbusBookViewStub *stub)
{
  stub->priv = G_TYPE_INSTANCE_GET_PRIVATE (stub, E_GDBUS_TYPE_BOOK_VIEW_STUB, EGdbusBookViewStubPrivate);
}

static void
e_gdbus_book_view_stub_class_init (EGdbusBookViewStubClass *klass)
{
  GObjectClass *gobject_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = e_gdbus_book_view_stub_finalize;
  gobject_class->get_property = e_gdbus_book_view_stub_get_property;
  gobject_class->set_property = e_gdbus_book_view_stub_set_property;
  g_type_class_add_private (klass, sizeof (EGdbusBookViewStubPrivate));
}

static void
stub_iface_init (EGdbusBookViewIface *iface)
{
}

/**
 * e_gdbus_book_view_stub_new:
 *
 * Creates a new stub object that can be exported via e_gdbus_book_view_register_object().
 *
 * Returns: A #EGdbusBookViewStub instance. Free with g_object_unref().
 */
EGdbusBookView *
e_gdbus_book_view_stub_new (void)
{
  return E_GDBUS_BOOK_VIEW (g_object_new (E_GDBUS_TYPE_BOOK_VIEW_STUB, NULL));
}
