/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors: Guillaume Desmottes <guillaume.desmottes@collabora.co.uk>
 */

#ifndef __EMPATHY_CHANNEL_FACTORY_H__
#define __EMPATHY_CHANNEL_FACTORY_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define EMPATHY_TYPE_CHANNEL_FACTORY         (empathy_channel_factory_get_type ())
#define EMPATHY_CHANNEL_FACTORY(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), EMPATHY_TYPE_CHANNEL_FACTORY, EmpathyChannelFactory))
#define EMPATHY_CHANNEL_FACTORY_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), EMPATHY_TYPE_CHANNEL_FACTORY, EmpathyChannelFactoryClass))
#define EMPATHY_IS_CHANNEL_FACTORY(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), EMPATHY_TYPE_CHANNEL_FACTORY))
#define EMPATHY_IS_CHANNEL_FACTORY_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), EMPATHY_TYPE_CHANNEL_FACTORY))
#define EMPATHY_CHANNEL_FACTORY_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), EMPATHY_TYPE_CHANNEL_FACTORY, EmpathyChannelFactoryClass))

typedef struct _EmpathyChannelFactory EmpathyChannelFactory;
typedef struct _EmpathyChannelFactoryClass EmpathyChannelFactoryClass;
typedef struct _EmpathyChannelFactoryPrivate EmpathyChannelFactoryPrivate;

struct _EmpathyChannelFactory
{
  GObject parent;
  EmpathyChannelFactoryPrivate *priv;
};

struct _EmpathyChannelFactoryClass
{
  GObjectClass parent_class;
};

GType empathy_channel_factory_get_type (void) G_GNUC_CONST;

EmpathyChannelFactory * empathy_channel_factory_new (void);

EmpathyChannelFactory * empathy_channel_factory_dup (void);

G_END_DECLS
#endif /* __EMPATHY_CHANNEL_FACTORY_H__ */
