/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/* eel-pango-extensions.h - interface for new functions that conceptually
                            belong in pango. Perhaps some of these will be
                            actually rolled into pango someday.

   Copyright (C) 2001 Anders Carlsson

   The Eel Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Eel Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Eel Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Authors: Anders Carlsson <andersca@gnu.org>
*/

#include <config.h>
#include "eel-pango-extensions.h"

#include <string.h>

PangoAttrList *
eel_pango_attr_list_copy_or_create (PangoAttrList *attr_list)
{
	if (attr_list != NULL) {
		return pango_attr_list_copy (attr_list);
	}
	return pango_attr_list_new ();
}

PangoAttrList *
eel_pango_attr_list_apply_global_attribute (PangoAttrList *attr_list,
					    PangoAttribute *attr)
{
	PangoAttrList *new_attr_list;

	g_return_val_if_fail (attr != NULL, NULL);

	attr->start_index = 0;
	attr->end_index = G_MAXINT;
	
	new_attr_list = eel_pango_attr_list_copy_or_create (attr_list);
	pango_attr_list_change (new_attr_list, attr);
	return new_attr_list;
}

static void
apply_global_attribute (PangoLayout *layout, PangoAttribute *attr)
{
	PangoAttrList *attr_list;
	PangoAttrList *old_attr_list;

	old_attr_list = pango_layout_get_attributes (layout);
	attr_list = eel_pango_attr_list_apply_global_attribute (old_attr_list, attr);
	pango_layout_set_attributes (layout, attr_list);
	pango_attr_list_unref (attr_list);
}

void
eel_pango_layout_set_underline (PangoLayout *layout, PangoUnderline underline)
{
	apply_global_attribute (layout, pango_attr_underline_new (underline));
}

void
eel_pango_layout_set_weight (PangoLayout *layout, PangoWeight weight)
{
	apply_global_attribute (layout, pango_attr_weight_new (weight));
}

void
eel_pango_layout_set_font_desc_from_string (PangoLayout *layout, const char *str)
{
	PangoFontDescription *desc;

	desc = pango_font_description_from_string (str);
	pango_layout_set_font_description (layout, desc);
	pango_font_description_free (desc);
}

