/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/* eel-gobject-extensions.h - interface for new functions that conceptually
                              belong in glib. Perhaps some of these will be
                              actually rolled into glib someday.

   Copyright (C) 2001 Darin Adler

   The Eel Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Eel Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Eel Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Authors: Darin Adler <darin@bentspoon.com>
*/

#ifndef EEL_GOBJECT_EXTENSIONS_H
#define EEL_GOBJECT_EXTENSIONS_H

#include <glib-object.h>

void eel_signal_connect_object_while_alive (GObject     *object,
					    const char  *signal,
					    GCallback    callback,
					    GObject     *alive_object);
void eel_signal_connect_while_alive        (GObject     *object,
					    const char  *signal,
					    GCallback    callback,
					    gpointer     callback_data,
					    GObject     *alive_object);

#endif /* EEL_GOBJECT_EXTENSIONS_H */
