/* ease-pdf-element.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-pdf-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <poppler.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;
typedef struct _EaseMediaElementPrivate EaseMediaElementPrivate;

#define EASE_TYPE_PDF_ELEMENT (ease_pdf_element_get_type ())
#define EASE_PDF_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_PDF_ELEMENT, EasePdfElement))
#define EASE_PDF_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_PDF_ELEMENT, EasePdfElementClass))
#define EASE_IS_PDF_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_PDF_ELEMENT))
#define EASE_IS_PDF_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_PDF_ELEMENT))
#define EASE_PDF_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_PDF_ELEMENT, EasePdfElementClass))

typedef struct _EasePdfElement EasePdfElement;
typedef struct _EasePdfElementClass EasePdfElementClass;
typedef struct _EasePdfElementPrivate EasePdfElementPrivate;

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;

#define EASE_TYPE_BACKGROUND_WIDGET (ease_background_widget_get_type ())
#define EASE_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidget))
#define EASE_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))
#define EASE_IS_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_IS_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_BACKGROUND_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))

typedef struct _EaseBackgroundWidget EaseBackgroundWidget;
typedef struct _EaseBackgroundWidgetClass EaseBackgroundWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_PDF_ACTOR (ease_pdf_actor_get_type ())
#define EASE_PDF_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_PDF_ACTOR, EasePdfActor))
#define EASE_PDF_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_PDF_ACTOR, EasePdfActorClass))
#define EASE_IS_PDF_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_PDF_ACTOR))
#define EASE_IS_PDF_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_PDF_ACTOR))
#define EASE_PDF_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_PDF_ACTOR, EasePdfActorClass))

typedef struct _EasePdfActor EasePdfActor;
typedef struct _EasePdfActorClass EasePdfActorClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;
typedef struct _Block10Data Block10Data;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	void (*cairo_render_small) (EaseElement* self, cairo_t* context, GError** error);
	void (*cairo_free_cache) (EaseElement* self);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
	float (*get_minimum_width) (EaseElement* self);
	float (*get_minimum_height) (EaseElement* self);
};

struct _EaseMediaElement {
	EaseElement parent_instance;
	EaseMediaElementPrivate * priv;
};

struct _EaseMediaElementClass {
	EaseElementClass parent_class;
};

struct _EasePdfElement {
	EaseMediaElement parent_instance;
	EasePdfElementPrivate * priv;
	EaseBackground* background;
	PopplerDocument* pdf_doc;
};

struct _EasePdfElementClass {
	EaseMediaElementClass parent_class;
};

struct _EasePdfElementPrivate {
	gint _displayed_page;
	gboolean _allow_flipping;
	EaseBackgroundWidget* bg_widget;
};

struct _Block10Data {
	int _ref_count_;
	EasePdfElement * self;
	gboolean silence_undo;
	GtkHScale* scale;
	GtkCheckButton* flip;
};


static gpointer ease_pdf_element_parent_class = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_media_element_get_type (void) G_GNUC_CONST;
GType ease_pdf_element_get_type (void) G_GNUC_CONST;
GType ease_background_get_type (void) G_GNUC_CONST;
GType ease_background_widget_get_type (void) G_GNUC_CONST;
#define EASE_PDF_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_PDF_ELEMENT, EasePdfElementPrivate))
enum  {
	EASE_PDF_ELEMENT_DUMMY_PROPERTY,
	EASE_PDF_ELEMENT_DISPLAYED_PAGE,
	EASE_PDF_ELEMENT_ALLOW_FLIPPING
};
#define EASE_PDF_ELEMENT_UI_FILE "inspector-element-pdf.ui"
#define EASE_PDF_ELEMENT_DEFAULT_PAGE 0
EasePdfElement* ease_pdf_element_new (const char* filename);
EasePdfElement* ease_pdf_element_construct (GType object_type, const char* filename);
EaseMediaElement* ease_media_element_construct (GType object_type);
EaseBackground* ease_background_new_white (void);
EaseBackground* ease_background_construct_white (GType object_type);
void ease_element_signals (EaseElement* self);
GType ease_slide_get_type (void) G_GNUC_CONST;
EasePdfElement* ease_pdf_element_new_from_json (JsonObject* obj, EaseSlide* owner);
EasePdfElement* ease_pdf_element_construct_from_json (GType object_type, JsonObject* obj, EaseSlide* owner);
EaseMediaElement* ease_media_element_construct_from_json (GType object_type, JsonObject* obj);
void ease_element_set_parent (EaseElement* self, EaseSlide* value);
#define EASE_THEME_PDF_DEFAULT_PAGE "pdf-default-page"
void ease_pdf_element_set_displayed_page (EasePdfElement* self, gint value);
#define EASE_THEME_PDF_ALLOW_FLIPPING "pdf-allow-flipping"
void ease_pdf_element_set_allow_flipping (EasePdfElement* self, gboolean value);
#define EASE_THEME_BACKGROUND "background"
EaseBackground* ease_background_new_from_json (JsonObject* obj);
EaseBackground* ease_background_construct_from_json (GType object_type, JsonObject* obj);
char* ease_media_element_get_full_filename (EaseMediaElement* self);
static EaseActor* ease_pdf_element_real_actor (EaseElement* base, EaseActorContext c);
EasePdfActor* ease_pdf_actor_new (EasePdfElement* e, EaseActorContext c);
EasePdfActor* ease_pdf_actor_construct (GType object_type, EasePdfElement* e, EaseActorContext c);
GType ease_pdf_actor_get_type (void) G_GNUC_CONST;
static JsonObject* ease_pdf_element_real_to_json (EaseElement* base);
JsonObject* ease_element_to_json (EaseElement* self);
JsonObject* ease_background_to_json (EaseBackground* self);
gint ease_pdf_element_get_displayed_page (EasePdfElement* self);
gboolean ease_pdf_element_get_allow_flipping (EasePdfElement* self);
static char* ease_pdf_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter);
char* ease_temp_request (GError** error);
float ease_element_get_width (EaseElement* self);
float ease_element_get_height (EaseElement* self);
void ease_element_cairo_render (EaseElement* self, cairo_t* context, GError** error);
gint ease_html_exporter_get_render_index (EaseHTMLExporter* self);
char* ease_html_exporter_copy_rendered (EaseHTMLExporter* self, const char* rendered);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
char* ease_html_exporter_get_basename (EaseHTMLExporter* self);
static void ease_pdf_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error);
void ease_background_cairo_render (EaseBackground* self, cairo_t* cr, gint width, gint height, const char* path, GError** error);
EaseSlide* ease_element_get_parent (EaseElement* self);
GType ease_document_get_type (void) G_GNUC_CONST;
EaseDocument* ease_slide_get_parent (EaseSlide* self);
const char* ease_document_get_path (EaseDocument* self);
static GtkWidget* ease_pdf_element_real_inspector_widget (EaseElement* base);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
static char* _lambda56_ (GtkScale* s, double value, EasePdfElement* self);
static char* __lambda56__gtk_scale_format_value (GtkScale* _sender, double value, gpointer self);
static void _lambda57_ (Block10Data* _data10_);
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
static void __lambda57__gtk_range_value_changed (GtkRange* _sender, gpointer self);
static void _lambda58_ (Block10Data* _data10_);
static void __lambda58__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda59_ (GtkToggleButton* button, Block10Data* _data10_);
static void __lambda59__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda60_ (Block10Data* _data10_);
static void __lambda60__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
EaseBackgroundWidget* ease_background_widget_new (EaseBackground* bg, EaseElement* e);
EaseBackgroundWidget* ease_background_widget_construct (GType object_type, EaseBackground* bg, EaseElement* e);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void ease_pdf_element_real_signals (EaseElement* base);
static void _lambda51_ (GObject* o, GParamSpec* p, EasePdfElement* self);
static void __lambda51__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda52_ (EaseUndoItem* item, EasePdfElement* self);
gboolean ease_background_owns_undoitem (EaseBackground* self, EaseUndoItem* item);
static void __lambda52__ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self);
static void ease_pdf_element_finalize (GObject* obj);
static void ease_pdf_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_pdf_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 48 "ease-pdf-element.vala"
EasePdfElement* ease_pdf_element_construct (GType object_type, const char* filename) {
#line 343 "ease-pdf-element.c"
	EasePdfElement * self;
	char* _tmp0_;
	char* _tmp1_;
	PopplerDocument* _tmp2_;
	PopplerDocument* _tmp3_;
	PopplerDocument* _tmp4_;
	EaseBackground* _tmp5_;
	GError * _inner_error_ = NULL;
#line 48 "ease-pdf-element.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 48 "ease-pdf-element.vala"
	self = (EasePdfElement*) ease_media_element_construct (object_type);
#line 50 "ease-pdf-element.vala"
	_tmp0_ = g_filename_to_uri (filename, NULL, &_inner_error_);
#line 358 "ease-pdf-element.c"
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 50 "ease-pdf-element.vala"
	_tmp3_ = (_tmp2_ = poppler_document_new_from_file (_tmp1_ = _tmp0_, NULL, &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
#line 366 "ease-pdf-element.c"
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 50 "ease-pdf-element.vala"
	self->pdf_doc = (_tmp4_ = _tmp3_, _g_object_unref0 (self->pdf_doc), _tmp4_);
#line 52 "ease-pdf-element.vala"
	self->background = (_tmp5_ = ease_background_new_white (), _g_object_unref0 (self->background), _tmp5_);
#line 53 "ease-pdf-element.vala"
	ease_element_signals ((EaseElement*) self);
#line 378 "ease-pdf-element.c"
	return self;
}


#line 48 "ease-pdf-element.vala"
EasePdfElement* ease_pdf_element_new (const char* filename) {
#line 48 "ease-pdf-element.vala"
	return ease_pdf_element_construct (EASE_TYPE_PDF_ELEMENT, filename);
#line 387 "ease-pdf-element.c"
}


#line 56 "ease-pdf-element.vala"
EasePdfElement* ease_pdf_element_construct_from_json (GType object_type, JsonObject* obj, EaseSlide* owner) {
#line 393 "ease-pdf-element.c"
	EasePdfElement * self;
	EaseBackground* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	PopplerDocument* _tmp5_;
	PopplerDocument* _tmp6_;
	PopplerDocument* _tmp7_;
	GError * _inner_error_ = NULL;
#line 56 "ease-pdf-element.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 56 "ease-pdf-element.vala"
	g_return_val_if_fail (owner != NULL, NULL);
#line 58 "ease-pdf-element.vala"
	self = (EasePdfElement*) ease_media_element_construct_from_json (object_type, obj);
#line 59 "ease-pdf-element.vala"
	ease_element_set_parent ((EaseElement*) self, owner);
#line 60 "ease-pdf-element.vala"
	ease_pdf_element_set_displayed_page (self, atoi (json_object_get_string_member (obj, EASE_THEME_PDF_DEFAULT_PAGE)));
#line 61 "ease-pdf-element.vala"
	ease_pdf_element_set_allow_flipping (self, json_object_get_boolean_member (obj, EASE_THEME_PDF_ALLOW_FLIPPING));
#line 63 "ease-pdf-element.vala"
	self->background = (_tmp0_ = ease_background_new_from_json (json_object_get_object_member (obj, EASE_THEME_BACKGROUND)), _g_object_unref0 (self->background), _tmp0_);
#line 66 "ease-pdf-element.vala"
	_tmp3_ = (_tmp2_ = g_filename_to_uri (_tmp1_ = ease_media_element_get_full_filename ((EaseMediaElement*) self), NULL, &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
#line 420 "ease-pdf-element.c"
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 66 "ease-pdf-element.vala"
	_tmp6_ = (_tmp5_ = poppler_document_new_from_file (_tmp4_ = _tmp3_, NULL, &_inner_error_), _g_free0 (_tmp4_), _tmp5_);
#line 428 "ease-pdf-element.c"
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 66 "ease-pdf-element.vala"
	self->pdf_doc = (_tmp7_ = _tmp6_, _g_object_unref0 (self->pdf_doc), _tmp7_);
#line 436 "ease-pdf-element.c"
	return self;
}


#line 56 "ease-pdf-element.vala"
EasePdfElement* ease_pdf_element_new_from_json (JsonObject* obj, EaseSlide* owner) {
#line 56 "ease-pdf-element.vala"
	return ease_pdf_element_construct_from_json (EASE_TYPE_PDF_ELEMENT, obj, owner);
#line 445 "ease-pdf-element.c"
}


#line 70 "ease-pdf-element.vala"
static EaseActor* ease_pdf_element_real_actor (EaseElement* base, EaseActorContext c) {
#line 451 "ease-pdf-element.c"
	EasePdfElement * self;
	EaseActor* result = NULL;
	self = (EasePdfElement*) base;
	result = (EaseActor*) g_object_ref_sink (ease_pdf_actor_new (self, c));
#line 72 "ease-pdf-element.vala"
	return result;
#line 458 "ease-pdf-element.c"
}


#line 75 "ease-pdf-element.vala"
static JsonObject* ease_pdf_element_real_to_json (EaseElement* base) {
#line 464 "ease-pdf-element.c"
	EasePdfElement * self;
	JsonObject* result = NULL;
	JsonObject* obj;
	char* _tmp0_;
	self = (EasePdfElement*) base;
#line 77 "ease-pdf-element.vala"
	obj = EASE_ELEMENT_CLASS (ease_pdf_element_parent_class)->to_json ((EaseElement*) EASE_MEDIA_ELEMENT (self));
#line 78 "ease-pdf-element.vala"
	json_object_set_object_member (obj, EASE_THEME_BACKGROUND, ease_background_to_json (self->background));
#line 79 "ease-pdf-element.vala"
	json_object_set_string_member (obj, EASE_THEME_PDF_DEFAULT_PAGE, _tmp0_ = g_strdup_printf ("%i", self->priv->_displayed_page));
#line 476 "ease-pdf-element.c"
	_g_free0 (_tmp0_);
#line 80 "ease-pdf-element.vala"
	json_object_set_boolean_member (obj, EASE_THEME_PDF_ALLOW_FLIPPING, self->priv->_allow_flipping);
#line 480 "ease-pdf-element.c"
	result = obj;
#line 81 "ease-pdf-element.vala"
	return result;
#line 484 "ease-pdf-element.c"
}


/**
 * Renders this PdfElement as HTML.
 */
#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 493 "ease-pdf-element.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 502 "ease-pdf-element.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 510 "ease-pdf-element.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch27_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 521 "ease-pdf-element.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch27_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 536 "ease-pdf-element.c"
	}
	goto __finally27;
	__catch27_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 547 "ease-pdf-element.c"
			_g_error_free0 (e);
		}
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 87 "ease-pdf-element.vala"
static char* ease_pdf_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter) {
#line 562 "ease-pdf-element.c"
	EasePdfElement * self;
	char* result = NULL;
	char* dir;
	cairo_surface_t* surface;
	cairo_t* cr;
	char* _tmp0_;
	char* _tmp1_;
	char* path;
	char* output;
	char* html;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	char* _tmp17_;
	char* _tmp18_;
	char* _tmp19_;
	char* _tmp20_;
	char* _tmp21_;
	char* _tmp22_;
	char* _tmp23_;
	char* _tmp24_;
	char* _tmp25_;
	char* _tmp26_;
	GError * _inner_error_ = NULL;
	self = (EasePdfElement*) base;
#line 87 "ease-pdf-element.vala"
	g_return_val_if_fail (exporter != NULL, NULL);
#line 89 "ease-pdf-element.vala"
	dir = ease_temp_request (&_inner_error_);
#line 604 "ease-pdf-element.c"
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 90 "ease-pdf-element.vala"
	surface = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) ease_element_get_width ((EaseElement*) self), (gint) ease_element_get_height ((EaseElement*) self));
#line 92 "ease-pdf-element.vala"
	cr = cairo_create (surface);
#line 93 "ease-pdf-element.vala"
	ease_element_cairo_render ((EaseElement*) self, cr, &_inner_error_);
#line 616 "ease-pdf-element.c"
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (surface);
		_g_free0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 95 "ease-pdf-element.vala"
	path = (_tmp1_ = g_build_filename (dir, _tmp0_ = g_strdup_printf ("%i", ease_html_exporter_get_render_index (exporter)), NULL), _g_free0 (_tmp0_), _tmp1_);
#line 96 "ease-pdf-element.vala"
	cairo_surface_write_to_png (surface, path);
#line 97 "ease-pdf-element.vala"
	output = ease_html_exporter_copy_rendered (exporter, path);
#line 100 "ease-pdf-element.vala"
	html = g_strdup ("<img class=\"pdf element\" ");
#line 103 "ease-pdf-element.vala"
	html = (_tmp2_ = g_strconcat (html, "style=\"", NULL), _g_free0 (html), _tmp2_);
#line 104 "ease-pdf-element.vala"
	html = (_tmp6_ = g_strconcat (html, _tmp5_ = g_strconcat (_tmp4_ = g_strconcat ("left:", _tmp3_ = g_strdup_printf ("%g", ease_element_get_x ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp6_);
#line 637 "ease-pdf-element.c"
	_g_free0 (_tmp5_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
#line 105 "ease-pdf-element.vala"
	html = (_tmp10_ = g_strconcat (html, _tmp9_ = g_strconcat (_tmp8_ = g_strconcat (" top:", _tmp7_ = g_strdup_printf ("%g", ease_element_get_y ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp10_);
#line 643 "ease-pdf-element.c"
	_g_free0 (_tmp9_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp7_);
#line 106 "ease-pdf-element.vala"
	html = (_tmp14_ = g_strconcat (html, _tmp13_ = g_strconcat (_tmp12_ = g_strconcat (" width:", _tmp11_ = g_strdup_printf ("%g", ease_element_get_width ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp14_);
#line 649 "ease-pdf-element.c"
	_g_free0 (_tmp13_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp11_);
#line 107 "ease-pdf-element.vala"
	html = (_tmp18_ = g_strconcat (html, _tmp17_ = g_strconcat (_tmp16_ = g_strconcat (" height:", _tmp15_ = g_strdup_printf ("%g", ease_element_get_height ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp18_);
#line 655 "ease-pdf-element.c"
	_g_free0 (_tmp17_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp15_);
#line 108 "ease-pdf-element.vala"
	html = (_tmp19_ = g_strconcat (html, " position: absolute;\" ", NULL), _g_free0 (html), _tmp19_);
#line 661 "ease-pdf-element.c"
	result = (_tmp26_ = g_strconcat (_tmp25_ = g_strconcat (_tmp20_ = g_strconcat (html, "src=\"", NULL), _tmp24_ = string_replace (_tmp23_ = g_strconcat (_tmp22_ = g_strconcat (_tmp21_ = ease_html_exporter_get_basename (exporter), " Media/", NULL), output, NULL), " ", "%20"), NULL), "\" alt=\"PDF\" />", NULL), _g_free0 (_tmp25_), _g_free0 (_tmp24_), _g_free0 (_tmp23_), _g_free0 (_tmp22_), _g_free0 (_tmp21_), _g_free0 (_tmp20_), _tmp26_);
	_g_free0 (html);
	_g_free0 (output);
	_g_free0 (path);
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	_g_free0 (dir);
#line 111 "ease-pdf-element.vala"
	return result;
#line 671 "ease-pdf-element.c"
	_g_free0 (html);
	_g_free0 (output);
	_g_free0 (path);
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	_g_free0 (dir);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 117 "ease-pdf-element.vala"
static void ease_pdf_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error) {
#line 688 "ease-pdf-element.c"
	EasePdfElement * self;
	PopplerPage* page;
	double w;
	double h;
	GError * _inner_error_ = NULL;
	self = (EasePdfElement*) base;
#line 117 "ease-pdf-element.vala"
	g_return_if_fail (context != NULL);
#line 120 "ease-pdf-element.vala"
	ease_background_cairo_render (self->background, context, (gint) ease_element_get_width ((EaseElement*) self), (gint) ease_element_get_height ((EaseElement*) self), ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))), &_inner_error_);
#line 699 "ease-pdf-element.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 124 "ease-pdf-element.vala"
	page = _g_object_ref0 (poppler_document_get_page (self->pdf_doc, self->priv->_displayed_page));
#line 127 "ease-pdf-element.vala"
	w = (double) 0;
#line 127 "ease-pdf-element.vala"
	h = (double) 0;
#line 128 "ease-pdf-element.vala"
	poppler_page_get_size (page, &w, &h);
#line 129 "ease-pdf-element.vala"
	cairo_scale (context, ease_element_get_width ((EaseElement*) self) / w, ease_element_get_height ((EaseElement*) self) / h);
#line 132 "ease-pdf-element.vala"
	poppler_page_render (page, context);
#line 716 "ease-pdf-element.c"
	_g_object_unref0 (page);
}


#line 152 "ease-pdf-element.vala"
static char* _lambda56_ (GtkScale* s, double value, EasePdfElement* self) {
#line 723 "ease-pdf-element.c"
	char* result = NULL;
#line 152 "ease-pdf-element.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 727 "ease-pdf-element.c"
	result = g_strdup_printf ("%i", ((gint) value) + 1);
#line 153 "ease-pdf-element.vala"
	return result;
#line 731 "ease-pdf-element.c"
}


#line 152 "ease-pdf-element.vala"
static char* __lambda56__gtk_scale_format_value (GtkScale* _sender, double value, gpointer self) {
#line 737 "ease-pdf-element.c"
	char* result;
	result = _lambda56_ (_sender, value, self);
	return result;
}


#line 157 "ease-pdf-element.vala"
static void _lambda57_ (Block10Data* _data10_) {
#line 746 "ease-pdf-element.c"
	EasePdfElement * self;
	EaseUndoAction* action;
	self = _data10_->self;
#line 159 "ease-pdf-element.vala"
	action = ease_undo_action_new ((GObject*) self, "displayed-page");
#line 160 "ease-pdf-element.vala"
	g_signal_emit_by_name ((EaseElement*) self, "changed");
#line 162 "ease-pdf-element.vala"
	ease_pdf_element_set_displayed_page (self, (gint) gtk_adjustment_get_value (gtk_range_get_adjustment ((GtkRange*) _data10_->scale)));
#line 165 "ease-pdf-element.vala"
	if (!_data10_->silence_undo) {
#line 165 "ease-pdf-element.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 760 "ease-pdf-element.c"
	}
	_g_object_unref0 (action);
}


#line 157 "ease-pdf-element.vala"
static void __lambda57__gtk_range_value_changed (GtkRange* _sender, gpointer self) {
#line 768 "ease-pdf-element.c"
	_lambda57_ (self);
}


#line 168 "ease-pdf-element.vala"
static void _lambda58_ (Block10Data* _data10_) {
#line 775 "ease-pdf-element.c"
	EasePdfElement * self;
	self = _data10_->self;
#line 169 "ease-pdf-element.vala"
	_data10_->silence_undo = TRUE;
#line 170 "ease-pdf-element.vala"
	gtk_adjustment_set_value (gtk_range_get_adjustment ((GtkRange*) _data10_->scale), (double) self->priv->_displayed_page);
#line 171 "ease-pdf-element.vala"
	g_signal_emit_by_name ((EaseElement*) self, "changed");
#line 172 "ease-pdf-element.vala"
	_data10_->silence_undo = FALSE;
#line 786 "ease-pdf-element.c"
}


#line 168 "ease-pdf-element.vala"
static void __lambda58__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 792 "ease-pdf-element.c"
	_lambda58_ (self);
}


#line 179 "ease-pdf-element.vala"
static void _lambda59_ (GtkToggleButton* button, Block10Data* _data10_) {
#line 799 "ease-pdf-element.c"
	EasePdfElement * self;
	EaseUndoAction* action;
	self = _data10_->self;
#line 179 "ease-pdf-element.vala"
	g_return_if_fail (button != NULL);
#line 181 "ease-pdf-element.vala"
	action = ease_undo_action_new ((GObject*) self, "allow-flipping");
#line 183 "ease-pdf-element.vala"
	ease_pdf_element_set_allow_flipping (self, gtk_toggle_button_get_active (button));
#line 186 "ease-pdf-element.vala"
	if (!_data10_->silence_undo) {
#line 186 "ease-pdf-element.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 813 "ease-pdf-element.c"
	}
	_g_object_unref0 (action);
}


#line 179 "ease-pdf-element.vala"
static void __lambda59__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 821 "ease-pdf-element.c"
	_lambda59_ (_sender, self);
}


#line 189 "ease-pdf-element.vala"
static void _lambda60_ (Block10Data* _data10_) {
#line 828 "ease-pdf-element.c"
	EasePdfElement * self;
	self = _data10_->self;
#line 190 "ease-pdf-element.vala"
	_data10_->silence_undo = TRUE;
#line 191 "ease-pdf-element.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data10_->flip, self->priv->_allow_flipping);
#line 192 "ease-pdf-element.vala"
	_data10_->silence_undo = FALSE;
#line 837 "ease-pdf-element.c"
}


#line 189 "ease-pdf-element.vala"
static void __lambda60__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 843 "ease-pdf-element.c"
	_lambda60_ (self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->flip);
		_g_object_unref0 (_data10_->scale);
		g_slice_free (Block10Data, _data10_);
	}
}


#line 135 "ease-pdf-element.vala"
static GtkWidget* ease_pdf_element_real_inspector_widget (EaseElement* base) {
#line 866 "ease-pdf-element.c"
	EasePdfElement * self;
	GtkWidget* result = NULL;
	Block10Data* _data10_;
	GtkBuilder* builder;
	GObject* _tmp2_;
	GObject* _tmp3_;
	EaseBackgroundWidget* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (EasePdfElement*) base;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->silence_undo = FALSE;
#line 139 "ease-pdf-element.vala"
	builder = gtk_builder_new ();
#line 884 "ease-pdf-element.c"
	{
		char* _tmp0_;
		char* _tmp1_;
#line 142 "ease-pdf-element.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_PDF_ELEMENT_UI_FILE, NULL)), &_inner_error_);
#line 890 "ease-pdf-element.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 145 "ease-pdf-element.vala"
			g_error ("ease-pdf-element.vala:145: Error loading UI: %s", e->message);
#line 906 "ease-pdf-element.c"
			_g_error_free0 (e);
		}
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		block10_data_unref (_data10_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_data10_->scale = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "disp-page"), GTK_IS_HSCALE (_tmp2_) ? ((GtkHScale*) _tmp2_) : NULL));
#line 149 "ease-pdf-element.vala"
	gtk_adjustment_set_upper (gtk_range_get_adjustment ((GtkRange*) _data10_->scale), (double) poppler_document_get_n_pages (self->pdf_doc));
#line 152 "ease-pdf-element.vala"
	g_signal_connect_object ((GtkScale*) _data10_->scale, "format-value", (GCallback) __lambda56__gtk_scale_format_value, self, 0);
#line 157 "ease-pdf-element.vala"
	g_signal_connect_data ((GtkRange*) _data10_->scale, "value-changed", (GCallback) __lambda57__gtk_range_value_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 168 "ease-pdf-element.vala"
	g_signal_connect_data ((GObject*) self, "notify::displayed-page", (GCallback) __lambda58__g_object_notify, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 927 "ease-pdf-element.c"
	_data10_->flip = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "allow-flipping"), GTK_IS_CHECK_BUTTON (_tmp3_) ? ((GtkCheckButton*) _tmp3_) : NULL));
#line 177 "ease-pdf-element.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data10_->flip, self->priv->_allow_flipping);
#line 179 "ease-pdf-element.vala"
	g_signal_connect_data ((GtkToggleButton*) _data10_->flip, "toggled", (GCallback) __lambda59__gtk_toggle_button_toggled, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 189 "ease-pdf-element.vala"
	g_signal_connect_data ((GObject*) self, "notify::allow-flipping", (GCallback) __lambda60__g_object_notify, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 196 "ease-pdf-element.vala"
	self->priv->bg_widget = (_tmp4_ = g_object_ref_sink (ease_background_widget_new (self->background, (EaseElement*) self)), _g_object_unref0 (self->priv->bg_widget), _tmp4_);
#line 197 "ease-pdf-element.vala"
	gtk_box_pack_end ((_tmp5_ = gtk_builder_get_object (builder, "root-vbox"), GTK_IS_BOX (_tmp5_) ? ((GtkBox*) _tmp5_) : NULL), (GtkWidget*) self->priv->bg_widget, FALSE, TRUE, (guint) 0);
#line 199 "ease-pdf-element.vala"
	gtk_widget_show ((GtkWidget*) self->priv->bg_widget);
#line 941 "ease-pdf-element.c"
	result = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (builder, "root"), GTK_IS_WIDGET (_tmp6_) ? ((GtkWidget*) _tmp6_) : NULL));
	_g_object_unref0 (builder);
	block10_data_unref (_data10_);
#line 202 "ease-pdf-element.vala"
	return result;
#line 947 "ease-pdf-element.c"
	_g_object_unref0 (builder);
	block10_data_unref (_data10_);
}


#line 209 "ease-pdf-element.vala"
static void _lambda51_ (GObject* o, GParamSpec* p, EasePdfElement* self) {
#line 209 "ease-pdf-element.vala"
	g_return_if_fail (o != NULL);
#line 209 "ease-pdf-element.vala"
	g_return_if_fail (p != NULL);
#line 209 "ease-pdf-element.vala"
	g_signal_emit_by_name ((EaseElement*) self, "changed");
#line 961 "ease-pdf-element.c"
}


#line 209 "ease-pdf-element.vala"
static void __lambda51__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 967 "ease-pdf-element.c"
	_lambda51_ (_sender, pspec, self);
}


#line 211 "ease-pdf-element.vala"
static void _lambda52_ (EaseUndoItem* item, EasePdfElement* self) {
#line 211 "ease-pdf-element.vala"
	g_return_if_fail (item != NULL);
#line 212 "ease-pdf-element.vala"
	if (ease_background_owns_undoitem (self->background, item)) {
#line 212 "ease-pdf-element.vala"
		g_signal_emit_by_name ((EaseElement*) self, "changed");
#line 980 "ease-pdf-element.c"
	}
}


#line 211 "ease-pdf-element.vala"
static void __lambda52__ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self) {
#line 987 "ease-pdf-element.c"
	_lambda52_ (action, self);
}


#line 205 "ease-pdf-element.vala"
static void ease_pdf_element_real_signals (EaseElement* base) {
#line 994 "ease-pdf-element.c"
	EasePdfElement * self;
	self = (EasePdfElement*) base;
#line 207 "ease-pdf-element.vala"
	EASE_ELEMENT_CLASS (ease_pdf_element_parent_class)->signals ((EaseElement*) EASE_MEDIA_ELEMENT (self));
#line 209 "ease-pdf-element.vala"
	g_signal_connect_object ((GObject*) self, "notify::default-page", (GCallback) __lambda51__g_object_notify, self, 0);
#line 211 "ease-pdf-element.vala"
	g_signal_connect_object ((EaseUndoSource*) self, "undo", (GCallback) __lambda52__ease_undo_source_undo, self, 0);
#line 1003 "ease-pdf-element.c"
}


gint ease_pdf_element_get_displayed_page (EasePdfElement* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_displayed_page;
#line 29 "ease-pdf-element.vala"
	return result;
#line 1013 "ease-pdf-element.c"
}


void ease_pdf_element_set_displayed_page (EasePdfElement* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_displayed_page = value;
	g_object_notify ((GObject *) self, "displayed-page");
}


gboolean ease_pdf_element_get_allow_flipping (EasePdfElement* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_allow_flipping;
#line 34 "ease-pdf-element.vala"
	return result;
#line 1030 "ease-pdf-element.c"
}


void ease_pdf_element_set_allow_flipping (EasePdfElement* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_allow_flipping = value;
	g_object_notify ((GObject *) self, "allow-flipping");
}


static void ease_pdf_element_class_init (EasePdfElementClass * klass) {
	ease_pdf_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EasePdfElementPrivate));
	EASE_ELEMENT_CLASS (klass)->actor = ease_pdf_element_real_actor;
	EASE_ELEMENT_CLASS (klass)->to_json = ease_pdf_element_real_to_json;
	EASE_ELEMENT_CLASS (klass)->html_render = ease_pdf_element_real_html_render;
	EASE_ELEMENT_CLASS (klass)->cairo_render = ease_pdf_element_real_cairo_render;
	EASE_ELEMENT_CLASS (klass)->inspector_widget = ease_pdf_element_real_inspector_widget;
	EASE_ELEMENT_CLASS (klass)->signals = ease_pdf_element_real_signals;
	G_OBJECT_CLASS (klass)->get_property = ease_pdf_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_pdf_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_pdf_element_finalize;
	/**
	 * The page of the PDF file that is initially displayed.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_PDF_ELEMENT_DISPLAYED_PAGE, g_param_spec_int ("displayed-page", "displayed-page", "displayed-page", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Whether or not the user can change pages in the presentation.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_PDF_ELEMENT_ALLOW_FLIPPING, g_param_spec_boolean ("allow-flipping", "allow-flipping", "allow-flipping", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ease_pdf_element_instance_init (EasePdfElement * self) {
	self->priv = EASE_PDF_ELEMENT_GET_PRIVATE (self);
	self->priv->_displayed_page = 0;
	self->priv->_allow_flipping = TRUE;
}


static void ease_pdf_element_finalize (GObject* obj) {
	EasePdfElement * self;
	self = EASE_PDF_ELEMENT (obj);
	_g_object_unref0 (self->background);
	_g_object_unref0 (self->priv->bg_widget);
	_g_object_unref0 (self->pdf_doc);
	G_OBJECT_CLASS (ease_pdf_element_parent_class)->finalize (obj);
}


/**
 * Displays a PDF document in a presentation.
 */
GType ease_pdf_element_get_type (void) {
	static volatile gsize ease_pdf_element_type_id__volatile = 0;
	if (g_once_init_enter (&ease_pdf_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EasePdfElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_pdf_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EasePdfElement), 0, (GInstanceInitFunc) ease_pdf_element_instance_init, NULL };
		GType ease_pdf_element_type_id;
		ease_pdf_element_type_id = g_type_register_static (EASE_TYPE_MEDIA_ELEMENT, "EasePdfElement", &g_define_type_info, 0);
		g_once_init_leave (&ease_pdf_element_type_id__volatile, ease_pdf_element_type_id);
	}
	return ease_pdf_element_type_id__volatile;
}


static void ease_pdf_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EasePdfElement * self;
	self = EASE_PDF_ELEMENT (object);
	switch (property_id) {
		case EASE_PDF_ELEMENT_DISPLAYED_PAGE:
		g_value_set_int (value, ease_pdf_element_get_displayed_page (self));
		break;
		case EASE_PDF_ELEMENT_ALLOW_FLIPPING:
		g_value_set_boolean (value, ease_pdf_element_get_allow_flipping (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_pdf_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EasePdfElement * self;
	self = EASE_PDF_ELEMENT (object);
	switch (property_id) {
		case EASE_PDF_ELEMENT_DISPLAYED_PAGE:
		ease_pdf_element_set_displayed_page (self, g_value_get_int (value));
		break;
		case EASE_PDF_ELEMENT_ALLOW_FLIPPING:
		ease_pdf_element_set_allow_flipping (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




