/* ease-element.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	void (*cairo_render_small) (EaseElement* self, cairo_t* context, GError** error);
	void (*cairo_free_cache) (EaseElement* self);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
	float (*get_minimum_width) (EaseElement* self);
	float (*get_minimum_height) (EaseElement* self);
};

struct _EaseElementPrivate {
	EaseSlide* parent_priv;
	GtkWidget* inspector_widg;
	char* _identifier;
	char* _element_type;
	float _x;
	float _y;
	float _width;
	float _height;
	gboolean _has_been_edited;
};


static gpointer ease_element_parent_class = NULL;
static EaseUndoSourceIface* ease_element_ease_undo_source_parent_iface = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_slide_get_type (void) G_GNUC_CONST;
#define EASE_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_ELEMENT, EaseElementPrivate))
enum  {
	EASE_ELEMENT_DUMMY_PROPERTY,
	EASE_ELEMENT_PARENT,
	EASE_ELEMENT_DOCUMENT,
	EASE_ELEMENT_IDENTIFIER,
	EASE_ELEMENT_ELEMENT_TYPE,
	EASE_ELEMENT_X,
	EASE_ELEMENT_Y,
	EASE_ELEMENT_WIDTH,
	EASE_ELEMENT_HEIGHT,
	EASE_ELEMENT_HAS_BEEN_EDITED
};
#define EASE_ELEMENT_THEME_WIDTH ((float) 800)
#define EASE_ELEMENT_THEME_HEIGHT ((float) 600)
#define EASE_ELEMENT_DEFAULT_MIN_WIDTH ((float) 20)
#define EASE_ELEMENT_DEFAULT_MIN_HEIGHT ((float) 20)
EaseElement* ease_element_construct_from_json (GType object_type, JsonObject* obj);
void ease_element_signals (EaseElement* self);
#define EASE_THEME_E_IDENTIFIER "element-identifier"
void ease_element_set_identifier (EaseElement* self, const char* value);
#define EASE_THEME_X "x"
void ease_element_set_x (EaseElement* self, float value);
#define EASE_THEME_Y "y"
void ease_element_set_y (EaseElement* self, float value);
#define EASE_THEME_WIDTH "width"
void ease_element_set_width (EaseElement* self, float value);
#define EASE_THEME_HEIGHT "height"
void ease_element_set_height (EaseElement* self, float value);
#define EASE_THEME_HAS_BEEN_EDITED "has-been-edited"
void ease_element_set_has_been_edited (EaseElement* self, gboolean value);
static void ease_element_real_signals (EaseElement* self);
static void _lambda3_ (GObject* o, GParamSpec* p, EaseElement* self);
static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda4_ (GObject* o, GParamSpec* p, EaseElement* self);
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda5_ (GObject* o, GParamSpec* p, EaseElement* self);
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda6_ (GObject* o, GParamSpec* p, EaseElement* self);
static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
JsonObject* ease_element_to_json (EaseElement* self);
static JsonObject* ease_element_real_to_json (EaseElement* self);
const char* ease_element_get_identifier (EaseElement* self);
#define EASE_THEME_ELEMENT_TYPE "element-type"
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
float ease_element_get_width (EaseElement* self);
float ease_element_get_height (EaseElement* self);
gboolean ease_element_get_has_been_edited (EaseElement* self);
EaseElement* ease_element_construct_with_owner (GType object_type, EaseSlide* owner);
void ease_element_set_parent (EaseElement* self, EaseSlide* value);
void ease_element_to_html (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
static void ease_element_real_to_html (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
char* ease_element_html_render (EaseElement* self, EaseHTMLExporter* exporter);
void ease_html_exporter_add_progress (EaseHTMLExporter* self, double amount);
char** ease_element_claim_media (EaseElement* self, int* result_length1);
static char** ease_element_real_claim_media (EaseElement* self, int* result_length1);
void ease_element_request_advance (EaseElement* self);
EaseSlide* ease_element_get_parent (EaseElement* self);
static char* ease_element_real_html_render (EaseElement* self, EaseHTMLExporter* exporter);
void ease_element_cairo_render (EaseElement* self, cairo_t* context, GError** error);
static void ease_element_real_cairo_render (EaseElement* self, cairo_t* context, GError** error);
void ease_element_cairo_render_small (EaseElement* self, cairo_t* context, GError** error);
static void ease_element_real_cairo_render_small (EaseElement* self, cairo_t* context, GError** error);
void ease_element_cairo_free_cache (EaseElement* self);
static void ease_element_real_cairo_free_cache (EaseElement* self);
EaseActor* ease_element_actor (EaseElement* self, EaseActorContext c);
static EaseActor* ease_element_real_actor (EaseElement* self, EaseActorContext c);
GtkWidget* ease_element_inspector_widget (EaseElement* self);
static GtkWidget* ease_element_real_inspector_widget (EaseElement* self);
GtkWidget* ease_element_get_inspector_widget (EaseElement* self);
GList* ease_element_tool_items (EaseElement* self);
static GList* ease_element_real_tool_items (EaseElement* self);
gboolean ease_element_set_color (EaseElement* self, ClutterColor* c);
static gboolean ease_element_real_set_color (EaseElement* self, ClutterColor* c);
ClutterColor* ease_element_get_color (EaseElement* self);
static ClutterColor* ease_element_real_get_color (EaseElement* self);
float ease_element_get_minimum_width (EaseElement* self);
static float ease_element_real_get_minimum_width (EaseElement* self);
float ease_element_get_minimum_height (EaseElement* self);
static float ease_element_real_get_minimum_height (EaseElement* self);
EaseElement* ease_element_construct (GType object_type);
static void _lambda2_ (EaseElement* self);
static void __lambda2__ease_element_changed (EaseElement* _sender, gpointer self);
GType ease_document_get_type (void) G_GNUC_CONST;
EaseDocument* ease_element_get_document (EaseElement* self);
EaseDocument* ease_slide_get_parent (EaseSlide* self);
const char* ease_element_get_element_type (EaseElement* self);
void ease_element_set_element_type (EaseElement* self, const char* value);
static void ease_element_finalize (GObject* obj);
static void ease_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Creates an Element from a JsonObject
 */
#line 1057 "glib-2.0.vapi"
static gboolean string_to_bool (const char* self) {
#line 255 "ease-element.c"
	gboolean result = FALSE;
#line 1057 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1058 "glib-2.0.vapi"
	if (_vala_strcmp0 (self, "true") == 0) {
#line 261 "ease-element.c"
		result = TRUE;
#line 1059 "glib-2.0.vapi"
		return result;
#line 265 "ease-element.c"
	} else {
		result = FALSE;
#line 1061 "glib-2.0.vapi"
		return result;
#line 270 "ease-element.c"
	}
}


#line 81 "ease-element.vala"
EaseElement* ease_element_construct_from_json (GType object_type, JsonObject* obj) {
#line 277 "ease-element.c"
	EaseElement * self;
#line 81 "ease-element.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 81 "ease-element.vala"
	self = (EaseElement*) g_object_new (object_type, NULL);
#line 83 "ease-element.vala"
	ease_element_signals (self);
#line 84 "ease-element.vala"
	ease_element_set_identifier (self, json_object_get_string_member (obj, EASE_THEME_E_IDENTIFIER));
#line 85 "ease-element.vala"
	ease_element_set_x (self, (float) g_ascii_strtod (json_object_get_string_member (obj, EASE_THEME_X), NULL));
#line 86 "ease-element.vala"
	ease_element_set_y (self, (float) g_ascii_strtod (json_object_get_string_member (obj, EASE_THEME_Y), NULL));
#line 87 "ease-element.vala"
	ease_element_set_width (self, (float) g_ascii_strtod (json_object_get_string_member (obj, EASE_THEME_WIDTH), NULL));
#line 88 "ease-element.vala"
	ease_element_set_height (self, (float) g_ascii_strtod (json_object_get_string_member (obj, EASE_THEME_HEIGHT), NULL));
#line 89 "ease-element.vala"
	ease_element_set_has_been_edited (self, string_to_bool (json_object_get_string_member (obj, EASE_THEME_HAS_BEEN_EDITED)));
#line 297 "ease-element.c"
	return self;
}


/**
 * Connects base Element signals.
 */
#line 98 "ease-element.vala"
static void _lambda3_ (GObject* o, GParamSpec* p, EaseElement* self) {
#line 98 "ease-element.vala"
	g_return_if_fail (o != NULL);
#line 98 "ease-element.vala"
	g_return_if_fail (p != NULL);
#line 98 "ease-element.vala"
	g_signal_emit_by_name (self, "changed");
#line 313 "ease-element.c"
}


#line 98 "ease-element.vala"
static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 319 "ease-element.c"
	_lambda3_ (_sender, pspec, self);
}


#line 99 "ease-element.vala"
static void _lambda4_ (GObject* o, GParamSpec* p, EaseElement* self) {
#line 99 "ease-element.vala"
	g_return_if_fail (o != NULL);
#line 99 "ease-element.vala"
	g_return_if_fail (p != NULL);
#line 99 "ease-element.vala"
	g_signal_emit_by_name (self, "changed");
#line 332 "ease-element.c"
}


#line 99 "ease-element.vala"
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 338 "ease-element.c"
	_lambda4_ (_sender, pspec, self);
}


#line 100 "ease-element.vala"
static void _lambda5_ (GObject* o, GParamSpec* p, EaseElement* self) {
#line 100 "ease-element.vala"
	g_return_if_fail (o != NULL);
#line 100 "ease-element.vala"
	g_return_if_fail (p != NULL);
#line 100 "ease-element.vala"
	g_signal_emit_by_name (self, "position-changed");
#line 351 "ease-element.c"
}


#line 100 "ease-element.vala"
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 357 "ease-element.c"
	_lambda5_ (_sender, pspec, self);
}


#line 101 "ease-element.vala"
static void _lambda6_ (GObject* o, GParamSpec* p, EaseElement* self) {
#line 101 "ease-element.vala"
	g_return_if_fail (o != NULL);
#line 101 "ease-element.vala"
	g_return_if_fail (p != NULL);
#line 101 "ease-element.vala"
	g_signal_emit_by_name (self, "position-changed");
#line 370 "ease-element.c"
}


#line 101 "ease-element.vala"
static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 376 "ease-element.c"
	_lambda6_ (_sender, pspec, self);
}


#line 96 "ease-element.vala"
static void ease_element_real_signals (EaseElement* self) {
#line 96 "ease-element.vala"
	g_return_if_fail (self != NULL);
#line 98 "ease-element.vala"
	g_signal_connect_object ((GObject*) self, "notify::width", (GCallback) __lambda3__g_object_notify, self, 0);
#line 99 "ease-element.vala"
	g_signal_connect_object ((GObject*) self, "notify::height", (GCallback) __lambda4__g_object_notify, self, 0);
#line 100 "ease-element.vala"
	g_signal_connect_object ((GObject*) self, "notify::x", (GCallback) __lambda5__g_object_notify, self, 0);
#line 101 "ease-element.vala"
	g_signal_connect_object ((GObject*) self, "notify::y", (GCallback) __lambda6__g_object_notify, self, 0);
#line 393 "ease-element.c"
}


#line 81 "ease-element.vala"
void ease_element_signals (EaseElement* self) {
#line 81 "ease-element.vala"
	EASE_ELEMENT_GET_CLASS (self)->signals (self);
#line 401 "ease-element.c"
}


/**
 * Writes an Element to a JsonObject
 */
#line 35 "glib-2.0.vapi"
static char* bool_to_string (gboolean self) {
#line 410 "ease-element.c"
	char* result = NULL;
#line 36 "glib-2.0.vapi"
	if (self) {
#line 414 "ease-element.c"
		result = g_strdup ("true");
#line 37 "glib-2.0.vapi"
		return result;
#line 418 "ease-element.c"
	} else {
		result = g_strdup ("false");
#line 39 "glib-2.0.vapi"
		return result;
#line 423 "ease-element.c"
	}
}


#line 107 "ease-element.vala"
static JsonObject* ease_element_real_to_json (EaseElement* self) {
#line 430 "ease-element.c"
	JsonObject* result = NULL;
	JsonObject* obj;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
#line 107 "ease-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 109 "ease-element.vala"
	obj = json_object_new ();
#line 111 "ease-element.vala"
	json_object_set_string_member (obj, EASE_THEME_E_IDENTIFIER, self->priv->_identifier);
#line 112 "ease-element.vala"
	json_object_set_string_member (obj, EASE_THEME_ELEMENT_TYPE, g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self)));
#line 113 "ease-element.vala"
	json_object_set_string_member (obj, EASE_THEME_X, _tmp0_ = g_strdup_printf ("%g", self->priv->_x));
#line 448 "ease-element.c"
	_g_free0 (_tmp0_);
#line 114 "ease-element.vala"
	json_object_set_string_member (obj, EASE_THEME_Y, _tmp1_ = g_strdup_printf ("%g", self->priv->_y));
#line 452 "ease-element.c"
	_g_free0 (_tmp1_);
#line 115 "ease-element.vala"
	json_object_set_string_member (obj, EASE_THEME_WIDTH, _tmp2_ = g_strdup_printf ("%g", self->priv->_width));
#line 456 "ease-element.c"
	_g_free0 (_tmp2_);
#line 116 "ease-element.vala"
	json_object_set_string_member (obj, EASE_THEME_HEIGHT, _tmp3_ = g_strdup_printf ("%g", self->priv->_height));
#line 460 "ease-element.c"
	_g_free0 (_tmp3_);
#line 117 "ease-element.vala"
	json_object_set_string_member (obj, EASE_THEME_HAS_BEEN_EDITED, _tmp4_ = bool_to_string (self->priv->_has_been_edited));
#line 464 "ease-element.c"
	_g_free0 (_tmp4_);
	result = obj;
#line 120 "ease-element.vala"
	return result;
#line 469 "ease-element.c"
}


JsonObject* ease_element_to_json (EaseElement* self) {
	return EASE_ELEMENT_GET_CLASS (self)->to_json (self);
}


/**
 * Create a new element.
 *
 * @param owner The slide that this Element belongs to.
 */
#line 128 "ease-element.vala"
EaseElement* ease_element_construct_with_owner (GType object_type, EaseSlide* owner) {
#line 485 "ease-element.c"
	EaseElement * self;
#line 128 "ease-element.vala"
	g_return_val_if_fail (owner != NULL, NULL);
#line 128 "ease-element.vala"
	self = (EaseElement*) g_object_new (object_type, NULL);
#line 130 "ease-element.vala"
	ease_element_set_parent (self, owner);
#line 493 "ease-element.c"
	return self;
}


/**
 * Creates HTML markup for this Element.
 * 
 * The <div> tag for this Element is appended to the "HTML" parameter.
 * This should be inside a <div> tag for the Element's {@link Slide}.
 *
 * @param html The HTML string in its current state.
 * @param exporter The {@link HTMLExporter}, for the path and progress.
 * @param amount The amount progress should increase by when done.
 */
#line 143 "ease-element.vala"
static void ease_element_real_to_html (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount) {
#line 510 "ease-element.c"
	char* _tmp0_;
	char* _tmp1_;
#line 143 "ease-element.vala"
	g_return_if_fail (self != NULL);
#line 143 "ease-element.vala"
	g_return_if_fail (html != NULL);
#line 143 "ease-element.vala"
	g_return_if_fail (exporter != NULL);
#line 148 "ease-element.vala"
	*html = (_tmp1_ = g_strconcat (*html, _tmp0_ = ease_element_html_render (self, exporter), NULL), _g_free0 (*html), _tmp1_);
#line 521 "ease-element.c"
	_g_free0 (_tmp0_);
#line 151 "ease-element.vala"
	ease_html_exporter_add_progress (exporter, amount);
#line 525 "ease-element.c"
}


#line 128 "ease-element.vala"
void ease_element_to_html (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount) {
#line 128 "ease-element.vala"
	EASE_ELEMENT_GET_CLASS (self)->to_html (self, html, exporter, amount);
#line 533 "ease-element.c"
}


/**
 * Allows a subclass of Element to "claim" media files. Media files that
 * are not claimed will not be included when the {@link Document} is saved.
 * Subclasses with media should override this method and return an
 * appropriate array. The "short" (not absolute) path must be used.
 */
#line 160 "ease-element.vala"
static char** ease_element_real_claim_media (EaseElement* self, int* result_length1) {
#line 545 "ease-element.c"
	char** result = NULL;
	char** _tmp0_ = NULL;
	char** _tmp1_;
#line 160 "ease-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 551 "ease-element.c"
	result = (_tmp1_ = (_tmp0_ = g_new0 (char*, 0 + 1), _tmp0_), *result_length1 = 0, _tmp1_);
#line 162 "ease-element.vala"
	return result;
#line 555 "ease-element.c"
}


#line 128 "ease-element.vala"
char** ease_element_claim_media (EaseElement* self, int* result_length1) {
#line 128 "ease-element.vala"
	return EASE_ELEMENT_GET_CLASS (self)->claim_media (self, result_length1);
#line 563 "ease-element.c"
}


/**
 * Requests that the presentation be advanced a slide.
 */
#line 168 "ease-element.vala"
void ease_element_request_advance (EaseElement* self) {
#line 168 "ease-element.vala"
	g_return_if_fail (self != NULL);
#line 170 "ease-element.vala"
	g_signal_emit_by_name (ease_element_get_parent (self), "request-advance", self);
#line 576 "ease-element.c"
}


/**
 * Creates the actual HTML markup for this Element.
 *
 * @param html The HTML string in its current state.
 * @param exporter The {@link HTMLExporter}, for its path.
 */
#line 179 "ease-element.vala"
static char* ease_element_real_html_render (EaseElement* self, EaseHTMLExporter* exporter) {
#line 588 "ease-element.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `ease_element_html_render'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* ease_element_html_render (EaseElement* self, EaseHTMLExporter* exporter) {
	return EASE_ELEMENT_GET_CLASS (self)->html_render (self, exporter);
}


/**
 * Renders this Element to a CairoContext.
 *
 * @param context The context to render to.
 */
#line 186 "ease-element.vala"
static void ease_element_real_cairo_render (EaseElement* self, cairo_t* context, GError** error) {
#line 607 "ease-element.c"
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `ease_element_cairo_render'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void ease_element_cairo_render (EaseElement* self, cairo_t* context, GError** error) {
	EASE_ELEMENT_GET_CLASS (self)->cairo_render (self, context, error);
}


/**
 * Renders this Element to a thumbnail-sized CairoContext. The ability to
 * override this method in subclasses allows for optimizations to be
 * performed, preventing slowdown.
 *
 * Especially when dragging Elements around, thumbnails are rapidly redrawn.
 * If an Element subclass uses any potentially large media files, it is a
 * good idea to override this method, cache a low resolution version of the
 * file, and draw with that.
 *
 * If not overriden, this method will simply call {@link cairo_render}.
 *
 * @param context The context to render to.
 */
#line 202 "ease-element.vala"
static void ease_element_real_cairo_render_small (EaseElement* self, cairo_t* context, GError** error) {
#line 635 "ease-element.c"
	GError * _inner_error_ = NULL;
#line 202 "ease-element.vala"
	g_return_if_fail (self != NULL);
#line 202 "ease-element.vala"
	g_return_if_fail (context != NULL);
#line 204 "ease-element.vala"
	ease_element_cairo_render (self, context, &_inner_error_);
#line 643 "ease-element.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void ease_element_cairo_render_small (EaseElement* self, cairo_t* context, GError** error) {
	EASE_ELEMENT_GET_CLASS (self)->cairo_render_small (self, context, error);
}


/**
 * Instructs subclasses to free any cached data for Cairo rendering.
 */
#line 210 "ease-element.vala"
static void ease_element_real_cairo_free_cache (EaseElement* self) {
#line 210 "ease-element.vala"
	g_return_if_fail (self != NULL);
#line 663 "ease-element.c"
}


void ease_element_cairo_free_cache (EaseElement* self) {
	EASE_ELEMENT_GET_CLASS (self)->cairo_free_cache (self);
}


/**
 * Returns a ClutterActor for use in presentations and the editor.
 *
 * @param c The context of the actor.
 */
#line 217 "ease-element.vala"
static EaseActor* ease_element_real_actor (EaseElement* self, EaseActorContext c) {
#line 679 "ease-element.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `ease_element_actor'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


EaseActor* ease_element_actor (EaseElement* self, EaseActorContext c) {
	return EASE_ELEMENT_GET_CLASS (self)->actor (self, c);
}


/**
 * Returns an Inspector widget for editing this Element. This is
 * a new widget - use {@link get_inspector_widget} to retrieve the cached
 * widget (or automatically create a new one if needed.
 */
#line 224 "ease-element.vala"
static GtkWidget* ease_element_real_inspector_widget (EaseElement* self) {
#line 698 "ease-element.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `ease_element_inspector_widget'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWidget* ease_element_inspector_widget (EaseElement* self) {
	return EASE_ELEMENT_GET_CLASS (self)->inspector_widget (self);
}


/**
 * Returns the Element's inspector widget.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 229 "ease-element.vala"
GtkWidget* ease_element_get_inspector_widget (EaseElement* self) {
#line 720 "ease-element.c"
	GtkWidget* result = NULL;
	GtkWidget* _tmp0_;
#line 229 "ease-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 231 "ease-element.vala"
	if (self->priv->inspector_widg != NULL) {
#line 727 "ease-element.c"
		result = _g_object_ref0 (self->priv->inspector_widg);
#line 231 "ease-element.vala"
		return result;
#line 731 "ease-element.c"
	}
	result = _g_object_ref0 (self->priv->inspector_widg = (_tmp0_ = ease_element_inspector_widget (self), _g_object_unref0 (self->priv->inspector_widg), _tmp0_));
#line 232 "ease-element.vala"
	return result;
#line 736 "ease-element.c"
}


/**
 * Returns a GList of ToolItems to add to the main toolbar when this
 * Element is selected.
 */
#line 240 "ease-element.vala"
static GList* ease_element_real_tool_items (EaseElement* self) {
#line 746 "ease-element.c"
	GList* result = NULL;
#line 240 "ease-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 750 "ease-element.c"
	result = NULL;
#line 242 "ease-element.vala"
	return result;
#line 754 "ease-element.c"
}


GList* ease_element_tool_items (EaseElement* self) {
	return EASE_ELEMENT_GET_CLASS (self)->tool_items (self);
}


/**
 * If applicable, this method sets the color of an Element and returns true.
 * Otherwise, it returns false. The method should be overridden by
 * subclasses that provide a "color" property.
 *
 * @param c The color to set the element to.
 */
#line 252 "ease-element.vala"
static gboolean ease_element_real_set_color (EaseElement* self, ClutterColor* c) {
#line 772 "ease-element.c"
	gboolean result = FALSE;
#line 252 "ease-element.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 776 "ease-element.c"
	result = FALSE;
#line 254 "ease-element.vala"
	return result;
#line 780 "ease-element.c"
}


gboolean ease_element_set_color (EaseElement* self, ClutterColor* c) {
	return EASE_ELEMENT_GET_CLASS (self)->set_color (self, c);
}


/**
 * If applicable, this method returns the color of an Element. By default,
 * it returns null. Subclasses that provide a color property should override
 * this method.
 */
#line 262 "ease-element.vala"
static ClutterColor* ease_element_real_get_color (EaseElement* self) {
#line 796 "ease-element.c"
	ClutterColor* result = NULL;
#line 262 "ease-element.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 800 "ease-element.c"
	result = NULL;
#line 264 "ease-element.vala"
	return result;
#line 804 "ease-element.c"
}


ClutterColor* ease_element_get_color (EaseElement* self) {
	return EASE_ELEMENT_GET_CLASS (self)->get_color (self);
}


/**
 * This method represents the minimum width of this Element type. The user
 * will be unable to resize the Element's width any smaller than this.
 * If desired, subclasses can override this method to provide a custom
 * minimum size.
 */
#line 273 "ease-element.vala"
static float ease_element_real_get_minimum_width (EaseElement* self) {
#line 821 "ease-element.c"
	float result = 0.0F;
#line 273 "ease-element.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 825 "ease-element.c"
	result = EASE_ELEMENT_DEFAULT_MIN_WIDTH;
#line 275 "ease-element.vala"
	return result;
#line 829 "ease-element.c"
}


float ease_element_get_minimum_width (EaseElement* self) {
	return EASE_ELEMENT_GET_CLASS (self)->get_minimum_width (self);
}


/**
 * This method represents the minimum height of this Element type. The user
 * will be unable to resize the Element's height any smaller than this.
 * If desired, subclasses can override this method to provide a custom
 * minimum size.
 */
#line 284 "ease-element.vala"
static float ease_element_real_get_minimum_height (EaseElement* self) {
#line 846 "ease-element.c"
	float result = 0.0F;
#line 284 "ease-element.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 850 "ease-element.c"
	result = EASE_ELEMENT_DEFAULT_MIN_HEIGHT;
#line 286 "ease-element.vala"
	return result;
#line 854 "ease-element.c"
}


float ease_element_get_minimum_height (EaseElement* self) {
	return EASE_ELEMENT_GET_CLASS (self)->get_minimum_height (self);
}


#line 25 "ease-element.vala"
EaseElement* ease_element_construct (GType object_type) {
#line 865 "ease-element.c"
	EaseElement * self;
#line 25 "ease-element.vala"
	self = (EaseElement*) g_object_new (object_type, NULL);
#line 869 "ease-element.c"
	return self;
}


EaseSlide* ease_element_get_parent (EaseElement* self) {
	EaseSlide* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->parent_priv;
#line 52 "ease-element.vala"
	return result;
#line 880 "ease-element.c"
}


#line 56 "ease-element.vala"
static void _lambda2_ (EaseElement* self) {
#line 56 "ease-element.vala"
	g_signal_emit_by_name (ease_element_get_parent (self), "changed", ease_element_get_parent (self));
#line 888 "ease-element.c"
}


#line 56 "ease-element.vala"
static void __lambda2__ease_element_changed (EaseElement* _sender, gpointer self) {
#line 894 "ease-element.c"
	_lambda2_ (self);
}


void ease_element_set_parent (EaseElement* self, EaseSlide* value) {
	EaseSlide* _tmp0_;
	g_return_if_fail (self != NULL);
#line 55 "ease-element.vala"
	self->priv->parent_priv = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->parent_priv), _tmp0_);
#line 56 "ease-element.vala"
	g_signal_connect_object (self, "changed", (GCallback) __lambda2__ease_element_changed, self, 0);
#line 906 "ease-element.c"
	g_object_notify ((GObject *) self, "parent");
}


EaseDocument* ease_element_get_document (EaseElement* self) {
	EaseDocument* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = ease_slide_get_parent (ease_element_get_parent (self));
#line 64 "ease-element.vala"
	return result;
#line 917 "ease-element.c"
}


const char* ease_element_get_identifier (EaseElement* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_identifier;
#line 295 "ease-element.vala"
	return result;
#line 927 "ease-element.c"
}


void ease_element_set_identifier (EaseElement* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_identifier = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_identifier), _tmp0_);
	g_object_notify ((GObject *) self, "identifier");
}


const char* ease_element_get_element_type (EaseElement* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_element_type;
#line 300 "ease-element.vala"
	return result;
#line 945 "ease-element.c"
}


void ease_element_set_element_type (EaseElement* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_element_type = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_element_type), _tmp0_);
	g_object_notify ((GObject *) self, "element-type");
}


float ease_element_get_x (EaseElement* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_x;
#line 305 "ease-element.vala"
	return result;
#line 963 "ease-element.c"
}


void ease_element_set_x (EaseElement* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_x = value;
	g_object_notify ((GObject *) self, "x");
}


float ease_element_get_y (EaseElement* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_y;
#line 310 "ease-element.vala"
	return result;
#line 980 "ease-element.c"
}


void ease_element_set_y (EaseElement* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_y = value;
	g_object_notify ((GObject *) self, "y");
}


float ease_element_get_width (EaseElement* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_width;
#line 315 "ease-element.vala"
	return result;
#line 997 "ease-element.c"
}


void ease_element_set_width (EaseElement* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_width = value;
	g_object_notify ((GObject *) self, "width");
}


float ease_element_get_height (EaseElement* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_height;
#line 320 "ease-element.vala"
	return result;
#line 1014 "ease-element.c"
}


void ease_element_set_height (EaseElement* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_height = value;
	g_object_notify ((GObject *) self, "height");
}


gboolean ease_element_get_has_been_edited (EaseElement* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_been_edited;
#line 325 "ease-element.vala"
	return result;
#line 1031 "ease-element.c"
}


void ease_element_set_has_been_edited (EaseElement* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_been_edited = value;
	g_object_notify ((GObject *) self, "has-been-edited");
}


static void ease_element_class_init (EaseElementClass * klass) {
	ease_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseElementPrivate));
	EASE_ELEMENT_CLASS (klass)->signals = ease_element_real_signals;
	EASE_ELEMENT_CLASS (klass)->to_json = ease_element_real_to_json;
	EASE_ELEMENT_CLASS (klass)->to_html = ease_element_real_to_html;
	EASE_ELEMENT_CLASS (klass)->claim_media = ease_element_real_claim_media;
	EASE_ELEMENT_CLASS (klass)->html_render = ease_element_real_html_render;
	EASE_ELEMENT_CLASS (klass)->cairo_render = ease_element_real_cairo_render;
	EASE_ELEMENT_CLASS (klass)->cairo_render_small = ease_element_real_cairo_render_small;
	EASE_ELEMENT_CLASS (klass)->cairo_free_cache = ease_element_real_cairo_free_cache;
	EASE_ELEMENT_CLASS (klass)->actor = ease_element_real_actor;
	EASE_ELEMENT_CLASS (klass)->inspector_widget = ease_element_real_inspector_widget;
	EASE_ELEMENT_CLASS (klass)->tool_items = ease_element_real_tool_items;
	EASE_ELEMENT_CLASS (klass)->set_color = ease_element_real_set_color;
	EASE_ELEMENT_CLASS (klass)->get_color = ease_element_real_get_color;
	EASE_ELEMENT_CLASS (klass)->get_minimum_width = ease_element_real_get_minimum_width;
	EASE_ELEMENT_CLASS (klass)->get_minimum_height = ease_element_real_get_minimum_height;
	G_OBJECT_CLASS (klass)->get_property = ease_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_element_finalize;
	/**
	 * The {@link Slide} that this Element is a part of.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_PARENT, g_param_spec_object ("parent", "parent", "parent", EASE_TYPE_SLIDE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The {@link Document} that this Element is part of. get-only.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_DOCUMENT, g_param_spec_object ("document", "document", "document", EASE_TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The Element's identifier on its master {@link Slide}.
	 *
	 * This property allows Ease to simply change the theme of a {@link Slide}.
	 * Elements can be quickly matched up and updated appropriately.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_IDENTIFIER, g_param_spec_string ("identifier", "identifier", "identifier", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The Element's type: currently "text", "image", or "video".
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_ELEMENT_TYPE, g_param_spec_string ("element-type", "element-type", "element-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The X position of this Element.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_X, g_param_spec_float ("x", "x", "x", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The Y position of this Element.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_Y, g_param_spec_float ("y", "y", "y", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The width of this Element.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_WIDTH, g_param_spec_float ("width", "width", "width", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The height of this Element.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_HEIGHT, g_param_spec_float ("height", "height", "height", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * If the Element has been edited by the user in the past.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_ELEMENT_HAS_BEEN_EDITED, g_param_spec_boolean ("has-been-edited", "has-been-edited", "has-been-edited", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Notifies of a position change for this Element. Note that the "x" and "y"
	 * properties do not emit the "changed" signal - only this signal.
	 */
	g_signal_new ("position_changed", EASE_TYPE_ELEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Notifies of a general change in the Element. Subclasses that play nice
	 * should add handlers to trigger this signal.
	 */
	g_signal_new ("changed", EASE_TYPE_ELEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void ease_element_ease_undo_source_interface_init (EaseUndoSourceIface * iface) {
	ease_element_ease_undo_source_parent_iface = g_type_interface_peek_parent (iface);
}


static void ease_element_instance_init (EaseElement * self) {
	self->priv = EASE_ELEMENT_GET_PRIVATE (self);
}


static void ease_element_finalize (GObject* obj) {
	EaseElement * self;
	self = EASE_ELEMENT (obj);
	_g_object_unref0 (self->priv->parent_priv);
	_g_object_unref0 (self->priv->inspector_widg);
	_g_free0 (self->priv->_identifier);
	_g_free0 (self->priv->_element_type);
	G_OBJECT_CLASS (ease_element_parent_class)->finalize (obj);
}


/**
 * An object on a {@link Slide}.
 *
 * Elements form the content of {@link Document}s. The Element class is
 * abstract, so each type of element is represented by a subclass. The Element
 * base class contains properties common to all types of element.
 */
GType ease_element_get_type (void) {
	static volatile gsize ease_element_type_id__volatile = 0;
	if (g_once_init_enter (&ease_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseElement), 0, (GInstanceInitFunc) ease_element_instance_init, NULL };
		static const GInterfaceInfo ease_undo_source_info = { (GInterfaceInitFunc) ease_element_ease_undo_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType ease_element_type_id;
		ease_element_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseElement", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (ease_element_type_id, EASE_TYPE_UNDO_SOURCE, &ease_undo_source_info);
		g_once_init_leave (&ease_element_type_id__volatile, ease_element_type_id);
	}
	return ease_element_type_id__volatile;
}


static void ease_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseElement * self;
	self = EASE_ELEMENT (object);
	switch (property_id) {
		case EASE_ELEMENT_PARENT:
		g_value_set_object (value, ease_element_get_parent (self));
		break;
		case EASE_ELEMENT_DOCUMENT:
		g_value_set_object (value, ease_element_get_document (self));
		break;
		case EASE_ELEMENT_IDENTIFIER:
		g_value_set_string (value, ease_element_get_identifier (self));
		break;
		case EASE_ELEMENT_ELEMENT_TYPE:
		g_value_set_string (value, ease_element_get_element_type (self));
		break;
		case EASE_ELEMENT_X:
		g_value_set_float (value, ease_element_get_x (self));
		break;
		case EASE_ELEMENT_Y:
		g_value_set_float (value, ease_element_get_y (self));
		break;
		case EASE_ELEMENT_WIDTH:
		g_value_set_float (value, ease_element_get_width (self));
		break;
		case EASE_ELEMENT_HEIGHT:
		g_value_set_float (value, ease_element_get_height (self));
		break;
		case EASE_ELEMENT_HAS_BEEN_EDITED:
		g_value_set_boolean (value, ease_element_get_has_been_edited (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseElement * self;
	self = EASE_ELEMENT (object);
	switch (property_id) {
		case EASE_ELEMENT_PARENT:
		ease_element_set_parent (self, g_value_get_object (value));
		break;
		case EASE_ELEMENT_IDENTIFIER:
		ease_element_set_identifier (self, g_value_get_string (value));
		break;
		case EASE_ELEMENT_ELEMENT_TYPE:
		ease_element_set_element_type (self, g_value_get_string (value));
		break;
		case EASE_ELEMENT_X:
		ease_element_set_x (self, g_value_get_float (value));
		break;
		case EASE_ELEMENT_Y:
		ease_element_set_y (self, g_value_get_float (value));
		break;
		case EASE_ELEMENT_WIDTH:
		ease_element_set_width (self, g_value_get_float (value));
		break;
		case EASE_ELEMENT_HEIGHT:
		ease_element_set_height (self, g_value_get_float (value));
		break;
		case EASE_ELEMENT_HAS_BEEN_EDITED:
		ease_element_set_has_been_edited (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




