/* ease-handle.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-handle.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <ease-core.h>
#include <float.h>
#include <math.h>
#include <cairo.h>


#define EASE_TYPE_HANDLE (ease_handle_get_type ())
#define EASE_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HANDLE, EaseHandle))
#define EASE_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HANDLE, EaseHandleClass))
#define EASE_IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HANDLE))
#define EASE_IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HANDLE))
#define EASE_HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HANDLE, EaseHandleClass))

typedef struct _EaseHandle EaseHandle;
typedef struct _EaseHandleClass EaseHandleClass;
typedef struct _EaseHandlePrivate EaseHandlePrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _EaseHandle {
	ClutterCairoTexture parent_instance;
	EaseHandlePrivate * priv;
	EaseHandlePosition position;
};

struct _EaseHandleClass {
	ClutterCairoTextureClass parent_class;
};

struct _EaseHandlePrivate {
	gboolean flipped;
};


static gpointer ease_handle_parent_class = NULL;

GType ease_handle_get_type (void) G_GNUC_CONST;
#define EASE_HANDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_HANDLE, EaseHandlePrivate))
enum  {
	EASE_HANDLE_DUMMY_PROPERTY
};
#define EASE_HANDLE_SIZE 35
EaseHandle* ease_handle_new (EaseHandlePosition pos);
EaseHandle* ease_handle_construct (GType object_type, EaseHandlePosition pos);
static void ease_handle_redraw (EaseHandle* self);
void ease_handle_drag (EaseHandle* self, float change_x, float change_y, EaseElement* target, gboolean proportional, gboolean from_center);
void ease_handle_reposition (EaseHandle* self, ClutterActor* selection);
void ease_handle_flip (EaseHandle* self, gboolean f);
static void ease_handle_finalize (GObject* obj);



/**
 * Creates a Handle. Does automatically set the Handle's position - call
 * reposition() to do this.
 *
 * @param pos The position of this handle relative to the selection
 * rectangle.
 */
#line 45 "ease-handle.vala"
EaseHandle* ease_handle_construct (GType object_type, EaseHandlePosition pos) {
#line 85 "ease-handle.c"
	EaseHandle * self;
	guint _tmp0_;
	guint _tmp1_;
	self = g_object_newv (object_type, 0, NULL);
#line 48 "ease-handle.vala"
	clutter_actor_set_width ((ClutterActor*) self, (clutter_actor_set_height ((ClutterActor*) self, (float) (g_object_set ((ClutterCairoTexture*) self, "surface-width", (g_object_set ((ClutterCairoTexture*) self, "surface-height", (guint) EASE_HANDLE_SIZE, NULL), (g_object_get ((ClutterCairoTexture*) self, "surface-height", &_tmp0_, NULL), _tmp0_)), NULL), (g_object_get ((ClutterCairoTexture*) self, "surface-width", &_tmp1_, NULL), _tmp1_))), clutter_actor_get_height ((ClutterActor*) self)));
#line 51 "ease-handle.vala"
	ease_handle_redraw (self);
#line 54 "ease-handle.vala"
	self->position = pos;
#line 57 "ease-handle.vala"
	clutter_actor_set_anchor_point ((ClutterActor*) self, (float) (EASE_HANDLE_SIZE / 2), (float) (EASE_HANDLE_SIZE / 2));
#line 60 "ease-handle.vala"
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
#line 100 "ease-handle.c"
	return self;
}


#line 45 "ease-handle.vala"
EaseHandle* ease_handle_new (EaseHandlePosition pos) {
#line 45 "ease-handle.vala"
	return ease_handle_construct (EASE_TYPE_HANDLE, pos);
#line 109 "ease-handle.c"
}


/**
 * Performs a drag of the handle, updating the selected {@link Actor}'s size
 * and position.
 *
 * @param change_x The x drag distance.
 * @param change_y The y drag distance.
 * @param target The Element to update.
 * @param proportional If any scaling should be proportional, if possible.
 * @param from_center If the resize should operate from the center of the
 * target element.
 */
#line 74 "ease-handle.vala"
void ease_handle_drag (EaseHandle* self, float change_x, float change_y, EaseElement* target, gboolean proportional, gboolean from_center) {
#line 126 "ease-handle.c"
	float translate_x;
	float translate_y;
	float resize_x;
	float resize_y;
#line 74 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 74 "ease-handle.vala"
	g_return_if_fail (target != NULL);
#line 77 "ease-handle.vala"
	translate_x = (float) 0;
#line 77 "ease-handle.vala"
	translate_y = (float) 0;
#line 77 "ease-handle.vala"
	resize_x = (float) 0;
#line 77 "ease-handle.vala"
	resize_y = (float) 0;
#line 79 "ease-handle.vala"
	switch (self->position) {
#line 145 "ease-handle.c"
		case EASE_HANDLE_POSITION_TOP_LEFT:
		{
#line 82 "ease-handle.vala"
			if (proportional) {
#line 84 "ease-handle.vala"
				if ((change_x / change_y) > (ease_element_get_width (target) / ease_element_get_height (target))) {
#line 86 "ease-handle.vala"
					translate_x = change_y * (ease_element_get_width (target) / ease_element_get_height (target));
#line 87 "ease-handle.vala"
					translate_y = change_y;
#line 156 "ease-handle.c"
				} else {
#line 91 "ease-handle.vala"
					translate_y = change_x * (ease_element_get_height (target) / ease_element_get_width (target));
#line 92 "ease-handle.vala"
					translate_x = change_x;
#line 162 "ease-handle.c"
				}
#line 94 "ease-handle.vala"
				resize_x = -translate_x;
#line 95 "ease-handle.vala"
				resize_y = -translate_y;
#line 96 "ease-handle.vala"
				break;
#line 170 "ease-handle.c"
			}
#line 99 "ease-handle.vala"
			translate_x = change_x;
#line 100 "ease-handle.vala"
			translate_y = change_y;
#line 101 "ease-handle.vala"
			resize_x = -change_x;
#line 102 "ease-handle.vala"
			resize_y = -change_y;
#line 103 "ease-handle.vala"
			break;
#line 182 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP_RIGHT:
		{
#line 106 "ease-handle.vala"
			if (proportional) {
#line 108 "ease-handle.vala"
				if ((change_x / change_y) > (ease_element_get_width (target) / ease_element_get_height (target))) {
#line 110 "ease-handle.vala"
					resize_x = change_y * (ease_element_get_width (target) / ease_element_get_height (target));
#line 111 "ease-handle.vala"
					resize_y = change_y;
#line 194 "ease-handle.c"
				} else {
#line 115 "ease-handle.vala"
					resize_y = change_x * (ease_element_get_height (target) / ease_element_get_width (target));
#line 116 "ease-handle.vala"
					resize_x = change_x;
#line 200 "ease-handle.c"
				}
#line 118 "ease-handle.vala"
				translate_y = -resize_y;
#line 119 "ease-handle.vala"
				break;
#line 206 "ease-handle.c"
			}
#line 122 "ease-handle.vala"
			translate_y = change_y;
#line 123 "ease-handle.vala"
			resize_x = change_x;
#line 124 "ease-handle.vala"
			resize_y = -change_y;
#line 125 "ease-handle.vala"
			break;
#line 216 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP:
		{
#line 128 "ease-handle.vala"
			if (proportional) {
#line 130 "ease-handle.vala"
				resize_x = (-change_y) * (ease_element_get_width (target) / ease_element_get_height (target));
#line 131 "ease-handle.vala"
				translate_x = (-resize_x) / 2;
#line 226 "ease-handle.c"
			}
#line 134 "ease-handle.vala"
			translate_y = change_y;
#line 135 "ease-handle.vala"
			resize_y = -change_y;
#line 136 "ease-handle.vala"
			break;
#line 234 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM:
		{
#line 139 "ease-handle.vala"
			if (proportional) {
#line 141 "ease-handle.vala"
				resize_x = change_y * (ease_element_get_width (target) / ease_element_get_height (target));
#line 142 "ease-handle.vala"
				translate_x = (-resize_x) / 2;
#line 244 "ease-handle.c"
			}
#line 145 "ease-handle.vala"
			resize_y = change_y;
#line 146 "ease-handle.vala"
			break;
#line 250 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_LEFT:
		{
#line 149 "ease-handle.vala"
			if (proportional) {
#line 151 "ease-handle.vala"
				resize_y = (-change_x) * (ease_element_get_width (target) / ease_element_get_height (target));
#line 152 "ease-handle.vala"
				translate_y = (-resize_y) / 2;
#line 260 "ease-handle.c"
			}
#line 155 "ease-handle.vala"
			translate_x = change_x;
#line 156 "ease-handle.vala"
			resize_x = -change_x;
#line 157 "ease-handle.vala"
			break;
#line 268 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_RIGHT:
		{
#line 160 "ease-handle.vala"
			if (proportional) {
#line 162 "ease-handle.vala"
				resize_y = change_x * (ease_element_get_width (target) / ease_element_get_height (target));
#line 163 "ease-handle.vala"
				translate_y = (-resize_y) / 2;
#line 278 "ease-handle.c"
			}
#line 166 "ease-handle.vala"
			resize_x = change_x;
#line 167 "ease-handle.vala"
			break;
#line 284 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_LEFT:
		{
#line 170 "ease-handle.vala"
			if (proportional) {
#line 172 "ease-handle.vala"
				if ((change_x / change_y) > (ease_element_get_width (target) / ease_element_get_height (target))) {
#line 174 "ease-handle.vala"
					resize_x = (-change_y) * (ease_element_get_width (target) / ease_element_get_height (target));
#line 175 "ease-handle.vala"
					resize_y = -change_y;
#line 296 "ease-handle.c"
				} else {
#line 179 "ease-handle.vala"
					resize_y = (-change_x) * (ease_element_get_height (target) / ease_element_get_width (target));
#line 180 "ease-handle.vala"
					resize_x = -change_x;
#line 302 "ease-handle.c"
				}
#line 183 "ease-handle.vala"
				translate_x = -resize_x;
#line 184 "ease-handle.vala"
				break;
#line 308 "ease-handle.c"
			}
#line 187 "ease-handle.vala"
			translate_x = change_x;
#line 188 "ease-handle.vala"
			resize_x = -change_x;
#line 189 "ease-handle.vala"
			resize_y = change_y;
#line 190 "ease-handle.vala"
			break;
#line 318 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_RIGHT:
		{
#line 193 "ease-handle.vala"
			if (proportional) {
#line 195 "ease-handle.vala"
				if ((change_x / change_y) > (ease_element_get_width (target) / ease_element_get_height (target))) {
#line 197 "ease-handle.vala"
					resize_x = change_y * (ease_element_get_width (target) / ease_element_get_height (target));
#line 198 "ease-handle.vala"
					resize_y = change_y;
#line 330 "ease-handle.c"
				} else {
#line 202 "ease-handle.vala"
					resize_y = change_x * (ease_element_get_height (target) / ease_element_get_width (target));
#line 203 "ease-handle.vala"
					resize_x = change_x;
#line 336 "ease-handle.c"
				}
#line 205 "ease-handle.vala"
				break;
#line 340 "ease-handle.c"
			}
#line 208 "ease-handle.vala"
			resize_x = change_x;
#line 209 "ease-handle.vala"
			resize_y = change_y;
#line 210 "ease-handle.vala"
			break;
#line 348 "ease-handle.c"
		}
	}
#line 213 "ease-handle.vala"
	if (((ease_element_get_width (target) + resize_x) - translate_x) <= ease_element_get_minimum_width (target)) {
#line 215 "ease-handle.vala"
		translate_x = (float) 0;
#line 216 "ease-handle.vala"
		resize_x = (float) 0;
#line 217 "ease-handle.vala"
		if (proportional) {
#line 219 "ease-handle.vala"
			translate_y = (float) 0;
#line 220 "ease-handle.vala"
			resize_y = (float) 0;
#line 363 "ease-handle.c"
		}
	}
#line 223 "ease-handle.vala"
	if (((ease_element_get_height (target) + resize_y) - translate_y) <= ease_element_get_minimum_height (target)) {
#line 226 "ease-handle.vala"
		translate_y = (float) 0;
#line 227 "ease-handle.vala"
		resize_y = (float) 0;
#line 228 "ease-handle.vala"
		if (proportional) {
#line 230 "ease-handle.vala"
			translate_x = (float) 0;
#line 231 "ease-handle.vala"
			resize_x = (float) 0;
#line 378 "ease-handle.c"
		}
	}
#line 235 "ease-handle.vala"
	ease_element_set_x (target, ease_element_get_x (target) + translate_x);
#line 236 "ease-handle.vala"
	ease_element_set_y (target, ease_element_get_y (target) + translate_y);
#line 237 "ease-handle.vala"
	ease_element_set_width (target, ease_element_get_width (target) + resize_x);
#line 238 "ease-handle.vala"
	ease_element_set_height (target, ease_element_get_height (target) + resize_y);
#line 389 "ease-handle.c"
}


/**
 * Places this Handle in its proper location, relative to the selection
 * rectangle.
 *
 * @param selection The selection rectangle to position the Handle around.
 */
#line 247 "ease-handle.vala"
void ease_handle_reposition (EaseHandle* self, ClutterActor* selection) {
#line 247 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 247 "ease-handle.vala"
	g_return_if_fail (selection != NULL);
#line 249 "ease-handle.vala"
	switch (self->position) {
#line 407 "ease-handle.c"
		case EASE_HANDLE_POSITION_TOP_LEFT:
		{
#line 252 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection));
#line 253 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection));
#line 254 "ease-handle.vala"
			break;
#line 416 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP_RIGHT:
		{
#line 257 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + clutter_actor_get_width (selection));
#line 258 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection));
#line 259 "ease-handle.vala"
			break;
#line 426 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP:
		{
#line 262 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + (clutter_actor_get_width (selection) / 2));
#line 263 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection));
#line 264 "ease-handle.vala"
			break;
#line 436 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_LEFT:
		{
#line 267 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection));
#line 268 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + (clutter_actor_get_height (selection) / 2));
#line 269 "ease-handle.vala"
			break;
#line 446 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_RIGHT:
		{
#line 272 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + clutter_actor_get_width (selection));
#line 273 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + (clutter_actor_get_height (selection) / 2));
#line 274 "ease-handle.vala"
			break;
#line 456 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_LEFT:
		{
#line 277 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection));
#line 278 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + clutter_actor_get_height (selection));
#line 279 "ease-handle.vala"
			break;
#line 466 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_RIGHT:
		{
#line 282 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + clutter_actor_get_width (selection));
#line 283 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + clutter_actor_get_height (selection));
#line 284 "ease-handle.vala"
			break;
#line 476 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM:
		{
#line 287 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + (clutter_actor_get_width (selection) / 2));
#line 288 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + clutter_actor_get_height (selection));
#line 289 "ease-handle.vala"
			break;
#line 486 "ease-handle.c"
		}
	}
}


/**
 * Flips the colors of the handle.
 */
#line 296 "ease-handle.vala"
void ease_handle_flip (EaseHandle* self, gboolean f) {
#line 296 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 298 "ease-handle.vala"
	self->priv->flipped = f;
#line 299 "ease-handle.vala"
	ease_handle_redraw (self);
#line 503 "ease-handle.c"
}


#line 302 "ease-handle.vala"
static void ease_handle_redraw (EaseHandle* self) {
#line 509 "ease-handle.c"
	cairo_t* cr;
#line 302 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 305 "ease-handle.vala"
	cr = clutter_cairo_texture_create ((ClutterCairoTexture*) self);
#line 308 "ease-handle.vala"
	cairo_arc (cr, (double) (EASE_HANDLE_SIZE / 2), (double) (EASE_HANDLE_SIZE / 2), (double) (EASE_HANDLE_SIZE / 4), (double) 0, 2 * 3.1415);
#line 311 "ease-handle.vala"
	if (!self->priv->flipped) {
#line 311 "ease-handle.vala"
		cairo_set_source_rgba (cr, (double) 1, (double) 1, (double) 1, (double) 1);
#line 521 "ease-handle.c"
	} else {
#line 312 "ease-handle.vala"
		cairo_set_source_rgba (cr, (double) 0, (double) 0, (double) 0, (double) 1);
#line 525 "ease-handle.c"
	}
#line 313 "ease-handle.vala"
	cairo_fill_preserve (cr);
#line 316 "ease-handle.vala"
	if (!self->priv->flipped) {
#line 316 "ease-handle.vala"
		cairo_set_source_rgba (cr, (double) 0, (double) 0, (double) 0, (double) 1);
#line 533 "ease-handle.c"
	} else {
#line 317 "ease-handle.vala"
		cairo_set_source_rgba (cr, (double) 1, (double) 1, (double) 1, (double) 1);
#line 537 "ease-handle.c"
	}
#line 318 "ease-handle.vala"
	cairo_stroke (cr);
#line 541 "ease-handle.c"
	_cairo_destroy0 (cr);
}


static void ease_handle_class_init (EaseHandleClass * klass) {
	ease_handle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseHandlePrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_handle_finalize;
}


static void ease_handle_instance_init (EaseHandle * self) {
	self->priv = EASE_HANDLE_GET_PRIVATE (self);
	self->priv->flipped = FALSE;
}


static void ease_handle_finalize (GObject* obj) {
	EaseHandle * self;
	self = EASE_HANDLE (obj);
	G_OBJECT_CLASS (ease_handle_parent_class)->finalize (obj);
}


/**
 * Interface element for manipulating the size of {@link Actor}s.
 */
GType ease_handle_get_type (void) {
	static volatile gsize ease_handle_type_id__volatile = 0;
	if (g_once_init_enter (&ease_handle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseHandleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_handle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseHandle), 0, (GInstanceInitFunc) ease_handle_instance_init, NULL };
		GType ease_handle_type_id;
		ease_handle_type_id = g_type_register_static (CLUTTER_TYPE_CAIRO_TEXTURE, "EaseHandle", &g_define_type_info, 0);
		g_once_init_leave (&ease_handle_type_id__volatile, ease_handle_type_id);
	}
	return ease_handle_type_id__volatile;
}




