/* source-base-group.c generated by valac 0.10.0, the Vala compiler
 * generated from source-base-group.vala, do not modify */

/*
 * Copyright (c) 2010, Nate Stedman <natesm@gmail.com>
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define SOURCE_TYPE_BASE_GROUP (source_base_group_get_type ())
#define SOURCE_BASE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_BASE_GROUP, SourceBaseGroup))
#define SOURCE_BASE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_BASE_GROUP, SourceBaseGroupClass))
#define SOURCE_IS_BASE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_BASE_GROUP))
#define SOURCE_IS_BASE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_BASE_GROUP))
#define SOURCE_BASE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_BASE_GROUP, SourceBaseGroupClass))

typedef struct _SourceBaseGroup SourceBaseGroup;
typedef struct _SourceBaseGroupClass SourceBaseGroupClass;
typedef struct _SourceBaseGroupPrivate SourceBaseGroupPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SOURCE_TYPE_ITEM (source_item_get_type ())
#define SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_ITEM, SourceItem))
#define SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_ITEM, SourceItemClass))
#define SOURCE_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_ITEM))
#define SOURCE_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_ITEM))
#define SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_ITEM, SourceItemClass))

typedef struct _SourceItem SourceItem;
typedef struct _SourceItemClass SourceItemClass;

struct _SourceBaseGroup {
	GtkAlignment parent_instance;
	SourceBaseGroupPrivate * priv;
	GtkAlignment* header_align;
	GtkAlignment* items_align;
};

struct _SourceBaseGroupClass {
	GtkAlignmentClass parent_class;
};

struct _SourceBaseGroupPrivate {
	GtkLabel* header;
	GtkVBox* items_box;
};


static gpointer source_base_group_parent_class = NULL;

GType source_base_group_get_type (void) G_GNUC_CONST;
#define SOURCE_BASE_GROUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SOURCE_TYPE_BASE_GROUP, SourceBaseGroupPrivate))
enum  {
	SOURCE_BASE_GROUP_DUMMY_PROPERTY
};
#define SOURCE_BASE_GROUP_HEADER_FORMAT "<b>%s</b>"
#define SOURCE_BASE_GROUP_ITEM_PADDING 2
#define SOURCE_BASE_GROUP_ITEMS_PADDING_LEFT 5
#define SOURCE_BASE_GROUP_ITEMS_PADDING_RIGHT 5
#define SOURCE_BASE_GROUP_ITEMS_PADDING_TOP 5
#define SOURCE_BASE_GROUP_ITEMS_PADDING_BOTTOM 10
SourceBaseGroup* source_base_group_construct (GType object_type, const char* title);
GType source_item_get_type (void) G_GNUC_CONST;
void source_base_group_add_item (SourceBaseGroup* self, SourceItem* item);
static void _lambda78_ (SourceItem* sender, SourceBaseGroup* self);
static void __lambda78__source_item_clicked (SourceItem* _sender, SourceItem* sender, gpointer self);
static void source_base_group_finalize (GObject* obj);



/**
 * Base constructor for subclasses of Source.BaseGroup.
 *
 * @param title The header of the Source.BaseGroup.
 */
#line 89 "source-base-group.vala"
SourceBaseGroup* source_base_group_construct (GType object_type, const char* title) {
#line 99 "source-base-group.c"
	SourceBaseGroup * self;
	GtkVBox* _tmp0_;
	GtkAlignment* _tmp1_;
	char* _tmp2_;
	GtkLabel* _tmp3_;
	GtkAlignment* _tmp4_;
#line 89 "source-base-group.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 108 "source-base-group.c"
	self = g_object_newv (object_type, 0, NULL);
#line 92 "source-base-group.vala"
	self->priv->items_box = (_tmp0_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (TRUE, SOURCE_BASE_GROUP_ITEM_PADDING)), _g_object_unref0 (self->priv->items_box), _tmp0_);
#line 93 "source-base-group.vala"
	self->items_align = (_tmp1_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 1, (float) 0)), _g_object_unref0 (self->items_align), _tmp1_);
#line 94 "source-base-group.vala"
	gtk_alignment_set_padding (self->items_align, (guint) SOURCE_BASE_GROUP_ITEMS_PADDING_TOP, (guint) SOURCE_BASE_GROUP_ITEMS_PADDING_BOTTOM, (guint) SOURCE_BASE_GROUP_ITEMS_PADDING_LEFT, (guint) SOURCE_BASE_GROUP_ITEMS_PADDING_RIGHT);
#line 98 "source-base-group.vala"
	self->priv->header = (_tmp3_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp2_ = g_strdup_printf (SOURCE_BASE_GROUP_HEADER_FORMAT, title))), _g_object_unref0 (self->priv->header), _tmp3_);
#line 118 "source-base-group.c"
	_g_free0 (_tmp2_);
#line 99 "source-base-group.vala"
	gtk_label_set_use_markup (self->priv->header, TRUE);
#line 100 "source-base-group.vala"
	self->header_align = (_tmp4_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 0, (float) 0)), _g_object_unref0 (self->header_align), _tmp4_);
#line 102 "source-base-group.vala"
	gtk_alignment_set ((GtkAlignment*) self, (float) 0, (float) 0, (float) 1, (float) 0);
#line 105 "source-base-group.vala"
	gtk_container_add ((GtkContainer*) self->items_align, (GtkWidget*) self->priv->items_box);
#line 106 "source-base-group.vala"
	gtk_container_add ((GtkContainer*) self->header_align, (GtkWidget*) self->priv->header);
#line 130 "source-base-group.c"
	return self;
}


/**
 * Adds a {@link Source.Item} to the end of this group.
 *
 * @param item The {@link Source.Item} to add.
 */
#line 117 "source-base-group.vala"
static void _lambda78_ (SourceItem* sender, SourceBaseGroup* self) {
#line 117 "source-base-group.vala"
	g_return_if_fail (sender != NULL);
#line 117 "source-base-group.vala"
	g_signal_emit_by_name (self, "clicked", sender);
#line 146 "source-base-group.c"
}


#line 117 "source-base-group.vala"
static void __lambda78__source_item_clicked (SourceItem* _sender, SourceItem* sender, gpointer self) {
#line 152 "source-base-group.c"
	_lambda78_ (sender, self);
}


#line 114 "source-base-group.vala"
void source_base_group_add_item (SourceBaseGroup* self, SourceItem* item) {
#line 114 "source-base-group.vala"
	g_return_if_fail (self != NULL);
#line 114 "source-base-group.vala"
	g_return_if_fail (item != NULL);
#line 116 "source-base-group.vala"
	gtk_box_pack_start ((GtkBox*) self->priv->items_box, (GtkWidget*) item, FALSE, FALSE, (guint) 0);
#line 117 "source-base-group.vala"
	g_signal_connect_object (item, "clicked", (GCallback) __lambda78__source_item_clicked, self, 0);
#line 167 "source-base-group.c"
}


static void source_base_group_class_init (SourceBaseGroupClass * klass) {
	source_base_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SourceBaseGroupPrivate));
	G_OBJECT_CLASS (klass)->finalize = source_base_group_finalize;
	/**
	 * Emitted when a child {@link Source.Item} of this group is clicked.
	 *
	 * @param sender The {@link Source.Item} that was clicked.
	 */
	g_signal_new ("clicked", SOURCE_TYPE_BASE_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOURCE_TYPE_ITEM);
}


static void source_base_group_instance_init (SourceBaseGroup * self) {
	self->priv = SOURCE_BASE_GROUP_GET_PRIVATE (self);
}


static void source_base_group_finalize (GObject* obj) {
	SourceBaseGroup * self;
	self = SOURCE_BASE_GROUP (obj);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->items_box);
	_g_object_unref0 (self->header_align);
	_g_object_unref0 (self->items_align);
	G_OBJECT_CLASS (source_base_group_parent_class)->finalize (obj);
}


/**
 * Abstract base class for a group in a {@link Source.List}.
 *
 * Source.BaseGroup can contain any amount of {@link Source.Item}s. Above
 * these items, a header is shown in order to categorize a {@link Source.List}.
 */
GType source_base_group_get_type (void) {
	static volatile gsize source_base_group_type_id__volatile = 0;
	if (g_once_init_enter (&source_base_group_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceBaseGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_base_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceBaseGroup), 0, (GInstanceInitFunc) source_base_group_instance_init, NULL };
		GType source_base_group_type_id;
		source_base_group_type_id = g_type_register_static (GTK_TYPE_ALIGNMENT, "SourceBaseGroup", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&source_base_group_type_id__volatile, source_base_group_type_id);
	}
	return source_base_group_type_id__volatile;
}




