/* ease-undo-actions-element.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-undo-actions-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>


#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;
typedef struct _EaseUndoItemPrivate EaseUndoItemPrivate;

#define EASE_TYPE_ELEMENT_ADD_UNDO_ACTION (ease_element_add_undo_action_get_type ())
#define EASE_ELEMENT_ADD_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoAction))
#define EASE_ELEMENT_ADD_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoActionClass))
#define EASE_IS_ELEMENT_ADD_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION))
#define EASE_IS_ELEMENT_ADD_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION))
#define EASE_ELEMENT_ADD_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoActionClass))

typedef struct _EaseElementAddUndoAction EaseElementAddUndoAction;
typedef struct _EaseElementAddUndoActionClass EaseElementAddUndoActionClass;
typedef struct _EaseElementAddUndoActionPrivate EaseElementAddUndoActionPrivate;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION (ease_element_remove_undo_action_get_type ())
#define EASE_ELEMENT_REMOVE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoAction))
#define EASE_ELEMENT_REMOVE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoActionClass))
#define EASE_IS_ELEMENT_REMOVE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION))
#define EASE_IS_ELEMENT_REMOVE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION))
#define EASE_ELEMENT_REMOVE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoActionClass))

typedef struct _EaseElementRemoveUndoAction EaseElementRemoveUndoAction;
typedef struct _EaseElementRemoveUndoActionClass EaseElementRemoveUndoActionClass;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;
typedef struct _EaseElementRemoveUndoActionPrivate EaseElementRemoveUndoActionPrivate;

#define EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION (ease_element_reorder_undo_action_get_type ())
#define EASE_ELEMENT_REORDER_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoAction))
#define EASE_ELEMENT_REORDER_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoActionClass))
#define EASE_IS_ELEMENT_REORDER_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION))
#define EASE_IS_ELEMENT_REORDER_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION))
#define EASE_ELEMENT_REORDER_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoActionClass))

typedef struct _EaseElementReorderUndoAction EaseElementReorderUndoAction;
typedef struct _EaseElementReorderUndoActionClass EaseElementReorderUndoActionClass;
typedef struct _EaseElementReorderUndoActionPrivate EaseElementReorderUndoActionPrivate;

struct _EaseUndoItem {
	GObject parent_instance;
	EaseUndoItemPrivate * priv;
};

struct _EaseUndoItemClass {
	GObjectClass parent_class;
	EaseUndoItem* (*apply) (EaseUndoItem* self);
	gboolean (*contains) (EaseUndoItem* self, GObject* obj);
};

struct _EaseElementAddUndoAction {
	EaseUndoItem parent_instance;
	EaseElementAddUndoActionPrivate * priv;
};

struct _EaseElementAddUndoActionClass {
	EaseUndoItemClass parent_class;
};

struct _EaseElementAddUndoActionPrivate {
	EaseElement* element;
};

struct _EaseElementRemoveUndoAction {
	EaseUndoItem parent_instance;
	EaseElementRemoveUndoActionPrivate * priv;
};

struct _EaseElementRemoveUndoActionClass {
	EaseUndoItemClass parent_class;
};

struct _EaseElementRemoveUndoActionPrivate {
	EaseElement* element;
	EaseSlide* slide;
	gint index;
};

struct _EaseElementReorderUndoAction {
	EaseUndoItem parent_instance;
	EaseElementReorderUndoActionPrivate * priv;
};

struct _EaseElementReorderUndoActionClass {
	EaseUndoItemClass parent_class;
};

struct _EaseElementReorderUndoActionPrivate {
	EaseElement* element;
	EaseSlide* slide;
	gint index_orig;
	gint index_current;
};


static gpointer ease_element_add_undo_action_parent_class = NULL;
static gpointer ease_element_remove_undo_action_parent_class = NULL;
static gpointer ease_element_reorder_undo_action_parent_class = NULL;

GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_element_add_undo_action_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
#define EASE_ELEMENT_ADD_UNDO_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoActionPrivate))
enum  {
	EASE_ELEMENT_ADD_UNDO_ACTION_DUMMY_PROPERTY
};
EaseElementAddUndoAction* ease_element_add_undo_action_new (EaseElement* e);
EaseElementAddUndoAction* ease_element_add_undo_action_construct (GType object_type, EaseElement* e);
EaseUndoItem* ease_undo_item_construct (GType object_type);
static EaseUndoItem* ease_element_add_undo_action_real_apply (EaseUndoItem* base);
EaseElementRemoveUndoAction* ease_element_remove_undo_action_new (EaseElement* e);
EaseElementRemoveUndoAction* ease_element_remove_undo_action_construct (GType object_type, EaseElement* e);
GType ease_element_remove_undo_action_get_type (void) G_GNUC_CONST;
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_element_get_parent (EaseElement* self);
void ease_slide_remove_actual (EaseSlide* self, EaseElement* e, gboolean emit_undo);
static void ease_element_add_undo_action_finalize (GObject* obj);
#define EASE_ELEMENT_REMOVE_UNDO_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoActionPrivate))
enum  {
	EASE_ELEMENT_REMOVE_UNDO_ACTION_DUMMY_PROPERTY
};
gint ease_slide_index_of (EaseSlide* self, EaseElement* e);
static EaseUndoItem* ease_element_remove_undo_action_real_apply (EaseUndoItem* base);
void ease_slide_add_actual (EaseSlide* self, gint index, EaseElement* e, gboolean emit_undo);
static void ease_element_remove_undo_action_finalize (GObject* obj);
GType ease_element_reorder_undo_action_get_type (void) G_GNUC_CONST;
#define EASE_ELEMENT_REORDER_UNDO_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoActionPrivate))
enum  {
	EASE_ELEMENT_REORDER_UNDO_ACTION_DUMMY_PROPERTY
};
EaseElementReorderUndoAction* ease_element_reorder_undo_action_new (EaseElement* e, gint orig, gint current);
EaseElementReorderUndoAction* ease_element_reorder_undo_action_construct (GType object_type, EaseElement* e, gint orig, gint current);
static EaseUndoItem* ease_element_reorder_undo_action_real_apply (EaseUndoItem* base);
void ease_slide_reorder (EaseSlide* self, EaseElement* element, gint current, gint target);
static void ease_element_reorder_undo_action_finalize (GObject* obj);



/**
 * Creates an ElementAddUndoAction.
 *
 * @param e The element that was added.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 33 "ease-undo-actions-element.vala"
EaseElementAddUndoAction* ease_element_add_undo_action_construct (GType object_type, EaseElement* e) {
#line 202 "ease-undo-actions-element.c"
	EaseElementAddUndoAction * self;
	EaseElement* _tmp0_;
#line 33 "ease-undo-actions-element.vala"
	g_return_val_if_fail (e != NULL, NULL);
#line 33 "ease-undo-actions-element.vala"
	self = (EaseElementAddUndoAction*) ease_undo_item_construct (object_type);
#line 35 "ease-undo-actions-element.vala"
	self->priv->element = (_tmp0_ = _g_object_ref0 (e), _g_object_unref0 (self->priv->element), _tmp0_);
#line 211 "ease-undo-actions-element.c"
	return self;
}


#line 33 "ease-undo-actions-element.vala"
EaseElementAddUndoAction* ease_element_add_undo_action_new (EaseElement* e) {
#line 33 "ease-undo-actions-element.vala"
	return ease_element_add_undo_action_construct (EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, e);
#line 220 "ease-undo-actions-element.c"
}


/**
 * Applies the action, removing the {@link Element}.
 */
#line 41 "ease-undo-actions-element.vala"
static EaseUndoItem* ease_element_add_undo_action_real_apply (EaseUndoItem* base) {
#line 229 "ease-undo-actions-element.c"
	EaseElementAddUndoAction * self;
	EaseUndoItem* result = NULL;
	EaseElementRemoveUndoAction* action;
	self = (EaseElementAddUndoAction*) base;
#line 43 "ease-undo-actions-element.vala"
	action = ease_element_remove_undo_action_new (self->priv->element);
#line 44 "ease-undo-actions-element.vala"
	ease_slide_remove_actual (ease_element_get_parent (self->priv->element), self->priv->element, FALSE);
#line 238 "ease-undo-actions-element.c"
	result = (EaseUndoItem*) action;
#line 45 "ease-undo-actions-element.vala"
	return result;
#line 242 "ease-undo-actions-element.c"
}


static void ease_element_add_undo_action_class_init (EaseElementAddUndoActionClass * klass) {
	ease_element_add_undo_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseElementAddUndoActionPrivate));
	EASE_UNDO_ITEM_CLASS (klass)->apply = ease_element_add_undo_action_real_apply;
	G_OBJECT_CLASS (klass)->finalize = ease_element_add_undo_action_finalize;
}


static void ease_element_add_undo_action_instance_init (EaseElementAddUndoAction * self) {
	self->priv = EASE_ELEMENT_ADD_UNDO_ACTION_GET_PRIVATE (self);
}


static void ease_element_add_undo_action_finalize (GObject* obj) {
	EaseElementAddUndoAction * self;
	self = EASE_ELEMENT_ADD_UNDO_ACTION (obj);
	_g_object_unref0 (self->priv->element);
	G_OBJECT_CLASS (ease_element_add_undo_action_parent_class)->finalize (obj);
}


/**
 * Undos the addition of an {@link Element} to a {@link Slide}.
 */
GType ease_element_add_undo_action_get_type (void) {
	static volatile gsize ease_element_add_undo_action_type_id__volatile = 0;
	if (g_once_init_enter (&ease_element_add_undo_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseElementAddUndoActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_element_add_undo_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseElementAddUndoAction), 0, (GInstanceInitFunc) ease_element_add_undo_action_instance_init, NULL };
		GType ease_element_add_undo_action_type_id;
		ease_element_add_undo_action_type_id = g_type_register_static (EASE_TYPE_UNDO_ITEM, "EaseElementAddUndoAction", &g_define_type_info, 0);
		g_once_init_leave (&ease_element_add_undo_action_type_id__volatile, ease_element_add_undo_action_type_id);
	}
	return ease_element_add_undo_action_type_id__volatile;
}


/**
 * Creates an ElementRemoveUndoAction. Note that this method references
 * {@link Element.parent}. Therefore, the action must be constructed
 * before the Element is actually removed.
 *
 * @param e The element that was added.
 */
#line 76 "ease-undo-actions-element.vala"
EaseElementRemoveUndoAction* ease_element_remove_undo_action_construct (GType object_type, EaseElement* e) {
#line 291 "ease-undo-actions-element.c"
	EaseElementRemoveUndoAction * self;
	EaseElement* _tmp0_;
	EaseSlide* _tmp1_;
#line 76 "ease-undo-actions-element.vala"
	g_return_val_if_fail (e != NULL, NULL);
#line 76 "ease-undo-actions-element.vala"
	self = (EaseElementRemoveUndoAction*) ease_undo_item_construct (object_type);
#line 78 "ease-undo-actions-element.vala"
	self->priv->element = (_tmp0_ = _g_object_ref0 (e), _g_object_unref0 (self->priv->element), _tmp0_);
#line 79 "ease-undo-actions-element.vala"
	self->priv->slide = (_tmp1_ = _g_object_ref0 (ease_element_get_parent (e)), _g_object_unref0 (self->priv->slide), _tmp1_);
#line 80 "ease-undo-actions-element.vala"
	self->priv->index = ease_slide_index_of (ease_element_get_parent (e), e);
#line 305 "ease-undo-actions-element.c"
	return self;
}


#line 76 "ease-undo-actions-element.vala"
EaseElementRemoveUndoAction* ease_element_remove_undo_action_new (EaseElement* e) {
#line 76 "ease-undo-actions-element.vala"
	return ease_element_remove_undo_action_construct (EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, e);
#line 314 "ease-undo-actions-element.c"
}


/**
 * Applies the action, restoring the {@link Element}.
 */
#line 86 "ease-undo-actions-element.vala"
static EaseUndoItem* ease_element_remove_undo_action_real_apply (EaseUndoItem* base) {
#line 323 "ease-undo-actions-element.c"
	EaseElementRemoveUndoAction * self;
	EaseUndoItem* result = NULL;
	self = (EaseElementRemoveUndoAction*) base;
#line 88 "ease-undo-actions-element.vala"
	ease_slide_add_actual (self->priv->slide, self->priv->index, self->priv->element, FALSE);
#line 329 "ease-undo-actions-element.c"
	result = (EaseUndoItem*) ease_element_add_undo_action_new (self->priv->element);
#line 89 "ease-undo-actions-element.vala"
	return result;
#line 333 "ease-undo-actions-element.c"
}


static void ease_element_remove_undo_action_class_init (EaseElementRemoveUndoActionClass * klass) {
	ease_element_remove_undo_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseElementRemoveUndoActionPrivate));
	EASE_UNDO_ITEM_CLASS (klass)->apply = ease_element_remove_undo_action_real_apply;
	G_OBJECT_CLASS (klass)->finalize = ease_element_remove_undo_action_finalize;
}


static void ease_element_remove_undo_action_instance_init (EaseElementRemoveUndoAction * self) {
	self->priv = EASE_ELEMENT_REMOVE_UNDO_ACTION_GET_PRIVATE (self);
}


static void ease_element_remove_undo_action_finalize (GObject* obj) {
	EaseElementRemoveUndoAction * self;
	self = EASE_ELEMENT_REMOVE_UNDO_ACTION (obj);
	_g_object_unref0 (self->priv->element);
	_g_object_unref0 (self->priv->slide);
	G_OBJECT_CLASS (ease_element_remove_undo_action_parent_class)->finalize (obj);
}


/**
 * Undos the removal of an {@link Element} from a {@link Slide}.
 */
GType ease_element_remove_undo_action_get_type (void) {
	static volatile gsize ease_element_remove_undo_action_type_id__volatile = 0;
	if (g_once_init_enter (&ease_element_remove_undo_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseElementRemoveUndoActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_element_remove_undo_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseElementRemoveUndoAction), 0, (GInstanceInitFunc) ease_element_remove_undo_action_instance_init, NULL };
		GType ease_element_remove_undo_action_type_id;
		ease_element_remove_undo_action_type_id = g_type_register_static (EASE_TYPE_UNDO_ITEM, "EaseElementRemoveUndoAction", &g_define_type_info, 0);
		g_once_init_leave (&ease_element_remove_undo_action_type_id__volatile, ease_element_remove_undo_action_type_id);
	}
	return ease_element_remove_undo_action_type_id__volatile;
}


/**
 * Creates an ElementReorderUndoAction.
 *
 * @param e The element that was added.
 * @param orig The original index of the element.
 * @param current The new index of the element.
 */
#line 122 "ease-undo-actions-element.vala"
EaseElementReorderUndoAction* ease_element_reorder_undo_action_construct (GType object_type, EaseElement* e, gint orig, gint current) {
#line 383 "ease-undo-actions-element.c"
	EaseElementReorderUndoAction * self;
	EaseElement* _tmp0_;
	EaseSlide* _tmp1_;
#line 122 "ease-undo-actions-element.vala"
	g_return_val_if_fail (e != NULL, NULL);
#line 122 "ease-undo-actions-element.vala"
	self = (EaseElementReorderUndoAction*) ease_undo_item_construct (object_type);
#line 124 "ease-undo-actions-element.vala"
	self->priv->element = (_tmp0_ = _g_object_ref0 (e), _g_object_unref0 (self->priv->element), _tmp0_);
#line 125 "ease-undo-actions-element.vala"
	self->priv->slide = (_tmp1_ = _g_object_ref0 (ease_element_get_parent (e)), _g_object_unref0 (self->priv->slide), _tmp1_);
#line 126 "ease-undo-actions-element.vala"
	self->priv->index_orig = orig;
#line 127 "ease-undo-actions-element.vala"
	self->priv->index_current = current;
#line 399 "ease-undo-actions-element.c"
	return self;
}


#line 122 "ease-undo-actions-element.vala"
EaseElementReorderUndoAction* ease_element_reorder_undo_action_new (EaseElement* e, gint orig, gint current) {
#line 122 "ease-undo-actions-element.vala"
	return ease_element_reorder_undo_action_construct (EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, e, orig, current);
#line 408 "ease-undo-actions-element.c"
}


/**
 * Applies the action, restoring the {@link Element}.
 */
#line 133 "ease-undo-actions-element.vala"
static EaseUndoItem* ease_element_reorder_undo_action_real_apply (EaseUndoItem* base) {
#line 417 "ease-undo-actions-element.c"
	EaseElementReorderUndoAction * self;
	EaseUndoItem* result = NULL;
	gint temp;
	self = (EaseElementReorderUndoAction*) base;
#line 135 "ease-undo-actions-element.vala"
	ease_slide_reorder (self->priv->slide, self->priv->element, self->priv->index_current, self->priv->index_orig);
#line 138 "ease-undo-actions-element.vala"
	temp = self->priv->index_current;
#line 139 "ease-undo-actions-element.vala"
	self->priv->index_orig = self->priv->index_current;
#line 140 "ease-undo-actions-element.vala"
	self->priv->index_current = temp;
#line 430 "ease-undo-actions-element.c"
	result = _g_object_ref0 ((EaseUndoItem*) self);
#line 142 "ease-undo-actions-element.vala"
	return result;
#line 434 "ease-undo-actions-element.c"
}


static void ease_element_reorder_undo_action_class_init (EaseElementReorderUndoActionClass * klass) {
	ease_element_reorder_undo_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseElementReorderUndoActionPrivate));
	EASE_UNDO_ITEM_CLASS (klass)->apply = ease_element_reorder_undo_action_real_apply;
	G_OBJECT_CLASS (klass)->finalize = ease_element_reorder_undo_action_finalize;
}


static void ease_element_reorder_undo_action_instance_init (EaseElementReorderUndoAction * self) {
	self->priv = EASE_ELEMENT_REORDER_UNDO_ACTION_GET_PRIVATE (self);
}


static void ease_element_reorder_undo_action_finalize (GObject* obj) {
	EaseElementReorderUndoAction * self;
	self = EASE_ELEMENT_REORDER_UNDO_ACTION (obj);
	_g_object_unref0 (self->priv->element);
	_g_object_unref0 (self->priv->slide);
	G_OBJECT_CLASS (ease_element_reorder_undo_action_parent_class)->finalize (obj);
}


GType ease_element_reorder_undo_action_get_type (void) {
	static volatile gsize ease_element_reorder_undo_action_type_id__volatile = 0;
	if (g_once_init_enter (&ease_element_reorder_undo_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseElementReorderUndoActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_element_reorder_undo_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseElementReorderUndoAction), 0, (GInstanceInitFunc) ease_element_reorder_undo_action_instance_init, NULL };
		GType ease_element_reorder_undo_action_type_id;
		ease_element_reorder_undo_action_type_id = g_type_register_static (EASE_TYPE_UNDO_ITEM, "EaseElementReorderUndoAction", &g_define_type_info, 0);
		g_once_init_leave (&ease_element_reorder_undo_action_type_id__volatile, ease_element_reorder_undo_action_type_id);
	}
	return ease_element_reorder_undo_action_type_id__volatile;
}




