/* ease-theme.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-theme.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define EASE_TYPE_THEME (ease_theme_get_type ())
#define EASE_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_THEME, EaseTheme))
#define EASE_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_THEME, EaseThemeClass))
#define EASE_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_THEME))
#define EASE_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_THEME))
#define EASE_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_THEME, EaseThemeClass))

typedef struct _EaseTheme EaseTheme;
typedef struct _EaseThemeClass EaseThemeClass;
typedef struct _EaseThemePrivate EaseThemePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;

#define EASE_TYPE_BACKGROUND_TYPE (ease_background_type_get_type ())

#define EASE_TYPE_GRADIENT (ease_gradient_get_type ())
#define EASE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_GRADIENT, EaseGradient))
#define EASE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_GRADIENT, EaseGradientClass))
#define EASE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_GRADIENT))
#define EASE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_GRADIENT))
#define EASE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_GRADIENT, EaseGradientClass))

typedef struct _EaseGradient EaseGradient;
typedef struct _EaseGradientClass EaseGradientClass;

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;

#define EASE_TYPE_TEXT_ELEMENT (ease_text_element_get_type ())
#define EASE_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElement))
#define EASE_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))
#define EASE_IS_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ELEMENT))
#define EASE_IS_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ELEMENT))
#define EASE_TEXT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))

typedef struct _EaseTextElement EaseTextElement;
typedef struct _EaseTextElementClass EaseTextElementClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _EaseTheme {
	GObject parent_instance;
	EaseThemePrivate * priv;
	char* title;
};

struct _EaseThemeClass {
	GObjectClass parent_class;
};

struct _EaseThemePrivate {
	char* _path;
	GeeMap* masters;
	GeeMap* elements;
	GeeMap* master_defaults;
	GeeMap* element_defaults;
};

typedef enum  {
	EASE_BACKGROUND_TYPE_COLOR,
	EASE_BACKGROUND_TYPE_GRADIENT,
	EASE_BACKGROUND_TYPE_IMAGE
} EaseBackgroundType;


static EaseTheme* ease_theme_defaults_store;
static EaseTheme* ease_theme_defaults_store = NULL;
static gpointer ease_theme_parent_class = NULL;

GType ease_theme_get_type (void) G_GNUC_CONST;
#define EASE_THEME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_THEME, EaseThemePrivate))
enum  {
	EASE_THEME_DUMMY_PROPERTY,
	EASE_THEME_PATH
};
#define EASE_THEME_DEFAULTS_PATH "theme-defaults.json"
#define EASE_THEME_JSON_PATH "Theme.json"
#define EASE_THEME_MEDIA_PATH "Media"
#define EASE_THEME_MASTERS "masters"
#define EASE_THEME_ELEMENTS "elements"
#define EASE_THEME_MASTER_DEF "master-defaults"
#define EASE_THEME_ELEMENT_DEF "element-defaults"
#define EASE_THEME_THEME_TITLE "title"
#define EASE_THEME_THEME_AUTHOR "author"
#define EASE_THEME_TITLE "title"
#define EASE_THEME_CONTENT "content"
#define EASE_THEME_CONTENT_HEADER "content-header"
#define EASE_THEME_CONTENT_DUAL "content-dual"
#define EASE_THEME_CONTENT_DUAL_HEADER "content-dual-header"
#define EASE_THEME_MEDIA "media"
#define EASE_THEME_MEDIA_HEADER "media-header"
#define EASE_THEME_EMPTY "empty"
#define EASE_THEME_BACKGROUND_COLOR "background-color"
#define EASE_THEME_BACKGROUND_GRADIENT "background-gradient"
#define EASE_THEME_BACKGROUND_IMAGE "background-image"
#define EASE_THEME_BACKGROUND_IMAGE_SOURCE "background-image-source"
#define EASE_THEME_BACKGROUND_IMAGE_FILL "background-image-fill"
#define EASE_THEME_S_IDENTIFIER "slide-identifier"
#define EASE_THEME_BACKGROUND_TYPE "background-type"
#define EASE_THEME_BACKGROUND_TYPE_COLOR "background-type-color"
#define EASE_THEME_BACKGROUND_TYPE_GRADIENT "background-type-gradient"
#define EASE_THEME_BACKGROUND_TYPE_IMAGE "background-type-image"
#define EASE_THEME_BACKGROUND "background"
#define EASE_THEME_TITLE_TEXT "title-text"
#define EASE_THEME_AUTHOR_TEXT "author-text"
#define EASE_THEME_CONTENT_TEXT "content-text"
#define EASE_THEME_HEADER_TEXT "header-text"
#define EASE_THEME_CUSTOM_TEXT "custom-text"
#define EASE_THEME_TEXT_FONT "text-font"
#define EASE_THEME_TEXT_SIZE "text-size"
#define EASE_THEME_TEXT_STYLE "text-style"
#define EASE_THEME_TEXT_VARIANT "text-variant"
#define EASE_THEME_TEXT_WEIGHT "text-weight"
#define EASE_THEME_TEXT_ALIGN "text-align"
#define EASE_THEME_TEXT_COLOR "text-color"
#define EASE_THEME_TEXT_TEXT "text"
#define EASE_THEME_CONTENT_MEDIA "content-media"
#define EASE_THEME_CUSTOM_MEDIA "custom-media"
#define EASE_THEME_MEDIA_FILENAME "media-filename"
#define EASE_THEME_MEDIA_SOURCE_FILENAME "media-source-filename"
#define EASE_THEME_SHAPE_TYPE "shape-type"
#define EASE_THEME_PDF_DEFAULT_PAGE "pdf-default-page"
#define EASE_THEME_PDF_ALLOW_FLIPPING "pdf-allow-flipping"
#define EASE_THEME_GRAD_LINEAR "linear"
#define EASE_THEME_GRAD_LINEAR_MIRRORED "linear-mirrored"
#define EASE_THEME_GRAD_RADIAL "radial"
#define EASE_THEME_IMAGE_STRETCH "image-fill-stretch"
#define EASE_THEME_IMAGE_ASPECT "image-fill-aspect"
#define EASE_THEME_IMAGE_ORIGINAL "image-fill-original"
#define EASE_THEME_VIDEO_PLAY_AUTO "video-play-automatically"
#define EASE_THEME_VIDEO_MUTE "video-mute"
#define EASE_THEME_VIDEO_END_ACTION "video-end-action"
#define EASE_THEME_VIDEO_END_STOP "video-end-stop"
#define EASE_THEME_VIDEO_END_LOOP "video-end-loop"
#define EASE_THEME_VIDEO_END_CONTINUE "video-end-continue"
#define EASE_THEME_E_IDENTIFIER "element-identifier"
#define EASE_THEME_ELEMENT_TYPE "element-type"
#define EASE_THEME_PAD_LEFT "padding-left"
#define EASE_THEME_PAD_RIGHT "padding-right"
#define EASE_THEME_PAD_TOP "padding-top"
#define EASE_THEME_PAD_BOTTOM "padding-bottom"
#define EASE_THEME_WIDTH "width"
#define EASE_THEME_HEIGHT "height"
#define EASE_THEME_X "x"
#define EASE_THEME_Y "y"
#define EASE_THEME_HAS_BEEN_EDITED "has-been-edited"
EaseTheme* ease_theme_new (const char* dir_path);
EaseTheme* ease_theme_construct (GType object_type, const char* dir_path);
void ease_theme_set_path (EaseTheme* self, const char* value);
static void ease_theme_load_from_json (EaseTheme* self, const char* json_path);
const char* ease_theme_get_path (EaseTheme* self);
EaseTheme* ease_theme_new_json (const char* json_path);
EaseTheme* ease_theme_construct_json (GType object_type, const char* json_path);
static EaseTheme* ease_theme_new_copy (EaseTheme* copy_from);
static EaseTheme* ease_theme_construct_copy (GType object_type, EaseTheme* copy_from);
EaseTheme* ease_theme_copy_to_path (EaseTheme* self, const char* copy_to, GError** error);
void ease_recursive_copy (const char* from_dir, const char* to_dir, GError** error);
static void ease_theme_fill_map (EaseTheme* self, JsonObject* obj, const char* name, GeeMap* map);
static void ease_theme_fill_single_map (EaseTheme* self, JsonObject* obj, GeeMap* map);
void ease_theme_copy_media (EaseTheme* self, const char* target, GError** error);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_theme_create_slide (EaseTheme* self, const char* master, gint width, gint height);
EaseSlide* ease_slide_new (void);
EaseSlide* ease_slide_construct (GType object_type);
void ease_slide_set_theme (EaseSlide* self, EaseTheme* value);
void ease_slide_set_master (EaseSlide* self, const char* value);
static char* ease_theme_master_get (EaseTheme* self, const char* master, const char* prop);
GType ease_background_get_type (void) G_GNUC_CONST;
EaseBackground* ease_slide_get_background (EaseSlide* self);
EaseColor* ease_color_new_from_string (const char* str);
EaseColor* ease_color_construct_from_string (GType object_type, const char* str);
GType ease_color_get_type (void) G_GNUC_CONST;
void ease_background_set_color (EaseBackground* self, EaseColor* value);
GType ease_background_type_get_type (void) G_GNUC_CONST;
void ease_background_set_background_type (EaseBackground* self, EaseBackgroundType value);
EaseGradient* ease_gradient_new_from_string (const char* str);
EaseGradient* ease_gradient_construct_from_string (GType object_type, const char* str);
GType ease_gradient_get_type (void) G_GNUC_CONST;
void ease_background_set_gradient (EaseBackground* self, EaseGradient* value);
GType ease_image_get_type (void) G_GNUC_CONST;
EaseImage* ease_background_get_image (EaseBackground* self);
void ease_image_set_filename (EaseImage* self, const char* value);
static char* ease_theme_element_get (EaseTheme* self, const char* element, const char* prop);
GType ease_element_get_type (void) G_GNUC_CONST;
void ease_slide_append (EaseSlide* self, EaseElement* e);
GType ease_text_element_get_type (void) G_GNUC_CONST;
static EaseTextElement* ease_theme_create_text (EaseTheme* self, const char* type, gint x, gint y, gint w, gint h);
EaseTextElement* ease_theme_create_custom_text (EaseTheme* self);
EaseTextElement* ease_text_element_new (void);
EaseTextElement* ease_text_element_construct (GType object_type);
void ease_text_element_set_text_font (EaseTextElement* self, const char* value);
void ease_text_element_text_size_from_string (EaseTextElement* self, const char* str);
void ease_text_element_text_style_from_string (EaseTextElement* self, const char* str);
void ease_text_element_text_variant_from_string (EaseTextElement* self, const char* str);
void ease_text_element_text_weight_from_string (EaseTextElement* self, const char* str);
void ease_text_element_text_align_from_string (EaseTextElement* self, const char* str);
void ease_text_element_set_color (EaseTextElement* self, EaseColor* value);
void ease_element_set_x (EaseElement* self, float value);
void ease_element_set_y (EaseElement* self, float value);
void ease_element_set_width (EaseElement* self, float value);
void ease_element_set_height (EaseElement* self, float value);
void ease_element_set_identifier (EaseElement* self, const char* value);
void ease_element_set_has_been_edited (EaseElement* self, gboolean value);
void ease_text_element_set_text (EaseTextElement* self, const char* value);
static EaseTheme* ease_theme_get_defaults (void);
char* ease_theme_master_description (const char* master);
char* ease_theme_master_mnemonic_description (const char* master);
char* ease_theme_master_from_description (const char* desc);
char* ease_data_path (const char* path);
static void ease_theme_finalize (GObject* obj);
static void ease_theme_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_theme_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);

const char* EASE_THEME_MASTER_SLIDES[4] = {EASE_THEME_TITLE, EASE_THEME_CONTENT_HEADER, EASE_THEME_CONTENT, EASE_THEME_EMPTY};
static const char* EASE_THEME_TEXT_PROPS[6] = {EASE_THEME_TEXT_FONT, EASE_THEME_TEXT_SIZE, EASE_THEME_TEXT_STYLE, EASE_THEME_TEXT_VARIANT, EASE_THEME_TEXT_WEIGHT, EASE_THEME_TEXT_ALIGN};


/**
 * Loads a themes from a directory.
 *
 * @param path The path to the theme's directory.
 */
#line 214 "ease-theme.vala"
EaseTheme* ease_theme_construct (GType object_type, const char* dir_path) {
#line 307 "ease-theme.c"
	EaseTheme * self;
	char* _tmp0_;
#line 214 "ease-theme.vala"
	g_return_val_if_fail (dir_path != NULL, NULL);
#line 214 "ease-theme.vala"
	self = (EaseTheme*) g_object_new (object_type, NULL);
#line 216 "ease-theme.vala"
	ease_theme_set_path (self, dir_path);
#line 217 "ease-theme.vala"
	ease_theme_load_from_json (self, _tmp0_ = g_build_filename (self->priv->_path, EASE_THEME_JSON_PATH, NULL));
#line 318 "ease-theme.c"
	_g_free0 (_tmp0_);
	return self;
}


#line 214 "ease-theme.vala"
EaseTheme* ease_theme_new (const char* dir_path) {
#line 214 "ease-theme.vala"
	return ease_theme_construct (EASE_TYPE_THEME, dir_path);
#line 328 "ease-theme.c"
}


/**
 * Loads a Theme from pure JSON, (no archive).
 *
 * This constructor is used to load the defaults. It is also used when
 * loading a previously saved {@link Document}.
 *
 * @param json_path The path to the JSON file.
 */
#line 228 "ease-theme.vala"
EaseTheme* ease_theme_construct_json (GType object_type, const char* json_path) {
#line 342 "ease-theme.c"
	EaseTheme * self;
#line 228 "ease-theme.vala"
	g_return_val_if_fail (json_path != NULL, NULL);
#line 228 "ease-theme.vala"
	self = (EaseTheme*) g_object_new (object_type, NULL);
#line 230 "ease-theme.vala"
	ease_theme_load_from_json (self, json_path);
#line 350 "ease-theme.c"
	return self;
}


#line 228 "ease-theme.vala"
EaseTheme* ease_theme_new_json (const char* json_path) {
#line 228 "ease-theme.vala"
	return ease_theme_construct_json (EASE_TYPE_THEME, json_path);
#line 359 "ease-theme.c"
}


/**
 * Creates a "shallow" copy of a Theme.
 *
 * This constructor does not copy any data from the provided Theme. It
 * instead creates a new set of references to the same data.
 *
 * @param copy_from The Theme to copy from.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 241 "ease-theme.vala"
static EaseTheme* ease_theme_construct_copy (GType object_type, EaseTheme* copy_from) {
#line 378 "ease-theme.c"
	EaseTheme * self;
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	char* _tmp4_;
#line 241 "ease-theme.vala"
	g_return_val_if_fail (copy_from != NULL, NULL);
#line 241 "ease-theme.vala"
	self = (EaseTheme*) g_object_new (object_type, NULL);
#line 244 "ease-theme.vala"
	self->priv->masters = (_tmp0_ = _g_object_ref0 (copy_from->priv->masters), _g_object_unref0 (self->priv->masters), _tmp0_);
#line 245 "ease-theme.vala"
	self->priv->elements = (_tmp1_ = _g_object_ref0 (copy_from->priv->elements), _g_object_unref0 (self->priv->elements), _tmp1_);
#line 246 "ease-theme.vala"
	self->priv->master_defaults = (_tmp2_ = _g_object_ref0 (copy_from->priv->master_defaults), _g_object_unref0 (self->priv->master_defaults), _tmp2_);
#line 247 "ease-theme.vala"
	self->priv->element_defaults = (_tmp3_ = _g_object_ref0 (copy_from->priv->element_defaults), _g_object_unref0 (self->priv->element_defaults), _tmp3_);
#line 248 "ease-theme.vala"
	self->title = (_tmp4_ = g_strdup (copy_from->title), _g_free0 (self->title), _tmp4_);
#line 249 "ease-theme.vala"
	ease_theme_set_path (self, copy_from->priv->_path);
#line 401 "ease-theme.c"
	return self;
}


#line 241 "ease-theme.vala"
static EaseTheme* ease_theme_new_copy (EaseTheme* copy_from) {
#line 241 "ease-theme.vala"
	return ease_theme_construct_copy (EASE_TYPE_THEME, copy_from);
#line 410 "ease-theme.c"
}


/**
 * Copies a Theme's data files to a specified path, returning a Theme
 * pointing to those files.
 *
 * This method uses the private Theme.copy() constructor. This constructor
 * performs a shallow copy - thus, the Gee.Maps holding the Theme's data
 * are the same for both themes. This is OK, because Themes should never be
 * modified after they are first loaded.
 *
 * @param copy_to The path to copy the Theme to.
 */
#line 263 "ease-theme.vala"
EaseTheme* ease_theme_copy_to_path (EaseTheme* self, const char* copy_to, GError** error) {
#line 427 "ease-theme.c"
	EaseTheme* result = NULL;
	EaseTheme* theme;
	GError * _inner_error_ = NULL;
#line 263 "ease-theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 263 "ease-theme.vala"
	g_return_val_if_fail (copy_to != NULL, NULL);
#line 266 "ease-theme.vala"
	ease_recursive_copy (self->priv->_path, copy_to, &_inner_error_);
#line 437 "ease-theme.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 269 "ease-theme.vala"
	theme = ease_theme_new_copy (self);
#line 270 "ease-theme.vala"
	ease_theme_set_path (theme, copy_to);
#line 446 "ease-theme.c"
	result = theme;
#line 271 "ease-theme.vala"
	return result;
#line 450 "ease-theme.c"
}


/**
 * Loads a Theme's information from JSON
 *
 * This function is used to load the defaults and  to load each
 * extracted theme.
 *
 * @param json_path The path to the JSON file.
 */
static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


#line 282 "ease-theme.vala"
static void ease_theme_load_from_json (EaseTheme* self, const char* json_path) {
#line 469 "ease-theme.c"
	JsonParser* parser;
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	JsonNode* node;
	JsonObject* root;
	GError * _inner_error_ = NULL;
#line 282 "ease-theme.vala"
	g_return_if_fail (self != NULL);
#line 282 "ease-theme.vala"
	g_return_if_fail (json_path != NULL);
#line 284 "ease-theme.vala"
	parser = json_parser_new ();
#line 484 "ease-theme.c"
	{
#line 287 "ease-theme.vala"
		json_parser_load_from_file (parser, json_path, &_inner_error_);
#line 488 "ease-theme.c"
		if (_inner_error_ != NULL) {
			goto __catch36_g_error;
		}
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 291 "ease-theme.vala"
			g_error (_ ("Error loading theme: %s"), e->message);
#line 502 "ease-theme.c"
			_g_error_free0 (e);
		}
	}
	__finally36:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 295 "ease-theme.vala"
	self->priv->masters = (_tmp0_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->masters), _tmp0_);
#line 296 "ease-theme.vala"
	self->priv->elements = (_tmp1_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->elements), _tmp1_);
#line 297 "ease-theme.vala"
	self->priv->master_defaults = (_tmp2_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL), _g_object_unref0 (self->priv->master_defaults), _tmp2_);
#line 298 "ease-theme.vala"
	self->priv->element_defaults = (_tmp3_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL), _g_object_unref0 (self->priv->element_defaults), _tmp3_);
#line 301 "ease-theme.vala"
	node = json_parser_get_root (parser);
#line 302 "ease-theme.vala"
	if (node == NULL) {
#line 525 "ease-theme.c"
		_g_object_unref0 (parser);
#line 302 "ease-theme.vala"
		return;
#line 529 "ease-theme.c"
	}
#line 303 "ease-theme.vala"
	root = _json_object_ref0 (json_node_get_object (node));
#line 304 "ease-theme.vala"
	if (root == NULL) {
#line 535 "ease-theme.c"
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
#line 304 "ease-theme.vala"
		return;
#line 540 "ease-theme.c"
	}
#line 307 "ease-theme.vala"
	if (json_object_has_member (root, EASE_THEME_THEME_TITLE)) {
#line 544 "ease-theme.c"
		char* _tmp4_;
#line 308 "ease-theme.vala"
		self->title = (_tmp4_ = g_strdup (json_node_get_string (json_object_get_member (root, EASE_THEME_THEME_TITLE))), _g_free0 (self->title), _tmp4_);
#line 548 "ease-theme.c"
	}
#line 311 "ease-theme.vala"
	ease_theme_fill_map (self, root, EASE_THEME_MASTERS, self->priv->masters);
#line 312 "ease-theme.vala"
	ease_theme_fill_map (self, root, EASE_THEME_ELEMENTS, self->priv->elements);
#line 314 "ease-theme.vala"
	if (json_object_has_member (root, EASE_THEME_MASTER_DEF)) {
#line 315 "ease-theme.vala"
		ease_theme_fill_single_map (self, json_object_get_object_member (root, EASE_THEME_MASTER_DEF), self->priv->master_defaults);
#line 558 "ease-theme.c"
	}
#line 317 "ease-theme.vala"
	if (json_object_has_member (root, EASE_THEME_ELEMENT_DEF)) {
#line 318 "ease-theme.vala"
		ease_theme_fill_single_map (self, json_object_get_object_member (root, EASE_THEME_ELEMENT_DEF), self->priv->element_defaults);
#line 564 "ease-theme.c"
	}
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
}


/**
 * Copies all files under Media/ to a new directory.
 *
 * @param target The path to copy media files to.
 */
#line 327 "ease-theme.vala"
void ease_theme_copy_media (EaseTheme* self, const char* target, GError** error) {
#line 578 "ease-theme.c"
	char* origin_path;
	GFile* _tmp0_;
	gboolean _tmp1_;
	char* target_path;
	GError * _inner_error_ = NULL;
#line 327 "ease-theme.vala"
	g_return_if_fail (self != NULL);
#line 327 "ease-theme.vala"
	g_return_if_fail (target != NULL);
#line 329 "ease-theme.vala"
	origin_path = g_build_filename (self->priv->_path, EASE_THEME_MEDIA_PATH, NULL);
#line 331 "ease-theme.vala"
	if ((_tmp1_ = !g_file_query_exists (_tmp0_ = g_file_new_for_path (origin_path), NULL), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 592 "ease-theme.c"
		_g_free0 (origin_path);
#line 331 "ease-theme.vala"
		return;
#line 596 "ease-theme.c"
	}
#line 333 "ease-theme.vala"
	target_path = g_build_filename (target, EASE_THEME_MEDIA_PATH, NULL);
#line 335 "ease-theme.vala"
	ease_recursive_copy (origin_path, target_path, &_inner_error_);
#line 602 "ease-theme.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (target_path);
		_g_free0 (origin_path);
		return;
	}
	_g_free0 (target_path);
	_g_free0 (origin_path);
}


/**
 * Creates a slide from a theme master.
 *
 * @param master The string identifier for the master to use. This should be
 * a string constant of this class (TITLE, CONTENT, etc.)
 * @param width The width of the slide.
 * @param height The height of the slide.
 */
#line 346 "ease-theme.vala"
EaseSlide* ease_theme_create_slide (EaseTheme* self, const char* master, gint width, gint height) {
#line 624 "ease-theme.c"
	EaseSlide* result = NULL;
	EaseSlide* slide;
	char* _tmp5_;
	GQuark _tmp6_;
	const char* _tmp40_;
	GQuark _tmp41_;
#line 346 "ease-theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 346 "ease-theme.vala"
	g_return_val_if_fail (master != NULL, NULL);
#line 348 "ease-theme.vala"
	slide = ease_slide_new ();
#line 349 "ease-theme.vala"
	ease_slide_set_theme (slide, self);
#line 350 "ease-theme.vala"
	ease_slide_set_master (slide, master);
#line 641 "ease-theme.c"
	_tmp5_ = ease_theme_master_get (self, master, EASE_THEME_BACKGROUND_TYPE);
	_tmp6_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	g_free (_tmp5_);
	if (_tmp6_ == g_quark_from_string (EASE_THEME_BACKGROUND_TYPE_COLOR))
	switch (0) {
		default:
		{
			char* _tmp0_;
			EaseColor* _tmp1_;
#line 356 "ease-theme.vala"
			ease_background_set_color (ease_slide_get_background (slide), _tmp1_ = ease_color_new_from_string (_tmp0_ = ease_theme_master_get (self, master, EASE_THEME_BACKGROUND_COLOR)));
#line 653 "ease-theme.c"
			_g_object_unref0 (_tmp1_);
			_g_free0 (_tmp0_);
#line 358 "ease-theme.vala"
			ease_background_set_background_type (ease_slide_get_background (slide), EASE_BACKGROUND_TYPE_COLOR);
#line 359 "ease-theme.vala"
			break;
#line 660 "ease-theme.c"
		}
	} else if (_tmp6_ == g_quark_from_string (EASE_THEME_BACKGROUND_TYPE_GRADIENT))
	switch (0) {
		default:
		{
			char* _tmp2_;
			EaseGradient* _tmp3_;
#line 361 "ease-theme.vala"
			ease_background_set_gradient (ease_slide_get_background (slide), _tmp3_ = ease_gradient_new_from_string (_tmp2_ = ease_theme_master_get (self, master, EASE_THEME_BACKGROUND_GRADIENT)));
#line 670 "ease-theme.c"
			_g_object_unref0 (_tmp3_);
			_g_free0 (_tmp2_);
#line 363 "ease-theme.vala"
			ease_background_set_background_type (ease_slide_get_background (slide), EASE_BACKGROUND_TYPE_GRADIENT);
#line 364 "ease-theme.vala"
			break;
#line 677 "ease-theme.c"
		}
	} else if (_tmp6_ == g_quark_from_string (EASE_THEME_BACKGROUND_TYPE_IMAGE))
	switch (0) {
		default:
		{
			char* _tmp4_;
#line 366 "ease-theme.vala"
			ease_image_set_filename (ease_background_get_image (ease_slide_get_background (slide)), _tmp4_ = ease_theme_master_get (self, master, EASE_THEME_BACKGROUND_IMAGE));
#line 686 "ease-theme.c"
			_g_free0 (_tmp4_);
#line 368 "ease-theme.vala"
			ease_background_set_background_type (ease_slide_get_background (slide), EASE_BACKGROUND_TYPE_IMAGE);
#line 369 "ease-theme.vala"
			break;
#line 692 "ease-theme.c"
		}
	}
	_tmp40_ = master;
	_tmp41_ = (NULL == _tmp40_) ? 0 : g_quark_from_string (_tmp40_);
	if (_tmp41_ == g_quark_from_string (EASE_THEME_TITLE))
	switch (0) {
		default:
		{
			char* _tmp7_;
			gint _tmp8_;
			gint left;
			char* _tmp9_;
			gint _tmp10_;
			gint h;
			char* _tmp11_;
			char* _tmp12_;
			EaseTextElement* _tmp13_;
			char* _tmp14_;
			char* _tmp15_;
			char* _tmp16_;
			char* _tmp17_;
			EaseTextElement* _tmp18_;
#line 377 "ease-theme.vala"
			left = (_tmp8_ = atoi (_tmp7_ = ease_theme_element_get (self, EASE_THEME_TITLE_TEXT, EASE_THEME_PAD_LEFT)), _g_free0 (_tmp7_), _tmp8_);
#line 378 "ease-theme.vala"
			h = (_tmp10_ = atoi (_tmp9_ = ease_theme_element_get (self, EASE_THEME_TITLE_TEXT, EASE_THEME_HEIGHT)), _g_free0 (_tmp9_), _tmp10_);
#line 379 "ease-theme.vala"
			ease_slide_append (slide, (EaseElement*) (_tmp13_ = ease_theme_create_text (self, EASE_THEME_TITLE_TEXT, left, ((height / 2) - h) - atoi (_tmp11_ = ease_theme_element_get (self, EASE_THEME_TITLE_TEXT, EASE_THEME_PAD_BOTTOM)), (width - left) - atoi (_tmp12_ = ease_theme_element_get (self, EASE_THEME_TITLE_TEXT, EASE_THEME_PAD_RIGHT)), h)));
#line 721 "ease-theme.c"
			_g_object_unref0 (_tmp13_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp11_);
#line 388 "ease-theme.vala"
			left = atoi (_tmp14_ = ease_theme_element_get (self, EASE_THEME_AUTHOR_TEXT, EASE_THEME_PAD_LEFT));
#line 727 "ease-theme.c"
			_g_free0 (_tmp14_);
#line 389 "ease-theme.vala"
			ease_slide_append (slide, (EaseElement*) (_tmp18_ = ease_theme_create_text (self, EASE_THEME_AUTHOR_TEXT, left, (height / 2) + atoi (_tmp15_ = ease_theme_element_get (self, EASE_THEME_AUTHOR_TEXT, EASE_THEME_PAD_TOP)), (width - left) - atoi (_tmp16_ = ease_theme_element_get (self, EASE_THEME_AUTHOR_TEXT, EASE_THEME_PAD_RIGHT)), atoi (_tmp17_ = ease_theme_element_get (self, EASE_THEME_AUTHOR_TEXT, EASE_THEME_HEIGHT)))));
#line 731 "ease-theme.c"
			_g_object_unref0 (_tmp18_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp15_);
#line 396 "ease-theme.vala"
			break;
#line 738 "ease-theme.c"
		}
	} else if (_tmp41_ == g_quark_from_string (EASE_THEME_CONTENT))
	switch (0) {
		default:
		{
			char* _tmp19_;
			gint _tmp20_;
			gint left;
			char* _tmp21_;
			gint _tmp22_;
			gint top;
			char* _tmp23_;
			char* _tmp24_;
			EaseTextElement* _tmp25_;
#line 399 "ease-theme.vala"
			left = (_tmp20_ = atoi (_tmp19_ = ease_theme_element_get (self, EASE_THEME_CONTENT_TEXT, EASE_THEME_PAD_LEFT)), _g_free0 (_tmp19_), _tmp20_);
#line 400 "ease-theme.vala"
			top = (_tmp22_ = atoi (_tmp21_ = ease_theme_element_get (self, EASE_THEME_CONTENT_TEXT, EASE_THEME_PAD_TOP)), _g_free0 (_tmp21_), _tmp22_);
#line 402 "ease-theme.vala"
			ease_slide_append (slide, (EaseElement*) (_tmp25_ = ease_theme_create_text (self, EASE_THEME_CONTENT_TEXT, left, top, (width - left) - atoi (_tmp23_ = ease_theme_element_get (self, EASE_THEME_CONTENT_TEXT, EASE_THEME_PAD_RIGHT)), (height - top) - atoi (_tmp24_ = ease_theme_element_get (self, EASE_THEME_HEADER_TEXT, EASE_THEME_PAD_BOTTOM)))));
#line 759 "ease-theme.c"
			_g_object_unref0 (_tmp25_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp23_);
#line 409 "ease-theme.vala"
			break;
#line 765 "ease-theme.c"
		}
	} else if (_tmp41_ == g_quark_from_string (EASE_THEME_CONTENT_HEADER))
	switch (0) {
		default:
		{
			char* _tmp26_;
			gint _tmp27_;
			gint left;
			char* _tmp28_;
			gint _tmp29_;
			gint top;
			char* _tmp30_;
			char* _tmp31_;
			EaseTextElement* _tmp32_;
			char* _tmp33_;
			char* _tmp34_;
			char* _tmp35_;
			char* _tmp36_;
			char* _tmp37_;
			char* _tmp38_;
			EaseTextElement* _tmp39_;
#line 413 "ease-theme.vala"
			left = (_tmp27_ = atoi (_tmp26_ = ease_theme_element_get (self, EASE_THEME_HEADER_TEXT, EASE_THEME_PAD_LEFT)), _g_free0 (_tmp26_), _tmp27_);
#line 414 "ease-theme.vala"
			top = (_tmp29_ = atoi (_tmp28_ = ease_theme_element_get (self, EASE_THEME_HEADER_TEXT, EASE_THEME_PAD_TOP)), _g_free0 (_tmp28_), _tmp29_);
#line 416 "ease-theme.vala"
			ease_slide_append (slide, (EaseElement*) (_tmp32_ = ease_theme_create_text (self, EASE_THEME_HEADER_TEXT, left, top, (width - left) - atoi (_tmp30_ = ease_theme_element_get (self, EASE_THEME_HEADER_TEXT, EASE_THEME_PAD_RIGHT)), atoi (_tmp31_ = ease_theme_element_get (self, EASE_THEME_HEADER_TEXT, EASE_THEME_HEIGHT)))));
#line 793 "ease-theme.c"
			_g_object_unref0 (_tmp32_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp30_);
#line 425 "ease-theme.vala"
			left = atoi (_tmp33_ = ease_theme_element_get (self, EASE_THEME_CONTENT_TEXT, EASE_THEME_PAD_LEFT));
#line 799 "ease-theme.c"
			_g_free0 (_tmp33_);
#line 426 "ease-theme.vala"
			top = top + ((atoi (_tmp34_ = ease_theme_element_get (self, EASE_THEME_HEADER_TEXT, EASE_THEME_HEIGHT)) + atoi (_tmp35_ = ease_theme_element_get (self, EASE_THEME_HEADER_TEXT, EASE_THEME_PAD_BOTTOM))) + atoi (_tmp36_ = ease_theme_element_get (self, EASE_THEME_CONTENT_TEXT, EASE_THEME_PAD_TOP)));
#line 803 "ease-theme.c"
			_g_free0 (_tmp36_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp34_);
#line 429 "ease-theme.vala"
			ease_slide_append (slide, (EaseElement*) (_tmp39_ = ease_theme_create_text (self, EASE_THEME_CONTENT_TEXT, left, top, (width - left) - atoi (_tmp37_ = ease_theme_element_get (self, EASE_THEME_CONTENT_TEXT, EASE_THEME_PAD_RIGHT)), (height - top) - atoi (_tmp38_ = ease_theme_element_get (self, EASE_THEME_CONTENT_TEXT, EASE_THEME_PAD_BOTTOM)))));
#line 809 "ease-theme.c"
			_g_object_unref0 (_tmp39_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp37_);
#line 436 "ease-theme.vala"
			break;
#line 815 "ease-theme.c"
		}
	} else if (((((_tmp41_ == g_quark_from_string (EASE_THEME_CONTENT_DUAL)) || (_tmp41_ == g_quark_from_string (EASE_THEME_CONTENT_DUAL_HEADER))) || (_tmp41_ == g_quark_from_string (EASE_THEME_MEDIA))) || (_tmp41_ == g_quark_from_string (EASE_THEME_MEDIA_HEADER))) || (_tmp41_ == g_quark_from_string (EASE_THEME_EMPTY)))
	switch (0) {
		default:
		{
#line 443 "ease-theme.vala"
			break;
#line 823 "ease-theme.c"
		}
	} else
	switch (0) {
		default:
		{
#line 445 "ease-theme.vala"
			g_error (_ ("Invalid master slide title: %s"), master);
#line 831 "ease-theme.c"
			result = NULL;
			_g_object_unref0 (slide);
#line 446 "ease-theme.vala"
			return result;
#line 836 "ease-theme.c"
		}
	}
	result = slide;
#line 449 "ease-theme.vala"
	return result;
#line 842 "ease-theme.c"
}


/**
 * Returns a custom {@link TextElement} with its x and y positions set to 0.
 */
#line 455 "ease-theme.vala"
EaseTextElement* ease_theme_create_custom_text (EaseTheme* self) {
#line 851 "ease-theme.c"
	EaseTextElement* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	EaseTextElement* _tmp2_;
#line 455 "ease-theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 858 "ease-theme.c"
	result = (_tmp2_ = ease_theme_create_text (self, EASE_THEME_CUSTOM_TEXT, 0, 0, atoi (_tmp0_ = ease_theme_element_get (self, EASE_THEME_CUSTOM_TEXT, EASE_THEME_WIDTH)), atoi (_tmp1_ = ease_theme_element_get (self, EASE_THEME_CUSTOM_TEXT, EASE_THEME_HEIGHT))), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 457 "ease-theme.vala"
	return result;
#line 862 "ease-theme.c"
}


/**
 * Creates a text element, given an element type and dimensions.
 */
#line 465 "ease-theme.vala"
static EaseTextElement* ease_theme_create_text (EaseTheme* self, const char* type, gint x, gint y, gint w, gint h) {
#line 871 "ease-theme.c"
	EaseTextElement* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	EaseTextElement* text;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	EaseColor* _tmp11_;
#line 465 "ease-theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 465 "ease-theme.vala"
	g_return_val_if_fail (type != NULL, NULL);
#line 468 "ease-theme.vala"
	if (_vala_strcmp0 (type, EASE_THEME_TITLE_TEXT) == 0) {
#line 468 "ease-theme.vala"
		_tmp3_ = TRUE;
#line 894 "ease-theme.c"
	} else {
#line 468 "ease-theme.vala"
		_tmp3_ = _vala_strcmp0 (type, EASE_THEME_AUTHOR_TEXT) == 0;
#line 898 "ease-theme.c"
	}
#line 468 "ease-theme.vala"
	if (_tmp3_) {
#line 468 "ease-theme.vala"
		_tmp2_ = TRUE;
#line 904 "ease-theme.c"
	} else {
#line 469 "ease-theme.vala"
		_tmp2_ = _vala_strcmp0 (type, EASE_THEME_CUSTOM_TEXT) == 0;
#line 908 "ease-theme.c"
	}
#line 468 "ease-theme.vala"
	if (_tmp2_) {
#line 468 "ease-theme.vala"
		_tmp1_ = TRUE;
#line 914 "ease-theme.c"
	} else {
#line 469 "ease-theme.vala"
		_tmp1_ = _vala_strcmp0 (type, EASE_THEME_CONTENT_TEXT) == 0;
#line 918 "ease-theme.c"
	}
#line 468 "ease-theme.vala"
	if (_tmp1_) {
#line 468 "ease-theme.vala"
		_tmp0_ = TRUE;
#line 924 "ease-theme.c"
	} else {
#line 470 "ease-theme.vala"
		_tmp0_ = _vala_strcmp0 (type, EASE_THEME_HEADER_TEXT) == 0;
#line 928 "ease-theme.c"
	}
#line 468 "ease-theme.vala"
	if (!_tmp0_) {
#line 472 "ease-theme.vala"
		g_error (_ ("Not a valid text element type: %s"), type);
#line 934 "ease-theme.c"
	}
#line 476 "ease-theme.vala"
	text = ease_text_element_new ();
#line 479 "ease-theme.vala"
	ease_text_element_set_text_font (text, _tmp4_ = ease_theme_element_get (self, type, EASE_THEME_TEXT_FONT));
#line 940 "ease-theme.c"
	_g_free0 (_tmp4_);
#line 480 "ease-theme.vala"
	ease_text_element_text_size_from_string (text, _tmp5_ = ease_theme_element_get (self, type, EASE_THEME_TEXT_SIZE));
#line 944 "ease-theme.c"
	_g_free0 (_tmp5_);
#line 481 "ease-theme.vala"
	ease_text_element_text_style_from_string (text, _tmp6_ = ease_theme_element_get (self, type, EASE_THEME_TEXT_STYLE));
#line 948 "ease-theme.c"
	_g_free0 (_tmp6_);
#line 482 "ease-theme.vala"
	ease_text_element_text_variant_from_string (text, _tmp7_ = ease_theme_element_get (self, type, EASE_THEME_TEXT_VARIANT));
#line 952 "ease-theme.c"
	_g_free0 (_tmp7_);
#line 483 "ease-theme.vala"
	ease_text_element_text_weight_from_string (text, _tmp8_ = ease_theme_element_get (self, type, EASE_THEME_TEXT_WEIGHT));
#line 956 "ease-theme.c"
	_g_free0 (_tmp8_);
#line 484 "ease-theme.vala"
	ease_text_element_text_align_from_string (text, _tmp9_ = ease_theme_element_get (self, type, EASE_THEME_TEXT_ALIGN));
#line 960 "ease-theme.c"
	_g_free0 (_tmp9_);
#line 487 "ease-theme.vala"
	ease_text_element_set_color (text, _tmp11_ = ease_color_new_from_string (_tmp10_ = ease_theme_element_get (self, type, EASE_THEME_TEXT_COLOR)));
#line 964 "ease-theme.c"
	_g_object_unref0 (_tmp11_);
	_g_free0 (_tmp10_);
#line 490 "ease-theme.vala"
	ease_element_set_x ((EaseElement*) text, (float) x);
#line 491 "ease-theme.vala"
	ease_element_set_y ((EaseElement*) text, (float) y);
#line 492 "ease-theme.vala"
	ease_element_set_width ((EaseElement*) text, (float) w);
#line 493 "ease-theme.vala"
	ease_element_set_height ((EaseElement*) text, (float) h);
#line 496 "ease-theme.vala"
	ease_element_set_identifier ((EaseElement*) text, type);
#line 497 "ease-theme.vala"
	ease_element_set_has_been_edited ((EaseElement*) text, FALSE);
#line 498 "ease-theme.vala"
	ease_text_element_set_text (text, "");
#line 981 "ease-theme.c"
	result = text;
#line 500 "ease-theme.vala"
	return result;
#line 985 "ease-theme.c"
}


/**
 * Retrieves an element property.
 *
 * @param element The element name to search for.
 * @param prop The property name to search for.
 */
#line 509 "ease-theme.vala"
static char* ease_theme_element_get (EaseTheme* self, const char* element, const char* prop) {
#line 997 "ease-theme.c"
	char* result = NULL;
	GeeMap* map;
	char* str;
#line 509 "ease-theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 509 "ease-theme.vala"
	g_return_val_if_fail (element != NULL, NULL);
#line 509 "ease-theme.vala"
	g_return_val_if_fail (prop != NULL, NULL);
#line 512 "ease-theme.vala"
	map = (GeeMap*) gee_map_get (self->priv->elements, element);
#line 513 "ease-theme.vala"
	if (map != NULL) {
#line 1011 "ease-theme.c"
		char* str;
#line 515 "ease-theme.vala"
		str = (char*) gee_map_get (map, prop);
#line 516 "ease-theme.vala"
		if (str != NULL) {
#line 1017 "ease-theme.c"
			result = str;
			_g_object_unref0 (map);
#line 516 "ease-theme.vala"
			return result;
#line 1022 "ease-theme.c"
		}
		_g_free0 (str);
	}
#line 520 "ease-theme.vala"
	str = (char*) gee_map_get (self->priv->element_defaults, prop);
#line 521 "ease-theme.vala"
	if (str != NULL) {
#line 1030 "ease-theme.c"
		result = str;
		_g_object_unref0 (map);
#line 521 "ease-theme.vala"
		return result;
#line 1035 "ease-theme.c"
	}
#line 524 "ease-theme.vala"
	if (ease_theme_get_defaults () == self) {
#line 526 "ease-theme.vala"
		g_error (_ ("Could not find property %s on element type %s."), prop, element);
#line 1041 "ease-theme.c"
	}
	result = ease_theme_element_get (ease_theme_get_defaults (), element, prop);
	_g_free0 (str);
	_g_object_unref0 (map);
#line 530 "ease-theme.vala"
	return result;
#line 1048 "ease-theme.c"
}


/**
 * Retrieves an master property.
 *
 * @param master The master name to search for.
 * @param prop The property name to search for.
 */
#line 539 "ease-theme.vala"
static char* ease_theme_master_get (EaseTheme* self, const char* master, const char* prop) {
#line 1060 "ease-theme.c"
	char* result = NULL;
	GeeMap* map;
	char* str;
#line 539 "ease-theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 539 "ease-theme.vala"
	g_return_val_if_fail (master != NULL, NULL);
#line 539 "ease-theme.vala"
	g_return_val_if_fail (prop != NULL, NULL);
#line 542 "ease-theme.vala"
	map = (GeeMap*) gee_map_get (self->priv->masters, master);
#line 543 "ease-theme.vala"
	if (map != NULL) {
#line 1074 "ease-theme.c"
		char* str;
#line 545 "ease-theme.vala"
		str = (char*) gee_map_get (map, prop);
#line 546 "ease-theme.vala"
		if (str != NULL) {
#line 1080 "ease-theme.c"
			result = str;
			_g_object_unref0 (map);
#line 546 "ease-theme.vala"
			return result;
#line 1085 "ease-theme.c"
		}
		_g_free0 (str);
	}
#line 550 "ease-theme.vala"
	str = (char*) gee_map_get (self->priv->master_defaults, prop);
#line 551 "ease-theme.vala"
	if (str != NULL) {
#line 1093 "ease-theme.c"
		result = str;
		_g_object_unref0 (map);
#line 551 "ease-theme.vala"
		return result;
#line 1098 "ease-theme.c"
	}
#line 554 "ease-theme.vala"
	if (ease_theme_get_defaults () == self) {
#line 556 "ease-theme.vala"
		g_error (_ ("Could not find property %s on master type %s."), prop, master);
#line 1104 "ease-theme.c"
	}
	result = ease_theme_master_get (ease_theme_get_defaults (), master, prop);
	_g_free0 (str);
	_g_object_unref0 (map);
#line 560 "ease-theme.vala"
	return result;
#line 1111 "ease-theme.c"
}


/**
 * Returns a string description for a specified master identifier.
 *
 * @param master The identifier. This should be a constant of this class.
 */
#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 1122 "ease-theme.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1131 "ease-theme.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 1139 "ease-theme.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch37_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 1150 "ease-theme.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch37_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 1165 "ease-theme.c"
	}
	goto __finally37;
	__catch37_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 1176 "ease-theme.c"
			_g_error_free0 (e);
		}
	}
	__finally37:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 568 "ease-theme.vala"
char* ease_theme_master_description (const char* master) {
#line 1191 "ease-theme.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
#line 568 "ease-theme.vala"
	g_return_val_if_fail (master != NULL, NULL);
#line 1197 "ease-theme.c"
	result = (_tmp1_ = string_replace (_tmp0_ = ease_theme_master_mnemonic_description (master), "_", ""), _g_free0 (_tmp0_), _tmp1_);
#line 570 "ease-theme.vala"
	return result;
#line 1201 "ease-theme.c"
}


/**
 * Returns a string description, with mnemonic, for a specified master
 * identifier.
 *
 * @param master The identifier. This should be a constant of this class.
 */
#line 579 "ease-theme.vala"
char* ease_theme_master_mnemonic_description (const char* master) {
#line 1213 "ease-theme.c"
	char* result = NULL;
	const char* _tmp0_;
	GQuark _tmp1_;
#line 579 "ease-theme.vala"
	g_return_val_if_fail (master != NULL, NULL);
#line 1219 "ease-theme.c"
	_tmp0_ = master;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (EASE_THEME_TITLE))
	switch (0) {
		default:
		{
			result = g_strdup (_ ("_Title slide"));
#line 584 "ease-theme.vala"
			return result;
#line 1229 "ease-theme.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_CONTENT))
	switch (0) {
		default:
		{
			result = g_strdup (_ ("Content slide _without header"));
#line 586 "ease-theme.vala"
			return result;
#line 1238 "ease-theme.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_CONTENT_HEADER))
	switch (0) {
		default:
		{
			result = g_strdup (_ ("_Content slide"));
#line 588 "ease-theme.vala"
			return result;
#line 1247 "ease-theme.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_CONTENT_DUAL))
	switch (0) {
		default:
		{
			result = g_strdup (_ ("Two column slide without _header"));
#line 590 "ease-theme.vala"
			return result;
#line 1256 "ease-theme.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_CONTENT_DUAL_HEADER))
	switch (0) {
		default:
		{
			result = g_strdup (_ ("T_wo column slide with header"));
#line 592 "ease-theme.vala"
			return result;
#line 1265 "ease-theme.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_MEDIA))
	switch (0) {
		default:
		{
			result = g_strdup (_ ("M_edia slide without header"));
#line 594 "ease-theme.vala"
			return result;
#line 1274 "ease-theme.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_MEDIA_HEADER))
	switch (0) {
		default:
		{
			result = g_strdup (_ ("_Media slide"));
#line 596 "ease-theme.vala"
			return result;
#line 1283 "ease-theme.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_EMPTY))
	switch (0) {
		default:
		{
			result = g_strdup (_ ("Em_pty Slide"));
#line 598 "ease-theme.vala"
			return result;
#line 1292 "ease-theme.c"
		}
	}
#line 601 "ease-theme.vala"
	g_critical (_ ("%s is not a valid identifier"), master);
#line 1297 "ease-theme.c"
	result = g_strdup (master);
#line 602 "ease-theme.vala"
	return result;
#line 1301 "ease-theme.c"
}


/**
 * Finds the master identifier associated with the provided description.
 *
 * The description may be a mnemonic.
 *
 * @param desc The description, provided by master_description or
 * master_mnemonic_description.
 */
#line 613 "ease-theme.vala"
char* ease_theme_master_from_description (const char* desc) {
#line 1315 "ease-theme.c"
	char* result = NULL;
	char* replaced;
#line 613 "ease-theme.vala"
	g_return_val_if_fail (desc != NULL, NULL);
#line 615 "ease-theme.vala"
	replaced = string_replace (desc, "_", "");
#line 1322 "ease-theme.c"
	{
		const char** master_collection;
		int master_collection_length1;
		int master_it;
#line 617 "ease-theme.vala"
		master_collection = EASE_THEME_MASTER_SLIDES;
#line 1329 "ease-theme.c"
		master_collection_length1 = G_N_ELEMENTS (EASE_THEME_MASTER_SLIDES);
		for (master_it = 0; master_it < G_N_ELEMENTS (EASE_THEME_MASTER_SLIDES); master_it = master_it + 1) {
			const char* master;
			master = master_collection[master_it];
			{
				char* _tmp0_;
				gboolean _tmp1_;
#line 619 "ease-theme.vala"
				if ((_tmp1_ = _vala_strcmp0 (_tmp0_ = ease_theme_master_description (master), replaced) == 0, _g_free0 (_tmp0_), _tmp1_)) {
#line 1339 "ease-theme.c"
					result = g_strdup (master);
					_g_free0 (replaced);
#line 619 "ease-theme.vala"
					return result;
#line 1344 "ease-theme.c"
				}
			}
		}
	}
#line 622 "ease-theme.vala"
	g_critical ("ease-theme.vala:622: Not a valid master description: %s", desc);
#line 1351 "ease-theme.c"
	result = g_strdup (desc);
	_g_free0 (replaced);
#line 623 "ease-theme.vala"
	return result;
#line 1356 "ease-theme.c"
}


/**
 * Fills a Gee.Map with style property overrides in the form of more
 * Gee.Maps.
 *
 * @param obj The root object.
 * @param name The name of the JSON array to use.
 * @param map The map to fill with submaps.
 */
#line 634 "ease-theme.vala"
static void ease_theme_fill_map (EaseTheme* self, JsonObject* obj, const char* name, GeeMap* map) {
#line 1370 "ease-theme.c"
	JsonObject* sub;
#line 634 "ease-theme.vala"
	g_return_if_fail (self != NULL);
#line 634 "ease-theme.vala"
	g_return_if_fail (obj != NULL);
#line 634 "ease-theme.vala"
	g_return_if_fail (name != NULL);
#line 634 "ease-theme.vala"
	g_return_if_fail (map != NULL);
#line 637 "ease-theme.vala"
	if (!json_object_has_member (obj, name)) {
#line 637 "ease-theme.vala"
		return;
#line 1384 "ease-theme.c"
	}
#line 638 "ease-theme.vala"
	sub = _json_object_ref0 (json_object_get_object_member (obj, name));
#line 639 "ease-theme.vala"
	if (sub == NULL) {
#line 1390 "ease-theme.c"
		_json_object_unref0 (sub);
#line 639 "ease-theme.vala"
		return;
#line 1394 "ease-theme.c"
	}
	{
		GList* i;
#line 641 "ease-theme.vala"
		i = json_object_get_members (sub);
#line 1400 "ease-theme.c"
		{
			gboolean _tmp0_;
#line 641 "ease-theme.vala"
			_tmp0_ = TRUE;
#line 641 "ease-theme.vala"
			while (TRUE) {
#line 1407 "ease-theme.c"
				JsonObject* curr_obj;
				GeeHashMap* submap;
#line 641 "ease-theme.vala"
				if (!_tmp0_) {
#line 642 "ease-theme.vala"
					i = i->next;
#line 1414 "ease-theme.c"
				}
#line 641 "ease-theme.vala"
				_tmp0_ = FALSE;
#line 642 "ease-theme.vala"
				if (!(i != NULL)) {
#line 642 "ease-theme.vala"
					break;
#line 1422 "ease-theme.c"
				}
#line 645 "ease-theme.vala"
				curr_obj = _json_object_ref0 (json_node_get_object (json_object_get_member (sub, (const char*) i->data)));
#line 648 "ease-theme.vala"
				submap = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 651 "ease-theme.vala"
				ease_theme_fill_single_map (self, curr_obj, (GeeMap*) submap);
#line 654 "ease-theme.vala"
				gee_map_set (map, (const char*) i->data, (GeeMap*) submap);
#line 1432 "ease-theme.c"
				_g_object_unref0 (submap);
				_json_object_unref0 (curr_obj);
			}
		}
	}
	_json_object_unref0 (sub);
}


/**
 * Fill a Gee.Map with key/value pairs.
 *
 * @param obj The json object to use.
 * @param map The map to fill.
 */
#line 664 "ease-theme.vala"
static void ease_theme_fill_single_map (EaseTheme* self, JsonObject* obj, GeeMap* map) {
#line 664 "ease-theme.vala"
	g_return_if_fail (self != NULL);
#line 664 "ease-theme.vala"
	g_return_if_fail (obj != NULL);
#line 664 "ease-theme.vala"
	g_return_if_fail (map != NULL);
#line 1456 "ease-theme.c"
	{
		GList* j;
#line 666 "ease-theme.vala"
		j = json_object_get_members (obj);
#line 1461 "ease-theme.c"
		{
			gboolean _tmp0_;
#line 666 "ease-theme.vala"
			_tmp0_ = TRUE;
#line 666 "ease-theme.vala"
			while (TRUE) {
#line 666 "ease-theme.vala"
				if (!_tmp0_) {
#line 667 "ease-theme.vala"
					j = j->next;
#line 1472 "ease-theme.c"
				}
#line 666 "ease-theme.vala"
				_tmp0_ = FALSE;
#line 667 "ease-theme.vala"
				if (!(j != NULL)) {
#line 667 "ease-theme.vala"
					break;
#line 1480 "ease-theme.c"
				}
#line 669 "ease-theme.vala"
				gee_map_set (map, (const char*) j->data, json_node_get_string (json_object_get_member (obj, (const char*) j->data)));
#line 1484 "ease-theme.c"
			}
		}
	}
}


const char* ease_theme_get_path (EaseTheme* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path;
#line 162 "ease-theme.vala"
	return result;
#line 1497 "ease-theme.c"
}


void ease_theme_set_path (EaseTheme* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_path), _tmp0_);
	g_object_notify ((GObject *) self, "path");
}


static EaseTheme* ease_theme_get_defaults (void) {
	EaseTheme* result;
	char* _tmp0_;
	EaseTheme* _tmp1_;
	EaseTheme* _tmp2_;
#line 199 "ease-theme.vala"
	if (ease_theme_defaults_store != NULL) {
#line 1516 "ease-theme.c"
		result = ease_theme_defaults_store;
#line 199 "ease-theme.vala"
		return result;
#line 1520 "ease-theme.c"
	}
	result = (_tmp2_ = ease_theme_defaults_store = (_tmp1_ = ease_theme_new_json (_tmp0_ = ease_data_path (EASE_THEME_DEFAULTS_PATH)), _g_object_unref0 (ease_theme_defaults_store), _tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 200 "ease-theme.vala"
	return result;
#line 1525 "ease-theme.c"
}


static void ease_theme_class_init (EaseThemeClass * klass) {
	ease_theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseThemePrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_theme_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_theme_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_theme_finalize;
	/**
	 * The path to the theme's extracted files.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_THEME_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ease_theme_instance_init (EaseTheme * self) {
	self->priv = EASE_THEME_GET_PRIVATE (self);
}


static void ease_theme_finalize (GObject* obj) {
	EaseTheme * self;
	self = EASE_THEME (obj);
	_g_free0 (self->title);
	_g_free0 (self->priv->_path);
	_g_object_unref0 (self->priv->masters);
	_g_object_unref0 (self->priv->elements);
	_g_object_unref0 (self->priv->master_defaults);
	_g_object_unref0 (self->priv->element_defaults);
	G_OBJECT_CLASS (ease_theme_parent_class)->finalize (obj);
}


/**
 * Internal representation of Ease themes.
 */
GType ease_theme_get_type (void) {
	static volatile gsize ease_theme_type_id__volatile = 0;
	if (g_once_init_enter (&ease_theme_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseTheme), 0, (GInstanceInitFunc) ease_theme_instance_init, NULL };
		GType ease_theme_type_id;
		ease_theme_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseTheme", &g_define_type_info, 0);
		g_once_init_leave (&ease_theme_type_id__volatile, ease_theme_type_id);
	}
	return ease_theme_type_id__volatile;
}


static void ease_theme_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseTheme * self;
	self = EASE_THEME (object);
	switch (property_id) {
		case EASE_THEME_PATH:
		g_value_set_string (value, ease_theme_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_theme_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseTheme * self;
	self = EASE_THEME (object);
	switch (property_id) {
		case EASE_THEME_PATH:
		ease_theme_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




