/* ease-pdf-actor.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-pdf-actor.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <poppler.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>


#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;
typedef struct _EaseActorPrivate EaseActorPrivate;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_PDF_ACTOR (ease_pdf_actor_get_type ())
#define EASE_PDF_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_PDF_ACTOR, EasePdfActor))
#define EASE_PDF_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_PDF_ACTOR, EasePdfActorClass))
#define EASE_IS_PDF_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_PDF_ACTOR))
#define EASE_IS_PDF_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_PDF_ACTOR))
#define EASE_PDF_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_PDF_ACTOR, EasePdfActorClass))

typedef struct _EasePdfActor EasePdfActor;
typedef struct _EasePdfActorClass EasePdfActorClass;
typedef struct _EasePdfActorPrivate EasePdfActorPrivate;

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;

#define EASE_TYPE_PDF_ELEMENT (ease_pdf_element_get_type ())
#define EASE_PDF_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_PDF_ELEMENT, EasePdfElement))
#define EASE_PDF_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_PDF_ELEMENT, EasePdfElementClass))
#define EASE_IS_PDF_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_PDF_ELEMENT))
#define EASE_IS_PDF_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_PDF_ELEMENT))
#define EASE_PDF_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_PDF_ELEMENT, EasePdfElementClass))

typedef struct _EasePdfElement EasePdfElement;
typedef struct _EasePdfElementClass EasePdfElementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;
typedef struct _EaseMediaElementPrivate EaseMediaElementPrivate;
typedef struct _EasePdfElementPrivate EasePdfElementPrivate;

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;
typedef struct _Block9Data Block9Data;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseActor {
	ClutterGroup parent_instance;
	EaseActorPrivate * priv;
	ClutterActor* contents;
	EaseElement* element;
	EaseActorContext context;
	gboolean is_background;
};

struct _EaseActorClass {
	ClutterGroupClass parent_class;
	void (*edit) (EaseActor* self, GtkWidget* sender);
	void (*end_edit) (EaseActor* self, GtkWidget* sender);
};

struct _EasePdfActor {
	EaseActor parent_instance;
	EasePdfActorPrivate * priv;
};

struct _EasePdfActorClass {
	EaseActorClass parent_class;
};

struct _EasePdfActorPrivate {
	ClutterCairoTexture* texture;
	gint current_page;
	PopplerDocument* doc;
	EasePdfElement* pdf_element;
};

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	void (*cairo_render_small) (EaseElement* self, cairo_t* context, GError** error);
	void (*cairo_free_cache) (EaseElement* self);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
	float (*get_minimum_width) (EaseElement* self);
	float (*get_minimum_height) (EaseElement* self);
};

struct _EaseMediaElement {
	EaseElement parent_instance;
	EaseMediaElementPrivate * priv;
};

struct _EaseMediaElementClass {
	EaseElementClass parent_class;
};

struct _EasePdfElement {
	EaseMediaElement parent_instance;
	EasePdfElementPrivate * priv;
	EaseBackground* background;
	PopplerDocument* pdf_doc;
};

struct _EasePdfElementClass {
	EaseMediaElementClass parent_class;
};

struct _Block9Data {
	int _ref_count_;
	EasePdfActor * self;
	EasePdfElement* e;
};


static gpointer ease_pdf_actor_parent_class = NULL;

GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_pdf_actor_get_type (void) G_GNUC_CONST;
GType ease_media_element_get_type (void) G_GNUC_CONST;
GType ease_pdf_element_get_type (void) G_GNUC_CONST;
#define EASE_PDF_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_PDF_ACTOR, EasePdfActorPrivate))
enum  {
	EASE_PDF_ACTOR_DUMMY_PROPERTY
};
EasePdfActor* ease_pdf_actor_new (EasePdfElement* e, EaseActorContext c);
EasePdfActor* ease_pdf_actor_construct (GType object_type, EasePdfElement* e, EaseActorContext c);
EaseActor* ease_actor_construct (GType object_type, EaseElement* e, EaseActorContext c);
float ease_element_get_width (EaseElement* self);
float ease_element_get_height (EaseElement* self);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
gint ease_pdf_element_get_displayed_page (EasePdfElement* self);
GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_background_get_type (void) G_GNUC_CONST;
static void ease_pdf_actor_draw_page (EasePdfActor* self);
static void _lambda55_ (Block9Data* _data9_);
static void __lambda55__ease_element_changed (EaseElement* _sender, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static void _lambda53_ (GObject* obj, GParamSpec* pspec, EasePdfActor* self);
static void __lambda53__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda54_ (GObject* obj, GParamSpec* pspec, EasePdfActor* self);
static void __lambda54__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void ease_background_cairo_render (EaseBackground* self, cairo_t* cr, gint width, gint height, const char* path, GError** error);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_element_get_parent (EaseElement* self);
GType ease_document_get_type (void) G_GNUC_CONST;
EaseDocument* ease_slide_get_parent (EaseSlide* self);
const char* ease_document_get_path (EaseDocument* self);
static void ease_pdf_actor_finalize (GObject* obj);



/**
 * Instantiates a new PdfActor from an Element.
 *
 * @param e The represented element.
 * @param c The context of this Actor (Presentation, Sidebar, Editor)
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 52 "ease-pdf-actor.vala"
static void _lambda55_ (Block9Data* _data9_) {
#line 290 "ease-pdf-actor.c"
	EasePdfActor * self;
	self = _data9_->self;
#line 53 "ease-pdf-actor.vala"
	self->priv->current_page = ease_pdf_element_get_displayed_page (_data9_->e);
#line 54 "ease-pdf-actor.vala"
	ease_pdf_actor_draw_page (self);
#line 297 "ease-pdf-actor.c"
}


#line 52 "ease-pdf-actor.vala"
static void __lambda55__ease_element_changed (EaseElement* _sender, gpointer self) {
#line 303 "ease-pdf-actor.c"
	_lambda55_ (self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->e);
		g_slice_free (Block9Data, _data9_);
	}
}


#line 34 "ease-pdf-actor.vala"
EasePdfActor* ease_pdf_actor_construct (GType object_type, EasePdfElement* e, EaseActorContext c) {
#line 325 "ease-pdf-actor.c"
	EasePdfActor * self;
	Block9Data* _data9_;
	EasePdfElement* _tmp0_;
	ClutterActor* _tmp1_;
	PopplerDocument* _tmp2_;
#line 34 "ease-pdf-actor.vala"
	g_return_val_if_fail (e != NULL, NULL);
#line 333 "ease-pdf-actor.c"
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->e = _g_object_ref0 (e);
#line 36 "ease-pdf-actor.vala"
	_data9_->self = g_object_ref (self = (EasePdfActor*) ease_actor_construct (object_type, (EaseElement*) _data9_->e, c));
#line 38 "ease-pdf-actor.vala"
	self->priv->pdf_element = (_tmp0_ = _g_object_ref0 (_data9_->e), _g_object_unref0 (self->priv->pdf_element), _tmp0_);
#line 40 "ease-pdf-actor.vala"
	((EaseActor*) self)->contents = (_tmp1_ = (ClutterActor*) g_object_ref_sink ((ClutterGroup*) clutter_group_new ()), _g_object_unref0 (((EaseActor*) self)->contents), _tmp1_);
#line 41 "ease-pdf-actor.vala"
	clutter_actor_set_width (((EaseActor*) self)->contents, ease_element_get_width ((EaseElement*) _data9_->e));
#line 42 "ease-pdf-actor.vala"
	clutter_actor_set_height (((EaseActor*) self)->contents, ease_element_get_height ((EaseElement*) _data9_->e));
#line 43 "ease-pdf-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, ease_element_get_x ((EaseElement*) _data9_->e));
#line 44 "ease-pdf-actor.vala"
	clutter_actor_set_y ((ClutterActor*) self, ease_element_get_y ((EaseElement*) _data9_->e));
#line 45 "ease-pdf-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, ((EaseActor*) self)->contents);
#line 47 "ease-pdf-actor.vala"
	self->priv->current_page = ease_pdf_element_get_displayed_page (_data9_->e);
#line 48 "ease-pdf-actor.vala"
	self->priv->doc = (_tmp2_ = _g_object_ref0 (_data9_->e->pdf_doc), _g_object_unref0 (self->priv->doc), _tmp2_);
#line 49 "ease-pdf-actor.vala"
	ease_pdf_actor_draw_page (self);
#line 52 "ease-pdf-actor.vala"
	g_signal_connect_data ((EaseElement*) _data9_->e, "changed", (GCallback) __lambda55__ease_element_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 361 "ease-pdf-actor.c"
	block9_data_unref (_data9_);
	return self;
}


#line 34 "ease-pdf-actor.vala"
EasePdfActor* ease_pdf_actor_new (EasePdfElement* e, EaseActorContext c) {
#line 34 "ease-pdf-actor.vala"
	return ease_pdf_actor_construct (EASE_TYPE_PDF_ACTOR, e, c);
#line 371 "ease-pdf-actor.c"
}


#line 74 "ease-pdf-actor.vala"
static void _lambda53_ (GObject* obj, GParamSpec* pspec, EasePdfActor* self) {
#line 74 "ease-pdf-actor.vala"
	g_return_if_fail (obj != NULL);
#line 74 "ease-pdf-actor.vala"
	g_return_if_fail (pspec != NULL);
#line 75 "ease-pdf-actor.vala"
	clutter_actor_set_width ((ClutterActor*) self->priv->texture, clutter_actor_get_width (((EaseActor*) self)->contents));
#line 383 "ease-pdf-actor.c"
}


#line 74 "ease-pdf-actor.vala"
static void __lambda53__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 389 "ease-pdf-actor.c"
	_lambda53_ (_sender, pspec, self);
}


#line 78 "ease-pdf-actor.vala"
static void _lambda54_ (GObject* obj, GParamSpec* pspec, EasePdfActor* self) {
#line 78 "ease-pdf-actor.vala"
	g_return_if_fail (obj != NULL);
#line 78 "ease-pdf-actor.vala"
	g_return_if_fail (pspec != NULL);
#line 79 "ease-pdf-actor.vala"
	clutter_actor_set_height ((ClutterActor*) self->priv->texture, clutter_actor_get_height (((EaseActor*) self)->contents));
#line 402 "ease-pdf-actor.c"
}


#line 78 "ease-pdf-actor.vala"
static void __lambda54__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 408 "ease-pdf-actor.c"
	_lambda54_ (_sender, pspec, self);
}


#line 58 "ease-pdf-actor.vala"
static void ease_pdf_actor_draw_page (EasePdfActor* self) {
#line 415 "ease-pdf-actor.c"
	PopplerPage* page;
	double width;
	double height;
	cairo_t* cr;
	GError * _inner_error_ = NULL;
#line 58 "ease-pdf-actor.vala"
	g_return_if_fail (self != NULL);
#line 61 "ease-pdf-actor.vala"
	page = _g_object_ref0 (poppler_document_get_page (self->priv->doc, self->priv->current_page));
#line 62 "ease-pdf-actor.vala"
	width = (double) 0;
#line 62 "ease-pdf-actor.vala"
	height = (double) 0;
#line 63 "ease-pdf-actor.vala"
	poppler_page_get_size (page, &width, &height);
#line 66 "ease-pdf-actor.vala"
	if (self->priv->texture == NULL) {
#line 433 "ease-pdf-actor.c"
		ClutterCairoTexture* _tmp0_;
		ClutterActor* _tmp1_;
#line 68 "ease-pdf-actor.vala"
		self->priv->texture = (_tmp0_ = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) ((gint) width), (guint) ((gint) height))), _g_object_unref0 (self->priv->texture), _tmp0_);
#line 69 "ease-pdf-actor.vala"
		clutter_container_add_actor ((ClutterContainer*) (_tmp1_ = ((EaseActor*) self)->contents, CLUTTER_IS_GROUP (_tmp1_) ? ((ClutterGroup*) _tmp1_) : NULL), (ClutterActor*) self->priv->texture);
#line 71 "ease-pdf-actor.vala"
		clutter_actor_set_width ((ClutterActor*) self->priv->texture, clutter_actor_get_width (((EaseActor*) self)->contents));
#line 72 "ease-pdf-actor.vala"
		clutter_actor_set_height ((ClutterActor*) self->priv->texture, clutter_actor_get_height (((EaseActor*) self)->contents));
#line 74 "ease-pdf-actor.vala"
		g_signal_connect_object ((GObject*) ((EaseActor*) self)->contents, "notify::width", (GCallback) __lambda53__g_object_notify, self, 0);
#line 78 "ease-pdf-actor.vala"
		g_signal_connect_object ((GObject*) ((EaseActor*) self)->contents, "notify::height", (GCallback) __lambda54__g_object_notify, self, 0);
#line 448 "ease-pdf-actor.c"
	} else {
#line 86 "ease-pdf-actor.vala"
		clutter_cairo_texture_set_surface_size (self->priv->texture, (guint) ((gint) width), (guint) ((gint) height));
#line 452 "ease-pdf-actor.c"
	}
#line 90 "ease-pdf-actor.vala"
	clutter_cairo_texture_clear (self->priv->texture);
#line 91 "ease-pdf-actor.vala"
	cr = clutter_cairo_texture_create (self->priv->texture);
#line 92 "ease-pdf-actor.vala"
	ease_background_cairo_render (self->priv->pdf_element->background, cr, (gint) width, (gint) height, ease_document_get_path (ease_slide_get_parent (ease_element_get_parent (((EaseActor*) self)->element))), &_inner_error_);
#line 460 "ease-pdf-actor.c"
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (cr);
		_g_object_unref0 (page);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 94 "ease-pdf-actor.vala"
	poppler_page_render (page, cr);
#line 470 "ease-pdf-actor.c"
	_cairo_destroy0 (cr);
	_g_object_unref0 (page);
}


static void ease_pdf_actor_class_init (EasePdfActorClass * klass) {
	ease_pdf_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EasePdfActorPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_pdf_actor_finalize;
}


static void ease_pdf_actor_instance_init (EasePdfActor * self) {
	self->priv = EASE_PDF_ACTOR_GET_PRIVATE (self);
}


static void ease_pdf_actor_finalize (GObject* obj) {
	EasePdfActor * self;
	self = EASE_PDF_ACTOR (obj);
	_g_object_unref0 (self->priv->texture);
	_g_object_unref0 (self->priv->doc);
	_g_object_unref0 (self->priv->pdf_element);
	G_OBJECT_CLASS (ease_pdf_actor_parent_class)->finalize (obj);
}


/**
 * Actor displaying a {@link PdfElement}.
 */
GType ease_pdf_actor_get_type (void) {
	static volatile gsize ease_pdf_actor_type_id__volatile = 0;
	if (g_once_init_enter (&ease_pdf_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EasePdfActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_pdf_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EasePdfActor), 0, (GInstanceInitFunc) ease_pdf_actor_instance_init, NULL };
		GType ease_pdf_actor_type_id;
		ease_pdf_actor_type_id = g_type_register_static (EASE_TYPE_ACTOR, "EasePdfActor", &g_define_type_info, 0);
		g_once_init_leave (&ease_pdf_actor_type_id__volatile, ease_pdf_actor_type_id);
	}
	return ease_pdf_actor_type_id__volatile;
}




