/* ease-image-element.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-image-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;
typedef struct _EaseMediaElementPrivate EaseMediaElementPrivate;

#define EASE_TYPE_IMAGE_ELEMENT (ease_image_element_get_type ())
#define EASE_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElement))
#define EASE_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))
#define EASE_IS_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IS_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IMAGE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))

typedef struct _EaseImageElement EaseImageElement;
typedef struct _EaseImageElementClass EaseImageElementClass;
typedef struct _EaseImageElementPrivate EaseImageElementPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_TYPE_IMAGE_ACTOR (ease_image_actor_get_type ())
#define EASE_IMAGE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE_ACTOR, EaseImageActor))
#define EASE_IMAGE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE_ACTOR, EaseImageActorClass))
#define EASE_IS_IMAGE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE_ACTOR))
#define EASE_IS_IMAGE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE_ACTOR))
#define EASE_IMAGE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE_ACTOR, EaseImageActorClass))

typedef struct _EaseImageActor EaseImageActor;
typedef struct _EaseImageActorClass EaseImageActorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;
typedef struct _Block8Data Block8Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	void (*cairo_render_small) (EaseElement* self, cairo_t* context, GError** error);
	void (*cairo_free_cache) (EaseElement* self);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
	float (*get_minimum_width) (EaseElement* self);
	float (*get_minimum_height) (EaseElement* self);
};

struct _EaseMediaElement {
	EaseElement parent_instance;
	EaseMediaElementPrivate * priv;
};

struct _EaseMediaElementClass {
	EaseElementClass parent_class;
};

struct _EaseImageElement {
	EaseMediaElement parent_instance;
	EaseImageElementPrivate * priv;
};

struct _EaseImageElementClass {
	EaseMediaElementClass parent_class;
};

struct _EaseImageElementPrivate {
	GdkPixbuf* small_cache_l;
};

struct _Block8Data {
	int _ref_count_;
	EaseImageElement * self;
	GtkFileChooserButton* file_b;
};


static gpointer ease_image_element_parent_class = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_media_element_get_type (void) G_GNUC_CONST;
GType ease_image_element_get_type (void) G_GNUC_CONST;
#define EASE_IMAGE_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementPrivate))
enum  {
	EASE_IMAGE_ELEMENT_DUMMY_PROPERTY
};
#define EASE_IMAGE_ELEMENT_UI_FILE_PATH "inspector-element-image.ui"
#define EASE_IMAGE_ELEMENT_CACHE_SIZE 100
EaseImageElement* ease_image_element_new (void);
EaseImageElement* ease_image_element_construct (GType object_type);
EaseMediaElement* ease_media_element_construct (GType object_type);
void ease_element_signals (EaseElement* self);
static void ease_image_element_real_signals (EaseElement* base);
static void _lambda22_ (EaseImageElement* self);
static void __lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
EaseImageElement* ease_image_element_new_from_json (JsonObject* obj);
EaseImageElement* ease_image_element_construct_from_json (GType object_type, JsonObject* obj);
EaseMediaElement* ease_media_element_construct_from_json (GType object_type, JsonObject* obj);
static EaseActor* ease_image_element_real_actor (EaseElement* base, EaseActorContext c);
EaseImageActor* ease_image_actor_new (EaseImageElement* e, EaseActorContext c);
EaseImageActor* ease_image_actor_construct (GType object_type, EaseImageElement* e, EaseActorContext c);
GType ease_image_actor_get_type (void) G_GNUC_CONST;
static void ease_image_element_real_cairo_free_cache (EaseElement* base);
static void ease_image_element_set_small_cache (EaseImageElement* self, GdkPixbuf* value);
static GtkWidget* ease_image_element_real_inspector_widget (EaseElement* base);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
const char* ease_media_element_get_source_filename (EaseMediaElement* self);
static void _lambda24_ (GtkFileChooserButton* button, Block8Data* _data8_);
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
void ease_undo_action_add (EaseUndoAction* self, GObject* obj, const char* prop);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_element_get_parent (EaseElement* self);
GType ease_document_get_type (void) G_GNUC_CONST;
EaseDocument* ease_slide_get_parent (EaseSlide* self);
char* ease_document_add_media_file (EaseDocument* self, const char* file, GError** error);
void ease_media_element_set_filename (EaseMediaElement* self, const char* value);
void ease_media_element_set_source_filename (EaseMediaElement* self, const char* value);
void ease_error_dialog (const char* title, const char* message);
static void __lambda24__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
static void _lambda25_ (GObject* obj, GParamSpec* spec, Block8Data* _data8_);
static void __lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static char* ease_image_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
float ease_element_get_width (EaseElement* self);
float ease_element_get_height (EaseElement* self);
char* ease_html_exporter_get_basename (EaseHTMLExporter* self);
const char* ease_media_element_get_filename (EaseMediaElement* self);
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path);
const char* ease_document_get_path (EaseDocument* self);
static void ease_image_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error);
static void ease_image_element_real_cairo_render_small (EaseElement* base, cairo_t* context, GError** error);
static GdkPixbuf* ease_image_element_get_small_cache (EaseImageElement* self);
static void ease_image_element_finalize (GObject* obj);
static void ease_image_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_image_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Create a new element.
 */
#line 44 "ease-image-element.vala"
EaseImageElement* ease_image_element_construct (GType object_type) {
#line 295 "ease-image-element.c"
	EaseImageElement * self;
#line 44 "ease-image-element.vala"
	self = (EaseImageElement*) ease_media_element_construct (object_type);
#line 46 "ease-image-element.vala"
	ease_element_signals ((EaseElement*) self);
#line 301 "ease-image-element.c"
	return self;
}


#line 44 "ease-image-element.vala"
EaseImageElement* ease_image_element_new (void) {
#line 44 "ease-image-element.vala"
	return ease_image_element_construct (EASE_TYPE_IMAGE_ELEMENT);
#line 310 "ease-image-element.c"
}


#line 52 "ease-image-element.vala"
static void _lambda22_ (EaseImageElement* self) {
#line 316 "ease-image-element.c"
	GdkPixbuf* _tmp0_;
#line 52 "ease-image-element.vala"
	self->priv->small_cache_l = (_tmp0_ = NULL, _g_object_unref0 (self->priv->small_cache_l), _tmp0_);
#line 320 "ease-image-element.c"
}


#line 52 "ease-image-element.vala"
static void __lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 326 "ease-image-element.c"
	_lambda22_ (self);
}


#line 49 "ease-image-element.vala"
static void ease_image_element_real_signals (EaseElement* base) {
#line 333 "ease-image-element.c"
	EaseImageElement * self;
	self = (EaseImageElement*) base;
#line 51 "ease-image-element.vala"
	EASE_ELEMENT_CLASS (ease_image_element_parent_class)->signals ((EaseElement*) EASE_MEDIA_ELEMENT (self));
#line 52 "ease-image-element.vala"
	g_signal_connect_object ((GObject*) self, "notify::filename", (GCallback) __lambda22__g_object_notify, self, 0);
#line 340 "ease-image-element.c"
}


#line 55 "ease-image-element.vala"
EaseImageElement* ease_image_element_construct_from_json (GType object_type, JsonObject* obj) {
#line 346 "ease-image-element.c"
	EaseImageElement * self;
#line 55 "ease-image-element.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 57 "ease-image-element.vala"
	self = (EaseImageElement*) ease_media_element_construct_from_json (object_type, obj);
#line 352 "ease-image-element.c"
	return self;
}


#line 55 "ease-image-element.vala"
EaseImageElement* ease_image_element_new_from_json (JsonObject* obj) {
#line 55 "ease-image-element.vala"
	return ease_image_element_construct_from_json (EASE_TYPE_IMAGE_ELEMENT, obj);
#line 361 "ease-image-element.c"
}


#line 60 "ease-image-element.vala"
static EaseActor* ease_image_element_real_actor (EaseElement* base, EaseActorContext c) {
#line 367 "ease-image-element.c"
	EaseImageElement * self;
	EaseActor* result = NULL;
	self = (EaseImageElement*) base;
	result = (EaseActor*) g_object_ref_sink (ease_image_actor_new (self, c));
#line 62 "ease-image-element.vala"
	return result;
#line 374 "ease-image-element.c"
}


#line 65 "ease-image-element.vala"
static void ease_image_element_real_cairo_free_cache (EaseElement* base) {
#line 380 "ease-image-element.c"
	EaseImageElement * self;
	self = (EaseImageElement*) base;
#line 67 "ease-image-element.vala"
	ease_image_element_set_small_cache (self, NULL);
#line 385 "ease-image-element.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 87 "ease-image-element.vala"
static void _lambda24_ (GtkFileChooserButton* button, Block8Data* _data8_) {
#line 396 "ease-image-element.c"
	EaseImageElement * self;
	EaseUndoAction* action;
	GError * _inner_error_ = NULL;
	self = _data8_->self;
#line 87 "ease-image-element.vala"
	g_return_if_fail (button != NULL);
#line 89 "ease-image-element.vala"
	action = ease_undo_action_new ((GObject*) self, "filename");
#line 90 "ease-image-element.vala"
	ease_undo_action_add (action, (GObject*) self, "source-filename");
#line 407 "ease-image-element.c"
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
#line 93 "ease-image-element.vala"
		_tmp2_ = (_tmp1_ = ease_document_add_media_file (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self)), _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _data8_->file_b), &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 416 "ease-image-element.c"
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
#line 93 "ease-image-element.vala"
		ease_media_element_set_filename ((EaseMediaElement*) self, _tmp3_ = _tmp2_);
#line 422 "ease-image-element.c"
		_g_free0 (_tmp3_);
#line 94 "ease-image-element.vala"
		ease_media_element_set_source_filename ((EaseMediaElement*) self, _tmp4_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _data8_->file_b));
#line 426 "ease-image-element.c"
		_g_free0 (_tmp4_);
#line 95 "ease-image-element.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 430 "ease-image-element.c"
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 99 "ease-image-element.vala"
			ease_error_dialog (_ ("Error Inserting Image"), e->message);
#line 441 "ease-image-element.c"
			_g_error_free0 (e);
		}
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (action);
}


#line 87 "ease-image-element.vala"
static void __lambda24__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
#line 458 "ease-image-element.c"
	_lambda24_ (_sender, self);
}


#line 103 "ease-image-element.vala"
static void _lambda25_ (GObject* obj, GParamSpec* spec, Block8Data* _data8_) {
#line 465 "ease-image-element.c"
	EaseImageElement * self;
	self = _data8_->self;
#line 103 "ease-image-element.vala"
	g_return_if_fail (obj != NULL);
#line 103 "ease-image-element.vala"
	g_return_if_fail (spec != NULL);
#line 104 "ease-image-element.vala"
	gtk_file_chooser_set_filename ((GtkFileChooser*) _data8_->file_b, ease_media_element_get_source_filename ((EaseMediaElement*) self));
#line 474 "ease-image-element.c"
}


#line 103 "ease-image-element.vala"
static void __lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 480 "ease-image-element.c"
	_lambda25_ (_sender, pspec, self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_g_object_unref0 (_data8_->file_b);
		g_slice_free (Block8Data, _data8_);
	}
}


#line 70 "ease-image-element.vala"
static GtkWidget* ease_image_element_real_inspector_widget (EaseElement* base) {
#line 502 "ease-image-element.c"
	EaseImageElement * self;
	GtkWidget* result = NULL;
	Block8Data* _data8_;
	GtkBuilder* builder;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (EaseImageElement*) base;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
#line 72 "ease-image-element.vala"
	builder = gtk_builder_new ();
#line 516 "ease-image-element.c"
	{
		char* _tmp0_;
		char* _tmp1_;
#line 75 "ease-image-element.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_IMAGE_ELEMENT_UI_FILE_PATH, NULL)), &_inner_error_);
#line 522 "ease-image-element.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 78 "ease-image-element.vala"
			g_error ("ease-image-element.vala:78: Error loading UI: %s", e->message);
#line 538 "ease-image-element.c"
			_g_error_free0 (e);
		}
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		block8_data_unref (_data8_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 81 "ease-image-element.vala"
	gtk_builder_connect_signals (builder, self);
#line 552 "ease-image-element.c"
	_data8_->file_b = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "file-button"), GTK_IS_FILE_CHOOSER_BUTTON (_tmp2_) ? ((GtkFileChooserButton*) _tmp2_) : NULL));
#line 85 "ease-image-element.vala"
	gtk_file_chooser_set_filename ((GtkFileChooser*) _data8_->file_b, ease_media_element_get_source_filename ((EaseMediaElement*) self));
#line 87 "ease-image-element.vala"
	g_signal_connect_data (_data8_->file_b, "file-set", (GCallback) __lambda24__gtk_file_chooser_button_file_set, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 103 "ease-image-element.vala"
	g_signal_connect_data ((GObject*) self, "notify::source-filename", (GCallback) __lambda25__g_object_notify, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 560 "ease-image-element.c"
	result = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "root"), GTK_IS_WIDGET (_tmp3_) ? ((GtkWidget*) _tmp3_) : NULL));
	_g_object_unref0 (builder);
	block8_data_unref (_data8_);
#line 108 "ease-image-element.vala"
	return result;
#line 566 "ease-image-element.c"
	_g_object_unref0 (builder);
	block8_data_unref (_data8_);
}


#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 574 "ease-image-element.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 583 "ease-image-element.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 591 "ease-image-element.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 602 "ease-image-element.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 617 "ease-image-element.c"
	}
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 628 "ease-image-element.c"
			_g_error_free0 (e);
		}
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 111 "ease-image-element.vala"
static char* ease_image_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter) {
#line 643 "ease-image-element.c"
	EaseImageElement * self;
	char* result = NULL;
	char* html;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	char* _tmp17_;
	char* _tmp18_;
	char* _tmp19_;
	char* _tmp20_;
	char* _tmp21_;
	char* _tmp22_;
	char* _tmp23_;
	char* _tmp24_;
	self = (EaseImageElement*) base;
#line 111 "ease-image-element.vala"
	g_return_val_if_fail (exporter != NULL, NULL);
#line 114 "ease-image-element.vala"
	html = g_strdup ("<img class=\"image element\" ");
#line 117 "ease-image-element.vala"
	html = (_tmp0_ = g_strconcat (html, "style=\"", NULL), _g_free0 (html), _tmp0_);
#line 118 "ease-image-element.vala"
	html = (_tmp4_ = g_strconcat (html, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat ("left:", _tmp1_ = g_strdup_printf ("%g", ease_element_get_x ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp4_);
#line 681 "ease-image-element.c"
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
#line 119 "ease-image-element.vala"
	html = (_tmp8_ = g_strconcat (html, _tmp7_ = g_strconcat (_tmp6_ = g_strconcat (" top:", _tmp5_ = g_strdup_printf ("%g", ease_element_get_y ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp8_);
#line 687 "ease-image-element.c"
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
#line 120 "ease-image-element.vala"
	html = (_tmp12_ = g_strconcat (html, _tmp11_ = g_strconcat (_tmp10_ = g_strconcat (" width:", _tmp9_ = g_strdup_printf ("%g", ease_element_get_width ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp12_);
#line 693 "ease-image-element.c"
	_g_free0 (_tmp11_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp9_);
#line 121 "ease-image-element.vala"
	html = (_tmp16_ = g_strconcat (html, _tmp15_ = g_strconcat (_tmp14_ = g_strconcat (" height:", _tmp13_ = g_strdup_printf ("%g", ease_element_get_height ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp16_);
#line 699 "ease-image-element.c"
	_g_free0 (_tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp13_);
#line 122 "ease-image-element.vala"
	html = (_tmp17_ = g_strconcat (html, " position: absolute;\" ", NULL), _g_free0 (html), _tmp17_);
#line 125 "ease-image-element.vala"
	html = (_tmp24_ = g_strconcat (html, _tmp23_ = g_strconcat (_tmp22_ = g_strconcat ("src=\"", _tmp21_ = string_replace (_tmp20_ = g_strconcat (_tmp19_ = g_strconcat (_tmp18_ = ease_html_exporter_get_basename (exporter), " ", NULL), ease_media_element_get_filename ((EaseMediaElement*) self), NULL), " ", "%20"), NULL), "\" alt=\"Image\" />", NULL), NULL), _g_free0 (html), _tmp24_);
#line 707 "ease-image-element.c"
	_g_free0 (_tmp23_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp18_);
#line 130 "ease-image-element.vala"
	ease_html_exporter_copy_file (exporter, ease_media_element_get_filename ((EaseMediaElement*) self), ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))));
#line 716 "ease-image-element.c"
	result = html;
#line 132 "ease-image-element.vala"
	return result;
#line 720 "ease-image-element.c"
}


/**
 * Renders an image Element with Cairo.
 */
#line 138 "ease-image-element.vala"
static void ease_image_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error) {
#line 729 "ease-image-element.c"
	EaseImageElement * self;
	char* filename;
	GdkPixbuf* pixbuf;
	GError * _inner_error_ = NULL;
	self = (EaseImageElement*) base;
#line 138 "ease-image-element.vala"
	g_return_if_fail (context != NULL);
#line 140 "ease-image-element.vala"
	filename = g_build_path ("/", ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))), ease_media_element_get_filename ((EaseMediaElement*) self), NULL);
#line 143 "ease-image-element.vala"
	pixbuf = gdk_pixbuf_new_from_file_at_scale (filename, (gint) ease_element_get_width ((EaseElement*) self), (gint) ease_element_get_height ((EaseElement*) self), FALSE, &_inner_error_);
#line 741 "ease-image-element.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filename);
		return;
	}
#line 148 "ease-image-element.vala"
	gdk_cairo_set_source_pixbuf (context, pixbuf, (double) 0, (double) 0);
#line 149 "ease-image-element.vala"
	cairo_rectangle (context, (double) 0, (double) 0, (double) ease_element_get_width ((EaseElement*) self), (double) ease_element_get_height ((EaseElement*) self));
#line 150 "ease-image-element.vala"
	cairo_fill (context);
#line 753 "ease-image-element.c"
	_g_object_unref0 (pixbuf);
	_g_free0 (filename);
}


#line 153 "ease-image-element.vala"
static void ease_image_element_real_cairo_render_small (EaseElement* base, cairo_t* context, GError** error) {
#line 761 "ease-image-element.c"
	EaseImageElement * self;
	GdkPixbuf* scaled;
	self = (EaseImageElement*) base;
#line 153 "ease-image-element.vala"
	g_return_if_fail (context != NULL);
#line 155 "ease-image-element.vala"
	scaled = gdk_pixbuf_scale_simple (ease_image_element_get_small_cache (self), (gint) ease_element_get_width ((EaseElement*) self), (gint) ease_element_get_height ((EaseElement*) self), GDK_INTERP_NEAREST);
#line 157 "ease-image-element.vala"
	gdk_cairo_set_source_pixbuf (context, scaled, (double) 0, (double) 0);
#line 158 "ease-image-element.vala"
	cairo_rectangle (context, (double) 0, (double) 0, (double) ease_element_get_width ((EaseElement*) self), (double) ease_element_get_height ((EaseElement*) self));
#line 159 "ease-image-element.vala"
	cairo_scale (context, (double) 40, (double) 40);
#line 160 "ease-image-element.vala"
	cairo_fill (context);
#line 777 "ease-image-element.c"
	_g_object_unref0 (scaled);
}


static GdkPixbuf* ease_image_element_get_small_cache (EaseImageElement* self) {
	GdkPixbuf* result;
	char* filename;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "ease-image-element.vala"
	if (self->priv->small_cache_l != NULL) {
#line 791 "ease-image-element.c"
		result = self->priv->small_cache_l;
#line 31 "ease-image-element.vala"
		return result;
#line 795 "ease-image-element.c"
	}
#line 32 "ease-image-element.vala"
	filename = g_build_path ("/", ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))), ease_media_element_get_filename ((EaseMediaElement*) self), NULL);
#line 33 "ease-image-element.vala"
	_tmp0_ = gdk_pixbuf_new_from_file_at_size (filename, EASE_IMAGE_ELEMENT_CACHE_SIZE, EASE_IMAGE_ELEMENT_CACHE_SIZE, &_inner_error_);
#line 801 "ease-image-element.c"
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = self->priv->small_cache_l = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->small_cache_l), _tmp1_);
	_g_free0 (filename);
#line 33 "ease-image-element.vala"
	return result;
#line 812 "ease-image-element.c"
	_g_free0 (filename);
}


static void ease_image_element_set_small_cache (EaseImageElement* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
#line 37 "ease-image-element.vala"
	self->priv->small_cache_l = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->small_cache_l), _tmp0_);
#line 822 "ease-image-element.c"
}


static void ease_image_element_class_init (EaseImageElementClass * klass) {
	ease_image_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseImageElementPrivate));
	EASE_ELEMENT_CLASS (klass)->signals = ease_image_element_real_signals;
	EASE_ELEMENT_CLASS (klass)->actor = ease_image_element_real_actor;
	EASE_ELEMENT_CLASS (klass)->cairo_free_cache = ease_image_element_real_cairo_free_cache;
	EASE_ELEMENT_CLASS (klass)->inspector_widget = ease_image_element_real_inspector_widget;
	EASE_ELEMENT_CLASS (klass)->html_render = ease_image_element_real_html_render;
	EASE_ELEMENT_CLASS (klass)->cairo_render = ease_image_element_real_cairo_render;
	EASE_ELEMENT_CLASS (klass)->cairo_render_small = ease_image_element_real_cairo_render_small;
	G_OBJECT_CLASS (klass)->get_property = ease_image_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_image_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_image_element_finalize;
}


static void ease_image_element_instance_init (EaseImageElement * self) {
	self->priv = EASE_IMAGE_ELEMENT_GET_PRIVATE (self);
}


static void ease_image_element_finalize (GObject* obj) {
	EaseImageElement * self;
	self = EASE_IMAGE_ELEMENT (obj);
	_g_object_unref0 (self->priv->small_cache_l);
	G_OBJECT_CLASS (ease_image_element_parent_class)->finalize (obj);
}


/**
 * A {@link MediaElement} subclass for displaying an image. Linked with
 * {@link ImageActor}.
 */
GType ease_image_element_get_type (void) {
	static volatile gsize ease_image_element_type_id__volatile = 0;
	if (g_once_init_enter (&ease_image_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseImageElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_image_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseImageElement), 0, (GInstanceInitFunc) ease_image_element_instance_init, NULL };
		GType ease_image_element_type_id;
		ease_image_element_type_id = g_type_register_static (EASE_TYPE_MEDIA_ELEMENT, "EaseImageElement", &g_define_type_info, 0);
		g_once_init_leave (&ease_image_element_type_id__volatile, ease_image_element_type_id);
	}
	return ease_image_element_type_id__volatile;
}


static void ease_image_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseImageElement * self;
	self = EASE_IMAGE_ELEMENT (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_image_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseImageElement * self;
	self = EASE_IMAGE_ELEMENT (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




