/* ease-handle.c generated by valac, the Vala compiler
 * generated from ease-handle.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <ease-core.h>
#include <float.h>
#include <math.h>
#include <cairo.h>


#define EASE_TYPE_HANDLE (ease_handle_get_type ())
#define EASE_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HANDLE, EaseHandle))
#define EASE_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HANDLE, EaseHandleClass))
#define EASE_IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HANDLE))
#define EASE_IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HANDLE))
#define EASE_HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HANDLE, EaseHandleClass))

typedef struct _EaseHandle EaseHandle;
typedef struct _EaseHandleClass EaseHandleClass;
typedef struct _EaseHandlePrivate EaseHandlePrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _EaseHandle {
	ClutterCairoTexture parent_instance;
	EaseHandlePrivate * priv;
};

struct _EaseHandleClass {
	ClutterCairoTextureClass parent_class;
};

struct _EaseHandlePrivate {
	EaseHandlePosition position;
	gboolean flipped;
};


static gpointer ease_handle_parent_class = NULL;

GType ease_handle_get_type (void) G_GNUC_CONST;
#define EASE_HANDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_HANDLE, EaseHandlePrivate))
enum  {
	EASE_HANDLE_DUMMY_PROPERTY
};
#define EASE_HANDLE_SIZE 35
static void ease_handle_redraw (EaseHandle* self);
EaseHandle* ease_handle_new (EaseHandlePosition pos);
EaseHandle* ease_handle_construct (GType object_type, EaseHandlePosition pos);
void ease_handle_drag (EaseHandle* self, float change_x, float change_y, EaseActor* target, gboolean prop);
void ease_handle_drag_from_center (EaseHandle* self, float change_x, float change_y, EaseActor* target, gboolean prop);
void ease_handle_reposition (EaseHandle* self, ClutterActor* selection);
void ease_handle_flip (EaseHandle* self, gboolean f);
static void ease_handle_finalize (GObject* obj);



#line 45 "ease-handle.vala"
EaseHandle* ease_handle_construct (GType object_type, EaseHandlePosition pos) {
#line 79 "ease-handle.c"
	EaseHandle * self;
	guint _tmp0_;
	guint _tmp1_;
	self = g_object_newv (object_type, 0, NULL);
#line 48 "ease-handle.vala"
	clutter_actor_set_width ((ClutterActor*) self, (clutter_actor_set_height ((ClutterActor*) self, (float) (g_object_set ((ClutterCairoTexture*) self, "surface-width", (g_object_set ((ClutterCairoTexture*) self, "surface-height", (guint) EASE_HANDLE_SIZE, NULL), (g_object_get ((ClutterCairoTexture*) self, "surface-height", &_tmp0_, NULL), _tmp0_)), NULL), (g_object_get ((ClutterCairoTexture*) self, "surface-width", &_tmp1_, NULL), _tmp1_))), clutter_actor_get_height ((ClutterActor*) self)));
#line 51 "ease-handle.vala"
	ease_handle_redraw (self);
#line 54 "ease-handle.vala"
	self->priv->position = pos;
#line 57 "ease-handle.vala"
	clutter_actor_set_anchor_point ((ClutterActor*) self, (float) (EASE_HANDLE_SIZE / 2), (float) (EASE_HANDLE_SIZE / 2));
#line 60 "ease-handle.vala"
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
#line 94 "ease-handle.c"
	return self;
}


#line 45 "ease-handle.vala"
EaseHandle* ease_handle_new (EaseHandlePosition pos) {
#line 45 "ease-handle.vala"
	return ease_handle_construct (EASE_TYPE_HANDLE, pos);
#line 103 "ease-handle.c"
}


#line 72 "ease-handle.vala"
void ease_handle_drag (EaseHandle* self, float change_x, float change_y, EaseActor* target, gboolean prop) {
#line 72 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 72 "ease-handle.vala"
	g_return_if_fail (target != NULL);
#line 74 "ease-handle.vala"
	switch (self->priv->position) {
#line 115 "ease-handle.c"
		case EASE_HANDLE_POSITION_TOP_LEFT:
		{
#line 77 "ease-handle.vala"
			ease_actor_translate (target, change_x, change_y);
#line 78 "ease-handle.vala"
			ease_actor_resize (target, -change_x, -change_y, prop);
#line 79 "ease-handle.vala"
			break;
#line 124 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP_RIGHT:
		{
#line 82 "ease-handle.vala"
			ease_actor_translate (target, (float) 0, change_y);
#line 83 "ease-handle.vala"
			ease_actor_resize (target, change_x, -change_y, prop);
#line 84 "ease-handle.vala"
			break;
#line 134 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP:
		{
#line 87 "ease-handle.vala"
			ease_actor_translate (target, (float) 0, change_y);
#line 88 "ease-handle.vala"
			ease_actor_resize (target, (float) 0, -change_y, FALSE);
#line 89 "ease-handle.vala"
			break;
#line 144 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM:
		{
#line 92 "ease-handle.vala"
			ease_actor_resize (target, (float) 0, change_y, FALSE);
#line 93 "ease-handle.vala"
			break;
#line 152 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_LEFT:
		{
#line 96 "ease-handle.vala"
			ease_actor_translate (target, change_x, (float) 0);
#line 97 "ease-handle.vala"
			ease_actor_resize (target, -change_x, (float) 0, FALSE);
#line 98 "ease-handle.vala"
			break;
#line 162 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_RIGHT:
		{
#line 101 "ease-handle.vala"
			ease_actor_resize (target, change_x, (float) 0, FALSE);
#line 102 "ease-handle.vala"
			break;
#line 170 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_LEFT:
		{
#line 105 "ease-handle.vala"
			ease_actor_translate (target, change_x, (float) 0);
#line 106 "ease-handle.vala"
			ease_actor_resize (target, -change_x, change_y, prop);
#line 107 "ease-handle.vala"
			break;
#line 180 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_RIGHT:
		{
#line 110 "ease-handle.vala"
			ease_actor_resize (target, change_x, change_y, prop);
#line 111 "ease-handle.vala"
			break;
#line 188 "ease-handle.c"
		}
	}
}


#line 124 "ease-handle.vala"
void ease_handle_drag_from_center (EaseHandle* self, float change_x, float change_y, EaseActor* target, gboolean prop) {
#line 124 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 124 "ease-handle.vala"
	g_return_if_fail (target != NULL);
#line 127 "ease-handle.vala"
	switch (self->priv->position) {
#line 202 "ease-handle.c"
		case EASE_HANDLE_POSITION_TOP_LEFT:
		{
#line 130 "ease-handle.vala"
			ease_actor_translate (target, change_x, change_y);
#line 131 "ease-handle.vala"
			ease_actor_resize (target, (-change_x) * 2, (-change_y) * 2, FALSE);
#line 132 "ease-handle.vala"
			break;
#line 211 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP_RIGHT:
		{
#line 135 "ease-handle.vala"
			ease_actor_translate (target, -change_x, change_y);
#line 136 "ease-handle.vala"
			ease_actor_resize (target, change_x * 2, (-change_y) * 2, prop);
#line 137 "ease-handle.vala"
			break;
#line 221 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP:
		{
#line 140 "ease-handle.vala"
			ease_actor_translate (target, (float) 0, change_y);
#line 141 "ease-handle.vala"
			ease_actor_resize (target, (float) 0, (-change_y) * 2, FALSE);
#line 142 "ease-handle.vala"
			break;
#line 231 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM:
		{
#line 145 "ease-handle.vala"
			ease_actor_translate (target, (float) 0, -change_y);
#line 146 "ease-handle.vala"
			ease_actor_resize (target, (float) 0, change_y * 2, FALSE);
#line 147 "ease-handle.vala"
			break;
#line 241 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_LEFT:
		{
#line 150 "ease-handle.vala"
			ease_actor_translate (target, change_x, (float) 0);
#line 151 "ease-handle.vala"
			ease_actor_resize (target, (-change_x) * 2, (float) 0, FALSE);
#line 152 "ease-handle.vala"
			break;
#line 251 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_RIGHT:
		{
#line 155 "ease-handle.vala"
			ease_actor_translate (target, -change_x, (float) 0);
#line 156 "ease-handle.vala"
			ease_actor_resize (target, change_x * 2, (float) 0, FALSE);
#line 157 "ease-handle.vala"
			break;
#line 261 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_LEFT:
		{
#line 160 "ease-handle.vala"
			ease_actor_translate (target, change_x, -change_y);
#line 161 "ease-handle.vala"
			ease_actor_resize (target, (-change_x) * 2, change_y * 2, prop);
#line 162 "ease-handle.vala"
			break;
#line 271 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_RIGHT:
		{
#line 165 "ease-handle.vala"
			ease_actor_translate (target, -change_x, -change_y);
#line 166 "ease-handle.vala"
			ease_actor_resize (target, change_x * 2, change_y * 2, prop);
#line 167 "ease-handle.vala"
			break;
#line 281 "ease-handle.c"
		}
	}
}


#line 177 "ease-handle.vala"
void ease_handle_reposition (EaseHandle* self, ClutterActor* selection) {
#line 177 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 177 "ease-handle.vala"
	g_return_if_fail (selection != NULL);
#line 179 "ease-handle.vala"
	switch (self->priv->position) {
#line 295 "ease-handle.c"
		case EASE_HANDLE_POSITION_TOP_LEFT:
		{
#line 182 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection));
#line 183 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection));
#line 184 "ease-handle.vala"
			break;
#line 304 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP_RIGHT:
		{
#line 187 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + clutter_actor_get_width (selection));
#line 188 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection));
#line 189 "ease-handle.vala"
			break;
#line 314 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_TOP:
		{
#line 192 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + (clutter_actor_get_width (selection) / 2));
#line 193 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection));
#line 194 "ease-handle.vala"
			break;
#line 324 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_LEFT:
		{
#line 197 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection));
#line 198 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + (clutter_actor_get_height (selection) / 2));
#line 199 "ease-handle.vala"
			break;
#line 334 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_RIGHT:
		{
#line 202 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + clutter_actor_get_width (selection));
#line 203 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + (clutter_actor_get_height (selection) / 2));
#line 204 "ease-handle.vala"
			break;
#line 344 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_LEFT:
		{
#line 207 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection));
#line 208 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + clutter_actor_get_height (selection));
#line 209 "ease-handle.vala"
			break;
#line 354 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM_RIGHT:
		{
#line 212 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + clutter_actor_get_width (selection));
#line 213 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + clutter_actor_get_height (selection));
#line 214 "ease-handle.vala"
			break;
#line 364 "ease-handle.c"
		}
		case EASE_HANDLE_POSITION_BOTTOM:
		{
#line 217 "ease-handle.vala"
			clutter_actor_set_x ((ClutterActor*) self, clutter_actor_get_x (selection) + (clutter_actor_get_width (selection) / 2));
#line 218 "ease-handle.vala"
			clutter_actor_set_y ((ClutterActor*) self, clutter_actor_get_y (selection) + clutter_actor_get_height (selection));
#line 219 "ease-handle.vala"
			break;
#line 374 "ease-handle.c"
		}
	}
}


#line 226 "ease-handle.vala"
void ease_handle_flip (EaseHandle* self, gboolean f) {
#line 226 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 228 "ease-handle.vala"
	self->priv->flipped = f;
#line 229 "ease-handle.vala"
	ease_handle_redraw (self);
#line 388 "ease-handle.c"
}


#line 232 "ease-handle.vala"
static void ease_handle_redraw (EaseHandle* self) {
#line 394 "ease-handle.c"
	cairo_t* cr;
#line 232 "ease-handle.vala"
	g_return_if_fail (self != NULL);
#line 235 "ease-handle.vala"
	cr = clutter_cairo_texture_create ((ClutterCairoTexture*) self);
#line 238 "ease-handle.vala"
	cairo_arc (cr, (double) (EASE_HANDLE_SIZE / 2), (double) (EASE_HANDLE_SIZE / 2), (double) (EASE_HANDLE_SIZE / 4), (double) 0, 2 * 3.1415);
#line 241 "ease-handle.vala"
	if (!self->priv->flipped) {
#line 241 "ease-handle.vala"
		cairo_set_source_rgba (cr, (double) 1, (double) 1, (double) 1, (double) 1);
#line 406 "ease-handle.c"
	} else {
#line 242 "ease-handle.vala"
		cairo_set_source_rgba (cr, (double) 0, (double) 0, (double) 0, (double) 1);
#line 410 "ease-handle.c"
	}
#line 243 "ease-handle.vala"
	cairo_fill_preserve (cr);
#line 246 "ease-handle.vala"
	if (!self->priv->flipped) {
#line 246 "ease-handle.vala"
		cairo_set_source_rgba (cr, (double) 0, (double) 0, (double) 0, (double) 1);
#line 418 "ease-handle.c"
	} else {
#line 247 "ease-handle.vala"
		cairo_set_source_rgba (cr, (double) 1, (double) 1, (double) 1, (double) 1);
#line 422 "ease-handle.c"
	}
#line 248 "ease-handle.vala"
	cairo_stroke (cr);
#line 426 "ease-handle.c"
	_cairo_destroy0 (cr);
}


static void ease_handle_class_init (EaseHandleClass * klass) {
	ease_handle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseHandlePrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_handle_finalize;
}


static void ease_handle_instance_init (EaseHandle * self) {
	self->priv = EASE_HANDLE_GET_PRIVATE (self);
	self->priv->flipped = FALSE;
}


static void ease_handle_finalize (GObject* obj) {
	EaseHandle * self;
	self = EASE_HANDLE (obj);
	G_OBJECT_CLASS (ease_handle_parent_class)->finalize (obj);
}


GType ease_handle_get_type (void) {
	static volatile gsize ease_handle_type_id__volatile = 0;
	if (g_once_init_enter (&ease_handle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseHandleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_handle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseHandle), 0, (GInstanceInitFunc) ease_handle_instance_init, NULL };
		GType ease_handle_type_id;
		ease_handle_type_id = g_type_register_static (CLUTTER_TYPE_CAIRO_TEXTURE, "EaseHandle", &g_define_type_info, 0);
		g_once_init_leave (&ease_handle_type_id__volatile, ease_handle_type_id);
	}
	return ease_handle_type_id__volatile;
}




