/* ease-video-element.c generated by valac, the Vala compiler
 * generated from ease-video-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;
typedef struct _EaseMediaElementPrivate EaseMediaElementPrivate;

#define EASE_TYPE_VIDEO_ELEMENT (ease_video_element_get_type ())
#define EASE_VIDEO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElement))
#define EASE_VIDEO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementClass))
#define EASE_IS_VIDEO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_VIDEO_ELEMENT))
#define EASE_IS_VIDEO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_VIDEO_ELEMENT))
#define EASE_VIDEO_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementClass))

typedef struct _EaseVideoElement EaseVideoElement;
typedef struct _EaseVideoElementClass EaseVideoElementClass;
typedef struct _EaseVideoElementPrivate EaseVideoElementPrivate;

#define EASE_TYPE_VIDEO_END_ACTION (ease_video_end_action_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define EASE_TYPE_VIDEO_ACTOR (ease_video_actor_get_type ())
#define EASE_VIDEO_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_VIDEO_ACTOR, EaseVideoActor))
#define EASE_VIDEO_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_VIDEO_ACTOR, EaseVideoActorClass))
#define EASE_IS_VIDEO_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_VIDEO_ACTOR))
#define EASE_IS_VIDEO_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_VIDEO_ACTOR))
#define EASE_VIDEO_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_VIDEO_ACTOR, EaseVideoActorClass))

typedef struct _EaseVideoActor EaseVideoActor;
typedef struct _EaseVideoActorClass EaseVideoActorClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
};

struct _EaseMediaElement {
	EaseElement parent_instance;
	EaseMediaElementPrivate * priv;
};

struct _EaseMediaElementClass {
	EaseElementClass parent_class;
};

struct _EaseVideoElement {
	EaseMediaElement parent_instance;
	EaseVideoElementPrivate * priv;
};

struct _EaseVideoElementClass {
	EaseMediaElementClass parent_class;
};

typedef enum  {
	EASE_VIDEO_END_ACTION_STOP,
	EASE_VIDEO_END_ACTION_LOOP,
	EASE_VIDEO_END_ACTION_CONTINUE
} EaseVideoEndAction;

struct _EaseVideoElementPrivate {
	gboolean silence_undo;
	gboolean _play_auto;
	EaseVideoEndAction _end_action;
	gboolean _mute;
};

struct _Block12Data {
	int _ref_count_;
	EaseVideoElement * self;
	GtkCheckButton* m_button;
	GtkCheckButton* a_button;
};

struct _Block13Data {
	int _ref_count_;
	EaseVideoElement * self;
	GtkComboBox* sender;
};


static gpointer ease_video_element_parent_class = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_media_element_get_type (void) G_GNUC_CONST;
GType ease_video_element_get_type (void) G_GNUC_CONST;
GType ease_video_end_action_get_type (void) G_GNUC_CONST;
#define EASE_VIDEO_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementPrivate))
enum  {
	EASE_VIDEO_ELEMENT_DUMMY_PROPERTY,
	EASE_VIDEO_ELEMENT_PLAY_AUTO,
	EASE_VIDEO_ELEMENT_END_ACTION,
	EASE_VIDEO_ELEMENT_MUTE
};
#define EASE_VIDEO_ELEMENT_UI_FILE "inspector-element-video.ui"
EaseMediaElement* ease_media_element_construct (GType object_type);
void ease_element_signals (EaseElement* self);
EaseVideoElement* ease_video_element_new (void);
EaseVideoElement* ease_video_element_construct (GType object_type);
EaseMediaElement* ease_media_element_construct_from_json (GType object_type, JsonObject* obj);
#define EASE_THEME_VIDEO_PLAY_AUTO "video-play-automatically"
void ease_video_element_set_play_auto (EaseVideoElement* self, gboolean value);
#define EASE_THEME_VIDEO_MUTE "video-mute"
void ease_video_element_set_mute (EaseVideoElement* self, gboolean value);
EaseVideoEndAction ease_video_end_action_from_string (const char* str);
#define EASE_THEME_VIDEO_END_ACTION "video-end-action"
void ease_video_element_set_end_action (EaseVideoElement* self, EaseVideoEndAction value);
EaseVideoElement* ease_video_element_new_from_json (JsonObject* obj);
EaseVideoElement* ease_video_element_construct_from_json (GType object_type, JsonObject* obj);
EaseVideoActor* ease_video_actor_new (EaseVideoElement* e, EaseActorContext c);
EaseVideoActor* ease_video_actor_construct (GType object_type, EaseVideoElement* e, EaseActorContext c);
GType ease_video_actor_get_type (void) G_GNUC_CONST;
static EaseActor* ease_video_element_real_actor (EaseElement* base, EaseActorContext c);
JsonObject* ease_element_to_json (EaseElement* self);
gboolean ease_video_element_get_play_auto (EaseVideoElement* self);
gboolean ease_video_element_get_mute (EaseVideoElement* self);
EaseVideoEndAction ease_video_element_get_end_action (EaseVideoElement* self);
char* ease_video_end_action_to_string (EaseVideoEndAction self);
static JsonObject* ease_video_element_real_to_json (EaseElement* base);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
float ease_element_get_width (EaseElement* self);
const char* ease_html_exporter_get_path (EaseHTMLExporter* self);
const char* ease_media_element_get_filename (EaseMediaElement* self);
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_element_get_parent (EaseElement* self);
GType ease_document_get_type (void) G_GNUC_CONST;
EaseDocument* ease_slide_get_parent (EaseSlide* self);
const char* ease_document_get_path (EaseDocument* self);
static char* ease_video_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
gint ease_slide_get_width (EaseSlide* self);
float ease_element_get_height (EaseElement* self);
gint ease_slide_get_height (EaseSlide* self);
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
void ease_undo_action_add (EaseUndoAction* self, GObject* obj, const char* prop);
void ease_element_set_x (EaseElement* self, float value);
void ease_element_set_y (EaseElement* self, float value);
void ease_element_set_width (EaseElement* self, float value);
void ease_element_set_height (EaseElement* self, float value);
static void _lambda46_ (EaseVideoElement* self);
static void __lambda46__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda48_ (EaseUndoAction* a, Block12Data* _data12_);
static void __lambda48__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
static void _lambda47_ (Block12Data* _data12_);
static void __lambda47__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda50_ (EaseUndoAction* a, Block12Data* _data12_);
static void __lambda50__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
static void _lambda49_ (Block12Data* _data12_);
static void __lambda49__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void ease_video_element_set_combobox (EaseVideoElement* self, GtkComboBox* combo);
static void ease_video_element_on_set_end_action (EaseVideoElement* self, GtkComboBox* sender);
static void _ease_video_element_on_set_end_action_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static GtkWidget* ease_video_element_real_inspector_widget (EaseElement* base);
static void _lambda51_ (EaseUndoAction* a, Block13Data* _data13_);
static void __lambda51__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
GtkListStore* ease_video_end_action_list_store (void);
static void ease_video_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error);
static void ease_video_element_finalize (GObject* obj);
static void ease_video_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_video_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define EASE_THEME_VIDEO_END_STOP "video-end-stop"
#define EASE_THEME_VIDEO_END_LOOP "video-end-loop"
#define EASE_THEME_VIDEO_END_CONTINUE "video-end-continue"
char* ease_video_end_action_description (EaseVideoEndAction self);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 46 "ease-video-element.vala"
EaseVideoElement* ease_video_element_construct (GType object_type) {
#line 334 "ease-video-element.c"
	EaseVideoElement * self;
#line 46 "ease-video-element.vala"
	self = (EaseVideoElement*) ease_media_element_construct (object_type);
#line 48 "ease-video-element.vala"
	ease_element_signals ((EaseElement*) self);
#line 340 "ease-video-element.c"
	return self;
}


#line 46 "ease-video-element.vala"
EaseVideoElement* ease_video_element_new (void) {
#line 46 "ease-video-element.vala"
	return ease_video_element_construct (EASE_TYPE_VIDEO_ELEMENT);
#line 349 "ease-video-element.c"
}


#line 1056 "glib-2.0.vapi"
static gboolean string_to_bool (const char* self) {
#line 355 "ease-video-element.c"
	gboolean result = FALSE;
#line 1056 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1057 "glib-2.0.vapi"
	if (_vala_strcmp0 (self, "true") == 0) {
#line 361 "ease-video-element.c"
		result = TRUE;
#line 1058 "glib-2.0.vapi"
		return result;
#line 365 "ease-video-element.c"
	} else {
		result = FALSE;
#line 1060 "glib-2.0.vapi"
		return result;
#line 370 "ease-video-element.c"
	}
}


#line 51 "ease-video-element.vala"
EaseVideoElement* ease_video_element_construct_from_json (GType object_type, JsonObject* obj) {
#line 377 "ease-video-element.c"
	EaseVideoElement * self;
#line 51 "ease-video-element.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 53 "ease-video-element.vala"
	self = (EaseVideoElement*) ease_media_element_construct_from_json (object_type, obj);
#line 54 "ease-video-element.vala"
	ease_video_element_set_play_auto (self, string_to_bool (json_object_get_string_member (obj, EASE_THEME_VIDEO_PLAY_AUTO)));
#line 55 "ease-video-element.vala"
	ease_video_element_set_mute (self, string_to_bool (json_object_get_string_member (obj, EASE_THEME_VIDEO_MUTE)));
#line 56 "ease-video-element.vala"
	ease_video_element_set_end_action (self, ease_video_end_action_from_string (json_object_get_string_member (obj, EASE_THEME_VIDEO_END_ACTION)));
#line 389 "ease-video-element.c"
	return self;
}


#line 51 "ease-video-element.vala"
EaseVideoElement* ease_video_element_new_from_json (JsonObject* obj) {
#line 51 "ease-video-element.vala"
	return ease_video_element_construct_from_json (EASE_TYPE_VIDEO_ELEMENT, obj);
#line 398 "ease-video-element.c"
}


#line 60 "ease-video-element.vala"
static EaseActor* ease_video_element_real_actor (EaseElement* base, EaseActorContext c) {
#line 404 "ease-video-element.c"
	EaseVideoElement * self;
	EaseActor* result = NULL;
	self = (EaseVideoElement*) base;
	result = (EaseActor*) g_object_ref_sink (ease_video_actor_new (self, c));
#line 62 "ease-video-element.vala"
	return result;
#line 411 "ease-video-element.c"
}


#line 35 "glib-2.0.vapi"
static char* bool_to_string (gboolean self) {
#line 417 "ease-video-element.c"
	char* result = NULL;
#line 36 "glib-2.0.vapi"
	if (self) {
#line 421 "ease-video-element.c"
		result = g_strdup ("true");
#line 37 "glib-2.0.vapi"
		return result;
#line 425 "ease-video-element.c"
	} else {
		result = g_strdup ("false");
#line 39 "glib-2.0.vapi"
		return result;
#line 430 "ease-video-element.c"
	}
}


#line 65 "ease-video-element.vala"
static JsonObject* ease_video_element_real_to_json (EaseElement* base) {
#line 437 "ease-video-element.c"
	EaseVideoElement * self;
	JsonObject* result = NULL;
	JsonObject* obj;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	self = (EaseVideoElement*) base;
#line 67 "ease-video-element.vala"
	obj = EASE_ELEMENT_CLASS (ease_video_element_parent_class)->to_json ((EaseElement*) EASE_MEDIA_ELEMENT (self));
#line 68 "ease-video-element.vala"
	json_object_set_string_member (obj, EASE_THEME_VIDEO_PLAY_AUTO, _tmp0_ = bool_to_string (self->priv->_play_auto));
#line 449 "ease-video-element.c"
	_g_free0 (_tmp0_);
#line 69 "ease-video-element.vala"
	json_object_set_string_member (obj, EASE_THEME_VIDEO_MUTE, _tmp1_ = bool_to_string (self->priv->_mute));
#line 453 "ease-video-element.c"
	_g_free0 (_tmp1_);
#line 70 "ease-video-element.vala"
	json_object_set_string_member (obj, EASE_THEME_VIDEO_END_ACTION, _tmp2_ = ease_video_end_action_to_string (self->priv->_end_action));
#line 457 "ease-video-element.c"
	_g_free0 (_tmp2_);
	result = obj;
#line 71 "ease-video-element.vala"
	return result;
#line 462 "ease-video-element.c"
}


#line 74 "ease-video-element.vala"
static char* ease_video_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter) {
#line 468 "ease-video-element.c"
	EaseVideoElement * self;
	char* result = NULL;
	char* html;
	char* _tmp0_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp9_;
	char* _tmp13_;
	char* _tmp12_;
	char* _tmp11_;
	char* _tmp10_;
	char* _tmp17_;
	char* _tmp16_;
	char* _tmp15_;
	char* _tmp14_;
	char* _tmp25_;
	char* _tmp24_;
	char* _tmp23_;
	char* _tmp22_;
	char* _tmp21_;
	char* _tmp20_;
	char* _tmp19_;
	char* _tmp18_;
	self = (EaseVideoElement*) base;
#line 74 "ease-video-element.vala"
	g_return_val_if_fail (exporter != NULL, NULL);
#line 77 "ease-video-element.vala"
	html = g_strdup ("<video class=\"video element\" ");
#line 80 "ease-video-element.vala"
	html = (_tmp0_ = g_strconcat (html, "style=\"", NULL), _g_free0 (html), _tmp0_);
#line 81 "ease-video-element.vala"
	html = (_tmp4_ = g_strconcat (html, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat ("left:", _tmp1_ = g_strdup_printf ("%g", ease_element_get_x ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp4_);
#line 507 "ease-video-element.c"
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
#line 82 "ease-video-element.vala"
	html = (_tmp8_ = g_strconcat (html, _tmp7_ = g_strconcat (_tmp6_ = g_strconcat (" top:", _tmp5_ = g_strdup_printf ("%g", ease_element_get_y ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp8_);
#line 513 "ease-video-element.c"
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
#line 83 "ease-video-element.vala"
	html = (_tmp9_ = g_strconcat (html, " position: absolute;\" ", NULL), _g_free0 (html), _tmp9_);
#line 86 "ease-video-element.vala"
	html = (_tmp13_ = g_strconcat (html, _tmp12_ = g_strconcat (_tmp11_ = g_strconcat (" width=\"", _tmp10_ = g_strdup_printf ("%g", ease_element_get_width ((EaseElement*) self)), NULL), "\" ", NULL), NULL), _g_free0 (html), _tmp13_);
#line 521 "ease-video-element.c"
	_g_free0 (_tmp12_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp10_);
#line 87 "ease-video-element.vala"
	html = (_tmp17_ = g_strconcat (html, _tmp16_ = g_strconcat (_tmp15_ = g_strconcat (" height=\"", _tmp14_ = g_strdup_printf ("%g", ease_element_get_width ((EaseElement*) self)), NULL), "\" ", NULL), NULL), _g_free0 (html), _tmp17_);
#line 527 "ease-video-element.c"
	_g_free0 (_tmp16_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp14_);
#line 90 "ease-video-element.vala"
	html = (_tmp25_ = g_strconcat (html, _tmp24_ = g_strconcat (_tmp23_ = g_strconcat (_tmp22_ = g_strconcat (_tmp21_ = g_strconcat (_tmp20_ = g_strconcat (_tmp19_ = g_strconcat (_tmp18_ = g_strconcat ("src=\"", ease_html_exporter_get_path (exporter), NULL), " ", NULL), ease_media_element_get_filename ((EaseMediaElement*) self), NULL), "\" ", NULL), "controls=\"yes\">", NULL), _ ("Your browser does not support the video tag"), NULL), "</video>", NULL), NULL), _g_free0 (html), _tmp25_);
#line 533 "ease-video-element.c"
	_g_free0 (_tmp24_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp18_);
#line 97 "ease-video-element.vala"
	ease_html_exporter_copy_file (exporter, ease_media_element_get_filename ((EaseMediaElement*) self), ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))));
#line 543 "ease-video-element.c"
	result = html;
#line 99 "ease-video-element.vala"
	return result;
#line 547 "ease-video-element.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 119 "ease-video-element.vala"
static void _lambda46_ (EaseVideoElement* self) {
#line 558 "ease-video-element.c"
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	EaseUndoAction* action;
#line 121 "ease-video-element.vala"
	if (ease_element_get_width ((EaseElement*) self) == ease_slide_get_width (ease_element_get_parent ((EaseElement*) self))) {
#line 121 "ease-video-element.vala"
		_tmp2_ = ease_element_get_height ((EaseElement*) self) == ease_slide_get_height (ease_element_get_parent ((EaseElement*) self));
#line 567 "ease-video-element.c"
	} else {
#line 121 "ease-video-element.vala"
		_tmp2_ = FALSE;
#line 571 "ease-video-element.c"
	}
#line 121 "ease-video-element.vala"
	if (_tmp2_) {
#line 122 "ease-video-element.vala"
		_tmp1_ = ease_element_get_x ((EaseElement*) self) == 0;
#line 577 "ease-video-element.c"
	} else {
#line 121 "ease-video-element.vala"
		_tmp1_ = FALSE;
#line 581 "ease-video-element.c"
	}
#line 121 "ease-video-element.vala"
	if (_tmp1_) {
#line 122 "ease-video-element.vala"
		_tmp0_ = ease_element_get_y ((EaseElement*) self) == 0;
#line 587 "ease-video-element.c"
	} else {
#line 121 "ease-video-element.vala"
		_tmp0_ = FALSE;
#line 591 "ease-video-element.c"
	}
#line 121 "ease-video-element.vala"
	if (_tmp0_) {
#line 122 "ease-video-element.vala"
		return;
#line 597 "ease-video-element.c"
	}
#line 125 "ease-video-element.vala"
	action = ease_undo_action_new ((GObject*) self, "x");
#line 126 "ease-video-element.vala"
	ease_undo_action_add (action, (GObject*) self, "y");
#line 127 "ease-video-element.vala"
	ease_undo_action_add (action, (GObject*) self, "width");
#line 128 "ease-video-element.vala"
	ease_undo_action_add (action, (GObject*) self, "height");
#line 131 "ease-video-element.vala"
	ease_element_set_x ((EaseElement*) self, (float) 0);
#line 132 "ease-video-element.vala"
	ease_element_set_y ((EaseElement*) self, (float) 0);
#line 133 "ease-video-element.vala"
	ease_element_set_width ((EaseElement*) self, (float) ease_slide_get_width (ease_element_get_parent ((EaseElement*) self)));
#line 134 "ease-video-element.vala"
	ease_element_set_height ((EaseElement*) self, (float) ease_slide_get_height (ease_element_get_parent ((EaseElement*) self)));
#line 137 "ease-video-element.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 617 "ease-video-element.c"
	_g_object_unref0 (action);
}


#line 119 "ease-video-element.vala"
static void __lambda46__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 624 "ease-video-element.c"
	_lambda46_ (self);
}


#line 148 "ease-video-element.vala"
static void _lambda48_ (EaseUndoAction* a, Block12Data* _data12_) {
#line 631 "ease-video-element.c"
	EaseVideoElement * self;
	self = _data12_->self;
#line 148 "ease-video-element.vala"
	g_return_if_fail (a != NULL);
#line 148 "ease-video-element.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data12_->m_button, self->priv->_mute);
#line 638 "ease-video-element.c"
}


#line 148 "ease-video-element.vala"
static void __lambda48__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 644 "ease-video-element.c"
	_lambda48_ (sender, self);
}


#line 144 "ease-video-element.vala"
static void _lambda47_ (Block12Data* _data12_) {
#line 651 "ease-video-element.c"
	EaseVideoElement * self;
	EaseUndoAction* action;
	self = _data12_->self;
#line 145 "ease-video-element.vala"
	ease_video_element_set_mute (self, gtk_toggle_button_get_active ((GtkToggleButton*) _data12_->m_button));
#line 147 "ease-video-element.vala"
	action = ease_undo_action_new ((GObject*) self, "mute");
#line 148 "ease-video-element.vala"
	g_signal_connect_data ((EaseUndoItem*) action, "applied", (GCallback) __lambda48__ease_undo_item_applied, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 149 "ease-video-element.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 663 "ease-video-element.c"
	_g_object_unref0 (action);
}


#line 144 "ease-video-element.vala"
static void __lambda47__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 670 "ease-video-element.c"
	_lambda47_ (self);
}


#line 156 "ease-video-element.vala"
static void _lambda50_ (EaseUndoAction* a, Block12Data* _data12_) {
#line 677 "ease-video-element.c"
	EaseVideoElement * self;
	self = _data12_->self;
#line 156 "ease-video-element.vala"
	g_return_if_fail (a != NULL);
#line 157 "ease-video-element.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data12_->a_button, self->priv->_play_auto);
#line 684 "ease-video-element.c"
}


#line 156 "ease-video-element.vala"
static void __lambda50__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 690 "ease-video-element.c"
	_lambda50_ (sender, self);
}


#line 152 "ease-video-element.vala"
static void _lambda49_ (Block12Data* _data12_) {
#line 697 "ease-video-element.c"
	EaseVideoElement * self;
	EaseUndoAction* action;
	self = _data12_->self;
#line 153 "ease-video-element.vala"
	ease_video_element_set_play_auto (self, gtk_toggle_button_get_active ((GtkToggleButton*) _data12_->a_button));
#line 155 "ease-video-element.vala"
	action = ease_undo_action_new ((GObject*) self, "play-auto");
#line 156 "ease-video-element.vala"
	g_signal_connect_data ((EaseUndoItem*) action, "applied", (GCallback) __lambda50__ease_undo_item_applied, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 159 "ease-video-element.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 709 "ease-video-element.c"
	_g_object_unref0 (action);
}


#line 152 "ease-video-element.vala"
static void __lambda49__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 716 "ease-video-element.c"
	_lambda49_ (self);
}


#line 173 "ease-video-element.vala"
static void _ease_video_element_on_set_end_action_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 723 "ease-video-element.c"
	ease_video_element_on_set_end_action (self, _sender);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->self);
		_g_object_unref0 (_data12_->a_button);
		_g_object_unref0 (_data12_->m_button);
		g_slice_free (Block12Data, _data12_);
	}
}


#line 105 "ease-video-element.vala"
static GtkWidget* ease_video_element_real_inspector_widget (EaseElement* base) {
#line 746 "ease-video-element.c"
	EaseVideoElement * self;
	GtkWidget* result = NULL;
	GError * _inner_error_;
	Block12Data* _data12_;
	GtkBuilder* builder;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GtkComboBox* combo;
	GObject* _tmp6_;
	self = (EaseVideoElement*) base;
	_inner_error_ = NULL;
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
#line 107 "ease-video-element.vala"
	builder = gtk_builder_new ();
#line 765 "ease-video-element.c"
	{
		char* _tmp1_;
		char* _tmp0_;
#line 110 "ease-video-element.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_VIDEO_ELEMENT_UI_FILE, NULL)), &_inner_error_);
#line 771 "ease-video-element.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 113 "ease-video-element.vala"
			g_error ("ease-video-element.vala:113: Error loading UI: %s", e->message);
#line 787 "ease-video-element.c"
			_g_error_free0 (e);
		}
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		block12_data_unref (_data12_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_data12_->m_button = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "mute"), GTK_IS_CHECK_BUTTON (_tmp2_) ? ((GtkCheckButton*) _tmp2_) : NULL));
	_data12_->a_button = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "play-auto"), GTK_IS_CHECK_BUTTON (_tmp3_) ? ((GtkCheckButton*) _tmp3_) : NULL));
#line 119 "ease-video-element.vala"
	g_signal_connect_object ((_tmp4_ = gtk_builder_get_object (builder, "fill-slide"), GTK_IS_BUTTON (_tmp4_) ? ((GtkButton*) _tmp4_) : NULL), "clicked", (GCallback) __lambda46__gtk_button_clicked, self, 0);
#line 141 "ease-video-element.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data12_->m_button, self->priv->_mute);
#line 142 "ease-video-element.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _data12_->a_button, self->priv->_play_auto);
#line 144 "ease-video-element.vala"
	g_signal_connect_data ((GtkToggleButton*) _data12_->m_button, "toggled", (GCallback) __lambda47__gtk_toggle_button_toggled, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 152 "ease-video-element.vala"
	g_signal_connect_data ((GtkToggleButton*) _data12_->a_button, "toggled", (GCallback) __lambda49__gtk_toggle_button_toggled, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 163 "ease-video-element.vala"
	combo = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (builder, "end-action"), GTK_IS_COMBO_BOX (_tmp5_) ? ((GtkComboBox*) _tmp5_) : NULL));
#line 164 "ease-video-element.vala"
	ease_video_element_set_combobox (self, combo);
#line 167 "ease-video-element.vala"
	g_signal_connect_object (combo, "changed", (GCallback) _ease_video_element_on_set_end_action_gtk_combo_box_changed, self, 0);
#line 817 "ease-video-element.c"
	result = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (builder, "root"), GTK_IS_WIDGET (_tmp6_) ? ((GtkWidget*) _tmp6_) : NULL));
	_g_object_unref0 (combo);
	_g_object_unref0 (builder);
	block12_data_unref (_data12_);
#line 170 "ease-video-element.vala"
	return result;
#line 824 "ease-video-element.c"
	_g_object_unref0 (combo);
	_g_object_unref0 (builder);
	block12_data_unref (_data12_);
}


#line 177 "ease-video-element.vala"
static void _lambda51_ (EaseUndoAction* a, Block13Data* _data13_) {
#line 833 "ease-video-element.c"
	EaseVideoElement * self;
	self = _data13_->self;
#line 177 "ease-video-element.vala"
	g_return_if_fail (a != NULL);
#line 178 "ease-video-element.vala"
	self->priv->silence_undo = TRUE;
#line 179 "ease-video-element.vala"
	ease_video_element_set_combobox (self, _data13_->sender);
#line 180 "ease-video-element.vala"
	self->priv->silence_undo = FALSE;
#line 844 "ease-video-element.c"
}


#line 177 "ease-video-element.vala"
static void __lambda51__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 850 "ease-video-element.c"
	_lambda51_ (sender, self);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->sender);
		g_slice_free (Block13Data, _data13_);
	}
}


#line 173 "ease-video-element.vala"
static void ease_video_element_on_set_end_action (EaseVideoElement* self, GtkComboBox* sender) {
#line 872 "ease-video-element.c"
	Block13Data* _data13_;
	EaseUndoAction* undo_action;
	EaseVideoEndAction action = 0;
	GtkTreeIter itr = {0};
#line 173 "ease-video-element.vala"
	g_return_if_fail (self != NULL);
#line 173 "ease-video-element.vala"
	g_return_if_fail (sender != NULL);
#line 881 "ease-video-element.c"
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_data13_->sender = _g_object_ref0 (sender);
#line 175 "ease-video-element.vala"
	undo_action = ease_undo_action_new ((GObject*) self, "end-action");
#line 177 "ease-video-element.vala"
	g_signal_connect_data ((EaseUndoItem*) undo_action, "applied", (GCallback) __lambda51__ease_undo_item_applied, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
#line 185 "ease-video-element.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (_data13_->sender), &itr);
#line 892 "ease-video-element.c"
	{
		gint i;
#line 186 "ease-video-element.vala"
		i = 0;
#line 897 "ease-video-element.c"
		{
			gboolean _tmp0_;
#line 186 "ease-video-element.vala"
			_tmp0_ = TRUE;
#line 186 "ease-video-element.vala"
			while (TRUE) {
#line 186 "ease-video-element.vala"
				if (!_tmp0_) {
#line 186 "ease-video-element.vala"
					i++;
#line 908 "ease-video-element.c"
				}
#line 186 "ease-video-element.vala"
				_tmp0_ = FALSE;
#line 186 "ease-video-element.vala"
				if (!(i < gtk_combo_box_get_active (_data13_->sender))) {
#line 186 "ease-video-element.vala"
					break;
#line 916 "ease-video-element.c"
				}
#line 188 "ease-video-element.vala"
				gtk_tree_model_iter_next (gtk_combo_box_get_model (_data13_->sender), &itr);
#line 920 "ease-video-element.c"
			}
		}
	}
#line 190 "ease-video-element.vala"
	gtk_tree_model_get (gtk_combo_box_get_model (_data13_->sender), &itr, 1, &action, -1);
#line 191 "ease-video-element.vala"
	ease_video_element_set_end_action (self, action);
#line 192 "ease-video-element.vala"
	if (!self->priv->silence_undo) {
#line 192 "ease-video-element.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) undo_action);
#line 932 "ease-video-element.c"
	}
	_g_object_unref0 (undo_action);
	block13_data_unref (_data13_);
}


#line 195 "ease-video-element.vala"
static void ease_video_element_set_combobox (EaseVideoElement* self, GtkComboBox* combo) {
#line 941 "ease-video-element.c"
	GtkListStore* _tmp0_;
	EaseVideoEndAction action = 0;
	GtkTreeIter itr = {0};
#line 195 "ease-video-element.vala"
	g_return_if_fail (self != NULL);
#line 195 "ease-video-element.vala"
	g_return_if_fail (combo != NULL);
#line 197 "ease-video-element.vala"
	gtk_combo_box_set_model (combo, (GtkTreeModel*) (_tmp0_ = ease_video_end_action_list_store ()));
#line 951 "ease-video-element.c"
	_g_object_unref0 (_tmp0_);
#line 200 "ease-video-element.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (combo), &itr);
#line 955 "ease-video-element.c"
	{
		gboolean _tmp1_;
#line 201 "ease-video-element.vala"
		_tmp1_ = TRUE;
#line 201 "ease-video-element.vala"
		while (TRUE) {
#line 201 "ease-video-element.vala"
			if (!_tmp1_) {
#line 209 "ease-video-element.vala"
				if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (combo), &itr)) {
#line 209 "ease-video-element.vala"
					break;
#line 968 "ease-video-element.c"
				}
			}
#line 201 "ease-video-element.vala"
			_tmp1_ = FALSE;
#line 203 "ease-video-element.vala"
			gtk_tree_model_get (gtk_combo_box_get_model (combo), &itr, 1, &action, -1);
#line 204 "ease-video-element.vala"
			if (action == self->priv->_end_action) {
#line 206 "ease-video-element.vala"
				gtk_combo_box_set_active_iter (combo, &itr);
#line 207 "ease-video-element.vala"
				break;
#line 981 "ease-video-element.c"
			}
		}
	}
}


#line 212 "ease-video-element.vala"
static void ease_video_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error) {
#line 990 "ease-video-element.c"
	EaseVideoElement * self;
	self = (EaseVideoElement*) base;
#line 212 "ease-video-element.vala"
	g_return_if_fail (context != NULL);
#line 995 "ease-video-element.c"
}


gboolean ease_video_element_get_play_auto (EaseVideoElement* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_play_auto;
#line 31 "ease-video-element.vala"
	return result;
#line 1005 "ease-video-element.c"
}


void ease_video_element_set_play_auto (EaseVideoElement* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_play_auto = value;
	g_object_notify ((GObject *) self, "play-auto");
}


EaseVideoEndAction ease_video_element_get_end_action (EaseVideoElement* self) {
	EaseVideoEndAction result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_end_action;
#line 38 "ease-video-element.vala"
	return result;
#line 1022 "ease-video-element.c"
}


void ease_video_element_set_end_action (EaseVideoElement* self, EaseVideoEndAction value) {
	g_return_if_fail (self != NULL);
	self->priv->_end_action = value;
	g_object_notify ((GObject *) self, "end-action");
}


gboolean ease_video_element_get_mute (EaseVideoElement* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mute;
#line 44 "ease-video-element.vala"
	return result;
#line 1039 "ease-video-element.c"
}


void ease_video_element_set_mute (EaseVideoElement* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_mute = value;
	g_object_notify ((GObject *) self, "mute");
}


static void ease_video_element_class_init (EaseVideoElementClass * klass) {
	ease_video_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseVideoElementPrivate));
	EASE_ELEMENT_CLASS (klass)->actor = ease_video_element_real_actor;
	EASE_ELEMENT_CLASS (klass)->to_json = ease_video_element_real_to_json;
	EASE_ELEMENT_CLASS (klass)->html_render = ease_video_element_real_html_render;
	EASE_ELEMENT_CLASS (klass)->inspector_widget = ease_video_element_real_inspector_widget;
	EASE_ELEMENT_CLASS (klass)->cairo_render = ease_video_element_real_cairo_render;
	G_OBJECT_CLASS (klass)->get_property = ease_video_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_video_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_video_element_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_VIDEO_ELEMENT_PLAY_AUTO, g_param_spec_boolean ("play-auto", "play-auto", "play-auto", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_VIDEO_ELEMENT_END_ACTION, g_param_spec_enum ("end-action", "end-action", "end-action", EASE_TYPE_VIDEO_END_ACTION, EASE_VIDEO_END_ACTION_STOP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_VIDEO_ELEMENT_MUTE, g_param_spec_boolean ("mute", "mute", "mute", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ease_video_element_instance_init (EaseVideoElement * self) {
	char* _tmp0_;
	self->priv = EASE_VIDEO_ELEMENT_GET_PRIVATE (self);
	self->priv->_play_auto = FALSE;
	_g_free0 (_tmp0_);
	self->priv->_end_action = EASE_VIDEO_END_ACTION_STOP;
	self->priv->_mute = FALSE;
}


static void ease_video_element_finalize (GObject* obj) {
	EaseVideoElement * self;
	self = EASE_VIDEO_ELEMENT (obj);
	G_OBJECT_CLASS (ease_video_element_parent_class)->finalize (obj);
}


GType ease_video_element_get_type (void) {
	static volatile gsize ease_video_element_type_id__volatile = 0;
	if (g_once_init_enter (&ease_video_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseVideoElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_video_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseVideoElement), 0, (GInstanceInitFunc) ease_video_element_instance_init, NULL };
		GType ease_video_element_type_id;
		ease_video_element_type_id = g_type_register_static (EASE_TYPE_MEDIA_ELEMENT, "EaseVideoElement", &g_define_type_info, 0);
		g_once_init_leave (&ease_video_element_type_id__volatile, ease_video_element_type_id);
	}
	return ease_video_element_type_id__volatile;
}


static void ease_video_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseVideoElement * self;
	self = EASE_VIDEO_ELEMENT (object);
	switch (property_id) {
		case EASE_VIDEO_ELEMENT_PLAY_AUTO:
		g_value_set_boolean (value, ease_video_element_get_play_auto (self));
		break;
		case EASE_VIDEO_ELEMENT_END_ACTION:
		g_value_set_enum (value, ease_video_element_get_end_action (self));
		break;
		case EASE_VIDEO_ELEMENT_MUTE:
		g_value_set_boolean (value, ease_video_element_get_mute (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_video_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseVideoElement * self;
	self = EASE_VIDEO_ELEMENT (object);
	switch (property_id) {
		case EASE_VIDEO_ELEMENT_PLAY_AUTO:
		ease_video_element_set_play_auto (self, g_value_get_boolean (value));
		break;
		case EASE_VIDEO_ELEMENT_END_ACTION:
		ease_video_element_set_end_action (self, g_value_get_enum (value));
		break;
		case EASE_VIDEO_ELEMENT_MUTE:
		ease_video_element_set_mute (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 227 "ease-video-element.vala"
char* ease_video_end_action_to_string (EaseVideoEndAction self) {
#line 1138 "ease-video-element.c"
	char* result = NULL;
#line 229 "ease-video-element.vala"
	switch (self) {
#line 1142 "ease-video-element.c"
		case EASE_VIDEO_END_ACTION_STOP:
		{
			result = g_strdup (EASE_THEME_VIDEO_END_STOP);
#line 231 "ease-video-element.vala"
			return result;
#line 1148 "ease-video-element.c"
		}
		case EASE_VIDEO_END_ACTION_LOOP:
		{
			result = g_strdup (EASE_THEME_VIDEO_END_LOOP);
#line 232 "ease-video-element.vala"
			return result;
#line 1155 "ease-video-element.c"
		}
		case EASE_VIDEO_END_ACTION_CONTINUE:
		{
			result = g_strdup (EASE_THEME_VIDEO_END_CONTINUE);
#line 233 "ease-video-element.vala"
			return result;
#line 1162 "ease-video-element.c"
		}
	}
	result = g_strdup ("undefined");
#line 235 "ease-video-element.vala"
	return result;
#line 1168 "ease-video-element.c"
}


#line 241 "ease-video-element.vala"
EaseVideoEndAction ease_video_end_action_from_string (const char* str) {
#line 1174 "ease-video-element.c"
	EaseVideoEndAction result = 0;
	GQuark _tmp1_;
	const char* _tmp0_;
#line 241 "ease-video-element.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 1180 "ease-video-element.c"
	_tmp0_ = str;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (EASE_THEME_VIDEO_END_STOP))
	switch (0) {
		default:
		{
			result = EASE_VIDEO_END_ACTION_STOP;
#line 245 "ease-video-element.vala"
			return result;
#line 1190 "ease-video-element.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_VIDEO_END_LOOP))
	switch (0) {
		default:
		{
			result = EASE_VIDEO_END_ACTION_LOOP;
#line 246 "ease-video-element.vala"
			return result;
#line 1199 "ease-video-element.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_VIDEO_END_CONTINUE))
	switch (0) {
		default:
		{
			result = EASE_VIDEO_END_ACTION_CONTINUE;
#line 247 "ease-video-element.vala"
			return result;
#line 1208 "ease-video-element.c"
		}
	}
#line 250 "ease-video-element.vala"
	g_warning ("ease-video-element.vala:250: %s is not a video aend action", str);
#line 1213 "ease-video-element.c"
	result = EASE_VIDEO_END_ACTION_STOP;
#line 251 "ease-video-element.vala"
	return result;
#line 1217 "ease-video-element.c"
}


#line 257 "ease-video-element.vala"
char* ease_video_end_action_description (EaseVideoEndAction self) {
#line 1223 "ease-video-element.c"
	char* result = NULL;
#line 259 "ease-video-element.vala"
	switch (self) {
#line 1227 "ease-video-element.c"
		case EASE_VIDEO_END_ACTION_STOP:
		{
			result = g_strdup (_ ("Stop playback"));
#line 261 "ease-video-element.vala"
			return result;
#line 1233 "ease-video-element.c"
		}
		case EASE_VIDEO_END_ACTION_LOOP:
		{
			result = g_strdup (_ ("Loop"));
#line 262 "ease-video-element.vala"
			return result;
#line 1240 "ease-video-element.c"
		}
		case EASE_VIDEO_END_ACTION_CONTINUE:
		{
			result = g_strdup (_ ("Continue to next slide"));
#line 263 "ease-video-element.vala"
			return result;
#line 1247 "ease-video-element.c"
		}
	}
	result = g_strdup ("undefined");
#line 265 "ease-video-element.vala"
	return result;
#line 1253 "ease-video-element.c"
}


#line 272 "ease-video-element.vala"
GtkListStore* ease_video_end_action_list_store (void) {
#line 1259 "ease-video-element.c"
	GtkListStore* result = NULL;
	GtkListStore* store;
	GtkTreeIter itr = {0};
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
#line 274 "ease-video-element.vala"
	store = gtk_list_store_new (2, G_TYPE_STRING, EASE_TYPE_VIDEO_END_ACTION, NULL);
#line 278 "ease-video-element.vala"
	gtk_list_store_append (store, &itr);
#line 279 "ease-video-element.vala"
	gtk_list_store_set (store, &itr, 0, _tmp0_ = ease_video_end_action_description (EASE_VIDEO_END_ACTION_STOP), 1, EASE_VIDEO_END_ACTION_STOP, -1);
#line 1272 "ease-video-element.c"
	_g_free0 (_tmp0_);
#line 280 "ease-video-element.vala"
	gtk_list_store_append (store, &itr);
#line 281 "ease-video-element.vala"
	gtk_list_store_set (store, &itr, 0, _tmp1_ = ease_video_end_action_description (EASE_VIDEO_END_ACTION_LOOP), 1, EASE_VIDEO_END_ACTION_LOOP, -1);
#line 1278 "ease-video-element.c"
	_g_free0 (_tmp1_);
#line 282 "ease-video-element.vala"
	gtk_list_store_append (store, &itr);
#line 283 "ease-video-element.vala"
	gtk_list_store_set (store, &itr, 0, _tmp2_ = ease_video_end_action_description (EASE_VIDEO_END_ACTION_CONTINUE), 1, EASE_VIDEO_END_ACTION_CONTINUE, -1);
#line 1284 "ease-video-element.c"
	_g_free0 (_tmp2_);
	result = store;
#line 285 "ease-video-element.vala"
	return result;
#line 1289 "ease-video-element.c"
}


GType ease_video_end_action_get_type (void) {
	static volatile gsize ease_video_end_action_type_id__volatile = 0;
	if (g_once_init_enter (&ease_video_end_action_type_id__volatile)) {
		static const GEnumValue values[] = {{EASE_VIDEO_END_ACTION_STOP, "EASE_VIDEO_END_ACTION_STOP", "stop"}, {EASE_VIDEO_END_ACTION_LOOP, "EASE_VIDEO_END_ACTION_LOOP", "loop"}, {EASE_VIDEO_END_ACTION_CONTINUE, "EASE_VIDEO_END_ACTION_CONTINUE", "continue"}, {0, NULL, NULL}};
		GType ease_video_end_action_type_id;
		ease_video_end_action_type_id = g_enum_register_static ("EaseVideoEndAction", values);
		g_once_init_leave (&ease_video_end_action_type_id__volatile, ease_video_end_action_type_id);
	}
	return ease_video_end_action_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




