/* ease-background-widget.c generated by valac, the Vala compiler
 * generated from ease-background-widget.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define EASE_TYPE_BACKGROUND_WIDGET (ease_background_widget_get_type ())
#define EASE_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidget))
#define EASE_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))
#define EASE_IS_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_IS_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_BACKGROUND_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))

typedef struct _EaseBackgroundWidget EaseBackgroundWidget;
typedef struct _EaseBackgroundWidgetClass EaseBackgroundWidgetClass;
typedef struct _EaseBackgroundWidgetPrivate EaseBackgroundWidgetPrivate;

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define EASE_TYPE_BACKGROUND_TYPE (ease_background_type_get_type ())

#define EASE_TYPE_GRADIENT_TYPE (ease_gradient_type_get_type ())

#define EASE_TYPE_GRADIENT (ease_gradient_get_type ())
#define EASE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_GRADIENT, EaseGradient))
#define EASE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_GRADIENT, EaseGradientClass))
#define EASE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_GRADIENT))
#define EASE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_GRADIENT))
#define EASE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_GRADIENT, EaseGradientClass))

typedef struct _EaseGradient EaseGradient;
typedef struct _EaseGradientClass EaseGradientClass;

#define EASE_TYPE_IMAGE_FILL_TYPE (ease_image_fill_type_get_type ())

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;

#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;
typedef struct _Block4Data Block4Data;

struct _EaseBackgroundWidget {
	GtkAlignment parent_instance;
	EaseBackgroundWidgetPrivate * priv;
};

struct _EaseBackgroundWidgetClass {
	GtkAlignmentClass parent_class;
};

struct _EaseBackgroundWidgetPrivate {
	GtkComboBox* background_type;
	GtkListStore* store;
	GtkComboBox* gradient_type;
	GtkVBox* box_color;
	GtkVBox* box_gradient;
	GtkVBox* box_image;
	GtkComboBox* image_fill;
	GtkHScale* grad_angle;
	GtkColorButton* bg_color;
	GtkColorButton* grad_color1;
	GtkColorButton* grad_color2;
	GtkFileChooserButton* bg_image;
	EaseBackground* background;
	gboolean silence_undo;
	EaseDocument* document;
	EaseSlide* slide;
	EaseElement* element;
};

typedef enum  {
	EASE_BACKGROUND_TYPE_COLOR,
	EASE_BACKGROUND_TYPE_GRADIENT,
	EASE_BACKGROUND_TYPE_IMAGE
} EaseBackgroundType;

typedef enum  {
	EASE_GRADIENT_TYPE_LINEAR,
	EASE_GRADIENT_TYPE_LINEAR_MIRRORED,
	EASE_GRADIENT_TYPE_RADIAL
} EaseGradientType;

typedef enum  {
	EASE_IMAGE_FILL_TYPE_STRETCH,
	EASE_IMAGE_FILL_TYPE_ASPECT,
	EASE_IMAGE_FILL_TYPE_ORIGINAL
} EaseImageFillType;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef void (*EaseDialogFileChooserDialogExtension) (GtkFileChooserDialog* d, void* user_data);
struct _Block4Data {
	int _ref_count_;
	EaseBackgroundWidget * self;
	GtkColorButton* sender;
};


static gpointer ease_background_widget_parent_class = NULL;

GType ease_background_widget_get_type (void) G_GNUC_CONST;
GType ease_background_get_type (void) G_GNUC_CONST;
GType ease_document_get_type (void) G_GNUC_CONST;
GType ease_slide_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
#define EASE_BACKGROUND_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetPrivate))
enum  {
	EASE_BACKGROUND_WIDGET_DUMMY_PROPERTY
};
#define EASE_BACKGROUND_WIDGET_UI_FILE_PATH "background.ui"
#define EASE_BACKGROUND_WIDGET_BG_DIALOG_TITLE _ ("Select Background Image")
EaseSlide* ease_element_get_parent (EaseElement* self);
EaseDocument* ease_slide_get_parent (EaseSlide* self);
static void ease_background_widget_init (EaseBackgroundWidget* self);
EaseBackgroundWidget* ease_background_widget_new (EaseBackground* bg, EaseElement* e);
EaseBackgroundWidget* ease_background_widget_construct (GType object_type, EaseBackground* bg, EaseElement* e);
EaseBackground* ease_slide_get_background (EaseSlide* self);
EaseBackgroundWidget* ease_background_widget_new_for_slide (EaseSlide* s);
EaseBackgroundWidget* ease_background_widget_construct_for_slide (GType object_type, EaseSlide* s);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
GType ease_background_type_get_type (void) G_GNUC_CONST;
static void ease_background_widget_display_bg_ui (EaseBackgroundWidget* self, EaseBackgroundType type);
EaseBackgroundType ease_background_get_background_type (EaseBackground* self);
GtkListStore* ease_gradient_type_list_store (void);
GtkListStore* ease_image_fill_type_list_store (void);
char* ease_background_type_description (EaseBackgroundType self);
GType ease_gradient_type_get_type (void) G_GNUC_CONST;
GType ease_gradient_get_type (void) G_GNUC_CONST;
EaseGradient* ease_background_get_gradient (EaseBackground* self);
EaseGradientType ease_gradient_get_mode (EaseGradient* self);
GType ease_image_fill_type_get_type (void) G_GNUC_CONST;
GType ease_image_get_type (void) G_GNUC_CONST;
EaseImage* ease_background_get_image (EaseBackground* self);
EaseImageFillType ease_image_get_fill (EaseImage* self);
GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
static void ease_background_widget_emit_undo (EaseBackgroundWidget* self, EaseUndoAction* action);
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
const char* ease_image_get_filename (EaseImage* self);
char* ease_dialog_open_ext (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target);
GtkWindow* ease_widget_window (GtkWidget* widg);
static void _lambda27_ (GtkFileChooserDialog* dialog, EaseBackgroundWidget* self);
static void __lambda27__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self);
void ease_image_set_source (EaseImage* self, const char* value);
char* ease_document_add_media_file (EaseDocument* self, const char* file, GError** error);
void ease_image_set_filename (EaseImage* self, const char* value);
EaseUndoItem* ease_undo_item_apply (EaseUndoItem* self);
static void _lambda28_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda28__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_undo_action_add (EaseUndoAction* self, GObject* obj, const char* prop);
void ease_background_set_background_type (EaseBackground* self, EaseBackgroundType value);
void ease_background_widget_on_background_changed (GtkWidget* sender, EaseBackgroundWidget* self);
static void _lambda29_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda29__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_gradient_set_mode (EaseGradient* self, EaseGradientType value);
void ease_background_widget_on_gradient_type_changed (GtkComboBox* sender, EaseBackgroundWidget* self);
static void _lambda30_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda30__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_image_set_fill (EaseImage* self, EaseImageFillType value);
void ease_background_widget_on_image_fill_changed (GtkComboBox* sender, EaseBackgroundWidget* self);
GType ease_color_get_type (void) G_GNUC_CONST;
EaseColor* ease_background_get_color (EaseBackground* self);
EaseUndoAction* ease_color_undo_action (EaseColor* self);
void ease_color_set_gdk (EaseColor* self, GdkColor* value);
EaseColor* ease_gradient_get_end (EaseGradient* self);
void ease_color_get_gdk (EaseColor* self, GdkColor* result);
static void _lambda31_ (Block4Data* _data4_);
static void __lambda31__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
EaseColor* ease_gradient_get_start (EaseGradient* self);
static void _lambda32_ (Block4Data* _data4_);
static void __lambda32__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
static void _lambda33_ (Block4Data* _data4_);
static void __lambda33__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
void ease_background_widget_on_color_set (GtkColorButton* sender, EaseBackgroundWidget* self);
const char* ease_image_get_source (EaseImage* self);
static void _lambda34_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda34__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_background_widget_on_file_set (GtkFileChooserButton* sender, EaseBackgroundWidget* self);
void ease_gradient_flip (EaseGradient* self);
static void _lambda35_ (EaseBackgroundWidget* self);
static void __lambda35__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_background_widget_on_reverse_gradient (GtkWidget* sender, EaseBackgroundWidget* self);
void ease_gradient_set_angle (EaseGradient* self, double value);
static void _lambda36_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda36__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_background_widget_on_set_angle (GtkWidget* sender, EaseBackgroundWidget* self);
EaseColor* ease_color_get_white (void);
void ease_background_set_color (EaseBackground* self, EaseColor* value);
EaseColor* ease_color_get_black (void);
EaseGradient* ease_gradient_new (EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_construct (GType object_type, EaseColor* start_color, EaseColor* end_color);
void ease_background_set_gradient (EaseBackground* self, EaseGradient* value);
double ease_gradient_get_angle (EaseGradient* self);
static void ease_background_widget_finalize (GObject* obj);

extern const EaseBackgroundType EASE_BACKGROUND_TYPE_TYPES[3];


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 47 "ease-background-widget.vala"
EaseBackgroundWidget* ease_background_widget_construct (GType object_type, EaseBackground* bg, EaseElement* e) {
#line 323 "ease-background-widget.c"
	EaseBackgroundWidget * self;
	EaseBackground* _tmp0_;
	EaseDocument* _tmp1_;
	EaseElement* _tmp2_;
#line 47 "ease-background-widget.vala"
	g_return_val_if_fail (bg != NULL, NULL);
#line 47 "ease-background-widget.vala"
	g_return_val_if_fail (e != NULL, NULL);
#line 332 "ease-background-widget.c"
	self = g_object_newv (object_type, 0, NULL);
#line 49 "ease-background-widget.vala"
	self->priv->background = (_tmp0_ = _g_object_ref0 (bg), _g_object_unref0 (self->priv->background), _tmp0_);
#line 50 "ease-background-widget.vala"
	self->priv->document = (_tmp1_ = _g_object_ref0 (ease_slide_get_parent (ease_element_get_parent (e))), _g_object_unref0 (self->priv->document), _tmp1_);
#line 51 "ease-background-widget.vala"
	self->priv->element = (_tmp2_ = _g_object_ref0 (e), _g_object_unref0 (self->priv->element), _tmp2_);
#line 52 "ease-background-widget.vala"
	ease_background_widget_init (self);
#line 342 "ease-background-widget.c"
	return self;
}


#line 47 "ease-background-widget.vala"
EaseBackgroundWidget* ease_background_widget_new (EaseBackground* bg, EaseElement* e) {
#line 47 "ease-background-widget.vala"
	return ease_background_widget_construct (EASE_TYPE_BACKGROUND_WIDGET, bg, e);
#line 351 "ease-background-widget.c"
}


#line 55 "ease-background-widget.vala"
EaseBackgroundWidget* ease_background_widget_construct_for_slide (GType object_type, EaseSlide* s) {
#line 357 "ease-background-widget.c"
	EaseBackgroundWidget * self;
	EaseDocument* _tmp0_;
	EaseBackground* _tmp1_;
	EaseSlide* _tmp2_;
#line 55 "ease-background-widget.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 364 "ease-background-widget.c"
	self = g_object_newv (object_type, 0, NULL);
#line 57 "ease-background-widget.vala"
	self->priv->document = (_tmp0_ = _g_object_ref0 (ease_slide_get_parent (s)), _g_object_unref0 (self->priv->document), _tmp0_);
#line 58 "ease-background-widget.vala"
	self->priv->background = (_tmp1_ = _g_object_ref0 (ease_slide_get_background (s)), _g_object_unref0 (self->priv->background), _tmp1_);
#line 59 "ease-background-widget.vala"
	self->priv->slide = (_tmp2_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->slide), _tmp2_);
#line 60 "ease-background-widget.vala"
	ease_background_widget_init (self);
#line 374 "ease-background-widget.c"
	return self;
}


#line 55 "ease-background-widget.vala"
EaseBackgroundWidget* ease_background_widget_new_for_slide (EaseSlide* s) {
#line 55 "ease-background-widget.vala"
	return ease_background_widget_construct_for_slide (EASE_TYPE_BACKGROUND_WIDGET, s);
#line 383 "ease-background-widget.c"
}


#line 63 "ease-background-widget.vala"
static void ease_background_widget_init (EaseBackgroundWidget* self) {
#line 389 "ease-background-widget.c"
	GError * _inner_error_;
	GtkBuilder* builder;
	GObject* _tmp2_;
	GtkVBox* _tmp4_;
	GObject* _tmp3_;
	GtkVBox* _tmp6_;
	GObject* _tmp5_;
	GtkVBox* _tmp8_;
	GObject* _tmp7_;
	GtkColorButton* _tmp10_;
	GObject* _tmp9_;
	GtkColorButton* _tmp12_;
	GObject* _tmp11_;
	GtkColorButton* _tmp14_;
	GObject* _tmp13_;
	GtkFileChooserButton* _tmp16_;
	GObject* _tmp15_;
	GtkComboBox* _tmp18_;
	GObject* _tmp17_;
	GtkHScale* _tmp20_;
	GObject* _tmp19_;
	GtkComboBox* _tmp22_;
	GObject* _tmp21_;
	GtkListStore* _tmp23_;
	GtkListStore* _tmp24_;
	GtkComboBox* _tmp26_;
	GObject* _tmp25_;
	GtkListStore* _tmp27_;
	GtkTreeIter iter = {0};
	GtkCellRendererText* render;
	GtkTreeIter itr = {0};
	EaseBackgroundType type = 0;
	EaseGradientType grad_type = 0;
	EaseImageFillType img_type = 0;
	GtkFileFilter* filter;
	GtkFileFilter* _tmp32_;
#line 63 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 428 "ease-background-widget.c"
	_inner_error_ = NULL;
#line 66 "ease-background-widget.vala"
	builder = gtk_builder_new ();
#line 432 "ease-background-widget.c"
	{
		char* _tmp1_;
		char* _tmp0_;
#line 69 "ease-background-widget.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_BACKGROUND_WIDGET_UI_FILE_PATH, NULL)), &_inner_error_);
#line 438 "ease-background-widget.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 72 "ease-background-widget.vala"
			g_error ("ease-background-widget.vala:72: Error loading UI: %s", e->message);
#line 454 "ease-background-widget.c"
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 75 "ease-background-widget.vala"
	gtk_container_add ((GtkContainer*) self, (_tmp2_ = gtk_builder_get_object (builder, "root"), GTK_IS_WIDGET (_tmp2_) ? ((GtkWidget*) _tmp2_) : NULL));
#line 76 "ease-background-widget.vala"
	gtk_alignment_set ((GtkAlignment*) self, (float) 0, (float) 1, (float) 0, (float) 0);
#line 79 "ease-background-widget.vala"
	self->priv->box_color = (_tmp4_ = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "vbox-color"), GTK_IS_VBOX (_tmp3_) ? ((GtkVBox*) _tmp3_) : NULL)), _g_object_unref0 (self->priv->box_color), _tmp4_);
#line 80 "ease-background-widget.vala"
	self->priv->box_gradient = (_tmp6_ = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (builder, "vbox-gradient"), GTK_IS_VBOX (_tmp5_) ? ((GtkVBox*) _tmp5_) : NULL)), _g_object_unref0 (self->priv->box_gradient), _tmp6_);
#line 81 "ease-background-widget.vala"
	self->priv->box_image = (_tmp8_ = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (builder, "vbox-image"), GTK_IS_VBOX (_tmp7_) ? ((GtkVBox*) _tmp7_) : NULL)), _g_object_unref0 (self->priv->box_image), _tmp8_);
#line 82 "ease-background-widget.vala"
	self->priv->bg_color = (_tmp10_ = _g_object_ref0 ((_tmp9_ = gtk_builder_get_object (builder, "color-color"), GTK_IS_COLOR_BUTTON (_tmp9_) ? ((GtkColorButton*) _tmp9_) : NULL)), _g_object_unref0 (self->priv->bg_color), _tmp10_);
#line 83 "ease-background-widget.vala"
	self->priv->grad_color1 = (_tmp12_ = _g_object_ref0 ((_tmp11_ = gtk_builder_get_object (builder, "color-startgradient"), GTK_IS_COLOR_BUTTON (_tmp11_) ? ((GtkColorButton*) _tmp11_) : NULL)), _g_object_unref0 (self->priv->grad_color1), _tmp12_);
#line 85 "ease-background-widget.vala"
	self->priv->grad_color2 = (_tmp14_ = _g_object_ref0 ((_tmp13_ = gtk_builder_get_object (builder, "color-endgradient"), GTK_IS_COLOR_BUTTON (_tmp13_) ? ((GtkColorButton*) _tmp13_) : NULL)), _g_object_unref0 (self->priv->grad_color2), _tmp14_);
#line 87 "ease-background-widget.vala"
	self->priv->bg_image = (_tmp16_ = _g_object_ref0 ((_tmp15_ = gtk_builder_get_object (builder, "button-image"), GTK_IS_FILE_CHOOSER_BUTTON (_tmp15_) ? ((GtkFileChooserButton*) _tmp15_) : NULL)), _g_object_unref0 (self->priv->bg_image), _tmp16_);
#line 89 "ease-background-widget.vala"
	self->priv->gradient_type = (_tmp18_ = _g_object_ref0 ((_tmp17_ = gtk_builder_get_object (builder, "combo-gradient"), GTK_IS_COMBO_BOX (_tmp17_) ? ((GtkComboBox*) _tmp17_) : NULL)), _g_object_unref0 (self->priv->gradient_type), _tmp18_);
#line 91 "ease-background-widget.vala"
	self->priv->grad_angle = (_tmp20_ = _g_object_ref0 ((_tmp19_ = gtk_builder_get_object (builder, "hscale-angle"), GTK_IS_HSCALE (_tmp19_) ? ((GtkHScale*) _tmp19_) : NULL)), _g_object_unref0 (self->priv->grad_angle), _tmp20_);
#line 92 "ease-background-widget.vala"
	self->priv->image_fill = (_tmp22_ = _g_object_ref0 ((_tmp21_ = gtk_builder_get_object (builder, "image-fill"), GTK_IS_COMBO_BOX (_tmp21_) ? ((GtkComboBox*) _tmp21_) : NULL)), _g_object_unref0 (self->priv->image_fill), _tmp22_);
#line 95 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 98 "ease-background-widget.vala"
	gtk_combo_box_set_model (self->priv->gradient_type, (GtkTreeModel*) (_tmp23_ = ease_gradient_type_list_store ()));
#line 493 "ease-background-widget.c"
	_g_object_unref0 (_tmp23_);
#line 101 "ease-background-widget.vala"
	gtk_combo_box_set_model (self->priv->image_fill, (GtkTreeModel*) (_tmp24_ = ease_image_fill_type_list_store ()));
#line 497 "ease-background-widget.c"
	_g_object_unref0 (_tmp24_);
#line 104 "ease-background-widget.vala"
	self->priv->background_type = (_tmp26_ = _g_object_ref0 ((_tmp25_ = gtk_builder_get_object (builder, "combobox-style"), GTK_IS_COMBO_BOX (_tmp25_) ? ((GtkComboBox*) _tmp25_) : NULL)), _g_object_unref0 (self->priv->background_type), _tmp26_);
#line 107 "ease-background-widget.vala"
	self->priv->store = (_tmp27_ = gtk_list_store_new (2, G_TYPE_STRING, EASE_TYPE_BACKGROUND_TYPE, NULL), _g_object_unref0 (self->priv->store), _tmp27_);
#line 503 "ease-background-widget.c"
	{
		EaseBackgroundType* b_collection;
		int b_collection_length1;
		int b_it;
#line 109 "ease-background-widget.vala"
		b_collection = EASE_BACKGROUND_TYPE_TYPES;
#line 510 "ease-background-widget.c"
		b_collection_length1 = G_N_ELEMENTS (EASE_BACKGROUND_TYPE_TYPES);
		for (b_it = 0; b_it < G_N_ELEMENTS (EASE_BACKGROUND_TYPE_TYPES); b_it = b_it + 1) {
			EaseBackgroundType b;
			b = b_collection[b_it];
			{
				char* _tmp28_;
#line 111 "ease-background-widget.vala"
				gtk_list_store_append (self->priv->store, &iter);
#line 112 "ease-background-widget.vala"
				gtk_list_store_set (self->priv->store, &iter, 0, _tmp28_ = ease_background_type_description (b), 1, b, -1);
#line 521 "ease-background-widget.c"
				_g_free0 (_tmp28_);
			}
		}
	}
#line 115 "ease-background-widget.vala"
	render = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
#line 117 "ease-background-widget.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->background_type, (GtkCellRenderer*) render, TRUE);
#line 118 "ease-background-widget.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->background_type, (GtkCellRenderer*) render, "text", 0, NULL);
#line 119 "ease-background-widget.vala"
	gtk_combo_box_set_model (self->priv->background_type, (GtkTreeModel*) self->priv->store);
#line 124 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->store, &itr);
#line 536 "ease-background-widget.c"
	{
		gboolean _tmp29_;
#line 125 "ease-background-widget.vala"
		_tmp29_ = TRUE;
#line 125 "ease-background-widget.vala"
		while (TRUE) {
#line 125 "ease-background-widget.vala"
			if (!_tmp29_) {
#line 133 "ease-background-widget.vala"
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->store, &itr)) {
#line 133 "ease-background-widget.vala"
					break;
#line 549 "ease-background-widget.c"
				}
			}
#line 125 "ease-background-widget.vala"
			_tmp29_ = FALSE;
#line 127 "ease-background-widget.vala"
			gtk_tree_model_get ((GtkTreeModel*) self->priv->store, &itr, 1, &type, -1);
#line 128 "ease-background-widget.vala"
			if (type == ease_background_get_background_type (self->priv->background)) {
#line 130 "ease-background-widget.vala"
				gtk_combo_box_set_active_iter (self->priv->background_type, &itr);
#line 131 "ease-background-widget.vala"
				break;
#line 562 "ease-background-widget.c"
			}
		}
	}
#line 137 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->priv->gradient_type), &itr);
#line 568 "ease-background-widget.c"
	{
		gboolean _tmp30_;
#line 138 "ease-background-widget.vala"
		_tmp30_ = TRUE;
#line 138 "ease-background-widget.vala"
		while (TRUE) {
#line 138 "ease-background-widget.vala"
			if (!_tmp30_) {
#line 146 "ease-background-widget.vala"
				if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->priv->gradient_type), &itr)) {
#line 146 "ease-background-widget.vala"
					break;
#line 581 "ease-background-widget.c"
				}
			}
#line 138 "ease-background-widget.vala"
			_tmp30_ = FALSE;
#line 140 "ease-background-widget.vala"
			gtk_tree_model_get (gtk_combo_box_get_model (self->priv->gradient_type), &itr, 1, &grad_type, -1);
#line 141 "ease-background-widget.vala"
			if (grad_type == ease_gradient_get_mode (ease_background_get_gradient (self->priv->background))) {
#line 143 "ease-background-widget.vala"
				gtk_combo_box_set_active_iter (self->priv->gradient_type, &itr);
#line 144 "ease-background-widget.vala"
				break;
#line 594 "ease-background-widget.c"
			}
		}
	}
#line 150 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->priv->image_fill), &itr);
#line 600 "ease-background-widget.c"
	{
		gboolean _tmp31_;
#line 151 "ease-background-widget.vala"
		_tmp31_ = TRUE;
#line 151 "ease-background-widget.vala"
		while (TRUE) {
#line 151 "ease-background-widget.vala"
			if (!_tmp31_) {
#line 159 "ease-background-widget.vala"
				if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->priv->image_fill), &itr)) {
#line 159 "ease-background-widget.vala"
					break;
#line 613 "ease-background-widget.c"
				}
			}
#line 151 "ease-background-widget.vala"
			_tmp31_ = FALSE;
#line 153 "ease-background-widget.vala"
			gtk_tree_model_get (gtk_combo_box_get_model (self->priv->image_fill), &itr, 1, &img_type, -1);
#line 154 "ease-background-widget.vala"
			if (img_type == ease_image_get_fill (ease_background_get_image (self->priv->background))) {
#line 156 "ease-background-widget.vala"
				gtk_combo_box_set_active_iter (self->priv->image_fill, &itr);
#line 157 "ease-background-widget.vala"
				break;
#line 626 "ease-background-widget.c"
			}
		}
	}
#line 162 "ease-background-widget.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 163 "ease-background-widget.vala"
	gtk_file_filter_add_pixbuf_formats (filter);
#line 164 "ease-background-widget.vala"
	gtk_file_filter_set_name (filter, _ ("Images"));
#line 165 "ease-background-widget.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->bg_image, filter);
#line 168 "ease-background-widget.vala"
	filter = (_tmp32_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp32_);
#line 169 "ease-background-widget.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 170 "ease-background-widget.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 171 "ease-background-widget.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->bg_image, filter);
#line 174 "ease-background-widget.vala"
	gtk_builder_connect_signals (builder, self);
#line 648 "ease-background-widget.c"
	_g_object_unref0 (filter);
	_g_object_unref0 (render);
	_g_object_unref0 (builder);
}


#line 177 "ease-background-widget.vala"
static void ease_background_widget_emit_undo (EaseBackgroundWidget* self, EaseUndoAction* action) {
#line 177 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 177 "ease-background-widget.vala"
	g_return_if_fail (action != NULL);
#line 179 "ease-background-widget.vala"
	if (!self->priv->silence_undo) {
#line 181 "ease-background-widget.vala"
		if (self->priv->slide != NULL) {
#line 181 "ease-background-widget.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self->priv->slide, "undo", (EaseUndoItem*) action);
#line 667 "ease-background-widget.c"
		} else {
#line 182 "ease-background-widget.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self->priv->element, "undo", (EaseUndoItem*) action);
#line 671 "ease-background-widget.c"
		}
	}
}


#line 210 "ease-background-widget.vala"
static void _lambda27_ (GtkFileChooserDialog* dialog, EaseBackgroundWidget* self) {
#line 679 "ease-background-widget.c"
	GtkFileFilter* filter;
	GtkFileFilter* _tmp0_;
#line 210 "ease-background-widget.vala"
	g_return_if_fail (dialog != NULL);
#line 212 "ease-background-widget.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 213 "ease-background-widget.vala"
	gtk_file_filter_add_pixbuf_formats (filter);
#line 214 "ease-background-widget.vala"
	gtk_file_filter_set_name (filter, _ ("Images"));
#line 215 "ease-background-widget.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 218 "ease-background-widget.vala"
	filter = (_tmp0_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp0_);
#line 219 "ease-background-widget.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 220 "ease-background-widget.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 221 "ease-background-widget.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 700 "ease-background-widget.c"
	_g_object_unref0 (filter);
}


#line 210 "ease-background-widget.vala"
static void __lambda27__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self) {
#line 707 "ease-background-widget.c"
	_lambda27_ (d, self);
}


#line 245 "ease-background-widget.vala"
static void _lambda28_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 245 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 246 "ease-background-widget.vala"
	self->priv->silence_undo = TRUE;
#line 247 "ease-background-widget.vala"
	gtk_combo_box_set_active (self->priv->background_type, (gint) ease_background_get_background_type (self->priv->background));
#line 248 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 249 "ease-background-widget.vala"
	self->priv->silence_undo = FALSE;
#line 724 "ease-background-widget.c"
}


#line 245 "ease-background-widget.vala"
static void __lambda28__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 730 "ease-background-widget.c"
	_lambda28_ (sender, self);
}


#line 187 "ease-background-widget.vala"
void ease_background_widget_on_background_changed (GtkWidget* sender, EaseBackgroundWidget* self) {
#line 737 "ease-background-widget.c"
	GError * _inner_error_;
	GtkTreeIter itr = {0};
	EaseBackgroundType type = 0;
	EaseUndoAction* action;
	gboolean _tmp1_ = FALSE;
#line 187 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 745 "ease-background-widget.c"
	_inner_error_ = NULL;
#line 190 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->store, &itr);
#line 749 "ease-background-widget.c"
	{
		gint i;
#line 193 "ease-background-widget.vala"
		i = 0;
#line 754 "ease-background-widget.c"
		{
			gboolean _tmp0_;
#line 193 "ease-background-widget.vala"
			_tmp0_ = TRUE;
#line 193 "ease-background-widget.vala"
			while (TRUE) {
#line 193 "ease-background-widget.vala"
				if (!_tmp0_) {
#line 193 "ease-background-widget.vala"
					i++;
#line 765 "ease-background-widget.c"
				}
#line 193 "ease-background-widget.vala"
				_tmp0_ = FALSE;
#line 193 "ease-background-widget.vala"
				if (!(i < gtk_combo_box_get_active (self->priv->background_type))) {
#line 193 "ease-background-widget.vala"
					break;
#line 773 "ease-background-widget.c"
				}
#line 195 "ease-background-widget.vala"
				gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->store, &itr);
#line 777 "ease-background-widget.c"
			}
		}
	}
#line 200 "ease-background-widget.vala"
	gtk_tree_model_get ((GtkTreeModel*) self->priv->store, &itr, 1, &type, -1);
#line 203 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) self->priv->background, "background-type");
#line 206 "ease-background-widget.vala"
	if (type == EASE_BACKGROUND_TYPE_IMAGE) {
#line 206 "ease-background-widget.vala"
		_tmp1_ = ease_image_get_filename (ease_background_get_image (self->priv->background)) == NULL;
#line 789 "ease-background-widget.c"
	} else {
#line 206 "ease-background-widget.vala"
		_tmp1_ = FALSE;
#line 793 "ease-background-widget.c"
	}
#line 206 "ease-background-widget.vala"
	if (_tmp1_) {
#line 797 "ease-background-widget.c"
		GtkWindow* _tmp2_;
		char* _tmp3_;
		char* filename;
#line 208 "ease-background-widget.vala"
		filename = (_tmp3_ = ease_dialog_open_ext (EASE_BACKGROUND_WIDGET_BG_DIALOG_TITLE, _tmp2_ = ease_widget_window ((GtkWidget*) self), __lambda27__ease_dialog_file_chooser_dialog_extension, self), _g_object_unref0 (_tmp2_), _tmp3_);
#line 224 "ease-background-widget.vala"
		if (filename != NULL) {
#line 805 "ease-background-widget.c"
			{
				char* image;
#line 228 "ease-background-widget.vala"
				ease_image_set_source (ease_background_get_image (self->priv->background), filename);
#line 229 "ease-background-widget.vala"
				image = ease_document_add_media_file (self->priv->document, filename, &_inner_error_);
#line 812 "ease-background-widget.c"
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
#line 230 "ease-background-widget.vala"
				ease_image_set_filename (ease_background_get_image (self->priv->background), image);
#line 818 "ease-background-widget.c"
				_g_free0 (image);
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
#line 234 "ease-background-widget.vala"
					g_critical ("ease-background-widget.vala:234: Error adding background image: %s", e->message);
#line 830 "ease-background-widget.c"
					_g_error_free0 (e);
				}
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_free0 (filename);
				_g_object_unref0 (action);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			EaseUndoItem* _tmp4_;
#line 240 "ease-background-widget.vala"
			_tmp4_ = ease_undo_item_apply ((EaseUndoItem*) action);
#line 846 "ease-background-widget.c"
			_g_object_unref0 (_tmp4_);
			_g_free0 (filename);
			_g_object_unref0 (action);
#line 241 "ease-background-widget.vala"
			return;
#line 852 "ease-background-widget.c"
		}
		_g_free0 (filename);
	}
#line 245 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda28__ease_undo_item_applied, self, 0);
#line 253 "ease-background-widget.vala"
	switch (type) {
#line 860 "ease-background-widget.c"
		case EASE_BACKGROUND_TYPE_COLOR:
		{
#line 256 "ease-background-widget.vala"
			ease_undo_action_add (action, (GObject*) self->priv->background, "color");
#line 257 "ease-background-widget.vala"
			break;
#line 867 "ease-background-widget.c"
		}
		case EASE_BACKGROUND_TYPE_GRADIENT:
		{
#line 259 "ease-background-widget.vala"
			ease_undo_action_add (action, (GObject*) self->priv->background, "gradient");
#line 260 "ease-background-widget.vala"
			break;
#line 875 "ease-background-widget.c"
		}
		case EASE_BACKGROUND_TYPE_IMAGE:
		{
#line 262 "ease-background-widget.vala"
			ease_undo_action_add (action, (GObject*) self->priv->background, "image");
#line 263 "ease-background-widget.vala"
			break;
#line 883 "ease-background-widget.c"
		}
	}
#line 266 "ease-background-widget.vala"
	ease_background_set_background_type (self->priv->background, type);
#line 268 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 271 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, type);
#line 892 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 279 "ease-background-widget.vala"
static void _lambda29_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 279 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 280 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 903 "ease-background-widget.c"
}


#line 279 "ease-background-widget.vala"
static void __lambda29__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 909 "ease-background-widget.c"
	_lambda29_ (sender, self);
}


#line 275 "ease-background-widget.vala"
void ease_background_widget_on_gradient_type_changed (GtkComboBox* sender, EaseBackgroundWidget* self) {
#line 916 "ease-background-widget.c"
	EaseUndoAction* action;
	EaseGradientType type = 0;
	GtkTreeIter itr = {0};
#line 275 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 277 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_gradient (self->priv->background), "mode");
#line 279 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda29__ease_undo_item_applied, self, 0);
#line 285 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (sender), &itr);
#line 928 "ease-background-widget.c"
	{
		gint i;
#line 286 "ease-background-widget.vala"
		i = 0;
#line 933 "ease-background-widget.c"
		{
			gboolean _tmp0_;
#line 286 "ease-background-widget.vala"
			_tmp0_ = TRUE;
#line 286 "ease-background-widget.vala"
			while (TRUE) {
#line 286 "ease-background-widget.vala"
				if (!_tmp0_) {
#line 286 "ease-background-widget.vala"
					i++;
#line 944 "ease-background-widget.c"
				}
#line 286 "ease-background-widget.vala"
				_tmp0_ = FALSE;
#line 286 "ease-background-widget.vala"
				if (!(i < gtk_combo_box_get_active (sender))) {
#line 286 "ease-background-widget.vala"
					break;
#line 952 "ease-background-widget.c"
				}
#line 288 "ease-background-widget.vala"
				gtk_tree_model_iter_next (gtk_combo_box_get_model (sender), &itr);
#line 956 "ease-background-widget.c"
			}
		}
	}
#line 290 "ease-background-widget.vala"
	gtk_tree_model_get (gtk_combo_box_get_model (sender), &itr, 1, &type, -1);
#line 291 "ease-background-widget.vala"
	ease_gradient_set_mode (ease_background_get_gradient (self->priv->background), type);
#line 292 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 966 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 300 "ease-background-widget.vala"
static void _lambda30_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 300 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 301 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 977 "ease-background-widget.c"
}


#line 300 "ease-background-widget.vala"
static void __lambda30__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 983 "ease-background-widget.c"
	_lambda30_ (sender, self);
}


#line 296 "ease-background-widget.vala"
void ease_background_widget_on_image_fill_changed (GtkComboBox* sender, EaseBackgroundWidget* self) {
#line 990 "ease-background-widget.c"
	EaseUndoAction* action;
	EaseImageFillType type = 0;
	GtkTreeIter itr = {0};
#line 296 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 298 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_image (self->priv->background), "fill");
#line 300 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda30__ease_undo_item_applied, self, 0);
#line 306 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (sender), &itr);
#line 1002 "ease-background-widget.c"
	{
		gint i;
#line 307 "ease-background-widget.vala"
		i = 0;
#line 1007 "ease-background-widget.c"
		{
			gboolean _tmp0_;
#line 307 "ease-background-widget.vala"
			_tmp0_ = TRUE;
#line 307 "ease-background-widget.vala"
			while (TRUE) {
#line 307 "ease-background-widget.vala"
				if (!_tmp0_) {
#line 307 "ease-background-widget.vala"
					i++;
#line 1018 "ease-background-widget.c"
				}
#line 307 "ease-background-widget.vala"
				_tmp0_ = FALSE;
#line 307 "ease-background-widget.vala"
				if (!(i < gtk_combo_box_get_active (sender))) {
#line 307 "ease-background-widget.vala"
					break;
#line 1026 "ease-background-widget.c"
				}
#line 309 "ease-background-widget.vala"
				gtk_tree_model_iter_next (gtk_combo_box_get_model (sender), &itr);
#line 1030 "ease-background-widget.c"
			}
		}
	}
#line 311 "ease-background-widget.vala"
	gtk_tree_model_get (gtk_combo_box_get_model (sender), &itr, 1, &type, -1);
#line 312 "ease-background-widget.vala"
	ease_image_set_fill (ease_background_get_image (self->priv->background), type);
#line 313 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 1040 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 324 "ease-background-widget.vala"
static void _lambda31_ (Block4Data* _data4_) {
#line 1047 "ease-background-widget.c"
	EaseBackgroundWidget * self;
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0};
	self = _data4_->self;
#line 325 "ease-background-widget.vala"
	gtk_color_button_set_color (_data4_->sender, (_tmp1_ = (ease_color_get_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), &_tmp0_), _tmp0_), &_tmp1_));
#line 1054 "ease-background-widget.c"
}


#line 324 "ease-background-widget.vala"
static void __lambda31__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1060 "ease-background-widget.c"
	_lambda31_ (self);
}


#line 332 "ease-background-widget.vala"
static void _lambda32_ (Block4Data* _data4_) {
#line 1067 "ease-background-widget.c"
	EaseBackgroundWidget * self;
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0};
	self = _data4_->self;
#line 333 "ease-background-widget.vala"
	gtk_color_button_set_color (_data4_->sender, (_tmp1_ = (ease_color_get_gdk (ease_gradient_get_start (ease_background_get_gradient (self->priv->background)), &_tmp0_), _tmp0_), &_tmp1_));
#line 1074 "ease-background-widget.c"
}


#line 332 "ease-background-widget.vala"
static void __lambda32__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1080 "ease-background-widget.c"
	_lambda32_ (self);
}


#line 340 "ease-background-widget.vala"
static void _lambda33_ (Block4Data* _data4_) {
#line 1087 "ease-background-widget.c"
	EaseBackgroundWidget * self;
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0};
	self = _data4_->self;
#line 341 "ease-background-widget.vala"
	gtk_color_button_set_color (_data4_->sender, (_tmp1_ = (ease_color_get_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), &_tmp0_), _tmp0_), &_tmp1_));
#line 1094 "ease-background-widget.c"
}


#line 340 "ease-background-widget.vala"
static void __lambda33__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1100 "ease-background-widget.c"
	_lambda33_ (self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->sender);
		g_slice_free (Block4Data, _data4_);
	}
}


#line 317 "ease-background-widget.vala"
void ease_background_widget_on_color_set (GtkColorButton* sender, EaseBackgroundWidget* self) {
#line 1122 "ease-background-widget.c"
	Block4Data* _data4_;
	EaseUndoAction* action;
#line 317 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 1127 "ease-background-widget.c"
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->sender = _g_object_ref0 (sender);
#line 319 "ease-background-widget.vala"
	action = NULL;
#line 320 "ease-background-widget.vala"
	if (_data4_->sender == self->priv->bg_color) {
#line 1136 "ease-background-widget.c"
		EaseUndoAction* _tmp0_;
		GdkColor _tmp1_ = {0};
		GdkColor _tmp2_;
#line 322 "ease-background-widget.vala"
		action = (_tmp0_ = ease_color_undo_action (ease_background_get_color (self->priv->background)), _g_object_unref0 (action), _tmp0_);
#line 323 "ease-background-widget.vala"
		ease_color_set_gdk (ease_background_get_color (self->priv->background), (_tmp2_ = (gtk_color_button_get_color (_data4_->sender, &_tmp1_), _tmp1_), &_tmp2_));
#line 324 "ease-background-widget.vala"
		g_signal_connect_data ((EaseUndoItem*) action, "applied", (GCallback) __lambda31__ease_undo_item_applied, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 1146 "ease-background-widget.c"
	} else {
#line 328 "ease-background-widget.vala"
		if (_data4_->sender == self->priv->grad_color1) {
#line 1150 "ease-background-widget.c"
			EaseUndoAction* _tmp3_;
			GdkColor _tmp4_ = {0};
			GdkColor _tmp5_;
#line 330 "ease-background-widget.vala"
			action = (_tmp3_ = ease_color_undo_action (ease_gradient_get_start (ease_background_get_gradient (self->priv->background))), _g_object_unref0 (action), _tmp3_);
#line 331 "ease-background-widget.vala"
			ease_color_set_gdk (ease_gradient_get_start (ease_background_get_gradient (self->priv->background)), (_tmp5_ = (gtk_color_button_get_color (_data4_->sender, &_tmp4_), _tmp4_), &_tmp5_));
#line 332 "ease-background-widget.vala"
			g_signal_connect_data ((EaseUndoItem*) action, "applied", (GCallback) __lambda32__ease_undo_item_applied, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 1160 "ease-background-widget.c"
		} else {
#line 336 "ease-background-widget.vala"
			if (_data4_->sender == self->priv->grad_color2) {
#line 1164 "ease-background-widget.c"
				EaseUndoAction* _tmp6_;
				GdkColor _tmp7_ = {0};
				GdkColor _tmp8_;
#line 338 "ease-background-widget.vala"
				action = (_tmp6_ = ease_color_undo_action (ease_gradient_get_end (ease_background_get_gradient (self->priv->background))), _g_object_unref0 (action), _tmp6_);
#line 339 "ease-background-widget.vala"
				ease_color_set_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), (_tmp8_ = (gtk_color_button_get_color (_data4_->sender, &_tmp7_), _tmp7_), &_tmp8_));
#line 340 "ease-background-widget.vala"
				g_signal_connect_data ((EaseUndoItem*) action, "applied", (GCallback) __lambda33__ease_undo_item_applied, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 1174 "ease-background-widget.c"
			}
		}
	}
#line 344 "ease-background-widget.vala"
	if (action != NULL) {
#line 344 "ease-background-widget.vala"
		ease_background_widget_emit_undo (self, action);
#line 1182 "ease-background-widget.c"
	}
	_g_object_unref0 (action);
	block4_data_unref (_data4_);
}


#line 356 "ease-background-widget.vala"
static void _lambda34_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 356 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 358 "ease-background-widget.vala"
	if (ease_image_get_source (ease_background_get_image (self->priv->background)) != NULL) {
#line 360 "ease-background-widget.vala"
		gtk_file_chooser_set_filename ((GtkFileChooser*) self->priv->bg_image, ease_image_get_source (ease_background_get_image (self->priv->background)));
#line 1197 "ease-background-widget.c"
	} else {
#line 364 "ease-background-widget.vala"
		gtk_file_chooser_unselect_all ((GtkFileChooser*) self->priv->bg_image);
#line 1201 "ease-background-widget.c"
	}
#line 367 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 1205 "ease-background-widget.c"
}


#line 356 "ease-background-widget.vala"
static void __lambda34__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1211 "ease-background-widget.c"
	_lambda34_ (sender, self);
}


#line 348 "ease-background-widget.vala"
void ease_background_widget_on_file_set (GtkFileChooserButton* sender, EaseBackgroundWidget* self) {
#line 1218 "ease-background-widget.c"
	GError * _inner_error_;
	EaseUndoAction* action;
#line 348 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 1223 "ease-background-widget.c"
	_inner_error_ = NULL;
#line 350 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_image (self->priv->background), "filename");
#line 351 "ease-background-widget.vala"
	ease_undo_action_add (action, (GObject*) ease_background_get_image (self->priv->background), "source");
#line 356 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda34__ease_undo_item_applied, self, 0);
#line 1231 "ease-background-widget.c"
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* i;
#line 372 "ease-background-widget.vala"
		ease_image_set_source (ease_background_get_image (self->priv->background), _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) sender));
#line 1239 "ease-background-widget.c"
		_g_free0 (_tmp0_);
#line 373 "ease-background-widget.vala"
		i = (_tmp2_ = ease_document_add_media_file (self->priv->document, _tmp1_ = gtk_file_chooser_get_filename ((GtkFileChooser*) sender), &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
#line 1243 "ease-background-widget.c"
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
#line 374 "ease-background-widget.vala"
		ease_image_set_filename (ease_background_get_image (self->priv->background), i);
#line 1249 "ease-background-widget.c"
		_g_free0 (i);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 378 "ease-background-widget.vala"
			g_critical ("ease-background-widget.vala:378: Error adding background image: %s", e->message);
#line 1261 "ease-background-widget.c"
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 381 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 1274 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 399 "ease-background-widget.vala"
static void _lambda35_ (EaseBackgroundWidget* self) {
#line 1281 "ease-background-widget.c"
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0};
	GdkColor _tmp3_;
	GdkColor _tmp2_ = {0};
#line 400 "ease-background-widget.vala"
	gtk_color_button_set_color (self->priv->grad_color1, (_tmp1_ = (ease_color_get_gdk (ease_gradient_get_start (ease_background_get_gradient (self->priv->background)), &_tmp0_), _tmp0_), &_tmp1_));
#line 401 "ease-background-widget.vala"
	gtk_color_button_set_color (self->priv->grad_color2, (_tmp3_ = (ease_color_get_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), &_tmp2_), _tmp2_), &_tmp3_));
#line 1290 "ease-background-widget.c"
}


#line 399 "ease-background-widget.vala"
static void __lambda35__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1296 "ease-background-widget.c"
	_lambda35_ (self);
}


#line 385 "ease-background-widget.vala"
void ease_background_widget_on_reverse_gradient (GtkWidget* sender, EaseBackgroundWidget* self) {
#line 1303 "ease-background-widget.c"
	EaseUndoAction* action;
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0};
	GdkColor _tmp3_;
	GdkColor _tmp2_ = {0};
#line 385 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 388 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_gradient (self->priv->background), "start");
#line 389 "ease-background-widget.vala"
	ease_undo_action_add (action, (GObject*) ease_background_get_gradient (self->priv->background), "end");
#line 392 "ease-background-widget.vala"
	ease_gradient_flip (ease_background_get_gradient (self->priv->background));
#line 395 "ease-background-widget.vala"
	gtk_color_button_set_color (self->priv->grad_color1, (_tmp1_ = (ease_color_get_gdk (ease_gradient_get_start (ease_background_get_gradient (self->priv->background)), &_tmp0_), _tmp0_), &_tmp1_));
#line 396 "ease-background-widget.vala"
	gtk_color_button_set_color (self->priv->grad_color2, (_tmp3_ = (ease_color_get_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), &_tmp2_), _tmp2_), &_tmp3_));
#line 399 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda35__ease_undo_item_applied, self, 0);
#line 405 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 1325 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 416 "ease-background-widget.vala"
static void _lambda36_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 416 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 417 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 1336 "ease-background-widget.c"
}


#line 416 "ease-background-widget.vala"
static void __lambda36__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1342 "ease-background-widget.c"
	_lambda36_ (sender, self);
}


#line 409 "ease-background-widget.vala"
void ease_background_widget_on_set_angle (GtkWidget* sender, EaseBackgroundWidget* self) {
#line 1349 "ease-background-widget.c"
	EaseUndoAction* action;
	GtkWidget* _tmp0_;
#line 409 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 411 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_gradient (self->priv->background), "angle");
#line 412 "ease-background-widget.vala"
	ease_gradient_set_angle (ease_background_get_gradient (self->priv->background), gtk_adjustment_get_value (gtk_range_get_adjustment ((GtkRange*) (_tmp0_ = sender, GTK_IS_HSCALE (_tmp0_) ? ((GtkHScale*) _tmp0_) : NULL))));
#line 414 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 416 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda36__ease_undo_item_applied, self, 0);
#line 1362 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 421 "ease-background-widget.vala"
static void ease_background_widget_display_bg_ui (EaseBackgroundWidget* self, EaseBackgroundType type) {
#line 421 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 423 "ease-background-widget.vala"
	switch (type) {
#line 1373 "ease-background-widget.c"
		case EASE_BACKGROUND_TYPE_COLOR:
		{
			GdkColor _tmp2_;
			GdkColor _tmp1_ = {0};
#line 426 "ease-background-widget.vala"
			gtk_widget_show_all ((GtkWidget*) self->priv->box_color);
#line 427 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_gradient);
#line 428 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_image);
#line 430 "ease-background-widget.vala"
			if (ease_background_get_color (self->priv->background) == NULL) {
#line 1386 "ease-background-widget.c"
				EaseColor* _tmp0_;
#line 432 "ease-background-widget.vala"
				ease_background_set_color (self->priv->background, _tmp0_ = ease_color_get_white ());
#line 1390 "ease-background-widget.c"
				_g_object_unref0 (_tmp0_);
			}
#line 434 "ease-background-widget.vala"
			ease_background_set_background_type (self->priv->background, EASE_BACKGROUND_TYPE_COLOR);
#line 436 "ease-background-widget.vala"
			gtk_color_button_set_color (self->priv->bg_color, (_tmp2_ = (ease_color_get_gdk (ease_background_get_color (self->priv->background), &_tmp1_), _tmp1_), &_tmp2_));
#line 438 "ease-background-widget.vala"
			break;
#line 1399 "ease-background-widget.c"
		}
		case EASE_BACKGROUND_TYPE_GRADIENT:
		{
			GdkColor _tmp7_;
			GdkColor _tmp6_ = {0};
			GdkColor _tmp9_;
			GdkColor _tmp8_ = {0};
#line 441 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_color);
#line 442 "ease-background-widget.vala"
			gtk_widget_show_all ((GtkWidget*) self->priv->box_gradient);
#line 443 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_image);
#line 445 "ease-background-widget.vala"
			if (ease_background_get_gradient (self->priv->background) == NULL) {
#line 1415 "ease-background-widget.c"
				EaseGradient* _tmp5_;
				EaseColor* _tmp4_;
				EaseColor* _tmp3_;
#line 447 "ease-background-widget.vala"
				ease_background_set_gradient (self->priv->background, _tmp5_ = ease_gradient_new (_tmp3_ = ease_color_get_black (), _tmp4_ = ease_color_get_white ()));
#line 1421 "ease-background-widget.c"
				_g_object_unref0 (_tmp5_);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (_tmp3_);
			}
#line 451 "ease-background-widget.vala"
			gtk_combo_box_set_active (self->priv->gradient_type, (gint) ease_gradient_get_mode (ease_background_get_gradient (self->priv->background)));
#line 453 "ease-background-widget.vala"
			ease_background_set_background_type (self->priv->background, EASE_BACKGROUND_TYPE_GRADIENT);
#line 455 "ease-background-widget.vala"
			gtk_color_button_set_color (self->priv->grad_color1, (_tmp7_ = (ease_color_get_gdk (ease_gradient_get_start (ease_background_get_gradient (self->priv->background)), &_tmp6_), _tmp6_), &_tmp7_));
#line 456 "ease-background-widget.vala"
			gtk_color_button_set_color (self->priv->grad_color2, (_tmp9_ = (ease_color_get_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), &_tmp8_), _tmp8_), &_tmp9_));
#line 458 "ease-background-widget.vala"
			gtk_adjustment_set_value (gtk_range_get_adjustment ((GtkRange*) self->priv->grad_angle), ease_gradient_get_angle (ease_background_get_gradient (self->priv->background)));
#line 460 "ease-background-widget.vala"
			break;
#line 1438 "ease-background-widget.c"
		}
		case EASE_BACKGROUND_TYPE_IMAGE:
		{
#line 463 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_color);
#line 464 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_gradient);
#line 465 "ease-background-widget.vala"
			gtk_widget_show_all ((GtkWidget*) self->priv->box_image);
#line 467 "ease-background-widget.vala"
			ease_background_set_background_type (self->priv->background, EASE_BACKGROUND_TYPE_IMAGE);
#line 468 "ease-background-widget.vala"
			if (ease_image_get_source (ease_background_get_image (self->priv->background)) != NULL) {
#line 470 "ease-background-widget.vala"
				gtk_file_chooser_set_filename ((GtkFileChooser*) self->priv->bg_image, ease_image_get_source (ease_background_get_image (self->priv->background)));
#line 1454 "ease-background-widget.c"
			} else {
#line 474 "ease-background-widget.vala"
				gtk_file_chooser_unselect_all ((GtkFileChooser*) self->priv->bg_image);
#line 1458 "ease-background-widget.c"
			}
#line 477 "ease-background-widget.vala"
			gtk_combo_box_set_active (self->priv->image_fill, (gint) ease_image_get_fill (ease_background_get_image (self->priv->background)));
#line 479 "ease-background-widget.vala"
			break;
#line 1464 "ease-background-widget.c"
		}
	}
}


static void ease_background_widget_class_init (EaseBackgroundWidgetClass * klass) {
	ease_background_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseBackgroundWidgetPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_background_widget_finalize;
}


static void ease_background_widget_instance_init (EaseBackgroundWidget * self) {
	self->priv = EASE_BACKGROUND_WIDGET_GET_PRIVATE (self);
}


static void ease_background_widget_finalize (GObject* obj) {
	EaseBackgroundWidget * self;
	self = EASE_BACKGROUND_WIDGET (obj);
	_g_object_unref0 (self->priv->background_type);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->gradient_type);
	_g_object_unref0 (self->priv->box_color);
	_g_object_unref0 (self->priv->box_gradient);
	_g_object_unref0 (self->priv->box_image);
	_g_object_unref0 (self->priv->image_fill);
	_g_object_unref0 (self->priv->grad_angle);
	_g_object_unref0 (self->priv->bg_color);
	_g_object_unref0 (self->priv->grad_color1);
	_g_object_unref0 (self->priv->grad_color2);
	_g_object_unref0 (self->priv->bg_image);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->document);
	_g_object_unref0 (self->priv->slide);
	_g_object_unref0 (self->priv->element);
	G_OBJECT_CLASS (ease_background_widget_parent_class)->finalize (obj);
}


GType ease_background_widget_get_type (void) {
	static volatile gsize ease_background_widget_type_id__volatile = 0;
	if (g_once_init_enter (&ease_background_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseBackgroundWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_background_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseBackgroundWidget), 0, (GInstanceInitFunc) ease_background_widget_instance_init, NULL };
		GType ease_background_widget_type_id;
		ease_background_widget_type_id = g_type_register_static (GTK_TYPE_ALIGNMENT, "EaseBackgroundWidget", &g_define_type_info, 0);
		g_once_init_leave (&ease_background_widget_type_id__volatile, ease_background_widget_type_id);
	}
	return ease_background_widget_type_id__volatile;
}




