/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Dave Camp <campd@oit.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#include <config.h>

#include <gnome.h>
#include "dryad.h"
#include <liboaf/liboaf.h>

/* FIXME: This really needs to be redone, this is just a temporary hack */

#define CORBA_string__alloc() (CORBA_char **)ORBit_alloc(sizeof(gpointer), CORBA_string__free, GUINT_TO_POINTER(1))

#define SERVER_CHECK_TIMEOUT 2000

static void 
check_servers (DryadApp *app)
{
    gboolean alive;
    gboolean quit = FALSE;

    if (app->dbg) {
        alive = gnome_unknown_ping (app->dbg->objref);
    
        if (!alive) {
            g_warning (_("Debugger no longer valid!  Exiting."));
            app->dbg = NULL;
            quit = TRUE;
        }
    }

    if (quit)
        dryad_exit (app);
}

static void
load_file (DryadApp *app, gchar *filename)
{
    gboolean success;

    if (!dryad_load_debugger (app))
        return;
    
    success = gdf_debugger_client_load_binary (app->dbg, filename);
    if (success) {
        gdf_debugger_client_set_breakpoint_function (app->dbg, 
                                                      NULL, "main",
                                                      NULL);
        app->binary_name = g_strdup (filename);
    } else {
        GtkWidget *app_widget;
        app_widget = glade_xml_get_widget (app->ui, "dryad_app");
        gnome_app_error (GNOME_APP (app_widget), 
                         _("Could not load file."));
    }
}

static guint
init_app (gchar *filename)
{
	DryadApp *app;	
	app = g_new0 (DryadApp, 1);

	app->binary_name = NULL;
    app->dbg = NULL;

    dryad_ui_init (app);

    if (filename)
        load_file (app, filename);

    gtk_timeout_add (SERVER_CHECK_TIMEOUT, check_servers, app);

	return FALSE;
}

void
dryad_exit (DryadApp *app)
{
	if (app->dbg)
		gtk_object_unref (GTK_OBJECT (app->dbg));

    dryad_ui_destroy (app);

	gtk_main_quit ();
}

int
main (int argc, char *argv[])
{
	CORBA_Environment ev;
	CORBA_ORB orb;

    gchar *filename = NULL;

	CORBA_exception_init (&ev);
#if 0
	orb = gnome_CORBA_init ("dryad", VERSION, &argc, argv,
							0, &ev);
#endif
    gnome_init_with_popt_table ("dryad", VERSION, argc, argv,
                                oaf_popt_options, 0, NULL);
    oaf_init (argc, argv);

	if (!bonobo_init (oaf_orb_get (), NULL, NULL)) 
		g_error (_("Can't initialize bonobo!"));
	
	glade_gnome_init ();

    if (argc == 2)
        filename = g_strdup (argv [1]);

	/* Cannot make CORBA calls unless we're in the main loop.  So we delay. */
	gtk_idle_add ((GtkFunction)init_app, filename);
	
	bonobo_main ();

	return 0;
}
