# Dots - A braille translation program.
#
# Copyright (C) 2009 Eitan Isaacson
# Copyright (C) 2010 Consorcio Fernando de los Rios
#               Author: Fernando Herrera <fherrera@onirica.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygtk
import gtk, glib
import os, tempfile
from config_builder import ConfigBuilder
import host_settings
import gettext
from dots_project import DotsProject
from document_builder import document_new
import gconf
import gtkunixprint
from table_editor import TableEditor
from translator import Translator

import gettext
gettext.bindtextdomain(host_settings.DOMAIN,host_settings.LOCALE_DIR)
gettext.textdomain(host_settings.DOMAIN)
_ = gettext.gettext

class AppWindow(object):
    def __init__(self):
	self.project = None
	self.document = None
	self.table_group = None
        self.main_xml = gtk.Builder()
	self.main_xml.set_translation_domain(host_settings.DOMAIN)
        self.main_xml.add_from_file (
            os.path.join(host_settings.gtkbuilder_dir, 'app_window.xml'))
        self.window = self.main_xml.get_object('window1')
	self.window.set_icon_name('dots')
        self.main_xml.connect_signals(self)
        self.config_builder = ConfigBuilder()
	self.client = gconf.client_get_default ()
	self.client.add_dir ("/apps/dots", gconf.CLIENT_PRELOAD_NONE)
        self.conf_xml = gtk.Builder()
	self.conf_xml.set_translation_domain(host_settings.DOMAIN)
        self.conf_xml.add_from_file (
            os.path.join(host_settings.gtkbuilder_dir, 'config.xml'))
 
	self.loadConfig()

    def loadConfig(self):
	self.config_builder['xml']['semanticFiles'] = self.client.get_string ("/apps/dots/semanticFiles")
	if self.client.get_bool ("/apps/dots/internetAccess"):
		self.config_builder['xml']['internetAccess'] = 'yes'
	else:
		self.config_builder['xml']['internetAccess'] = 'no'
	self.config_builder['translation']['literaryTextTable'] = self.client.get_string ("/apps/dots/literaryTextTable")
	self.config_builder['outputFormat']['cellsPerLine'] = self.client.get_int ("/apps/dots/cellsPerLine")
	if self.client.get_bool ("/apps/dots/braillePages"):
		self.config_builder['outputFormat']['braillePages'] = 'yes'
	else:
		self.config_builder['outputFormat']['braillePages'] = 'no'
	self.config_builder['outputFormat']['formatFor'] = self.client.get_string ("/apps/dots/formatFor")
	self.config_builder['outputFormat']['LinesPerPage'] = self.client.get_int ("/apps/dots/LinesPerPage")
	self.config_builder['outputFormat']['braillePageNumberAt'] =  self.client.get_string ("/apps/dots/braillePageNumberAt")
	self._populateTablesMenu()

    def saveConfig(self):
	self.client.set_string ("/apps/dots/semanticFiles", self.config_builder['xml']['semanticFiles'])
	if self.config_builder['xml']['internetAccess'] == 'yes':
		self.client.set_bool ("/apps/dots/internetAccess", True)
	else:
		self.client.set_bool ("/apps/dots/internetAccess", False)
	self.client.set_string ("/apps/dots/literaryTextTable", self.config_builder['translation']['literaryTextTable'])
	self.client.set_int ("/apps/dots/cellsPerLine", self.config_builder['outputFormat']['cellsPerLine'])
	if self.config_builder['outputFormat']['braillePages'] == 'yes':
		self.client.set_bool ("/apps/dots/braillePages", True)
	else:
		self.client.set_bool ("/apps/dots/braillePages", False)
	self.client.set_string ("/apps/dots/formatFor", self.config_builder['outputFormat']['formatFor'])
	self.client.set_int ("/apps/dots/LinesPerPage", self.config_builder['outputFormat']['LinesPerPage'])
	self.client.set_string ("/apps/dots/braillePageNumberAt", self.config_builder['outputFormat']['braillePageNumberAt'])

    def _OnTranslationFormatActivate(self, item):
	dialog = self.conf_xml.get_object('format_dialog')
	dialog.set_transient_for(self.window)
	radiotop = self.conf_xml.get_object('page_top')
	radiobottom = self.conf_xml.get_object('page_bottom')
	radionone = self.conf_xml.get_object('page_none')

	if self.config_builder['outputFormat']['braillePages'] == "yes":
		if self.config_builder['outputFormat']['braillePageNumberAt'] == "top":
			radiotop.set_active(True)
		else:
			radiobottom.set_active(True)
	else:
		radionone.set_active(True)
	lines = self.conf_xml.get_object('lines_entry')
	lines.set_value (self.config_builder['outputFormat']['LinesPerPage'])
	cells = self.conf_xml.get_object('cells_entry')
	cells.set_value (self.config_builder['outputFormat']['cellsPerLine'])

	response = dialog.run()
	if response == 0:
		self.config_builder['outputFormat']['cellsPerLine'] = cells.get_value_as_int()
		self.config_builder['outputFormat']['LinesPerPage'] = lines.get_value_as_int()
		if radiotop.get_active():
			self.config_builder['outputFormat']['braillePages'] = "yes"
			self.config_builder['outputFormat']['braillePageNumberAt'] = "top"
		elif radiobottom.get_active():
			self.config_builder['outputFormat']['braillePages'] = "yes"
			self.config_builder['outputFormat']['braillePageNumberAt'] = "bottom"
		else:
			self.config_builder['outputFormat']['braillePages'] = "no"
		
		if self.document is not None:
			self.translate (self.document, self.config_builder)

	dialog.hide()

    def _OnTranslationEditTableActivate(self, item):
	te = TableEditor (self.window)
	table = self.config_builder['translation']['literaryTextTable']
	if table.startswith('/'):
		te.open(table)
	else:
		te.open(os.path.join(host_settings.tablesdir, table))
	te.set_transient_for(self.window)
	te.show_all()
	while True:
		res = te.run()
		if res == gtk.RESPONSE_OK:
			tmpfile = tempfile.NamedTemporaryFile (delete=False)
			te.save(tmpfile.name)
			table_ok = self._testTable(tmpfile.name)
			if not table_ok:
				dialog = self.main_xml.get_object("table_error_dialog")
				dialog.set_transient_for(te)
				dialog.run()
				dialog.hide()
			else:
				te.save_as()
				new_table = te.get_filename()
				path, file = os.path.split (new_table)
				os.chdir (path)
				eitem = self._addTable (self.submenu, file, True)
				eitem.activate()
				eitem.show()
				break
		else:
			break
	te.destroy()




    def _addTable(self, submenu, table, prepend=False):
	tableitem = gtk.RadioMenuItem(self.table_group, table)
	tableitem.connect("activate", self._onTableActivate, table)
	if prepend:
		submenu.prepend (tableitem)
	else:
		submenu.append (tableitem)
	self.table_group = tableitem
	return tableitem

    def _testTable(self,filename):
	path, file = os.path.split (filename)
	os.chdir (path)
	old_table = self.config_builder['translation']['literaryTextTable']
	self.config_builder['translation']['literaryTextTable'] = file
	test_translator = Translator(self.config_builder)
	if test_translator.translate_string("Test") == "":
		self.config_builder['translation']['literaryTextTable'] = old_table
		return False
	else:
		return True, ""


    def _onTableOtherActivate(self, item):
	chooser = gtk.FileChooserDialog(title=None,action=gtk.FILE_CHOOSER_ACTION_OPEN,
					buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))
 	response = chooser.run()
	filename = chooser.get_filename()
	chooser.destroy()
	if response == gtk.RESPONSE_OK:
		table_ok = self._testTable(filename)
		if not table_ok:
			dialog = self.main_xml.get_object("table_error_dialog")
			dialog.set_transient_for(self.window)
			dialog.run()
			dialog.hide()
			return
	
		eitem = self._addTable (self.submenu, file, True)
		eitem.activate()
		eitem.show()

    def _onTableActivate(self, item, table):
	self.config_builder['translation']['literaryTextTable'] = table
	if self.document is not None:
		self.translate (self.document, self.config_builder)
	
	

    def _populateTablesMenu(self):
        def _sepatatorFunc(model, itr):
            return model[itr][0] == None
        menuitem = self.main_xml.get_object('select_table_menuitem')
	#Fixme, dont make this global, use get_menu at _onTableOtherActivate
	self.submenu = gtk.Menu()
	menuitem.set_submenu(self.submenu)
        table_list = filter(lambda x: x.endswith('ctb') or x.endswith('utb'),
                            os.listdir(host_settings.tablesdir))
        table_list.sort()
	group = None
	found = False
        for table in table_list:
		item = self._addTable (self.submenu, table)
		if table == self.config_builder['translation']['literaryTextTable']:
			item.activate()
			found = True

	othermenu = gtk.MenuItem("Other...")
	othermenu.connect_after("activate", self._onTableOtherActivate)
	self.submenu.append(othermenu)

	if not found:
		if os.access (self.config_builder['translation']['literaryTextTable'], os.R_OK):
			eitem = self._addTable (self.submenu, self.config_builder['translation']['literaryTextTable'], True)
			eitem.activate()
		else:
			self.submenu.set_active(1)



    def _onOpen(self, action):
	chooser = gtk.FileChooserDialog(title=None,action=gtk.FILE_CHOOSER_ACTION_OPEN,
					buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))
	filter = gtk.FileFilter()
	filter.set_name(_("All files"))
	filter.add_pattern("*")
	chooser.add_filter(filter)

	filter = gtk.FileFilter()
	filter.set_name(_("Documents"))
	filter.add_mime_type("application/pdf")
	filter.add_mime_type("application/vnd.oasis.opendocument.text")
	filter.add_mime_type("application/xhtml+xml")
	filter.add_mime_type("application/xml")
	filter.add_mime_type("text/plain")
	filter.add_mime_type("text/html")
	filter.add_pattern("*.pdf")
	filter.add_pattern("*.odt")
	filter.add_pattern("*.txt")
	filter.add_pattern("*.html")
	filter.add_pattern("*.xhtml")
	filter.add_pattern("*.xml")
	chooser.add_filter(filter)
	chooser.set_filter(filter)
 	response = chooser.run()
	filename = chooser.get_filename()
	chooser.destroy()
	if response == gtk.RESPONSE_OK:
		self.document = document_new (filename)
		self.addDocument (self.document)
		self.translate (self.document, self.config_builder)

    def _OnRevisionLine(self, item):
	reviewentry = self.main_xml.get_object('reviewentry')
	if item.get_active():
        	reviewentry.show()
	else:
        	reviewentry.hide()
		

    def _OnBrailleViewToggle(self, ascii_item):
        if ascii_item.get_active():
            self.project.view_ascii()
        else:
            self.project.view_braille()

    def _onLineChanged(self, view, project, line):
	self.main_xml.get_object('reviewentry').set_text(line)
	

    def _onSave(self, action):
        if self.project.out_file is None:
            self._onSaveAs(action)
        else:
            fsave = open(self.project.out_file, 'w')
            fsave.write(self.project.buffer.get_text(
                    self.project.buffer.get_start_iter(),
                    self.project.buffer.get_end_iter()))
            fsave.close()
            self.project.buffer.set_modified(False)            

    def _onSaveAs(self, action):
        dialog = gtk.FileChooserDialog(parent=self.window,
            action=gtk.FILE_CHOOSER_ACTION_SAVE,
            buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                     gtk.STOCK_SAVE, gtk.RESPONSE_OK))

        if self.project.out_file:
            dialog.set_filename(self.project.out_file)

        if (dialog.run() == gtk.RESPONSE_OK):
            fsave = open(dialog.get_filename(), 'w')
            fsave.write(self.project.buffer.get_text(
                    self.project.buffer.get_start_iter(),
                    self.project.buffer.get_end_iter()))
            fsave.close()
            self.project.out_file = dialog.get_filename()
            self.project.set_name(os.path.basename(self.project.out_file))
            self.project.buffer.set_modified(False)
            
        dialog.destroy()

    def _printJobSent(self, job, data, errormsg):
	if errormsg is not None:
		print "Error printing: " + errormsg
	
	os.unlink(data)
		

    def _onPrint(self, action):
	dialog = gtkunixprint.PrintUnixDialog()
        dialog.set_transient_for(self.window)
	response = dialog.run()
	if response == gtk.RESPONSE_OK:
		printer = dialog.get_selected_printer()
		settings = dialog.get_settings()
		setup = dialog.get_page_setup()
		job = gtkunixprint.PrintJob("dots", printer, settings, setup)
		tmpfile = tempfile.NamedTemporaryFile (delete=False)
		tmpfile.write (self.project.buffer.get_text(
				self.project.buffer.get_start_iter(),
				self.project.buffer.get_end_iter()))
		tmpfile.close()
		job.set_source_file(tmpfile.name)
		job.send(self._printJobSent, tmpfile.name)
	dialog.destroy()

    def _onAbout(self, action):
	about = gtk.AboutDialog()
	about.set_name ("dots")
	about.set_comments(_("A Braille translator for GNOME"))
	about.set_license("GPLv3")
	about.set_authors(["Eitan Isaacson", "Fernando Herrera  <fherrera@onirica.com>"])
	about.set_copyright("(C) 2009 Eitan Isaacson\n(C) 2010 Consorcio Fernando de los Rios")
	about.set_website("http://live.gnome.org/Dots")
	about.set_website_label("Dots website")
	about.set_documenters(["Fernando Herrera"])
	about.set_translator_credits(_("translator-credits"))
	about.run()
	about.destroy()


    def addDocument(self, document):
	container = self.main_xml.get_object('main_alignment')
	if self.project is not None:
		container.remove (self.project)
		self.project.destroy()

        self.project = DotsProject(document, _("Unsaved Document"))
	container.add(self.project)
        self.project.show_all()
	self.project.connect("line-changed", self._onLineChanged)

    def translate(self, document, config):
        res = self.project.transcribeBraille(config)
	if not res:
		dialog = self.main_xml.get_object('notext-dialog')
		dialog.run()
		dialog.hide()

	action = self.main_xml.get_object('action_save_as')
	action.set_sensitive(res)
	action = self.main_xml.get_object('action_save')
	action.set_sensitive(res)
	action = self.main_xml.get_object('action_print')
	action.set_sensitive(res)

	return res




    def run(self):
        self.window.show_all()
        self.main_xml.get_object('reviewentry').hide()
        gtk.main()

    def _onHelp(self, action):
	gtk.show_uri(None, "ghelp:dots", gtk.gdk.CURRENT_TIME)

    def _onQuit(self, window, event=None):
	self.saveConfig()
        gtk.main_quit()

if __name__ == "__main__":
    window = AppWindow()
    window.show_all()
    window.main_xml.get_object('reviewentry').hide()
    gtk.main()
