# Dots - A braille translation program.
#
# Copyright (C) 2009 Eitan Isaacson
# Copyright (C) 2010 Consorcio Fernando de los Rios
#               Author: Fernando Herrera <fherrera@onirica.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
import os, tempfile, host_settings, sys, gtk
import ascii_braille
import gtksourceview2, pango, gobject
import mimetypes

class DotsProject(gtk.ScrolledWindow):
    def __init__(self, document, name):
        gtk.ScrolledWindow.__init__(self)
        self.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.view = gtksourceview2.View()
        self.view.set_right_margin(25)
        self.view.set_left_margin(25)
        self.view.set_editable(False)
        self.view.modify_font(pango.FontDescription('Mono'))
	self.view.connect_after("move-cursor", self._onMoved)
        self.add(self.view)
        self.buffer = self.view.get_buffer()
        self.buffer.connect("modified-changed", self._onModified)
        self.braille_buffer = gtksourceview2.Buffer()
        self.document = document
        self.tab_label = gtk.Label()
        self.set_name(name)
        self.out_file = None
        self.config = None
	self.current_line = None
	try:
		gobject.signal_new("line-changed", self, gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, (gtk.ScrolledWindow, gobject.TYPE_STRING))
	except:
		pass

    def set_name(self, name):
        gtk.ScrolledWindow.set_name(self, name)
        self.tab_label.set_text(name)

    def _onModified(self, textbuffer):
        if textbuffer.get_modified():
            self.tab_label.set_text('*'+self.name)
        else:
            self.tab_label.set_text(self.name)

    def _onMoved(self, view, step, count, extend_selection):
	mark = view.get_buffer().get_mark("insert")
	iter = view.get_buffer().get_iter_at_mark(mark)
	line = iter.get_line()
	start = self.buffer.get_iter_at_line(line)
	end = start.copy()
	end.forward_to_line_end()
	text = self.buffer.get_text (start, end)
	if text != self.current_line:
		self.current_line = text
		self.emit("line-changed", self, self.current_line)

		
	

    def transcribeBraille(self, config):
        self.config = config
        return self._transcribeBraille()

    def view_ascii(self):
        self.view.set_buffer(self.buffer)

    def view_braille(self):
        self.view.set_buffer(self.braille_buffer)

    def _transcribeBraille(self):
	self.document.translate (self.config)
	
        braille_text = self.document.get_braille_text() 
	if braille_text == "":
		return False

        self.buffer.set_text(braille_text)

        self.braille_buffer.set_text(
            ''.join([ascii_braille.ascii_to_braille.get(
                        x, '') for x in braille_text]))
	return True
        
