/* dconf.c generated by valac 0.12.0, the Vala compiler
 * generated from dconf.vala, do not modify */

/*
 * Copyright © 2010, 2011 Codethink Limited
 * Copyright © 2011 Canonical Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dconf.h>
#include <stdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define TYPE_COMMAND_MAPPING (command_mapping_get_type ())
typedef struct _CommandMapping CommandMapping;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef void (*Command) (gchar** args, int args_length1, void* user_data, GError** error);
struct _CommandMapping {
	Command func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
	gchar* name;
};



void show_help (gboolean requested, const gchar* command);
void dconf_help (gchar** args, int args_length1, GError** error);
void dconf_read (gchar** args, int args_length1, GError** error);
void dconf_list (gchar** args, int args_length1, GError** error);
void dconf_write (gchar** args, int args_length1, GError** error);
void dconf_reset (gchar** args, int args_length1, GError** error);
void show_path (DConfClient* client, const gchar* path);
void watch_function (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag);
void dconf_watch (gchar** args, int args_length1, GError** error);
static void _watch_function_dconf_watch_func (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag, gpointer self);
void dconf_complete (gchar** args, int args_length1, GError** error);
GType command_mapping_get_type (void) G_GNUC_CONST;
CommandMapping* command_mapping_dup (const CommandMapping* self);
void command_mapping_free (CommandMapping* self);
void command_mapping_copy (const CommandMapping* self, CommandMapping* dest);
void command_mapping_destroy (CommandMapping* self);
void command_mapping_init (CommandMapping *self, const gchar* name, Command func, void* func_target);
gint _vala_main (gchar** args, int args_length1);
static void _dconf_help_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_read_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_list_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_write_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_reset_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_update (gchar** args, int args_length1);
static void _dconf_update_command (gchar** args, int args_length1, gpointer self);
static void _dconf_watch_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_dump (gchar** args, int args_length1, GError** error);
static void _dconf_dump_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_load (gchar** args, int args_length1, GError** error);
static void _dconf_load_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_complete_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _vala_CommandMapping_array_free (CommandMapping* array, gint array_length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


void show_help (gboolean requested, const gchar* command) {
	GString* _tmp0_ = NULL;
	GString* str;
	gchar* description;
	gchar* synopsis;
	const gchar* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	static GQuark _tmp2__label3 = 0;
	static GQuark _tmp2__label4 = 0;
	static GQuark _tmp2__label5 = 0;
	static GQuark _tmp2__label6 = 0;
	static GQuark _tmp2__label7 = 0;
	static GQuark _tmp2__label8 = 0;
	static GQuark _tmp2__label9 = 0;
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	description = NULL;
	synopsis = NULL;
	_tmp1_ = command;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string (NULL)))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("help")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup ("Print help");
				_g_free0 (description);
				description = _tmp3_;
				_tmp4_ = g_strdup ("COMMAND");
				_g_free0 (synopsis);
				synopsis = _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("read")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_strdup ("Read the value of a key");
				_g_free0 (description);
				description = _tmp5_;
				_tmp6_ = g_strdup ("KEY");
				_g_free0 (synopsis);
				synopsis = _tmp6_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label3) ? _tmp2__label3 : (_tmp2__label3 = g_quark_from_static_string ("list")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup ("List the sub-keys and sub-dirs of a dir");
				_g_free0 (description);
				description = _tmp7_;
				_tmp8_ = g_strdup ("DIR");
				_g_free0 (synopsis);
				synopsis = _tmp8_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label4) ? _tmp2__label4 : (_tmp2__label4 = g_quark_from_static_string ("write")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = g_strdup ("Write a new value to a key");
				_g_free0 (description);
				description = _tmp9_;
				_tmp10_ = g_strdup ("KEY VALUE");
				_g_free0 (synopsis);
				synopsis = _tmp10_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label5) ? _tmp2__label5 : (_tmp2__label5 = g_quark_from_static_string ("reset")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = g_strdup ("Reset a key or dir.  -f is required for dirs.");
				_g_free0 (description);
				description = _tmp11_;
				_tmp12_ = g_strdup ("[-f] PATH");
				_g_free0 (synopsis);
				synopsis = _tmp12_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label6) ? _tmp2__label6 : (_tmp2__label6 = g_quark_from_static_string ("update")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = g_strdup ("Update the system dconf databases");
				_g_free0 (description);
				description = _tmp13_;
				_tmp14_ = g_strdup ("");
				_g_free0 (synopsis);
				synopsis = _tmp14_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label7) ? _tmp2__label7 : (_tmp2__label7 = g_quark_from_static_string ("watch")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = g_strdup ("Watch a path for key changes");
				_g_free0 (description);
				description = _tmp15_;
				_tmp16_ = g_strdup ("PATH");
				_g_free0 (synopsis);
				synopsis = _tmp16_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label8) ? _tmp2__label8 : (_tmp2__label8 = g_quark_from_static_string ("dump")))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = g_strdup ("Dump an entire subpath to stdout");
				_g_free0 (description);
				description = _tmp17_;
				_tmp18_ = g_strdup ("DIR");
				_g_free0 (synopsis);
				synopsis = _tmp18_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label9) ? _tmp2__label9 : (_tmp2__label9 = g_quark_from_static_string ("load")))) {
		switch (0) {
			default:
			{
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = g_strdup ("Populate a subpath from stdin");
				_g_free0 (description);
				description = _tmp19_;
				_tmp20_ = g_strdup ("DIR");
				_g_free0 (synopsis);
				synopsis = _tmp20_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_string_append_printf (str, "Unknown command '%s'\n\n", command);
				command = NULL;
				break;
			}
		}
	}
	if (command == NULL) {
		g_string_append (str, "Usage:\n" \
"  dconf COMMAND [ARGS...]\n" \
"\n" \
"Commands:\n" \
"  help              Show this information\n" \
"  read              Read the value of a key\n" \
"  list              List the contents of a dir\n" \
"  write             Change the value of a key\n" \
"  reset             Reset the value of a key or dir\n" \
"  update            Update the system databases\n" \
"  watch             Watch a path for changes\n" \
"\n" \
"Use 'dconf help COMMAND' to get detailed help.\n" \
"\n");
	} else {
		g_string_append (str, "Usage:\n");
		g_string_append_printf (str, "  dconf %s %s\n\n", command, synopsis);
		g_string_append_printf (str, "%s\n\n", description);
		if (g_strcmp0 (synopsis, "") != 0) {
			gboolean _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_;
			gboolean _tmp29_;
			g_string_append (str, "Arguments:\n");
			_tmp21_ = string_contains (synopsis, "COMMAND");
			if (_tmp21_) {
				g_string_append (str, "  COMMAND   The (optional) command to explain\n");
			}
			_tmp22_ = string_contains (synopsis, "PATH");
			if (_tmp22_) {
				g_string_append (str, "  PATH      Either a KEY or DIR\n");
			}
			_tmp24_ = string_contains (synopsis, "PATH");
			if (_tmp24_) {
				_tmp23_ = TRUE;
			} else {
				gboolean _tmp25_;
				_tmp25_ = string_contains (synopsis, "KEY");
				_tmp23_ = _tmp25_;
			}
			if (_tmp23_) {
				g_string_append (str, "  KEY       A key path (starting, but not ending with '/')\n");
			}
			_tmp27_ = string_contains (synopsis, "PATH");
			if (_tmp27_) {
				_tmp26_ = TRUE;
			} else {
				gboolean _tmp28_;
				_tmp28_ = string_contains (synopsis, "DIR");
				_tmp26_ = _tmp28_;
			}
			if (_tmp26_) {
				g_string_append (str, "  DIR       A directory path (starting and ending with '/')\n");
			}
			_tmp29_ = string_contains (synopsis, "VALUE");
			if (_tmp29_) {
				g_string_append (str, "  VALUE     The value to write (in GVariant format)\n");
			}
		}
		g_string_append (str, "\n");
	}
	if (requested) {
		g_print ("%s", str->str);
	} else {
		g_printerr ("%s", str->str);
	}
	_g_free0 (synopsis);
	_g_free0 (description);
	_g_string_free0 (str);
}


void dconf_help (gchar** args, int args_length1, GError** error) {
	show_help (TRUE, args[2]);
}


void dconf_read (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_ = NULL;
	DConfClient* client;
	gchar* _tmp1_;
	gchar* key;
	GVariant* _tmp2_ = NULL;
	GVariant* _result_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new (NULL, NULL, NULL, NULL);
	client = _tmp0_;
	_tmp1_ = g_strdup (args[2]);
	key = _tmp1_;
	dconf_is_key (key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp2_ = dconf_client_read (client, key);
	_result_ = _tmp2_;
	if (_result_ != NULL) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = g_variant_print (_result_, TRUE);
		_tmp4_ = _tmp3_;
		g_print ("%s\n", _tmp4_);
		_g_free0 (_tmp4_);
	}
	_g_variant_unref0 (_result_);
	_g_free0 (key);
	_g_object_unref0 (client);
}


void dconf_list (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_ = NULL;
	DConfClient* client;
	gchar* _tmp1_;
	gchar* dir;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new (NULL, NULL, NULL, NULL);
	client = _tmp0_;
	_tmp1_ = g_strdup (args[2]);
	dir = _tmp1_;
	dconf_is_dir (dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		_g_object_unref0 (client);
		return;
	}
	_tmp3_ = dconf_client_list (client, dir, &_tmp2_);
	{
		gchar** item_collection;
		int item_collection_length1;
		int item_it;
		item_collection = _tmp3_;
		item_collection_length1 = _tmp2_;
		for (item_it = 0; item_it < _tmp2_; item_it = item_it + 1) {
			gchar* _tmp4_;
			gchar* item;
			_tmp4_ = g_strdup (item_collection[item_it]);
			item = _tmp4_;
			{
				g_print ("%s\n", item);
				_g_free0 (item);
			}
		}
		item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (dir);
	_g_object_unref0 (client);
}


void dconf_write (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_ = NULL;
	DConfClient* client;
	gchar* _tmp1_;
	gchar* key;
	gchar* _tmp2_;
	gchar* val;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new (NULL, NULL, NULL, NULL);
	client = _tmp0_;
	_tmp1_ = g_strdup (args[2]);
	key = _tmp1_;
	_tmp2_ = g_strdup (args[3]);
	val = _tmp2_;
	dconf_is_key (key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp3_ = g_variant_parse (NULL, val, NULL, NULL, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp5_ = _tmp4_;
	dconf_client_write (client, key, _tmp5_, NULL, NULL, &_inner_error_);
	_g_variant_unref0 (_tmp5_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_g_free0 (val);
	_g_free0 (key);
	_g_object_unref0 (client);
}


void dconf_reset (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_ = NULL;
	DConfClient* client;
	gboolean force;
	gint index;
	gchar* _tmp1_;
	gchar* path;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new (NULL, NULL, NULL, NULL);
	client = _tmp0_;
	force = FALSE;
	index = 2;
	if (g_strcmp0 (args[index], "-f") == 0) {
		force = TRUE;
		index++;
	}
	_tmp1_ = g_strdup (args[index]);
	path = _tmp1_;
	dconf_is_path (path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_tmp3_ = dconf_is_dir (path, NULL);
	if (_tmp3_) {
		_tmp2_ = !force;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GError* _tmp4_ = NULL;
		_tmp4_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "-f must be given to (recursively) reset entire dirs");
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	dconf_client_write (client, path, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_g_free0 (path);
	_g_object_unref0 (client);
}


void show_path (DConfClient* client, const gchar* path) {
	gboolean _tmp0_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = dconf_is_key (path, NULL);
	if (_tmp0_) {
		GVariant* _tmp1_ = NULL;
		GVariant* value;
		gchar* _tmp2_ = NULL;
		_tmp1_ = dconf_client_read (client, path);
		value = _tmp1_;
		if (value != NULL) {
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_variant_print (value, TRUE);
			_g_free0 (_tmp2_);
			_tmp2_ = _tmp3_;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("unset");
			_g_free0 (_tmp2_);
			_tmp2_ = _tmp4_;
		}
		g_print ("  %s\n", _tmp2_);
		_g_free0 (_tmp2_);
		_g_variant_unref0 (value);
	}
}


void watch_function (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag) {
	g_return_if_fail (client != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (tag != NULL);
	if (items_length1 == 0) {
		g_print ("%s\n", path);
		show_path (client, path);
		g_print ("\n");
	} else {
		{
			gchar** item_collection;
			int item_collection_length1;
			int item_it;
			item_collection = items;
			item_collection_length1 = items_length1;
			for (item_it = 0; item_it < items_length1; item_it = item_it + 1) {
				gchar* _tmp0_;
				gchar* item;
				_tmp0_ = g_strdup (item_collection[item_it]);
				item = _tmp0_;
				{
					gchar* _tmp1_;
					gchar* full;
					_tmp1_ = g_strconcat (path, item, NULL);
					full = _tmp1_;
					g_print ("%s\n", full);
					show_path (client, full);
					_g_free0 (full);
					_g_free0 (item);
				}
			}
		}
		g_print ("\n");
	}
}


static void _watch_function_dconf_watch_func (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag, gpointer self) {
	watch_function (client, path, items, items_length1, tag);
}


void dconf_watch (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_ = NULL;
	DConfClient* client;
	gchar* _tmp1_;
	gchar* path;
	GMainLoop* _tmp2_ = NULL;
	GMainLoop* _tmp3_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new (NULL, _watch_function_dconf_watch_func, NULL, NULL);
	client = _tmp0_;
	_tmp1_ = g_strdup (args[2]);
	path = _tmp1_;
	dconf_is_path (path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	dconf_client_watch (client, path, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_tmp2_ = g_main_loop_new (NULL, FALSE);
	_tmp3_ = _tmp2_;
	g_main_loop_run (_tmp3_);
	_g_main_loop_unref0 (_tmp3_);
	_g_free0 (path);
	_g_object_unref0 (client);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


void dconf_complete (gchar** args, int args_length1, GError** error) {
	gchar* _tmp0_;
	gchar* suffix;
	gchar* _tmp1_;
	gchar* path;
	gchar _tmp2_;
	_tmp0_ = g_strdup (args[2]);
	suffix = _tmp0_;
	_tmp1_ = g_strdup (args[3]);
	path = _tmp1_;
	if (g_strcmp0 (path, "") == 0) {
		g_print ("/\n");
		_g_free0 (path);
		_g_free0 (suffix);
		return;
	}
	_tmp2_ = string_get (path, (glong) 0);
	if (_tmp2_ == '/') {
		DConfClient* _tmp3_ = NULL;
		DConfClient* client;
		gint last;
		gchar* _tmp7_ = NULL;
		gchar* dir;
		gint _tmp8_;
		gchar** _tmp9_ = NULL;
		_tmp3_ = dconf_client_new (NULL, NULL, NULL, NULL);
		client = _tmp3_;
		last = 0;
		{
			gint i;
			i = 1;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					gchar _tmp5_;
					gchar _tmp6_;
					if (!_tmp4_) {
						i++;
					}
					_tmp4_ = FALSE;
					_tmp5_ = string_get (path, (glong) i);
					if (!(_tmp5_ != '\0')) {
						break;
					}
					_tmp6_ = string_get (path, (glong) i);
					if (_tmp6_ == '/') {
						last = i;
					}
				}
			}
		}
		_tmp7_ = string_substring (path, (glong) 0, (glong) (last + 1));
		dir = _tmp7_;
		_tmp9_ = dconf_client_list (client, dir, &_tmp8_);
		{
			gchar** item_collection;
			int item_collection_length1;
			int item_it;
			item_collection = _tmp9_;
			item_collection_length1 = _tmp8_;
			for (item_it = 0; item_it < _tmp8_; item_it = item_it + 1) {
				gchar* _tmp10_;
				gchar* item;
				_tmp10_ = g_strdup (item_collection[item_it]);
				item = _tmp10_;
				{
					gchar* _tmp11_;
					gchar* full_item;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_;
					_tmp11_ = g_strconcat (dir, item, NULL);
					full_item = _tmp11_;
					_tmp13_ = g_str_has_prefix (full_item, path);
					if (_tmp13_) {
						gboolean _tmp14_;
						_tmp14_ = g_str_has_suffix (item, suffix);
						_tmp12_ = _tmp14_;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						const gchar* _tmp15_ = NULL;
						gboolean _tmp16_;
						_tmp16_ = g_str_has_suffix (full_item, "/");
						if (_tmp16_) {
							_tmp15_ = "";
						} else {
							_tmp15_ = " ";
						}
						g_print ("%s%s\n", full_item, _tmp15_);
					}
					_g_free0 (full_item);
					_g_free0 (item);
				}
			}
			item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (dir);
		_g_object_unref0 (client);
	}
	_g_free0 (path);
	_g_free0 (suffix);
}


void command_mapping_init (CommandMapping *self, const gchar* name, Command func, void* func_target) {
	gchar* _tmp0_;
	Command _tmp1_;
	g_return_if_fail (name != NULL);
	memset (self, 0, sizeof (CommandMapping));
	_tmp0_ = g_strdup (name);
	_g_free0 ((*self).name);
	(*self).name = _tmp0_;
	_tmp1_ = func;
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
	(*self).func = _tmp1_;
	(*self).func_target = func_target;
	(*self).func_target_destroy_notify = NULL;
}


void command_mapping_copy (const CommandMapping* self, CommandMapping* dest) {
	dest->func = self->func;
	dest->name = g_strdup (self->name);
}


void command_mapping_destroy (CommandMapping* self) {
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
	_g_free0 ((*self).name);
}


CommandMapping* command_mapping_dup (const CommandMapping* self) {
	CommandMapping* dup;
	dup = g_new0 (CommandMapping, 1);
	command_mapping_copy (self, dup);
	return dup;
}


void command_mapping_free (CommandMapping* self) {
	command_mapping_destroy (self);
	g_free (self);
}


GType command_mapping_get_type (void) {
	static volatile gsize command_mapping_type_id__volatile = 0;
	if (g_once_init_enter (&command_mapping_type_id__volatile)) {
		GType command_mapping_type_id;
		command_mapping_type_id = g_boxed_type_register_static ("CommandMapping", (GBoxedCopyFunc) command_mapping_dup, (GBoxedFreeFunc) command_mapping_free);
		g_once_init_leave (&command_mapping_type_id__volatile, command_mapping_type_id);
	}
	return command_mapping_type_id__volatile;
}


static void _dconf_help_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_help (args, args_length1, error);
}


static void _dconf_read_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_read (args, args_length1, error);
}


static void _dconf_list_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_list (args, args_length1, error);
}


static void _dconf_write_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_write (args, args_length1, error);
}


static void _dconf_reset_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_reset (args, args_length1, error);
}


static void _dconf_update_command (gchar** args, int args_length1, gpointer self) {
	dconf_update (args, args_length1);
}


static void _dconf_watch_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_watch (args, args_length1, error);
}


static void _dconf_dump_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_dump (args, args_length1, error);
}


static void _dconf_load_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_load (args, args_length1, error);
}


static void _dconf_complete_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_complete (args, args_length1, error);
}


static void _vala_CommandMapping_array_free (CommandMapping* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			command_mapping_destroy (&array[i]);
		}
	}
	g_free (array);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	CommandMapping _tmp0_ = {0};
	CommandMapping _tmp1_ = {0};
	CommandMapping _tmp2_ = {0};
	CommandMapping _tmp3_ = {0};
	CommandMapping _tmp4_ = {0};
	CommandMapping _tmp5_ = {0};
	CommandMapping _tmp6_ = {0};
	CommandMapping _tmp7_ = {0};
	CommandMapping _tmp8_ = {0};
	CommandMapping _tmp9_ = {0};
	CommandMapping _tmp10_ = {0};
	CommandMapping _tmp11_ = {0};
	CommandMapping _tmp12_ = {0};
	CommandMapping _tmp13_ = {0};
	CommandMapping _tmp14_ = {0};
	CommandMapping _tmp15_ = {0};
	CommandMapping _tmp16_ = {0};
	CommandMapping _tmp17_ = {0};
	CommandMapping _tmp18_ = {0};
	CommandMapping _tmp19_ = {0};
	CommandMapping* _tmp20_ = NULL;
	CommandMapping* map;
	gint map_length1;
	gint _map_size_;
	GError* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	g_assert (args_length1 != 0);
	g_set_prgname (args[0]);
	command_mapping_init (&_tmp0_, "help", _dconf_help_command, NULL);
	_tmp1_ = _tmp0_;
	command_mapping_init (&_tmp2_, "read", _dconf_read_command, NULL);
	_tmp3_ = _tmp2_;
	command_mapping_init (&_tmp4_, "list", _dconf_list_command, NULL);
	_tmp5_ = _tmp4_;
	command_mapping_init (&_tmp6_, "write", _dconf_write_command, NULL);
	_tmp7_ = _tmp6_;
	command_mapping_init (&_tmp8_, "reset", _dconf_reset_command, NULL);
	_tmp9_ = _tmp8_;
	command_mapping_init (&_tmp10_, "update", _dconf_update_command, NULL);
	_tmp11_ = _tmp10_;
	command_mapping_init (&_tmp12_, "watch", _dconf_watch_command, NULL);
	_tmp13_ = _tmp12_;
	command_mapping_init (&_tmp14_, "dump", _dconf_dump_command, NULL);
	_tmp15_ = _tmp14_;
	command_mapping_init (&_tmp16_, "load", _dconf_load_command, NULL);
	_tmp17_ = _tmp16_;
	command_mapping_init (&_tmp18_, "_complete", _dconf_complete_command, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_new0 (CommandMapping, 10);
	_tmp20_[0] = _tmp1_;
	_tmp20_[1] = _tmp3_;
	_tmp20_[2] = _tmp5_;
	_tmp20_[3] = _tmp7_;
	_tmp20_[4] = _tmp9_;
	_tmp20_[5] = _tmp11_;
	_tmp20_[6] = _tmp13_;
	_tmp20_[7] = _tmp15_;
	_tmp20_[8] = _tmp17_;
	_tmp20_[9] = _tmp19_;
	map = _tmp20_;
	map_length1 = 10;
	_map_size_ = 10;
	if (args[1] == NULL) {
		GError* _tmp21_ = NULL;
		_tmp21_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "no command specified");
		_inner_error_ = _tmp21_;
		goto __catch0_g_error;
	}
	{
		CommandMapping* mapping_collection;
		int mapping_collection_length1;
		int mapping_it;
		mapping_collection = map;
		mapping_collection_length1 = map_length1;
		for (mapping_it = 0; mapping_it < map_length1; mapping_it = mapping_it + 1) {
			CommandMapping _tmp22_;
			CommandMapping _tmp23_ = {0};
			CommandMapping mapping;
			command_mapping_copy (&mapping_collection[mapping_it], &_tmp23_);
			_tmp22_ = _tmp23_;
			mapping = _tmp22_;
			{
				if (g_strcmp0 (mapping.name, args[1]) == 0) {
					mapping.func (args, args_length1, mapping.func_target, &_inner_error_);
					if (_inner_error_ != NULL) {
						command_mapping_destroy (&mapping);
						goto __catch0_g_error;
					}
					result = 0;
					command_mapping_destroy (&mapping);
					map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
					return result;
				}
				command_mapping_destroy (&mapping);
			}
		}
	}
	_tmp24_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "unknown command %s", args[1]);
	_inner_error_ = _tmp24_;
	goto __catch0_g_error;
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "error: %s\n\n", e->message);
		show_help (FALSE, args[1]);
		result = 1;
		_g_error_free0 (e);
		map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
		return result;
	}
	__finally0:
	map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



