/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __COUCHDB_GLIB_H__
#define __COUCHDB_GLIB_H__

#include <glib-object.h>

#define COUCHDB_TYPE                (couchdb_get_type ())
#define COUCHDB(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), COUCHDB_TYPE, CouchDB))
#define COUCHDB_IS(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COUCHDB_TYPE))
#define COUCHDB_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), COUCHDB_TYPE, CouchDBClass))
#define COUCHDB_IS_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), COUCHDB_TYPE))
#define COUCHDB_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), COUCHDB_TYPE, CouchDBClass))

typedef struct _CouchDB CouchDB;
typedef struct {
	GObjectClass parent_class;
} CouchDBClass;

GType    couchdb_get_type (void);
CouchDB *couchdb_new (const char *hostname);

/*
 * Databases API
 */

GSList     *couchdb_list_databases (CouchDB *couchdb, GError **error);

typedef struct {
	char *dbname;
	gint doc_count;
	gint doc_del_count;
	gint update_seq;
	gboolean compact_running;
	gint disk_size;
} CouchDBDatabaseInfo;

CouchDBDatabaseInfo *couchdb_get_database_info (CouchDB *couchdb, const char *dbname, GError **error);
void                 couchdb_free_database_info (CouchDBDatabaseInfo *dbinfo);

gboolean couchdb_create_database (CouchDB *couchdb, const char *dbname, GError **error);
gboolean couchdb_delete_database (CouchDB *couchdb, const char *dbname, GError **error);

void couchdb_free_database_list (GSList *dblist);

/*
 * Documents API
 */
typedef struct {
	char *docid;
	char *current_revision;
} CouchDBDocumentInfo;

#define COUCHDB_TYPE_DOCUMENT                (couchdb_document_get_type ())
#define COUCHDB_DOCUMENT(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), COUCHDB_TYPE_DOCUMENT, CouchDBDocument))
#define COUCHDB_IS_DOCUMENT(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COUCHDB_TYPE_DOCUMENT))
#define COUCHDB_DOCUMENT_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), COUCHDB_TYPE_DOCUMENT, CouchDBDocumentClass))
#define COUCHDB_IS_DOCUMENT_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), COUCHDB_TYPE_DOCUMENT))
#define COUCHDB_DOCUMENT_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), COUCHDB_TYPE_DOCUMENT, CouchDBDocumentClass))

typedef struct _CouchDBDocument CouchDBDocument;
typedef struct {
	GObjectClass parent_class;
} CouchDBDocumentClass;

GSList *couchdb_list_documents (CouchDB *couchdb, const char *dbname, GError **error);

CouchDBDocument *couchdb_document_new (CouchDB *couchdb);
CouchDBDocument *couchdb_document_get (CouchDB *couchdb,
				       const char *dbname,
				       const char *docid,
				       GError **error);
const char      *couchdb_document_get_id (CouchDBDocument *document);
void             couchdb_document_set_id (CouchDBDocument *document, const char *id);

const char      *couchdb_document_get_revision (CouchDBDocument *document);

gboolean    couchdb_document_get_boolean_field (CouchDBDocument *document, const char *field);
void        couchdb_document_set_boolean_field (CouchDBDocument *document, const char *field, gboolean value);
gint        couchdb_document_get_int_field (CouchDBDocument *document, const char *field);
void        couchdb_document_set_int_field (CouchDBDocument *document, const char *field, gint value);
gdouble     couchdb_document_get_double_field (CouchDBDocument *document, const char *field);
void        couchdb_document_set_double_field (CouchDBDocument *document, const char *field, gdouble value);
const char *couchdb_document_get_string_field (CouchDBDocument *document, const char *field);
void        couchdb_document_set_string_field (CouchDBDocument *document, const char *field, const char *value);

char            *couchdb_document_to_string (CouchDBDocument *document);


#endif
