// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TYPES_H
#define _CLUTTERMM_TYPES_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>
#include <cogl/cogl.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _ClutterKnot ClutterKnot; }
#endif

namespace Cogl
{
typedef CoglAngle Angle;
typedef CoglFixed Fixed;
} // namespace Cogl

namespace Clutter
{

typedef ClutterEvent Event;
typedef ClutterButtonEvent ButtonEvent;
typedef ClutterKeyEvent KeyEvent;
typedef ClutterMotionEvent MotionEvent;
typedef ClutterScrollEvent ScrollEvent;
typedef ClutterCrossingEvent CrossingEvent;

//TODO: Maybe redefine these, to avoid including a C header in our C++ header:

class InitError : public Glib::Error
{
public:
  enum Code
  {
    INIT_SUCCESS = 1,
    UNKNOWN = 0,
    THREADS = -1,
    BACKEND = -2,
    INTERNAL = -3
  };

  InitError(Code error_code, const Glib::ustring& error_message);
  explicit InitError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Clutter

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::InitError::Code> : public Glib::Value_Enum<Clutter::InitError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum AnimationMode
{
  CUSTOM_MODE,
  LINEAR,
  EASE_IN_QUAD,
  EASE_OUT_QUAD,
  EASE_IN_OUT_QUAD,
  EASE_IN_CUBIC,
  EASE_OUT_CUBIC,
  EASE_IN_OUT_CUBIC,
  EASE_IN_QUART,
  EASE_OUT_QUART,
  EASE_IN_OUT_QUART,
  EASE_IN_QUINT,
  EASE_OUT_QUINT,
  EASE_IN_OUT_QUINT,
  EASE_IN_SINE,
  EASE_OUT_SINE,
  EASE_IN_OUT_SINE,
  EASE_IN_EXPO,
  EASE_OUT_EXPO,
  EASE_IN_OUT_EXPO,
  EASE_IN_CIRC,
  EASE_OUT_CIRC,
  EASE_IN_OUT_CIRC,
  EASE_IN_ELASTIC,
  EASE_OUT_ELASTIC,
  EASE_IN_OUT_ELASTIC,
  EASE_IN_BACK,
  EASE_OUT_BACK,
  EASE_IN_OUT_BACK,
  EASE_IN_BOUNCE,
  EASE_OUT_BOUNCE,
  EASE_IN_OUT_BOUNCE,
  ANIMATION_LAST
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::AnimationMode> : public Glib::Value_Enum<Clutter::AnimationMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/**
 * @ingroup cluttermmEnums
 */
enum RotateDirection
{
  ROTATE_CW,
  ROTATE_CCW
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::RotateDirection> : public Glib::Value_Enum<Clutter::RotateDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/**
 * @ingroup cluttermmEnums
 */
enum RotateAxis
{
  X_AXIS,
  Y_AXIS,
  Z_AXIS
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::RotateAxis> : public Glib::Value_Enum<Clutter::RotateAxis>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/**
 * @ingroup cluttermmEnums
 */
enum Gravity
{
  GRAVITY_NONE,
  GRAVITY_NORTH,
  GRAVITY_NORTH_EAST,
  GRAVITY_EAST,
  GRAVITY_SOUTH_EAST,
  GRAVITY_SOUTH,
  GRAVITY_SOUTH_WEST,
  GRAVITY_WEST,
  GRAVITY_NORTH_WEST,
  GRAVITY_CENTER
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::Gravity> : public Glib::Value_Enum<Clutter::Gravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/**
 * @ingroup cluttermmEnums
 */
enum RequestMode
{
  REQUEST_HEIGHT_FOR_WIDTH,
  REQUEST_WIDTH_FOR_HEIGHT
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::RequestMode> : public Glib::Value_Enum<Clutter::RequestMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/**
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%FontFlags operator|(FontFlags, FontFlags)</tt><br>
 * <tt>%FontFlags operator&(FontFlags, FontFlags)</tt><br>
 * <tt>%FontFlags operator^(FontFlags, FontFlags)</tt><br>
 * <tt>%FontFlags operator~(FontFlags)</tt><br>
 * <tt>%FontFlags& operator|=(FontFlags&, FontFlags)</tt><br>
 * <tt>%FontFlags& operator&=(FontFlags&, FontFlags)</tt><br>
 * <tt>%FontFlags& operator^=(FontFlags&, FontFlags)</tt><br>
 */
enum FontFlags
{
  FONT_MIPMAPPING = (1 << 0),
  FONT_HINTING = (1 << 1)
};

/** @ingroup cluttermmEnums */
inline FontFlags operator|(FontFlags lhs, FontFlags rhs)
  { return static_cast<FontFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline FontFlags operator&(FontFlags lhs, FontFlags rhs)
  { return static_cast<FontFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline FontFlags operator^(FontFlags lhs, FontFlags rhs)
  { return static_cast<FontFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline FontFlags operator~(FontFlags flags)
  { return static_cast<FontFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline FontFlags& operator|=(FontFlags& lhs, FontFlags rhs)
  { return (lhs = static_cast<FontFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline FontFlags& operator&=(FontFlags& lhs, FontFlags rhs)
  { return (lhs = static_cast<FontFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline FontFlags& operator^=(FontFlags& lhs, FontFlags rhs)
  { return (lhs = static_cast<FontFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::FontFlags> : public Glib::Value_Flags<Clutter::FontFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/**
 * @ingroup cluttermmEnums
 */
enum TextDirection
{
  TEXT_DIRECTION_DEFAULT,
  TEXT_DIRECTION_LTR,
  TEXT_DIRECTION_RTL
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::TextDirection> : public Glib::Value_Enum<Clutter::TextDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Vertex
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Vertex CppObjectType;
  typedef ClutterVertex BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Vertex();

  explicit Vertex(const ClutterVertex* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterVertex*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterVertex* gobj() const { return &gobject_; }

protected:
  ClutterVertex gobject_;

private:
  
public:
  Vertex(float x, float y, float z = 0);

   float get_x() const;
    void set_x(const float& value);
    float get_y() const;
    void set_y(const float& value);
    float get_z() const;
    void set_z(const float& value);
 

};

class Geometry
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Geometry CppObjectType;
  typedef ClutterGeometry BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Geometry();

  explicit Geometry(const ClutterGeometry* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterGeometry*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterGeometry* gobj() const { return &gobject_; }

protected:
  ClutterGeometry gobject_;

private:
  
public:
  Geometry(int x, int y, guint width = 0, guint height = 0);

   int get_x() const;
   void set_x(int x);
   int get_y() const;
   void set_y(int y);
  void set_xy(int x, int y);

   guint get_width() const;
   void set_width(guint width);
   guint get_height() const;
   void set_height(guint height);
  void set_size(guint width, guint height);


};

class Knot
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Knot CppObjectType;
  typedef ClutterKnot BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  explicit Knot(ClutterKnot* gobject, bool make_a_copy = true);

  Knot(const Knot& other);
  Knot& operator=(const Knot& other);

  ~Knot();

  void swap(Knot& other);

  ///Provides access to the underlying C instance.
  ClutterKnot*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterKnot* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  ClutterKnot* gobj_copy() const;

protected:
  ClutterKnot* gobject_;

private:

  
public:

  // NOTE: _CUSTOM_DEFAULT_CTOR must be used on the last class definition
  // as it "falls through" to any following definitions in the same file.
  
  Knot();
  Knot(int x, int y);

   int get_x() const;
   void set_x(int x);
   int get_y() const;
   void set_y(int y);
  void set_xy(int x, int y);


};

} // namespace Clutter


namespace Glib
{

/** @relates Clutter::Vertex
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Vertex& wrap(ClutterVertex* object);

/** @relates Clutter::Vertex
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Vertex& wrap(const ClutterVertex* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Vertex> : public Glib::Value_Boxed<Clutter::Vertex>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{

/** @relates Clutter::Geometry
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Geometry& wrap(ClutterGeometry* object);

/** @relates Clutter::Geometry
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Geometry& wrap(const ClutterGeometry* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Geometry> : public Glib::Value_Boxed<Clutter::Geometry>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Clutter
{

/** @relates Clutter::Knot
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Knot& lhs, const Knot& rhs);

/** @relates Clutter::Knot
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Knot& lhs, const Knot& rhs);


} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Knot
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Knot& lhs, Knot& rhs)
  { lhs.swap(rhs); }

} // namespace Clutter

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Clutter::Knot
 */
Clutter::Knot wrap(ClutterKnot* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Knot> : public Glib::Value_Boxed<Clutter::Knot>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _CLUTTERMM_TYPES_H */

