// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_EFFECTTEMPLATE_H
#define _CLUTTERMM_EFFECTTEMPLATE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/alpha.h>
#include <cluttermm/actor.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterEffectTemplate ClutterEffectTemplate;
typedef struct _ClutterEffectTemplateClass ClutterEffectTemplateClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class EffectTemplate_Class; } // namespace Clutter
namespace Clutter
{


class EffectTemplate :
  public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef EffectTemplate CppObjectType;
  typedef EffectTemplate_Class CppClassType;
  typedef ClutterEffectTemplate BaseObjectType;
  typedef ClutterEffectTemplateClass BaseClassType;

private:  friend class EffectTemplate_Class;
  static CppClassType effecttemplate_class_;

private:
  // noncopyable
  EffectTemplate(const EffectTemplate&);
  EffectTemplate& operator=(const EffectTemplate&);

protected:
  explicit EffectTemplate(const Glib::ConstructParams& construct_params);
  explicit EffectTemplate(ClutterEffectTemplate* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~EffectTemplate();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterEffectTemplate*       gobj()       { return reinterpret_cast<ClutterEffectTemplate*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterEffectTemplate* gobj() const { return reinterpret_cast<ClutterEffectTemplate*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterEffectTemplate* gobj_copy();

private:


public:
  typedef sigc::slot<guint32, const Glib::RefPtr<Alpha>&> SlotAlphaFunc;
  typedef sigc::slot<void, const Glib::RefPtr<Actor>&> SlotEffectCompleteFunc;

protected:
  EffectTemplate(const Glib::RefPtr<Timeline>& timeline, const SlotAlphaFunc& alpha_func);
  EffectTemplate(guint msecs, const SlotAlphaFunc& alpha_func);
  

public:
  
  static Glib::RefPtr<EffectTemplate> create(const Glib::RefPtr<Timeline>& timeline, const SlotAlphaFunc& alpha_func);

  
  static Glib::RefPtr<EffectTemplate> create(guint msecs, const SlotAlphaFunc& alpha_func);


  /** Sets if effects using this template should make a copy of the
   * templates timeline (default) or reference the effects timeline.
   * 
   * Since: 0.6
   * @param setting A boolean indicating if effects should clone the timeline.
   */
  void set_timeline_clone(bool setting);
  
  /** Gets whether timelines should be cloned when creating a new
   * effect or just referenced.
   * @return <tt>true</tt> if the templates timeline is to be cloned.
   * 
   * Since: 0.6.
   */
  bool get_timeline_clone() const;

  
  /** Simple effect for fading a single Clutter::Actor.
   * @param template A Clutter::EffectTemplate.
   * @param actor A Clutter::Actor to apply the effect to.
   * @param opacity_end Final opacity value to apply to actor.
   * @param func A Clutter::EffectCompleteFunc to call on effect
   * completion or <tt>0</tt>.
   * @param data Data to pass to supplied  Clutter::EffectCompleteFunc
   * or <tt>0</tt>.
   * @return A Clutter::Timeline for the effect. Will be unrefed by
   * the effect when completed.
   * 
   * Since: 0.6.
   */

  Glib::RefPtr<Timeline> fade(const Glib::RefPtr<Actor>& actor, guint8 opacity_end, const SlotEffectCompleteFunc& func);

  
  /** Simple effect for changing the depth of a single Clutter::Actor.
   * @param template A Clutter::EffectTemplate.
   * @param actor A Clutter::Actor to apply the effect to.
   * @param depth_end Final depth value to apply to actor.
   * @param func A Clutter::EffectCompleteFunc to call on effect
   * completion or <tt>0</tt>.
   * @param data Data to pass to supplied  Clutter::EffectCompleteFunc
   * or <tt>0</tt>.
   * @return A Clutter::Timeline for the effect. Will be unrefed by
   * the effect when completed.
   * 
   * Since: 0.6.
   */

  Glib::RefPtr<Timeline> depth(const Glib::RefPtr<Actor>& actor, int depth_end, const SlotEffectCompleteFunc& func);

  
  /** Simple effect for moving a single Clutter::Actor along to a
   * destination point.
   * @param template A Clutter::EffectTemplate.
   * @param actor A Clutter::Actor to apply the effect to.
   * @param x X coordinate of the destination.
   * @param y Y coordinate of the destination.
   * @param func A Clutter::EffectCompleteFunc to call on effect
   * completion or <tt>0</tt>.
   * @param data Data to pass to supplied  Clutter::EffectCompleteFunc
   * or <tt>0</tt>.
   * @return A Clutter::Timeline for the effect. Will be unreferenced by
   * the effect when completed.
   * 
   * Since: 0.6.
   */

  Glib::RefPtr<Timeline> move(const Glib::RefPtr<Actor>& actor, int x, int y, const SlotEffectCompleteFunc& func);

  // TODO: Use C++ container for knots
  
  /** Simple effect for moving a single Clutter::Actor along a path.
   * @param template A Clutter::EffectTemplate.
   * @param actor A Clutter::Actor to apply the effect to.
   * @param knots An array of Clutter::Knots representing path for the actor.
   * @param n_knots Number of Clutter::Knots in passed array.
   * @param func A Clutter::EffectCompleteFunc to call on effect
   * completion or <tt>0</tt>.
   * @param data Data to pass to supplied  Clutter::EffectCompleteFunc
   * or <tt>0</tt>.
   * @return A Clutter::Timeline for the effect. Will be unreferenced by
   * the effect when completed.
   * 
   * Since: 0.6.
   */

  Glib::RefPtr<Timeline> path(const Glib::RefPtr<Actor>& actor, const ClutterKnot* knots, guint n_knots, const SlotEffectCompleteFunc& func);

  
  /** Simple effect for scaling a single Clutter::Actor.
   * @param template A Clutter::EffectTemplate.
   * @param actor A Clutter::Actor to apply the effect to.
   * @param x_scale_end Final X axis scale factor to apply to actor.
   * @param y_scale_end Final Y axis scale factor to apply to actor.
   * @param func A Clutter::EffectCompleteFunc to call on effect
   * completion or <tt>0</tt>.
   * @param data Data to pass to supplied  Clutter::EffectCompleteFunc
   * or <tt>0</tt>.
   * @return A Clutter::Timeline for the effect. Will be unreferenced by
   * the effect when completed.
   * 
   * Since: 0.6.
   */

  Glib::RefPtr<Timeline> scale(const Glib::RefPtr<Actor>& actor, double x_scale_end, double y_scale_end, const SlotEffectCompleteFunc& func);

  
  /** Simple effect for rotating a single Clutter::Actor.
   * @param template A Clutter::EffectTemplate.
   * @param actor A Clutter::Actor to apply the effect to.
   * @param axis Axis of rotation.
   * @param angle Final angle to apply to actor.
   * @param center_x Position on X axis to rotate about.
   * @param center_y Position on Y axis to rotate about.
   * @param center_z Position on Z axis to rotate about.
   * @param direction A Clutter::RotateDirection for the rotation.
   * @param func A Clutter::EffectCompleteFunc to call on effect
   * completion or <tt>0</tt>.
   * @param data User data to pass to supplied @a func or <tt>0</tt>.
   * @return A Clutter::Timeline for the effect. Will be unreferenced by
   * the effect when completed.
   * 
   * Since: 0.6.
   */

  Glib::RefPtr<Timeline> rotate(const Glib::RefPtr<Actor>& actor, RotateAxis axis, double angle_end, int center_x, int center_y, int center_z, RotateDirection direction, const SlotEffectCompleteFunc& func);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeline to use as a reference for the Template.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Timeline> > property_timeline() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** controls if effects should clone or reference the templated timeline.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_clone() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** controls if effects should clone or reference the templated timeline.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_clone() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::EffectTemplate
   */
  Glib::RefPtr<Clutter::EffectTemplate> wrap(ClutterEffectTemplate* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_EFFECTTEMPLATE_H */

