// Generated by gtkmmproc -- DO NOT MODIFY!


#include <cluttermm/color.h>
#include <cluttermm/private/color_p.h>

/* Copyright (C) 2007 The cluttermm Development Team

 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Clutter
{

Color::Color()
{
  // the set_from_*() functions don't modify the alpha value of the color, so
  // default to max alpha since that's probably the most common case
  ClutterColor tmp = { 0, 0, 0, 255 };
  gobject_ = clutter_color_copy(&tmp);
}

Color::Color(const Glib::ustring& color)
{
  // the set_from_*() functions don't modify the alpha value of the color, so
  // default to max alpha since that's probably the most common case
  ClutterColor tmp = { 0, 0, 0, 255 };
  gobject_ = clutter_color_copy(&tmp);
  set_from_string(color);
}

Color::Color(guint8 red, guint8 green, guint8 blue, guint8 alpha)
{
  ClutterColor tmp = { red, green, blue, alpha };
  gobject_ = clutter_color_copy(&tmp);
}

Color::Color(guint32 pixel)
{
  // the set_from_*() functions don't modify the alpha value of the color, so
  // default to max alpha since that's probably the most common case
  ClutterColor tmp = { 0, 0, 0, 255 };
  gobject_ = clutter_color_copy(&tmp);
  set_from_pixel(pixel);
}

void Color::set_from_string(const Glib::ustring& color)
{
  clutter_color_parse(color.c_str(), this->gobj());
}

void Color::set_from_rgb(guint8 red, guint8 blue, guint8 green)
{
    gobj()->red = red;
    gobj()->green = green;
    gobj()->blue = blue;
}

void set_from_rgb(guint8 red, guint8 blue, guint8 green);

Color Color::add(const Color& color) const
{
  return *this + color;
}

Color Color::subtract(const Color& color) const
{
  return *this - color;
}

void Color::darken()
{
    clutter_color_darken(this->gobj(), this->gobj());
}

void Color::shade(double shade)
{
    clutter_color_shade(this->gobj(), this->gobj(), shade);
}

void Color::shadex(Fixed shade)
{
    clutter_color_shadex(this->gobj(), this->gobj(), shade);
}

void Color::lighten()
{
    clutter_color_lighten(this->gobj(), this->gobj());
}

Color operator+(const Color& color1, const Color& color2)
{
  Color result;
  clutter_color_add(color1.gobj(), color2.gobj(), result.gobj());
  return result;
}

Color operator-(const Color& color1, const Color& color2)
{
  Color result;
  clutter_color_subtract(color1.gobj(), color2.gobj(), result.gobj());
  return result;
}

} //namespace Clutter


namespace
{
} // anonymous namespace


namespace Glib
{

Clutter::Color wrap(ClutterColor* object, bool take_copy)
{
  return Clutter::Color(object, take_copy);
}

} // namespace Glib


namespace Clutter
{


// static
GType Color::get_type()
{
  return clutter_color_get_type();
}


Color::Color(const Color& other)
:
  gobject_ ((other.gobject_) ? clutter_color_copy(other.gobject_) : 0)
{}

Color::Color(ClutterColor* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? clutter_color_copy(gobject) : gobject)
{}

Color& Color::operator=(const Color& other)
{
  Color temp (other);
  swap(temp);
  return *this;
}

Color::~Color()
{
  if(gobject_)
    clutter_color_free(gobject_);
}

void Color::swap(Color& other)
{
  ClutterColor *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

ClutterColor* Color::gobj_copy() const
{
  return clutter_color_copy(gobject_);
}


Glib::ustring Color::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(clutter_color_to_string(const_cast<ClutterColor*>(gobj())));
}

void Color::set_from_hls(guint8 hue, guint8 luminance, guint8 saturation)
{
clutter_color_from_hls(gobj(), hue, luminance, saturation); 
}

void Color::set_from_hlsx(Fixed hue, Fixed luminance, Fixed saturation)
{
clutter_color_from_hlsx(gobj(), hue, luminance, saturation); 
}

void Color::to_hls(guint8& hue, guint8& luminance, guint8& saturation) const
{
clutter_color_to_hls(const_cast<ClutterColor*>(gobj()), &(hue), &(luminance), &(saturation)); 
}

void Color::to_hlsx(Fixed& hue, Fixed& luminance, Fixed& saturation) const
{
clutter_color_to_hlsx(const_cast<ClutterColor*>(gobj()), &(hue), &(luminance), &(saturation)); 
}

void Color::set_from_pixel(guint32 pixel)
{
clutter_color_from_pixel(gobj(), pixel); 
}

guint32 Color::to_pixel() const
{
  return clutter_color_to_pixel(const_cast<ClutterColor*>(gobj()));
}

 guint8 Color::get_red() const
{
  return gobj()->red;
}
 
 void Color::set_red(const guint8& value)
{
  gobj()->red = value;
}
 
 guint8 Color::get_green() const
{
  return gobj()->green;
}
 
 void Color::set_green(const guint8& value)
{
  gobj()->green = value;
}
 
 guint8 Color::get_blue() const
{
  return gobj()->blue;
}
 
 void Color::set_blue(const guint8& value)
{
  gobj()->blue = value;
}
 
 guint8 Color::get_alpha() const
{
  return gobj()->alpha;
}
 
 void Color::set_alpha(const guint8& value)
{
  gobj()->alpha = value;
}
 

bool operator==(const Color& lhs, const Color& rhs)
{
  return (clutter_color_equal(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const Color& lhs, const Color& rhs)
{
  return (clutter_color_equal(lhs.gobj(), rhs.gobj()) == 0);
}


} // namespace Clutter


