// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTER_BOX2DMM_BOX2D_H
#define _CLUTTER_BOX2DMM_BOX2D_H


#include <glibmm.h>

/* Copyright (C) 2008 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/group.h>
#include <cluttermm/types.h> //For Clutter::Vertex.
#include <clutter-box2d/clutter-box2d-joint.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBox2D ClutterBox2D;
typedef struct _ClutterBox2DClass ClutterBox2DClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

namespace Box2D
{ class Box2D_Class; } // namespace Box2D

} // namespace Clutter
namespace Clutter
{

namespace Box2D
{

/** @addtogroup clutter_box2dmmEnums Enums and Flags */

/**
 * @ingroup clutter_box2dmmEnums
 */
enum Type
{
  BOX2D_NONE,
  BOX2D_DYNAMIC,
  BOX2D_STATIC
};


/** This is a container that can physically simulate collisions between dynamic and static actors.
 * Use set_child_property() on the child actors.
 */

class Box2D :
  public Clutter::Group
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Box2D CppObjectType;
  typedef Box2D_Class CppClassType;
  typedef ClutterBox2D BaseObjectType;
  typedef ClutterBox2DClass BaseClassType;

private:  friend class Box2D_Class;
  static CppClassType box2d_class_;

private:
  // noncopyable
  Box2D(const Box2D&);
  Box2D& operator=(const Box2D&);

protected:
  explicit Box2D(const Glib::ConstructParams& construct_params);
  explicit Box2D(ClutterBox2D* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Box2D();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBox2D*       gobj()       { return reinterpret_cast<ClutterBox2D*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBox2D* gobj() const { return reinterpret_cast<ClutterBox2D*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBox2D* gobj_copy();

private:


protected:
  Box2D();
  

public:
  
  static Glib::RefPtr<Box2D> create();


  void set_simulating(bool simulating = true);
  
  bool get_simulating() const;

  //TODO: Wrap ClutterBox2DJoint properly - ideally it would be a registered type, with hidden implementation.

  
  ClutterBox2DJoint* add_revolute_joint(const Glib::RefPtr<Clutter::Actor>& actor1, const Glib::RefPtr<Clutter::Actor>& actor2, const Clutter::Vertex& anchor1, const Clutter::Vertex& anchor2, double reference_angle);


  ClutterBox2DJoint* add_revolute_joint(const Glib::RefPtr<Clutter::Actor>& actor1, const Glib::RefPtr<Clutter::Actor>& actor2, const Clutter::Vertex& anchor);


  ClutterBox2DJoint* add_distance_joint(const Glib::RefPtr<Clutter::Actor>& actor1,
                                                     const Glib::RefPtr<Clutter::Actor>& actor2,
                                                     const Clutter::Vertex& anchor1,
                                                     const Clutter::Vertex& anchor2,
                                                     double length, double frequency = 0.0, double damping_ratio = 0.0);


  ClutterBox2DJoint* add_prismatic_joint(const Glib::RefPtr<Clutter::Actor>& actor1,
                                                      const Glib::RefPtr<Clutter::Actor>& actor2,
                                                      const ClutterVertex *anchor1,
                                                      const ClutterVertex *anchor2,
                                                      double min_length, double max_length,  const Clutter::Vertex& axis);


//TODO: Remove this conversion when the C API has been fixed. See http://bugzilla.o-hand.com/show_bug.cgi?id=1095
 

  ClutterBox2DJoint* add_mouse_joint(const Glib::RefPtr<Clutter::Actor>& actor, const Clutter::Vertex& target);


  void set_child_linear_velocity(const Glib::RefPtr<Clutter::Actor>& actor, const Clutter::Vertex& linear_velocity);
  Clutter::Vertex get_child_linear_velocity(const Glib::RefPtr<const Clutter::Actor>& actor) const;

  void set_child_angular_velocity(const Glib::RefPtr<Clutter::Actor>& actor, const Clutter::Vertex& angular_velocity);
  Clutter::Vertex get_child_angular_velocity(const Glib::RefPtr<const Clutter::Actor>& actor) const;

  void set_child_is_bullet(const Glib::RefPtr<Clutter::Actor>& actor, bool is_bullet = true);
  bool get_child_is_bullet(const Glib::RefPtr<const Clutter::Actor>& actor) const;

  void set_child_mode(const Glib::RefPtr<Clutter::Actor>& actor, Type mode);
  Type get_child_mode(const Glib::RefPtr<const Clutter::Actor>& actor) const;

  void set_child_manipulatable(const Glib::RefPtr<Clutter::Actor>& actor, bool manipulatable = true);
  bool get_child_manipulatable(const Glib::RefPtr<const Clutter::Actor>& actor) const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The gravity of .
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Clutter::Vertex> property_gravity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether ClutterBox2D is performing physical simulation or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_simulating() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether ClutterBox2D is performing physical simulation or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_simulating() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Box2D

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Box2D::Box2D
   */
  Glib::RefPtr<Clutter::Box2D::Box2D> wrap(ClutterBox2D* object, bool take_copy = false);
}


#endif /* _CLUTTER_BOX2DMM_BOX2D_H */

