#
# This file is part of ChronoJump
#
# Chronojump is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or   
#    (at your option) any later version.
#    
# Chronojump is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
#    GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Copyright (C) 2010   Xavier de Blas <xaviblas@gmail.com> , Carlos J. Gil Bellosta <cgb@datanalytics.com>
#

data <- read.csv2('pointsDump.csv',na.strings = "", sep=";", dec = ",", header=T)

#OpenCV has the 0 of the Y on the top, and R on the bottom. Change it
#maxY = max(data$hipY, data$kneeY, data$toeY)
maxX = 512
maxY = 384
data$hipY = maxY - data$hipY
data$kneeY = maxY - data$kneeY
data$toeY = maxY - data$toeY

#predict.all.fix.1 <- function( x, span, threshold = 3 ){
predict.all.fix.1 <- function( x, span = 30 / length(x), threshold = 3 ){
   time <- 1:length(x)

   resid  <- x - predict( loess( x ~ time, span = span ), time )
   x.outlier <- abs(resid) > threshold * sd(resid)

   time.1 <- time[!x.outlier]
   x.1      <- x[!x.outlier]

   predict( loess( x.1 ~ time.1, span = span ), time )
}

predict.next.fix.1 <- function( x, span = 30, threshold = 3, discard = 10 )
{
       if( length(x) < discard )
               return( x[ length( x ) ] )

       which.predict <- max( 1, length(x) - span):length(x)
       time.1 <- 1:length( which.predict )
       x.1    <- x[ which.predict ]

       resid  <- x.1 - predict( lm( x.1 ~ time.1 ), data.frame( time.1 = time.1 ) )
       x.outlier <- abs( resid ) > threshold * sd( resid )

       time.1   <- time.1[!x.outlier]
       x.1      <- x.1   [!x.outlier]

       round ( 
		       predict( lm( x.1 ~ time.1 ), newdata = data.frame( time.1 = length( time.1 ) + 1 ) ) 
     )
}



#Pruebo la función con ruido pero sin atípicos
#plot( predict.all.fix.1( data$hipY) ~ predict.all.fix.1( data$hipX ) )
#Pruebo la función con ruido y atípicos
#data$hipX[150] <- 90
#plot( predict.all.fix.1( data$hipY) ~ predict.all.fix.1( data$hipX ) )

#see graph of all three points
#col = rainbow(nrow(data))
#plot(data$hipY ~ data$hipX, xlim=c(0,512), ylim=c(0,384), col=col, xlab="", ylab="" )
#points(data$kneeY ~ data$kneeX, col=col)
#points(data$toeY ~ data$toeX, col=col)

#plot( predict.all.fix.1(data$hipY, .1) ~ predict.all.fix.1(data$hipX, .1), xlim=c(0,512), ylim=c(0,384), col=col, xlab="", ylab="" )
#points( predict.all.fix.1(data$kneeY, .2) ~ predict.all.fix.1(data$kneeX, .2) , col=col)
#points( predict.all.fix.1(data$toeY, .3) ~ predict.all.fix.1(data$toeX, .3) , col=col)


#see what happens with every point
#plot(data$hipY ~ data$hipX)
#plot( predict.all.fix.1(data$hipY, .1) ~ predict.all.fix.1(data$hipX, .1) )

#plot(data$kneeY ~ data$kneeX)
#plot( predict.all.fix.1(data$kneeY, .2) ~ predict.all.fix.1(data$kneeX, .2) )

#plot(data$toeY ~ data$toeX)
#plot( predict.all.fix.1(data$toeY, .3) ~ predict.all.fix.1(data$toeX, .3) )

#make outliers work:
#data$toeY[200]
#[1] 44
#data$toeY[200]=48

#plot(data$toeY ~ data$toeX)
#plot( predict.all.fix.1( data$toeY) ~ predict.all.fix.1( data$toeX ) )

results = c(
predict.next.fix.1 (data$hipX), predict.next.fix.1 (data$hipY), 
predict.next.fix.1 (data$kneeX), predict.next.fix.1 (data$kneeY), 
predict.next.fix.1 (data$toeX), predict.next.fix.1 (data$toeY)
)

write(results, file="results.csv", ncolumns=6, sep=";")



