/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <bakery/App/App_WithDoc_Gtk.h>
#include <bakery/App/GtkDialogs.h>
#include <gtkmm/stock.h>
#include <fstream>
#include <algorithm>
#include <libintl.h>

//#include <gtk/gtkfilesel.h>


namespace Bakery
{


//Initialize static member data:

App_WithDoc_Gtk::App_WithDoc_Gtk(const Glib::ustring& appname)
: App_WithDoc(appname),
  App_Gtk(appname),
  m_pMenuItem_File_Save(0), m_pToolbarItem_Save(0)
{
}

App_WithDoc_Gtk::~App_WithDoc_Gtk()
{
 
}


void App_WithDoc_Gtk::init()
{
  App_WithDoc::init(); //Create document and ask to show it in the UI.
  show();
}

void App_WithDoc_Gtk::init_toolbars()
{
  App_Gtk::init_toolbars();

  //And add some more items:
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::OPEN, SigC::slot(*this, &App_WithDoc::on_menu_file_open)) );
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::SAVE, SigC::slot(*this, &App_WithDoc::on_menu_file_save)) );
  m_pToolbarItem_Save = m_Toolbar.tools().back().get_widget(); //Remember the widget so we can disable it later.
}

void App_WithDoc_Gtk::init_menus_file()
{
  // File menu

  //Build menu:

  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::NEW, SigC::slot(*this, &App_WithDoc::on_menu_file_new)));
  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::OPEN, SigC::slot(*this, &App_WithDoc::on_menu_file_open)));

  m_Menu_File.items().push_back(Gtk::Menu_Helpers::MenuElem(gettext("_Recent Files"), m_SubMenu_RecentFiles));
  
  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::SAVE, SigC::slot(*this, &App_WithDoc::on_menu_file_save)));
  m_pMenuItem_File_Save = &(m_Menu_File.items().back()); //Remember the widget so we can disable it later.
  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::SAVE_AS, SigC::slot(*this, &App_WithDoc::on_menu_file_saveas)));

  m_Menu_File.items().push_back(Gtk::Menu_Helpers::SeparatorElem());

  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::CLOSE, SigC::slot(*this, &App_WithDoc::on_menu_file_close)));
  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::QUIT, SigC::slot(*this, &App_WithDoc::on_menu_file_exit)));

  //Add menu:
  m_MenuBar.items().push_back(Gtk::Menu_Helpers::MenuElem(gettext("_File"), m_Menu_File));
}


void App_WithDoc_Gtk::update_window_title()
{
  //Set application's main window title:

  Glib::ustring strTitle = m_strAppName;
  Document* pDoc = get_document();
  if(pDoc)
  {
    strTitle += " - " + pDoc->get_name();

    //Indicate unsaved changes:
    if(pDoc->get_modified())
      strTitle += " *";

    set_title(strTitle);
  }
}


void App_WithDoc_Gtk::show_document_history()
{
  //Clear existing sub menu items:
  m_SubMenu_RecentFiles.items().clear();
   
  //Add new sub menu items:
  guint index = 0;
  for(App_WithDoc::type_vecStrings::iterator iter = m_vecDocHistory.begin(); iter != m_vecDocHistory.end(); iter++)
  {
    Glib::ustring strName = *iter;
    if(!strName.empty())
    {
      strName = Document::util_filepath_get_name(strName);
      m_SubMenu_RecentFiles.items().push_back( Gtk::Menu_Helpers::MenuElem(
        strName,
        SigC::bind<guint>(SigC::slot(*this, &App_WithDoc::on_menu_file_open_recent), index) ) );
    }

    index++;
  }
}

void App_WithDoc_Gtk::ui_warning(const Glib::ustring& text)
{
  GtkDialogs::ui_warning(text);
}

Glib::ustring App_WithDoc_Gtk::ui_file_select_open()
{
  return GtkDialogs::ui_file_select_open();
}

Glib::ustring App_WithDoc_Gtk::ui_file_select_save(const Glib::ustring& old_filepath)
{
  return GtkDialogs::ui_file_select_save(old_filepath);
}

void App_WithDoc_Gtk::ui_show_modification_status()
{
  bool modified = m_pDocument->get_modified();
  
  //Enable Save and SaveAs menu items:
  if(m_pMenuItem_File_Save)
    m_pMenuItem_File_Save->set_sensitive(modified);

  if(m_pToolbarItem_Save)
    m_pToolbarItem_Save->set_sensitive(modified);
}

App_WithDoc_Gtk::enumSaveChanges App_WithDoc_Gtk::ui_offer_to_save_changes()
{
  return GtkDialogs::ui_offer_to_save_changes(m_pDocument->get_filepath());
}

bool App_WithDoc_Gtk::ui_ask_overwrite(const std::string& filepath)
{
  return GtkDialogs::ui_ask_overwrite(m_pDocument->get_filepath());
}
  

} //namespace
