/* Atomix -- a little mind game about atoms and molecules.
 * Copyright (C) 1999 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "board.h"
#include "preferences.h"
#include "theme.h"
#include "level.h"
#include "main.h"
#include "gtk-time-limit.h"

void
on_new_game_activate(GtkMenuItem     *menuitem,
                     gpointer         user_data)
{
	game_new();
}

void
on_pause_game_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	game_pause();

}
void
on_continue_game_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	game_continue();
}

void
on_undo_move_activate(GtkMenuItem     *menuitem,
                      gpointer         user_data)
{
	game_undo_move();
}


void
on_score_activate(GtkMenuItem     *menuitem,
		  gpointer         user_data)
{
	gnome_scores_display("Atomix", "atomix", NULL, 0);	
}


void
on_exit_activate(GtkWidget    *menuitem,
                 gpointer         user_data)
{
	if(get_game_state() == GAME_RUNNING)
	{
		game_user_quits();

		if(get_game_state() == GAME_NOT_RUNNING)
		{
			GtkWidget *app;
			app = get_app();
			g_return_if_fail(app != NULL);
			gtk_widget_destroy(app);    
		}
	}
	else
	{
		/* quit application */
		GtkWidget *app;
		app = get_app();
		g_return_if_fail(app != NULL);
		gtk_widget_destroy(app);    
	}
}


void
on_preferences_activate(GtkMenuItem     *menuitem,
                        gpointer         user_data)
{
	preferences_show_dialog();
}


void
on_about_activate(GtkMenuItem     *menuitem,
                  gpointer         user_data)
{
	GtkWidget* dlg;
	dlg = create_dlg_about();
	gtk_widget_show(dlg);
}


gboolean
on_app_destroy_event(GtkWidget       *widget,
                     GdkEvent        *event,
                     gpointer         user_data)
{
	board_destroy();
	
	if(get_actual_level())
	{
		level_destroy(get_actual_level());
	}
	if(get_actual_theme())
	{
		theme_destroy(get_actual_theme());
	}
	preferences_destroy();
	level_destroy_hash_table();
	theme_destroy_hash_table();
	gtk_main_quit();
	
	return TRUE;
}


/* This function ist used to remove all canvas items 
   (look at board_clear())*/
void
destroy_item(gpointer ptr, gpointer data)
{
	GtkObject* obj;

	obj = GTK_OBJECT (ptr);
	gtk_object_destroy(obj);
}


/* just to create my selfmade widget gtk_time_limit */
GtkWidget*
create_time_limit_widget (gchar *widget_name, gchar *string1, gchar *string2,
			  gint int1, gint int2)
{
	GtkWidget *alignment;
	GtkWidget *time_limit;
	
	alignment = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
	time_limit = gtk_time_limit_new();
	gtk_widget_show(time_limit);
	gtk_container_add(GTK_CONTAINER(alignment), time_limit);

	return alignment;
}


void
on_skip_level_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	game_skip_level();
}


void
on_leveleditor_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	static gchar *command[] = { "atomixed" }; 
	
	gnome_execute_async(NULL, 1, command);
}


gboolean
on_key_press_event           (GtkWidget       *widget,
			      GdkEventKey     *event,
			      gpointer         user_data)
{
	if(get_game_state() == GAME_RUNNING)
	{
		board_handle_key_event(event);
	}
	
	return TRUE;
}



void
on_end_game_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	game_user_quits();
}


gboolean
on_delete_event                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	on_exit_activate(widget, 0);
	
	return TRUE;
}


void
on_manual_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar *helpfile;

	helpfile = gnome_help_file_find_file("atomix", "atomix.html");
	
	if(helpfile != NULL)
	{
		gchar *url;
		
		url = g_strconcat("ghelp:", helpfile, NULL);
		
		gnome_help_goto(NULL, url);
		
		g_free(url);
		g_free(helpfile);
	}
	else
	{
		gnome_error_dialog(_("Couldn't find the Atomix manual!"));
	}
}


void
on_dlg_properties_help                 (GnomePropertyBox *gnomepropertybox,
                                        gint             pagenum,
                                        gpointer         user_data)
{
	static GnomeHelpMenuEntry help_entry = { "atomix", "preferences.html" };

	gnome_help_pbox_goto(NULL, 0, &help_entry);
}

