/* Atomixed -- the level-/themeeditor for atomix.
 * Copyright (C) 1999-2000 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef _ATOMIXED_IMAGE_WIN_CTRL_H 
#define _ATOMIXED_IMAGE_WIN_CTRL_H 

#include <gnome.h>
#include "theme.h"

typedef enum { 
	IMG_WIN_CTRL_SET, 
	IMG_WIN_CTRL_MOVE, 
	IMG_WIN_CTRL_CLEAR 
} MouseFunction;

void image_win_ctrl_init(GtkWidget *win);

void image_win_ctrl_destroy(void);

void image_win_ctrl_set_theme(Theme *theme);

void image_win_ctrl_update_theme(Theme *theme, ThemeImageKind hint);

void image_win_ctrl_select_obstacle(gint icon);

void image_win_ctrl_select_moveable(gint icon);

void image_win_ctrl_select_connection(gint icon);

void image_win_ctrl_unselect_connection(gint icon);

Tile* image_win_ctrl_get_actual_tile(void);

void image_win_ctrl_set_actual_tile(Tile *tile);

void image_win_ctrl_set_mouse_function(MouseFunction func);

MouseFunction image_win_ctrl_get_mouse_function(void);

#endif /* _ATOMIXED_IMAGE_WIN_CTRL_H  */

