'''
IPython console plugin.

@author: Eitan Isaacson
@organization: IBM Corporation
@copyright: Copyright (c) 2007 IBM Corporation
@license: BSD

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD which accompanies this distribution, and 
is available at U{http://www.opensource.org/licenses/bsd-license.php}
'''
import accerciser.plugin
import os
import pyLinAcc
import gtk
import ipython_view

if ipython_view.IPython == None:
  raise RuntimeError('The IPython module is required for the IPython console')
 

class Console(accerciser.plugin.ViewportPlugin):
  plugin_name = 'IPython console'
  plugin_description = 'Interactive console for manipulating currently selected accessible'
  def init(self):
    sw = gtk.ScrolledWindow()
    self.plugin_area.add(sw)
    self.ipython_view = ipython_view.IPythonView()
    self.ipython_view.updateNamespace({'acc': None})
    self.ipython_view.updateNamespace(pyLinAcc.__dict__)
    self.ipython_view.updateNamespace(pyLinAcc.Constants.__dict__)
    self.ipython_view.updateNamespace(pyLinAcc.Interfaces.__dict__)
    self.ipython_view.updateNamespace({'show': self._showAcc})
    sw.add(self.ipython_view)
  
  def onAccChanged(self, acc):
    self.ipython_view.updateNamespace({'acc': acc})

  def _showAcc(self, acc):
    self.node.update(acc)
