/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class TimeDurationDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private DatatypeValidator fBaseValidator = null;
    private String fPattern = null;
    private long fMaxInclusive = 0L;
    private long fMaxExclusive = 0L;
    private long fMinInclusive = 0L;
    private long fMinExclusive = 0L;
    private long fDuration = 0L;
    private long fPeriod = 0L;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;
    private int fFacetsDefined = 0;
    private boolean fDerivedByList = false;
    private long[] fEnumTimeDuration = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();

    public TimeDurationDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public TimeDurationDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        if (datatypeValidator != null) {
            this.setBasetype(datatypeValidator);
        }
        this.fDerivedByList = bl;
        if (hashtable != null && !this.fDerivedByList) {
            String string;
            Object object;
            if (this.fBaseValidator != null) {
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (string2.equals("pattern")) {
                        this.fFacetsDefined += 8;
                        this.fPattern = (String)hashtable.get(string2);
                        continue;
                    }
                    if (string2.equals("enumeration")) {
                        this.fFacetsDefined += 16;
                        continue;
                    }
                    if (string2.equals("maxInclusive")) {
                        this.fFacetsDefined += 32;
                        string = null;
                        try {
                            string = (String)hashtable.get(string2);
                            this.fMaxInclusive = TimeDurationDatatypeValidator.normalizeDuration(string.toCharArray(), 0);
                            continue;
                        }
                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, string2}));
                        }
                    }
                    if (string2.equals("maxExclusive")) {
                        this.fFacetsDefined += 64;
                        string = null;
                        try {
                            string = (String)hashtable.get(string2);
                            this.fMaxExclusive = TimeDurationDatatypeValidator.normalizeDuration(string.toCharArray(), 0);
                            continue;
                        }
                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, string2}));
                        }
                    }
                    if (string2.equals("minInclusive")) {
                        this.fFacetsDefined += 128;
                        string = null;
                        try {
                            string = (String)hashtable.get(string2);
                            this.fMinInclusive = TimeDurationDatatypeValidator.normalizeDuration(string.toCharArray(), 0);
                            continue;
                        }
                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, string2}));
                        }
                    }
                    if (string2.equals("minExclusive")) {
                        this.fFacetsDefined += 128;
                        string = null;
                        try {
                            string = (String)hashtable.get(string2);
                            this.fMinExclusive = TimeDurationDatatypeValidator.normalizeDuration(string.toCharArray(), 0);
                            continue;
                        }
                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                            throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, string2}));
                        }
                    }
                    throw new InvalidDatatypeFacetException(this.getErrorString(1, 0, null));
                }
            }
            this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
            this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
            this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
            boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
            if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
            }
            if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
            if ((this.fFacetsDefined & 0x10) != 0 && (object = (Vector)hashtable.get("enumeration")) != null) {
                this.fEnumTimeDuration = new long[((Vector)object).size()];
                int n = 0;
                string = null;
                try {
                    while (n < ((Vector)object).size()) {
                        string = (String)((Vector)object).elementAt(n);
                        this.fEnumTimeDuration[n] = TimeDurationDatatypeValidator.normalizeDuration(string.toCharArray(), 0);
                        this.boundsCheck(this.fEnumTimeDuration[n]);
                        ++n;
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new InvalidDatatypeFacetException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                }
            }
        }
    }

    private void boundsCheck(long l) throws InvalidDatatypeFacetException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isMaxInclusiveDefined) {
            bl = l <= this.fMaxInclusive;
        } else if (this.isMaxExclusiveDefined) {
            boolean bl3 = bl = l < this.fMaxExclusive;
        }
        if (this.isMinInclusiveDefined) {
            bl2 = l >= this.fMinInclusive;
        } else if (this.isMinExclusiveDefined) {
            boolean bl4 = bl2 = l > this.fMinExclusive;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeFacetException(this.getErrorString(9, 0, new Object[]{new Long(l)}));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        return -1;
    }

    private void enumCheck(long l) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumTimeDuration.length) {
            if (l == this.fEnumTimeDuration[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{new Long(l)}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public Hashtable getFacets() {
        return null;
    }

    private static final int indexOf(char[] cArray, int n, char c) {
        return TimeDurationDatatypeValidator.indexOf(cArray, n, c, cArray.length - 1);
    }

    private static final int indexOf(char[] cArray, int n, char c, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            if (cArray[n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static final int indexOneOf(char[] cArray, int n, String string) {
        return TimeDurationDatatypeValidator.indexOneOf(cArray, n, string, cArray.length - 1);
    }

    private static final int indexOneOf(char[] cArray, int n, String string, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < string.length()) {
                if (cArray[n3] == string.charAt(n4)) {
                    return n3;
                }
                ++n4;
            }
            ++n3;
        }
        return -1;
    }

    public static long normalizeDuration(char[] cArray, int n) throws InvalidDatatypeValueException {
        int n2;
        int n3;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = 0;
        int n7 = n;
        int n8 = 0;
        int n9 = n3 = n + cArray.length - 1;
        char[] cArray2 = new char[]{'Y', 'M', 'D'};
        char[] cArray3 = new char[]{'H', 'M', 'S'};
        char[] cArray4 = new char[]{'0', '0', '0'};
        int[] nArray = new int[17];
        n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = 0;
            ++n4;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        Calendar calendar = null;
        Calendar calendar2 = null;
        try {
            if (cArray[n7] == '-') {
                bl6 = true;
            }
            if ((n2 = TimeDurationDatatypeValidator.indexOf(cArray, n, '/')) > -1 && n2 < n3) {
                if (cArray[n2 + 1] == '-') {
                    bl7 = true;
                }
                if (cArray[bl6 ? n7 + 1 : n7] == 'P') {
                    if (bl6) {
                        ++n7;
                    }
                    bl8 = true;
                    n9 = n2 - 1;
                } else {
                    calendar = (GregorianCalendar)TimeDurationDatatypeValidator.normalizeInstant(cArray, n7, n2 - n7);
                }
                if (cArray[bl7 ? n2 + 2 : n2 + 1] == 'P') {
                    bl9 = true;
                    n7 = bl7 ? n2 + 2 : n2 + 1;
                } else {
                    calendar2 = (GregorianCalendar)TimeDurationDatatypeValidator.normalizeInstant(cArray, ++n2, n3 - n2 + 1);
                }
            } else {
                int n10 = n7 = bl6 ? n + 1 : n;
            }
            if (calendar != null && calendar2 != null) {
                return calendar2.getTime().getTime() - calendar.getTime().getTime();
            }
            if (bl8 && bl9) {
                throw new ParseException("Period cannot be expressed as 2 durations.", 0);
            }
            if (bl8 && cArray[n7] != 'P') {
                throw new ParseException("Invalid start character for timeDuration:" + cArray[n7], n7);
            }
            if (bl9 && cArray[n7] != 'P') {
                throw new ParseException("Invalid start character for timeDuration:" + cArray[n7], n7);
            }
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException(exception.toString());
        }
        try {
            n8 = n7 + 1;
            n4 = n7 + 1;
            while (n4 <= n9) {
                if (Character.isDigit(cArray[n4]) || cArray[n4] == '.') {
                    if (cArray[n4] == '.') {
                        bl5 = true;
                    }
                } else if (cArray[n4] == 'T') {
                    bl4 = true;
                    n6 = 0;
                    n8 = n4 + 1;
                } else {
                    n6 = TimeDurationDatatypeValidator.indexOf(bl4 ? cArray3 : cArray2, n6, cArray[n4]);
                    if (n6 == -1) {
                        throw new ParseException("Illegal or misplaced separator.", n4);
                    }
                    ++n6;
                    if (bl5 && cArray[n4] != 'S') {
                        throw new ParseException("Fractional digits allowed only for 'seconds'.", n4);
                    }
                    bl = false;
                    switch (cArray[n4]) {
                        case 'Y': {
                            if (bl4) {
                                throw new ParseException("Year must be specified before 'T' separator.", n4);
                            }
                            nArray[1] = TimeDurationDatatypeValidator.parseInt(cArray, n8, n4 - n8);
                            break;
                        }
                        case 'D': {
                            if (bl4) {
                                throw new ParseException("Days must be specified before 'T' separator.", n4);
                            }
                            nArray[5] = TimeDurationDatatypeValidator.parseInt(cArray, n8, n4 - n8);
                            break;
                        }
                        case 'H': {
                            if (!bl4) {
                                throw new ParseException("Hours must be specified after 'T' separator.", n4);
                            }
                            nArray[11] = TimeDurationDatatypeValidator.parseInt(cArray, n8, n4 - n8);
                            break;
                        }
                        case 'M': {
                            nArray[bl4 ? 12 : 2] = TimeDurationDatatypeValidator.parseInt(cArray, n8, n4 - n8);
                            break;
                        }
                        case 'S': {
                            if (!bl4) {
                                throw new ParseException("Seconds must be specified after 'T' separator.", n4);
                            }
                            if (!bl5) {
                                nArray[13] = TimeDurationDatatypeValidator.parseInt(cArray, n8, n4 - n8);
                                break;
                            }
                            n2 = TimeDurationDatatypeValidator.indexOf(cArray, n8, '.');
                            nArray[13] = TimeDurationDatatypeValidator.parseInt(cArray, n8, n2 - n8);
                            ++n2;
                            n5 = 0;
                            while (n2 <= n9 && n5 < 3 && Character.isDigit(cArray[n2])) {
                                cArray4[n5++] = cArray[n2++];
                            }
                            nArray[14] = TimeDurationDatatypeValidator.parseInt(cArray4, 0, 3);
                            bl5 = false;
                            break;
                        }
                        default: {
                            throw new ParseException("Illegal 'picture' character: " + cArray[n4], n4);
                        }
                    }
                    n8 = n4 + 1;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException(exception.toString());
        }
        try {
            if (calendar != null) {
                long l = calendar.getTime().getTime();
                n5 = 0;
                while (n5 < nArray.length) {
                    if (nArray[n5] != 0) {
                        ((GregorianCalendar)calendar).add(n5, bl7 ? -nArray[n5] : nArray[n5]);
                    }
                    ++n5;
                }
                long l2 = calendar.getTime().getTime();
                return l2 - l;
            }
            if (calendar2 != null) {
                long l = calendar2.getTime().getTime();
                n5 = 0;
                while (n5 < nArray.length) {
                    if (nArray[n5] > 0) {
                        ((GregorianCalendar)calendar2).add(n5, bl6 ? nArray[n5] : -nArray[n5]);
                    }
                    ++n5;
                }
                long l3 = calendar2.getTime().getTime();
                return l3 - l;
            }
            long l = ((long)nArray[1] * 31104000L + (long)nArray[2] * 2592000L + (long)nArray[5] * 86400L + (long)nArray[11] * 3600L + (long)nArray[12] * 60L + (long)nArray[13]) * 1000L + (long)nArray[14];
            return bl6 ? -l : l;
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException(exception.toString());
        }
    }

    public static Calendar normalizeInstant(char[] cArray, int n, int n2) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        int n7 = 0;
        int n8 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        char[] cArray2 = new char[]{'0', '0', '0'};
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n9 = n + n2 - 1;
        try {
            if (n2 < 16) {
                throw new ParseException("Value is too short.", 0);
            }
            gregorianCalendar.clear();
            gregorianCalendar.setLenient(false);
            if (cArray[n6] == '-' || cArray[n6] == '+') {
                gregorianCalendar.set(0, cArray[n6] == '-' ? 0 : 1);
                ++n6;
            }
            if ((n7 = TimeDurationDatatypeValidator.indexOf(cArray, n6, '-', n6 + 5)) == -1 || n7 > n9) {
                throw new ParseException("Year separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(1, TimeDurationDatatypeValidator.parseInt(cArray, n6, n7 - n6));
            n6 = n7 + 1;
            gregorianCalendar.set(2, TimeDurationDatatypeValidator.parseInt(cArray, n6, 2) - 1);
            if (cArray[n6 += 2] != '-') {
                throw new ParseException("Month separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(5, TimeDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2));
            if (cArray[n6 += 3] != 'T') {
                throw new ParseException("Time separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(11, TimeDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2));
            if (cArray[n6 += 3] != ':') {
                throw new ParseException("Hour separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(12, TimeDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2));
            if (n9 - (n6 += 3) > 1 && cArray[n6] == ':') {
                gregorianCalendar.set(13, TimeDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2));
                if ((n6 += 3) < n9 && cArray[n6] == '.') {
                    ++n6;
                    n8 = 0;
                    while (n6 <= n9 && n8 < 3 && Character.isDigit(cArray[n6])) {
                        cArray2[n8++] = cArray[n6++];
                    }
                    gregorianCalendar.set(14, TimeDurationDatatypeValidator.parseInt(cArray2, 0, 3));
                }
                while (n6 <= n9 && Character.isDigit(cArray[n6])) {
                    ++n6;
                }
            }
            if (n6 <= n9) {
                if (cArray[n6] == 'Z') {
                    gregorianCalendar.set(15, 0);
                } else if (cArray[n6] == '-' || cArray[n6] == '+') {
                    bl2 = cArray[n6] == '-';
                    n4 = TimeDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2);
                    if (n9 - n6 == 5) {
                        if (cArray[n6 + 3] != ':') {
                            throw new ParseException("time zone must be 'hh:mm'.", n6);
                        }
                        n5 = TimeDurationDatatypeValidator.parseInt(cArray, n6 + 4, 2);
                    }
                    n3 = n4 * 3600000 + n5 * 60000;
                    gregorianCalendar.set(15, bl2 ? -n3 : n3);
                } else {
                    throw new ParseException("Unrecognized time zone.", n6);
                }
            }
            return gregorianCalendar;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidDatatypeValueException("Unable to parse timeInstant " + exception.toString());
        }
    }

    private static final int parseInt(char[] cArray, int n, int n2) throws NumberFormatException {
        int n3;
        if (cArray == null) {
            throw new NumberFormatException("null");
        }
        int n4 = 10;
        int n5 = 0;
        boolean bl = false;
        int n6 = n;
        int n7 = 0;
        if (n2 <= 0) {
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        if (cArray[n6] == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n6;
        } else if (cArray[n6] == '+') {
            bl = false;
            n3 = -2147483647;
            ++n6;
        } else {
            n3 = -2147483647;
        }
        int n8 = n3 / n4;
        if (n6 < n + n2) {
            if ((n7 = Character.digit(cArray[n6++], n4)) < 0) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            n5 = -n7;
        }
        while (n6 < n + n2) {
            if ((n7 = Character.digit(cArray[n6++], n4)) < 0) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            if (n5 < n8) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            if ((n5 *= n4) < n3 + n7) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            n5 -= n7;
        }
        if (bl) {
            if (n6 > 1) {
                return n5;
            }
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        return -n5;
    }

    public void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public void setLocale(Locale locale) {
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (!this.fDerivedByList) {
            RegularExpression regularExpression;
            if (this.fPattern != null && !(regularExpression = new RegularExpression(this.fPattern, "X")).matches(string)) {
                throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
            }
            long l = TimeDurationDatatypeValidator.normalizeDuration(string.toCharArray(), 0);
            try {
                this.boundsCheck(l);
            }
            catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
                throw new InvalidDatatypeValueException("Boundary Exception");
            }
            if (this.fEnumTimeDuration != null) {
                this.enumCheck(l);
            }
        }
        return null;
    }
}

