/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.Serializable;
import org.w3c.dom.Node;

public class NodeVector
implements Serializable {
    private int m_blocksize;
    protected Node[] m_map;
    private int m_firstFree = 0;
    private int m_mapSize;

    public NodeVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new Node[this.m_blocksize];
    }

    public NodeVector(int n) {
        this.m_blocksize = n;
        this.m_mapSize = n;
        this.m_map = new Node[n];
    }

    public final void addElement(Node node) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
            this.m_map = nodeArray;
        }
        this.m_map[this.m_firstFree] = node;
        ++this.m_firstFree;
    }

    public final void appendNodes(NodeVector nodeVector) {
        int n = nodeVector.size();
        if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += n + this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + n);
            this.m_map = nodeArray;
        }
        System.arraycopy(nodeVector.m_map, 0, this.m_map, this.m_firstFree, n);
        this.m_firstFree += n;
    }

    public final boolean contains(Node node) {
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final Node elementAt(int n) {
        return this.m_map[n];
    }

    public final int indexOf(Node node) {
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final int indexOf(Node node, int n) {
        int n2 = n;
        while (n2 < this.m_firstFree) {
            Node node2 = this.m_map[n2];
            if (node2 != null && node2.equals(node)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final void insertElementAt(Node node, int n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
            this.m_map = nodeArray;
        }
        if (n <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n, this.m_map, n + 1, this.m_firstFree - n);
        }
        this.m_map[n] = node;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        int n = 0;
        while (n < this.m_firstFree) {
            this.m_map[n] = null;
            ++n;
        }
        this.m_firstFree = 0;
    }

    public final boolean removeElement(Node node) {
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                if (n > this.m_firstFree) {
                    System.arraycopy(this.m_map, n + 1, this.m_map, n - 1, this.m_firstFree - n);
                } else {
                    this.m_map[n] = null;
                }
                --this.m_firstFree;
                return true;
            }
            ++n;
        }
        return false;
    }

    public final void removeElementAt(int n) {
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n - 1, this.m_firstFree - n);
        } else {
            this.m_map[n] = null;
        }
    }

    public final void setElementAt(Node node, int n) {
        this.m_map[n] = node;
    }

    public final int size() {
        return this.m_firstFree;
    }
}

