/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CharacterDataImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements CharacterData,
Text {
    static final long serialVersionUID = -5294980852957403469L;

    public TextImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string);
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public boolean isIgnorableWhitespace() {
        if (this.syncData()) {
            this.synchronizeData();
        }
        return this.ignorableWhitespace();
    }

    public void setIgnorableWhitespace(boolean bl) {
        if (this.syncData()) {
            this.synchronizeData();
        }
        this.ignorableWhitespace(bl);
    }

    public Text splitText(int n) throws DOMException {
        if (this.readOnly()) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (this.syncData()) {
            this.synchronizeData();
        }
        if (n < 0 || n > this.data.length() - 1) {
            throw new DOMExceptionImpl(1, "DOM004 Index out of bounds");
        }
        Text text = this.getOwnerDocument().createTextNode(this.data.substring(n));
        this.setNodeValue(this.data.substring(0, n));
        Node node = this.getParentNode();
        if (node != null) {
            node.insertBefore(text, this.nextSibling);
        }
        return text;
    }
}

