/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.util.Arrays;
import org.apache.uniffle.common.ShufflePartitionedBlock;

public class ShufflePartitionedData {
    private int partitionId;
    private ShufflePartitionedBlock[] blockList;

    public ShufflePartitionedData(int partitionId, ShufflePartitionedBlock[] blockList) {
        this.partitionId = partitionId;
        this.blockList = blockList;
    }

    public String toString() {
        return "ShufflePartitionedData{partitionId=" + this.partitionId + ", blockList=" + Arrays.toString(this.blockList) + '}';
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public ShufflePartitionedBlock[] getBlockList() {
        if (this.blockList == null) {
            return new ShufflePartitionedBlock[0];
        }
        return this.blockList;
    }

    public long getTotalBlockSize() {
        if (this.blockList == null) {
            return 0L;
        }
        long size = 0L;
        for (ShufflePartitionedBlock block : this.blockList) {
            size += block.getSize();
        }
        return size;
    }
}

