/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl.grpc;

import java.util.concurrent.TimeUnit;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.impl.grpc.GrpcClient;
import org.apache.uniffle.client.request.RssPartitionToShuffleServerRequest;
import org.apache.uniffle.client.request.RssReassignFaultyShuffleServerRequest;
import org.apache.uniffle.client.request.RssReassignServersRequest;
import org.apache.uniffle.client.request.RssReportShuffleFetchFailureRequest;
import org.apache.uniffle.client.request.RssReportShuffleWriteFailureRequest;
import org.apache.uniffle.client.response.RssPartitionToShuffleServerResponse;
import org.apache.uniffle.client.response.RssReassignFaultyShuffleServerResponse;
import org.apache.uniffle.client.response.RssReassignServersReponse;
import org.apache.uniffle.client.response.RssReportShuffleFetchFailureResponse;
import org.apache.uniffle.client.response.RssReportShuffleWriteFailureResponse;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.proto.ShuffleManagerGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleManagerGrpcClient
extends GrpcClient
implements ShuffleManagerClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleManagerGrpcClient.class);
    private static RssBaseConf rssConf = new RssBaseConf();
    private long rpcTimeout = rssConf.getLong(RssBaseConf.RSS_CLIENT_TYPE_GRPC_TIMEOUT_MS);
    private ShuffleManagerGrpc.ShuffleManagerBlockingStub blockingStub = ShuffleManagerGrpc.newBlockingStub(this.channel);

    public ShuffleManagerGrpcClient(String host, int port) {
        this(host, port, 3);
    }

    public ShuffleManagerGrpcClient(String host, int port, int maxRetryAttempts) {
        this(host, port, maxRetryAttempts, true);
    }

    public ShuffleManagerGrpcClient(String host, int port, int maxRetryAttempts, boolean usePlaintext) {
        super(host, port, maxRetryAttempts, usePlaintext);
    }

    public ShuffleManagerGrpc.ShuffleManagerBlockingStub getBlockingStub() {
        return (ShuffleManagerGrpc.ShuffleManagerBlockingStub)this.blockingStub.withDeadlineAfter(this.rpcTimeout, TimeUnit.MILLISECONDS);
    }

    public String getDesc() {
        return "Shuffle manager grpc client ref " + this.host + ":" + this.port;
    }

    @Override
    public RssReportShuffleFetchFailureResponse reportShuffleFetchFailure(RssReportShuffleFetchFailureRequest request) {
        RssProtos.ReportShuffleFetchFailureRequest protoRequest = request.toProto();
        try {
            RssProtos.ReportShuffleFetchFailureResponse response = this.getBlockingStub().reportShuffleFetchFailure(protoRequest);
            return RssReportShuffleFetchFailureResponse.fromProto(response);
        }
        catch (Exception e) {
            String msg = "Report shuffle fetch failure to host:port[" + this.host + ":" + this.port + "] failed";
            LOG.warn(msg, (Throwable)e);
            throw new RssException(msg, e);
        }
    }

    @Override
    public RssPartitionToShuffleServerResponse getPartitionToShufflerServer(RssPartitionToShuffleServerRequest req) {
        RssProtos.PartitionToShuffleServerRequest protoRequest = req.toProto();
        RssProtos.PartitionToShuffleServerResponse partitionToShufflerServer = this.getBlockingStub().getPartitionToShufflerServer(protoRequest);
        RssPartitionToShuffleServerResponse rssPartitionToShuffleServerResponse = RssPartitionToShuffleServerResponse.fromProto(partitionToShufflerServer);
        return rssPartitionToShuffleServerResponse;
    }

    @Override
    public RssReportShuffleWriteFailureResponse reportShuffleWriteFailure(RssReportShuffleWriteFailureRequest request) {
        RssProtos.ReportShuffleWriteFailureRequest protoRequest = request.toProto();
        try {
            RssProtos.ReportShuffleWriteFailureResponse response = this.getBlockingStub().reportShuffleWriteFailure(protoRequest);
            return RssReportShuffleWriteFailureResponse.fromProto(response);
        }
        catch (Exception e) {
            String msg = "Report shuffle fetch failure to host:port[" + this.host + ":" + this.port + "] failed";
            LOG.warn(msg, (Throwable)e);
            throw new RssException(msg, e);
        }
    }

    @Override
    public RssReassignServersReponse reassignShuffleServers(RssReassignServersRequest req) {
        RssProtos.ReassignServersRequest reassignServersRequest = req.toProto();
        RssProtos.ReassignServersReponse reassignServersReponse = this.getBlockingStub().reassignShuffleServers(reassignServersRequest);
        return RssReassignServersReponse.fromProto(reassignServersReponse);
    }

    @Override
    public RssReassignFaultyShuffleServerResponse reassignFaultyShuffleServer(RssReassignFaultyShuffleServerRequest request) {
        RssProtos.RssReassignFaultyShuffleServerRequest rssReassignFaultyShuffleServerRequest = request.toProto();
        RssProtos.RssReassignFaultyShuffleServerResponse response = this.getBlockingStub().reassignFaultyShuffleServer(rssReassignFaultyShuffleServerRequest);
        return RssReassignFaultyShuffleServerResponse.fromProto(response);
    }
}

