/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.util.List;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.storage.handler.api.ClientReadHandler;
import org.apache.uniffle.storage.handler.impl.AbstractClientReadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiReplicaClientReadHandler
extends AbstractClientReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MultiReplicaClientReadHandler.class);
    private final List<ClientReadHandler> handlers;
    private final List<ShuffleServerInfo> shuffleServerInfos;
    private final Roaring64NavigableMap blockIdBitmap;
    private final Roaring64NavigableMap processedBlockIds;
    private int readHandlerIndex;

    public MultiReplicaClientReadHandler(List<ClientReadHandler> handlers, List<ShuffleServerInfo> shuffleServerInfos, Roaring64NavigableMap blockIdBitmap, Roaring64NavigableMap processedBlockIds) {
        this.handlers = handlers;
        this.blockIdBitmap = blockIdBitmap;
        this.processedBlockIds = processedBlockIds;
        this.shuffleServerInfos = shuffleServerInfos;
    }

    @Override
    public ShuffleDataResult readShuffleData() {
        ShuffleDataResult result = null;
        while (this.readHandlerIndex < this.handlers.size()) {
            ClientReadHandler handler = this.handlers.get(this.readHandlerIndex);
            try {
                result = handler.readShuffleData();
            }
            catch (Exception e) {
                LOG.warn("Failed to read a replica from [{}] due to ", (Object)this.shuffleServerInfos.get(this.readHandlerIndex).getId(), (Object)e);
            }
            if (result != null && !result.isEmpty()) {
                return result;
            }
            try {
                RssUtils.checkProcessedBlockIds(this.blockIdBitmap, this.processedBlockIds);
                return result;
            }
            catch (RssException e) {
                LOG.warn("Finished read from [{}], but haven't finished read all the blocks.", (Object)this.shuffleServerInfos.get(this.readHandlerIndex).getId(), (Object)e);
                ++this.readHandlerIndex;
                continue;
            }
            break;
        }
        return result;
    }

    @Override
    public void updateConsumedBlockInfo(BufferSegment bs, boolean isSkippedMetrics) {
        super.updateConsumedBlockInfo(bs, isSkippedMetrics);
        this.handlers.get(Math.min(this.readHandlerIndex, this.handlers.size() - 1)).updateConsumedBlockInfo(bs, isSkippedMetrics);
    }

    @Override
    public void logConsumedBlockInfo() {
        super.logConsumedBlockInfo();
        this.handlers.forEach(ClientReadHandler::logConsumedBlockInfo);
    }
}

