/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage.hybrid;

import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.storage.AbstractStorageManagerFallbackStrategy;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.server.storage.hybrid.FallbackBasedStorageManagerSelector;

public class DefaultStorageManagerSelector
extends FallbackBasedStorageManagerSelector {
    private final long flushColdStorageThresholdSize;

    public DefaultStorageManagerSelector(StorageManager warmStorageManager, StorageManager coldStorageManager, AbstractStorageManagerFallbackStrategy fallbackStrategy, ShuffleServerConf rssConf) {
        super(warmStorageManager, coldStorageManager, fallbackStrategy);
        this.flushColdStorageThresholdSize = (Long)rssConf.get(ShuffleServerConf.FLUSH_COLD_STORAGE_THRESHOLD_SIZE);
    }

    @Override
    StorageManager regularSelect(ShuffleDataFlushEvent flushEvent) {
        StorageManager storageManager = this.warmStorageManager;
        if (flushEvent.getSize() > this.flushColdStorageThresholdSize) {
            storageManager = this.coldStorageManager;
        }
        return storageManager;
    }
}

