/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.storage.StorageInfo;
import org.apache.uniffle.server.Checker;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.event.PurgeEvent;
import org.apache.uniffle.server.storage.AbstractStorageManagerFallbackStrategy;
import org.apache.uniffle.server.storage.HadoopStorageManager;
import org.apache.uniffle.server.storage.HadoopStorageManagerFallbackStrategy;
import org.apache.uniffle.server.storage.LocalStorageManager;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.server.storage.hybrid.StorageManagerSelector;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridStorageManager
implements StorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(HybridStorageManager.class);
    private final StorageManager warmStorageManager;
    private final StorageManager coldStorageManager;
    private final StorageManagerSelector storageManagerSelector;

    HybridStorageManager(ShuffleServerConf conf) {
        this.warmStorageManager = new LocalStorageManager(conf);
        this.coldStorageManager = new HadoopStorageManager(conf);
        try {
            AbstractStorageManagerFallbackStrategy storageManagerFallbackStrategy = HybridStorageManager.loadFallbackStrategy(conf);
            this.storageManagerSelector = this.loadManagerSelector(conf, storageManagerFallbackStrategy, this.warmStorageManager, this.coldStorageManager);
        }
        catch (Exception e) {
            throw new RssException("Errors on loading selector manager.", (Throwable)e);
        }
    }

    private StorageManagerSelector loadManagerSelector(ShuffleServerConf conf, AbstractStorageManagerFallbackStrategy storageManagerFallbackStrategy, StorageManager warmStorageManager, StorageManager coldStorageManager) throws Exception {
        String name = (String)conf.get(ShuffleServerConf.HYBRID_STORAGE_MANAGER_SELECTOR_CLASS);
        Class<?> klass = Class.forName(name);
        Constructor<?> constructor = klass.getConstructor(StorageManager.class, StorageManager.class, AbstractStorageManagerFallbackStrategy.class, ((Object)((Object)conf)).getClass());
        StorageManagerSelector instance = (StorageManagerSelector)constructor.newInstance(new Object[]{warmStorageManager, coldStorageManager, storageManagerFallbackStrategy, conf});
        return instance;
    }

    public static AbstractStorageManagerFallbackStrategy loadFallbackStrategy(ShuffleServerConf conf) throws Exception {
        AbstractStorageManagerFallbackStrategy instance;
        String name = conf.getString(ShuffleServerConf.HYBRID_STORAGE_FALLBACK_STRATEGY_CLASS, HadoopStorageManagerFallbackStrategy.class.getCanonicalName());
        Class<?> klass = Class.forName(name);
        try {
            Constructor<?> constructor = klass.getConstructor(((Object)((Object)conf)).getClass(), Boolean.TYPE);
            instance = (AbstractStorageManagerFallbackStrategy)constructor.newInstance(new Object[]{conf});
        }
        catch (NoSuchMethodException e) {
            Constructor<?> constructor = klass.getConstructor(((Object)((Object)conf)).getClass());
            instance = (AbstractStorageManagerFallbackStrategy)constructor.newInstance(new Object[]{conf});
        }
        return instance;
    }

    @Override
    public void registerRemoteStorage(String appId, RemoteStorageInfo remoteStorageInfo) {
        this.coldStorageManager.registerRemoteStorage(appId, remoteStorageInfo);
    }

    @Override
    public Storage selectStorage(ShuffleDataFlushEvent event) {
        return this.selectStorageManager(event).selectStorage(event);
    }

    @Override
    public Storage selectStorage(ShuffleDataReadEvent event) {
        return this.warmStorageManager.selectStorage(event);
    }

    @Override
    public void updateWriteMetrics(ShuffleDataFlushEvent event, long writeTime) {
        throw new UnsupportedOperationException();
    }

    private StorageManager selectStorageManager(ShuffleDataFlushEvent event) {
        StorageManager storageManager = this.storageManagerSelector.select(event);
        return storageManager;
    }

    @Override
    public boolean write(Storage storage, ShuffleWriteHandler handler, ShuffleDataFlushEvent event) {
        StorageManager underStorageManager = this.selectStorageManager(event);
        return underStorageManager.write(storage, handler, event);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Checker getStorageChecker() {
        return this.warmStorageManager.getStorageChecker();
    }

    @Override
    public boolean canWrite(ShuffleDataFlushEvent event) {
        return this.warmStorageManager.canWrite(event) || this.coldStorageManager.canWrite(event);
    }

    @Override
    public void checkAndClearLeakedShuffleData(Collection<String> appIds) {
        this.warmStorageManager.checkAndClearLeakedShuffleData(appIds);
    }

    @Override
    public Map<String, StorageInfo> getStorageInfo() {
        Map<String, StorageInfo> localStorageInfo = this.warmStorageManager.getStorageInfo();
        localStorageInfo.putAll(this.coldStorageManager.getStorageInfo());
        return localStorageInfo;
    }

    @Override
    public void removeResources(PurgeEvent event) {
        LOG.info("Start to remove resource of {}", (Object)event);
        this.warmStorageManager.removeResources(event);
        this.coldStorageManager.removeResources(event);
    }

    public StorageManager getColdStorageManager() {
        return this.coldStorageManager;
    }

    public StorageManager getWarmStorageManager() {
        return this.warmStorageManager;
    }
}

