/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.exception.FileNotFoundException;
import org.apache.uniffle.common.exception.NoBufferException;
import org.apache.uniffle.common.exception.NoBufferForHugePartitionException;
import org.apache.uniffle.common.exception.NoRegisterException;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.BlockIdLayout;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.proto.ShuffleServerGrpc;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleTaskManager;
import org.apache.uniffle.server.buffer.PreAllocatedBufferInfo;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.apache.uniffle.shaded.guava.collect.Maps;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.common.StorageReadMetrics;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerGrpcService
extends ShuffleServerGrpc.ShuffleServerImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleServerGrpcService.class);
    private final ShuffleServer shuffleServer;

    public ShuffleServerGrpcService(ShuffleServer shuffleServer) {
        this.shuffleServer = shuffleServer;
    }

    public void unregisterShuffleByAppId(RssProtos.ShuffleUnregisterByAppIdRequest request, StreamObserver<RssProtos.ShuffleUnregisterByAppIdResponse> responseStreamObserver) {
        String appId = request.getAppId();
        StatusCode result = StatusCode.SUCCESS;
        String responseMessage = "OK";
        try {
            this.shuffleServer.getShuffleTaskManager().removeShuffleDataAsync(appId);
        }
        catch (Exception e) {
            result = StatusCode.INTERNAL_ERROR;
        }
        RssProtos.ShuffleUnregisterByAppIdResponse reply = RssProtos.ShuffleUnregisterByAppIdResponse.newBuilder().setStatus(result.toProto()).setRetMsg(responseMessage).build();
        responseStreamObserver.onNext((Object)reply);
        responseStreamObserver.onCompleted();
    }

    public void unregisterShuffle(RssProtos.ShuffleUnregisterRequest request, StreamObserver<RssProtos.ShuffleUnregisterResponse> responseStreamObserver) {
        String appId = request.getAppId();
        int shuffleId = request.getShuffleId();
        StatusCode result = StatusCode.SUCCESS;
        String responseMessage = "OK";
        try {
            this.shuffleServer.getShuffleTaskManager().removeShuffleDataAsync(appId, shuffleId);
        }
        catch (Exception e) {
            result = StatusCode.INTERNAL_ERROR;
        }
        RssProtos.ShuffleUnregisterResponse reply = RssProtos.ShuffleUnregisterResponse.newBuilder().setStatus(result.toProto()).setRetMsg(responseMessage).build();
        responseStreamObserver.onNext((Object)reply);
        responseStreamObserver.onCompleted();
    }

    public void registerShuffle(RssProtos.ShuffleRegisterRequest req, StreamObserver<RssProtos.ShuffleRegisterResponse> responseObserver) {
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        String remoteStoragePath = req.getRemoteStorage().getPath();
        String user = req.getUser();
        ShuffleDataDistributionType shuffleDataDistributionType = ShuffleDataDistributionType.valueOf((String)Optional.ofNullable(req.getShuffleDataDistribution()).orElse(RssProtos.DataDistribution.NORMAL).name());
        int maxConcurrencyPerPartitionToWrite = req.getMaxConcurrencyPerPartitionToWrite();
        Map<String, String> remoteStorageConf = req.getRemoteStorage().getRemoteStorageConfList().stream().collect(Collectors.toMap(RssProtos.RemoteStorageConfItem::getKey, RssProtos.RemoteStorageConfItem::getValue));
        List<PartitionRange> partitionRanges = this.toPartitionRanges(req.getPartitionRangesList());
        LOG.info("Get register request for appId[" + appId + "], shuffleId[" + shuffleId + "], remoteStorage[" + remoteStoragePath + "] with " + partitionRanges.size() + " partition ranges. User: {}", (Object)user);
        StatusCode result = this.shuffleServer.getShuffleTaskManager().registerShuffle(appId, shuffleId, partitionRanges, new RemoteStorageInfo(remoteStoragePath, remoteStorageConf), user, shuffleDataDistributionType, maxConcurrencyPerPartitionToWrite);
        RssProtos.ShuffleRegisterResponse reply = RssProtos.ShuffleRegisterResponse.newBuilder().setStatus(result.toProto()).build();
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendShuffleData(RssProtos.SendShuffleDataRequest req, StreamObserver<RssProtos.SendShuffleDataResponse> responseObserver) {
        RssProtos.SendShuffleDataResponse reply;
        long transportTime;
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        long requireBufferId = req.getRequireBufferId();
        long timestamp = req.getTimestamp();
        if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
            this.shuffleServer.getGrpcMetrics().recordTransportTime("sendShuffleData", transportTime);
        }
        int requireSize = this.shuffleServer.getShuffleTaskManager().getRequireBufferSize(requireBufferId);
        StatusCode ret = StatusCode.SUCCESS;
        String responseMessage = "OK";
        if (req.getShuffleDataCount() > 0) {
            boolean isPreAllocated;
            ShuffleServerMetrics.counterTotalReceivedDataSize.inc((double)requireSize);
            ShuffleTaskManager manager = this.shuffleServer.getShuffleTaskManager();
            PreAllocatedBufferInfo info = manager.getAndRemovePreAllocatedBuffer(requireBufferId);
            boolean bl = isPreAllocated = info != null;
            if (!isPreAllocated) {
                String errorMsg = "Can't find requireBufferId[" + requireBufferId + "] for appId[" + appId + "], shuffleId[" + shuffleId + "]";
                LOG.warn(errorMsg);
                responseMessage = errorMsg;
                RssProtos.SendShuffleDataResponse reply2 = RssProtos.SendShuffleDataResponse.newBuilder().setStatus(StatusCode.INTERNAL_ERROR.toProto()).setRetMsg(responseMessage).build();
                responseObserver.onNext((Object)reply2);
                responseObserver.onCompleted();
                return;
            }
            long start = System.currentTimeMillis();
            List<ShufflePartitionedData> shufflePartitionedData = this.toPartitionedData(req);
            long alreadyReleasedSize = 0L;
            boolean hasFailureOccurred = false;
            for (ShufflePartitionedData spd : shufflePartitionedData) {
                String shuffleDataInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + spd.getPartitionId() + "]";
                try {
                    ret = manager.cacheShuffleData(appId, shuffleId, isPreAllocated, spd);
                    if (ret != StatusCode.SUCCESS) {
                        String errorMsg = "Error happened when shuffleEngine.write for " + shuffleDataInfo + ", statusCode=" + ret;
                        LOG.error(errorMsg);
                        responseMessage = errorMsg;
                        hasFailureOccurred = true;
                        break;
                    }
                    long toReleasedSize = spd.getTotalBlockSize();
                    manager.releasePreAllocatedSize(toReleasedSize);
                    alreadyReleasedSize += toReleasedSize;
                    manager.updateCachedBlockIds(appId, shuffleId, spd.getPartitionId(), spd.getBlockList());
                }
                catch (Exception e) {
                    String errorMsg = "Error happened when shuffleEngine.write for " + shuffleDataInfo + ": " + e.getMessage();
                    ret = StatusCode.INTERNAL_ERROR;
                    responseMessage = errorMsg;
                    LOG.error(errorMsg);
                    hasFailureOccurred = true;
                    break;
                }
                finally {
                    if (!hasFailureOccurred) continue;
                    this.shuffleServer.getShuffleBufferManager().releaseMemory(spd.getTotalBlockSize(), false, false);
                }
            }
            if ((long)info.getRequireSize() > alreadyReleasedSize) {
                manager.releasePreAllocatedSize((long)info.getRequireSize() - alreadyReleasedSize);
            }
            reply = RssProtos.SendShuffleDataResponse.newBuilder().setStatus(ret.toProto()).setRetMsg(responseMessage).build();
            long costTime = System.currentTimeMillis() - start;
            this.shuffleServer.getGrpcMetrics().recordProcessTime("sendShuffleData", costTime);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache Shuffle Data for appId[" + appId + "], shuffleId[" + shuffleId + "], cost " + costTime + " ms with " + shufflePartitionedData.size() + " blocks and " + requireSize + " bytes");
            }
        } else {
            reply = RssProtos.SendShuffleDataResponse.newBuilder().setStatus(StatusCode.INTERNAL_ERROR.toProto()).setRetMsg("No data in request").build();
        }
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    public void commitShuffleTask(RssProtos.ShuffleCommitRequest req, StreamObserver<RssProtos.ShuffleCommitResponse> responseObserver) {
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        int commitCount = 0;
        try {
            if (!this.shuffleServer.getShuffleTaskManager().getAppIds().contains(appId)) {
                throw new IllegalStateException("AppId " + appId + " was removed already");
            }
            commitCount = this.shuffleServer.getShuffleTaskManager().updateAndGetCommitCount(appId, shuffleId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Get commitShuffleTask request for appId[" + appId + "], shuffleId[" + shuffleId + "], currentCommitted[" + commitCount + "]");
            }
        }
        catch (Exception e) {
            status = StatusCode.INTERNAL_ERROR;
            msg = "Error happened when commit for appId[" + appId + "], shuffleId[" + shuffleId + "]";
            LOG.error(msg, (Throwable)e);
        }
        RssProtos.ShuffleCommitResponse reply = RssProtos.ShuffleCommitResponse.newBuilder().setCommitCount(commitCount).setStatus(status.toProto()).setRetMsg(msg).build();
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    public void finishShuffle(RssProtos.FinishShuffleRequest req, StreamObserver<RssProtos.FinishShuffleResponse> responseObserver) {
        StatusCode status;
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        String msg = "OK";
        String errorMsg = "Fail to finish shuffle for appId[" + appId + "], shuffleId[" + shuffleId + "], data may be lost";
        try {
            LOG.info("Get finishShuffle request for appId[" + appId + "], shuffleId[" + shuffleId + "]");
            status = this.shuffleServer.getShuffleTaskManager().commitShuffle(appId, shuffleId);
            if (status != StatusCode.SUCCESS) {
                status = StatusCode.INTERNAL_ERROR;
                msg = errorMsg;
            }
        }
        catch (Exception e) {
            status = StatusCode.INTERNAL_ERROR;
            msg = errorMsg;
            LOG.error(errorMsg, (Throwable)e);
        }
        RssProtos.FinishShuffleResponse response = RssProtos.FinishShuffleResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void requireBuffer(RssProtos.RequireBufferRequest request, StreamObserver<RssProtos.RequireBufferResponse> responseObserver) {
        String appId = request.getAppId();
        long requireBufferId = -1L;
        StatusCode status = StatusCode.SUCCESS;
        try {
            requireBufferId = StringUtils.isEmpty((CharSequence)appId) ? this.shuffleServer.getShuffleTaskManager().requireBuffer(request.getRequireSize()) : this.shuffleServer.getShuffleTaskManager().requireBuffer(appId, request.getShuffleId(), request.getPartitionIdsList(), request.getRequireSize());
        }
        catch (NoBufferException e) {
            status = StatusCode.NO_BUFFER;
            ShuffleServerMetrics.counterTotalRequireBufferFailedForRegularPartition.inc();
            ShuffleServerMetrics.counterTotalRequireBufferFailed.inc();
        }
        catch (NoBufferForHugePartitionException e) {
            status = StatusCode.NO_BUFFER_FOR_HUGE_PARTITION;
            ShuffleServerMetrics.counterTotalRequireBufferFailedForHugePartition.inc();
            ShuffleServerMetrics.counterTotalRequireBufferFailed.inc();
        }
        catch (NoRegisterException e) {
            status = StatusCode.NO_REGISTER;
            ShuffleServerMetrics.counterTotalRequireBufferFailed.inc();
        }
        RssProtos.RequireBufferResponse response = RssProtos.RequireBufferResponse.newBuilder().setStatus(status.toProto()).setRequireBufferId(requireBufferId).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void appHeartbeat(RssProtos.AppHeartBeatRequest request, StreamObserver<RssProtos.AppHeartBeatResponse> responseObserver) {
        String appId = request.getAppId();
        this.shuffleServer.getShuffleTaskManager().refreshAppId(appId);
        RssProtos.AppHeartBeatResponse response = RssProtos.AppHeartBeatResponse.newBuilder().setRetMsg("").setStatus(StatusCode.SUCCESS.toProto()).build();
        if (Context.current().isCancelled()) {
            responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
            LOG.warn("Cancelled by client {} for after deadline.", (Object)appId);
            return;
        }
        LOG.info("Get heartbeat from {}", (Object)appId);
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void reportShuffleResult(RssProtos.ReportShuffleResultRequest request, StreamObserver<RssProtos.ReportShuffleResultResponse> responseObserver) {
        String appId = request.getAppId();
        int shuffleId = request.getShuffleId();
        long taskAttemptId = request.getTaskAttemptId();
        int bitmapNum = request.getBitmapNum();
        Map<Integer, long[]> partitionToBlockIds = this.toPartitionBlocksMap(request.getPartitionToBlockIdsList());
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], taskAttemptId[" + taskAttemptId + "]";
        try {
            LOG.info("Report " + partitionToBlockIds.size() + " blocks as shuffle result for the task of " + requestInfo);
            this.shuffleServer.getShuffleTaskManager().addFinishedBlockIds(appId, shuffleId, partitionToBlockIds, bitmapNum);
        }
        catch (Exception e) {
            status = StatusCode.INTERNAL_ERROR;
            msg = "error happened when report shuffle result, check shuffle server for detail";
            LOG.error("Error happened when report shuffle result for " + requestInfo, (Throwable)e);
        }
        RssProtos.ReportShuffleResultResponse reply = RssProtos.ReportShuffleResultResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    public void getShuffleResult(RssProtos.GetShuffleResultRequest request, StreamObserver<RssProtos.GetShuffleResultResponse> responseObserver) {
        String appId = request.getAppId();
        int shuffleId = request.getShuffleId();
        int partitionId = request.getPartitionId();
        BlockIdLayout blockIdLayout = BlockIdLayout.from((int)request.getBlockIdLayout().getSequenceNoBits(), (int)request.getBlockIdLayout().getPartitionIdBits(), (int)request.getBlockIdLayout().getTaskAttemptIdBits());
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        byte[] serializedBlockIds = null;
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
        ByteString serializedBlockIdsBytes = ByteString.EMPTY;
        try {
            serializedBlockIds = this.shuffleServer.getShuffleTaskManager().getFinishedBlockIds(appId, shuffleId, Sets.newHashSet(partitionId), blockIdLayout);
            if (serializedBlockIds == null) {
                status = StatusCode.INTERNAL_ERROR;
                msg = "Can't get shuffle result for " + requestInfo;
                LOG.warn(msg);
            } else {
                serializedBlockIdsBytes = UnsafeByteOperations.unsafeWrap((byte[])serializedBlockIds);
            }
        }
        catch (Exception e) {
            status = StatusCode.INTERNAL_ERROR;
            msg = e.getMessage();
            LOG.error("Error happened when get shuffle result for {}", (Object)requestInfo, (Object)e);
        }
        RssProtos.GetShuffleResultResponse reply = RssProtos.GetShuffleResultResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setSerializedBitmap(serializedBlockIdsBytes).build();
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    public void getShuffleResultForMultiPart(RssProtos.GetShuffleResultForMultiPartRequest request, StreamObserver<RssProtos.GetShuffleResultForMultiPartResponse> responseObserver) {
        String appId = request.getAppId();
        int shuffleId = request.getShuffleId();
        List partitionsList = request.getPartitionsList();
        BlockIdLayout blockIdLayout = BlockIdLayout.from((int)request.getBlockIdLayout().getSequenceNoBits(), (int)request.getBlockIdLayout().getPartitionIdBits(), (int)request.getBlockIdLayout().getTaskAttemptIdBits());
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        byte[] serializedBlockIds = null;
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitions" + partitionsList;
        ByteString serializedBlockIdsBytes = ByteString.EMPTY;
        try {
            serializedBlockIds = this.shuffleServer.getShuffleTaskManager().getFinishedBlockIds(appId, shuffleId, Sets.newHashSet(partitionsList), blockIdLayout);
            if (serializedBlockIds == null) {
                status = StatusCode.INTERNAL_ERROR;
                msg = "Can't get shuffle result for " + requestInfo;
                LOG.warn(msg);
            } else {
                serializedBlockIdsBytes = UnsafeByteOperations.unsafeWrap((byte[])serializedBlockIds);
            }
        }
        catch (Exception e) {
            status = StatusCode.INTERNAL_ERROR;
            msg = e.getMessage();
            LOG.error("Error happened when get shuffle result for {}", (Object)requestInfo, (Object)e);
        }
        RssProtos.GetShuffleResultForMultiPartResponse reply = RssProtos.GetShuffleResultForMultiPartResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setSerializedBitmap(serializedBlockIdsBytes).build();
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLocalShuffleData(RssProtos.GetLocalShuffleDataRequest request, StreamObserver<RssProtos.GetLocalShuffleDataResponse> responseObserver) {
        long transportTime;
        String appId = request.getAppId();
        int shuffleId = request.getShuffleId();
        int partitionId = request.getPartitionId();
        int partitionNumPerRange = request.getPartitionNumPerRange();
        int partitionNum = request.getPartitionNum();
        long offset = request.getOffset();
        int length = request.getLength();
        long timestamp = request.getTimestamp();
        if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
            this.shuffleServer.getGrpcMetrics().recordTransportTime("getLocalShuffleData", transportTime);
        }
        String storageType = ((StorageType)this.shuffleServer.getShuffleServerConf().get(RssBaseConf.RSS_STORAGE_TYPE)).name();
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        RssProtos.GetLocalShuffleDataResponse reply = null;
        ShuffleDataResult sdr = null;
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]offset[" + offset + "]length[" + length + "]";
        int[] range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
        Storage storage = this.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0]));
        if (storage != null) {
            storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId));
        }
        if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(length)) {
            try {
                long start = System.currentTimeMillis();
                sdr = this.shuffleServer.getShuffleTaskManager().getShuffleData(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, storageType, offset, length);
                long readTime = System.currentTimeMillis() - start;
                ShuffleServerMetrics.counterTotalReadTime.inc((double)readTime);
                ShuffleServerMetrics.counterTotalReadDataSize.inc((double)sdr.getDataLength());
                ShuffleServerMetrics.counterTotalReadLocalDataFileSize.inc((double)sdr.getDataLength());
                this.shuffleServer.getGrpcMetrics().recordProcessTime("getLocalShuffleData", readTime);
                LOG.info("Successfully getShuffleData cost {} ms for shuffle data with {}", (Object)readTime, (Object)requestInfo);
                reply = RssProtos.GetLocalShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setData(UnsafeByteOperations.unsafeWrap((byte[])sdr.getData())).build();
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = "Error happened when get shuffle data for " + requestInfo + ", " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                reply = RssProtos.GetLocalShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
            }
            finally {
                if (sdr != null) {
                    sdr.release();
                }
                this.shuffleServer.getShuffleBufferManager().releaseReadMemory(length);
            }
        } else {
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get shuffle data";
            LOG.error(msg + " for " + requestInfo);
            reply = RssProtos.GetLocalShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
        }
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLocalShuffleIndex(RssProtos.GetLocalShuffleIndexRequest request, StreamObserver<RssProtos.GetLocalShuffleIndexResponse> responseObserver) {
        RssProtos.GetLocalShuffleIndexResponse reply;
        String appId = request.getAppId();
        int shuffleId = request.getShuffleId();
        int partitionId = request.getPartitionId();
        int partitionNumPerRange = request.getPartitionNumPerRange();
        int partitionNum = request.getPartitionNum();
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
        int[] range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
        Storage storage = this.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0]));
        if (storage != null) {
            storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId));
        }
        long assumedFileSize = this.shuffleServer.getShuffleServerConf().getLong(ShuffleServerConf.SERVER_SHUFFLE_INDEX_SIZE_HINT);
        if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(assumedFileSize)) {
            ShuffleIndexResult shuffleIndexResult = null;
            try {
                long start = System.currentTimeMillis();
                shuffleIndexResult = this.shuffleServer.getShuffleTaskManager().getShuffleIndex(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum);
                long readTime = System.currentTimeMillis() - start;
                ByteBuffer data = shuffleIndexResult.getIndexData();
                ShuffleServerMetrics.counterTotalReadDataSize.inc((double)data.remaining());
                ShuffleServerMetrics.counterTotalReadLocalIndexFileSize.inc((double)data.remaining());
                RssProtos.GetLocalShuffleIndexResponse.Builder builder = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg);
                LOG.info("Successfully getShuffleIndex cost {} ms for {} bytes with {}", new Object[]{readTime, data.remaining(), requestInfo});
                builder.setIndexData(UnsafeByteOperations.unsafeWrap((ByteBuffer)data));
                builder.setDataFileLen(shuffleIndexResult.getDataFileLen());
                reply = builder.build();
            }
            catch (FileNotFoundException indexFileNotFoundException) {
                LOG.warn("Index file for {} is not found, maybe the data has been flushed to cold storage.", (Object)requestInfo, (Object)indexFileNotFoundException);
                reply = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).build();
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = "Error happened when get shuffle index for " + requestInfo + ", " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                reply = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
            }
            finally {
                if (shuffleIndexResult != null) {
                    shuffleIndexResult.release();
                }
                this.shuffleServer.getShuffleBufferManager().releaseReadMemory(assumedFileSize);
            }
        } else {
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get shuffle index";
            LOG.error(msg + " for " + requestInfo);
            reply = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
        }
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMemoryShuffleData(RssProtos.GetMemoryShuffleDataRequest request, StreamObserver<RssProtos.GetMemoryShuffleDataResponse> responseObserver) {
        RssProtos.GetMemoryShuffleDataResponse reply;
        long transportTime;
        String appId = request.getAppId();
        int shuffleId = request.getShuffleId();
        int partitionId = request.getPartitionId();
        long blockId = request.getLastBlockId();
        int readBufferSize = request.getReadBufferSize();
        long timestamp = request.getTimestamp();
        if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
            this.shuffleServer.getGrpcMetrics().recordTransportTime("getMemoryShuffleData", transportTime);
        }
        long start = System.currentTimeMillis();
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
        if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(readBufferSize)) {
            ShuffleDataResult shuffleDataResult = null;
            try {
                Roaring64NavigableMap expectedTaskIds = null;
                if (request.getSerializedExpectedTaskIdsBitmap() != null && !request.getSerializedExpectedTaskIdsBitmap().isEmpty()) {
                    expectedTaskIds = RssUtils.deserializeBitMap((byte[])request.getSerializedExpectedTaskIdsBitmap().toByteArray());
                }
                shuffleDataResult = this.shuffleServer.getShuffleTaskManager().getInMemoryShuffleData(appId, shuffleId, partitionId, blockId, readBufferSize, expectedTaskIds);
                byte[] data = new byte[]{};
                ArrayList<BufferSegment> bufferSegments = Lists.newArrayList();
                if (shuffleDataResult != null) {
                    data = shuffleDataResult.getData();
                    bufferSegments = shuffleDataResult.getBufferSegments();
                    ShuffleServerMetrics.counterTotalReadDataSize.inc((double)data.length);
                    ShuffleServerMetrics.counterTotalReadMemoryDataSize.inc((double)data.length);
                }
                long costTime = System.currentTimeMillis() - start;
                this.shuffleServer.getGrpcMetrics().recordProcessTime("getMemoryShuffleData", costTime);
                LOG.info("Successfully getInMemoryShuffleData cost {} ms with {} bytes shuffle data for {}", new Object[]{costTime, data.length, requestInfo});
                reply = RssProtos.GetMemoryShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setData(UnsafeByteOperations.unsafeWrap((byte[])data)).addAllShuffleDataBlockSegments(this.toShuffleDataBlockSegments(bufferSegments)).build();
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = "Error happened when get in memory shuffle data for " + requestInfo + ", " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                reply = RssProtos.GetMemoryShuffleDataResponse.newBuilder().setData(UnsafeByteOperations.unsafeWrap((byte[])new byte[0])).addAllShuffleDataBlockSegments(Lists.newArrayList()).setStatus(status.toProto()).setRetMsg(msg).build();
            }
            finally {
                if (shuffleDataResult != null) {
                    shuffleDataResult.release();
                }
                this.shuffleServer.getShuffleBufferManager().releaseReadMemory(readBufferSize);
            }
        } else {
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get in memory shuffle data";
            LOG.error(msg + " for " + requestInfo);
            reply = RssProtos.GetMemoryShuffleDataResponse.newBuilder().setData(UnsafeByteOperations.unsafeWrap((byte[])new byte[0])).addAllShuffleDataBlockSegments(Lists.newArrayList()).setStatus(status.toProto()).setRetMsg(msg).build();
        }
        responseObserver.onNext((Object)reply);
        responseObserver.onCompleted();
    }

    private List<ShufflePartitionedData> toPartitionedData(RssProtos.SendShuffleDataRequest req) {
        ArrayList<ShufflePartitionedData> ret = Lists.newArrayList();
        for (RssProtos.ShuffleData data : req.getShuffleDataList()) {
            ret.add(new ShufflePartitionedData(data.getPartitionId(), this.toPartitionedBlock(data.getBlockList())));
        }
        return ret;
    }

    private ShufflePartitionedBlock[] toPartitionedBlock(List<RssProtos.ShuffleBlock> blocks) {
        if (blocks == null || blocks.size() == 0) {
            return new ShufflePartitionedBlock[0];
        }
        ShufflePartitionedBlock[] ret = new ShufflePartitionedBlock[blocks.size()];
        int i = 0;
        for (RssProtos.ShuffleBlock block : blocks) {
            ByteBuf data = ByteBufUtils.byteStringToByteBuf((ByteString)block.getData());
            ret[i] = new ShufflePartitionedBlock(block.getLength(), block.getUncompressLength(), block.getCrc(), block.getBlockId(), block.getTaskAttemptId(), data);
            ++i;
        }
        return ret;
    }

    private Map<Integer, long[]> toPartitionBlocksMap(List<RssProtos.PartitionToBlockIds> partitionToBlockIds) {
        HashMap<Integer, long[]> result = Maps.newHashMap();
        for (RssProtos.PartitionToBlockIds ptb : partitionToBlockIds) {
            List blockIds = ptb.getBlockIdsList();
            if (blockIds == null || blockIds.isEmpty()) continue;
            long[] array = new long[blockIds.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Long)blockIds.get(i);
            }
            result.put(ptb.getPartitionId(), array);
        }
        return result;
    }

    private List<PartitionRange> toPartitionRanges(List<RssProtos.ShufflePartitionRange> shufflePartitionRanges) {
        ArrayList<PartitionRange> partitionRanges = Lists.newArrayList();
        for (RssProtos.ShufflePartitionRange spr : shufflePartitionRanges) {
            partitionRanges.add(new PartitionRange(spr.getStart(), spr.getEnd()));
        }
        return partitionRanges;
    }

    private List<RssProtos.ShuffleDataBlockSegment> toShuffleDataBlockSegments(List<BufferSegment> bufferSegments) {
        ArrayList<RssProtos.ShuffleDataBlockSegment> shuffleDataBlockSegments = Lists.newArrayList();
        if (bufferSegments != null) {
            for (BufferSegment bs : bufferSegments) {
                shuffleDataBlockSegments.add(RssProtos.ShuffleDataBlockSegment.newBuilder().setBlockId(bs.getBlockId()).setCrc(bs.getCrc()).setOffset((long)bs.getOffset()).setLength(bs.getLength()).setTaskAttemptId(bs.getTaskAttemptId()).setUncompressLength(bs.getUncompressLength()).build());
            }
        }
        return shuffleDataBlockSegments;
    }
}

