/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;

public class ShufflePartitionedBlock {
    private int length;
    private long crc;
    private long blockId;
    private int uncompressLength;
    private ByteBuf data;
    private long taskAttemptId;

    public ShufflePartitionedBlock(int length, int uncompressLength, long crc, long blockId, long taskAttemptId, byte[] data) {
        this.length = length;
        this.crc = crc;
        this.blockId = blockId;
        this.uncompressLength = uncompressLength;
        this.taskAttemptId = taskAttemptId;
        this.data = data == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer((byte[])data);
    }

    public ShufflePartitionedBlock(int length, int uncompressLength, long crc, long blockId, long taskAttemptId, ByteBuf data) {
        this.length = length;
        this.crc = crc;
        this.blockId = blockId;
        this.uncompressLength = uncompressLength;
        this.taskAttemptId = taskAttemptId;
        this.data = data;
    }

    public long getSize() {
        return this.length + 24 + 8;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShufflePartitionedBlock that = (ShufflePartitionedBlock)o;
        return this.length == that.length && this.crc == that.crc && this.blockId == that.blockId && this.data.equals((Object)that.data);
    }

    public int hashCode() {
        return Objects.hash(this.length, this.crc, this.blockId, this.data);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public void setBlockId(long blockId) {
        this.blockId = blockId;
    }

    public ByteBuf getData() {
        return this.data;
    }

    public void setData(ByteBuf data) {
        this.data = data;
    }

    public int getUncompressLength() {
        return this.uncompressLength;
    }

    public long getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public void setTaskAttemptId(long taskAttemptId) {
        this.taskAttemptId = taskAttemptId;
    }

    public String toString() {
        return "ShufflePartitionedBlock{blockId[" + this.blockId + "], length[" + this.length + "], uncompressLength[" + this.uncompressLength + "], crc[" + this.crc + "], taskAttemptId[" + this.taskAttemptId + "]}";
    }
}

