/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.ShuffleHandleInfo;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.SparkVersionUtils;
import org.apache.spark.storage.BlockManagerId;
import org.apache.uniffle.client.api.CoordinatorClient;
import org.apache.uniffle.client.factory.CoordinatorClientFactory;
import org.apache.uniffle.client.factory.ShuffleManagerClientFactory;
import org.apache.uniffle.client.impl.grpc.ShuffleManagerGrpcClient;
import org.apache.uniffle.client.request.RssReportShuffleFetchFailureRequest;
import org.apache.uniffle.client.response.RssReportShuffleFetchFailureResponse;
import org.apache.uniffle.client.util.ClientUtils;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class RssSparkShuffleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RssSparkShuffleUtils.class);
    public static final ClassTag<ShuffleHandleInfo> SHUFFLE_HANDLER_INFO_CLASS_TAG = ClassTag$.MODULE$.apply(ShuffleHandleInfo.class);
    public static final ClassTag<byte[]> BYTE_ARRAY_CLASS_TAG = ClassTag$.MODULE$.apply(byte[].class);

    public static Configuration newHadoopConfiguration(SparkConf sparkConf) {
        SparkHadoopUtil util = new SparkHadoopUtil();
        Configuration conf = util.newConfiguration(sparkConf);
        boolean useOdfs = (Boolean)sparkConf.get(RssSparkConfig.RSS_OZONE_DFS_NAMENODE_ODFS_ENABLE);
        if (useOdfs) {
            int OZONE_PREFIX_LEN = "spark.rss.ozone.".length();
            conf.setBoolean(RssSparkConfig.RSS_OZONE_DFS_NAMENODE_ODFS_ENABLE.key().substring(OZONE_PREFIX_LEN), useOdfs);
            conf.set(RssSparkConfig.RSS_OZONE_FS_HDFS_IMPL.key().substring(OZONE_PREFIX_LEN), (String)sparkConf.get(RssSparkConfig.RSS_OZONE_FS_HDFS_IMPL));
            conf.set(RssSparkConfig.RSS_OZONE_FS_ABSTRACT_FILE_SYSTEM_HDFS_IMPL.key().substring(OZONE_PREFIX_LEN), (String)sparkConf.get(RssSparkConfig.RSS_OZONE_FS_ABSTRACT_FILE_SYSTEM_HDFS_IMPL));
        }
        return conf;
    }

    public static ShuffleManager loadShuffleManager(String name, SparkConf conf, boolean isDriver) throws Exception {
        ShuffleManager instance;
        Class<?> klass = Class.forName(name);
        try {
            Constructor<?> constructor = klass.getConstructor(conf.getClass(), Boolean.TYPE);
            instance = (ShuffleManager)constructor.newInstance(conf, isDriver);
        }
        catch (NoSuchMethodException e) {
            Constructor<?> constructor = klass.getConstructor(conf.getClass());
            instance = (ShuffleManager)constructor.newInstance(conf);
        }
        return instance;
    }

    public static List<CoordinatorClient> createCoordinatorClients(SparkConf sparkConf) {
        String clientType = (String)sparkConf.get(RssSparkConfig.RSS_CLIENT_TYPE);
        String coordinators = (String)sparkConf.get(RssSparkConfig.RSS_COORDINATOR_QUORUM);
        CoordinatorClientFactory coordinatorClientFactory = new CoordinatorClientFactory(ClientType.valueOf(clientType));
        return coordinatorClientFactory.createCoordinatorClient(coordinators);
    }

    public static void applyDynamicClientConf(SparkConf sparkConf, Map<String, String> confItems) {
        if (sparkConf == null) {
            LOG.warn("Spark conf is null");
            return;
        }
        if (confItems == null || confItems.isEmpty()) {
            LOG.warn("Empty conf items");
            return;
        }
        for (Map.Entry<String, String> kv : confItems.entrySet()) {
            String sparkConfKey = kv.getKey();
            if (!sparkConfKey.startsWith("spark.")) {
                sparkConfKey = "spark." + sparkConfKey;
            }
            String confVal = kv.getValue();
            if (sparkConf.contains(sparkConfKey) && !RssSparkConfig.RSS_MANDATORY_CLUSTER_CONF.contains(sparkConfKey)) continue;
            LOG.warn("Use conf dynamic conf {} = {}", (Object)sparkConfKey, (Object)confVal);
            sparkConf.set(sparkConfKey, confVal);
        }
    }

    public static void validateRssClientConf(SparkConf sparkConf) {
        String msgFormat = "%s must be set by the client or fetched from coordinators.";
        if (!sparkConf.contains(RssSparkConfig.RSS_STORAGE_TYPE.key())) {
            String msg = String.format(msgFormat, "Storage type");
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        String storageType = sparkConf.get(RssSparkConfig.RSS_STORAGE_TYPE.key());
        boolean testMode = sparkConf.getBoolean(RssSparkConfig.RSS_TEST_MODE_ENABLE.key(), false);
        ClientUtils.validateTestModeConf(testMode, storageType);
        int retryMax = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_MAX);
        long retryIntervalMax = (Long)sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_INTERVAL_MAX);
        long sendCheckTimeout = (Long)sparkConf.get(RssSparkConfig.RSS_CLIENT_SEND_CHECK_TIMEOUT_MS);
        if (retryIntervalMax * (long)retryMax > sendCheckTimeout) {
            throw new IllegalArgumentException(String.format("%s(%s) * %s(%s) should not bigger than %s(%s)", RssSparkConfig.RSS_CLIENT_RETRY_MAX.key(), retryMax, RssSparkConfig.RSS_CLIENT_RETRY_INTERVAL_MAX.key(), retryIntervalMax, RssSparkConfig.RSS_CLIENT_SEND_CHECK_TIMEOUT_MS.key(), sendCheckTimeout));
        }
    }

    public static Configuration getRemoteStorageHadoopConf(SparkConf sparkConf, RemoteStorageInfo remoteStorageInfo) {
        Configuration readerHadoopConf = RssSparkShuffleUtils.newHadoopConfiguration(sparkConf);
        Map<String, String> shuffleRemoteStorageConf = remoteStorageInfo.getConfItems();
        if (shuffleRemoteStorageConf != null && !shuffleRemoteStorageConf.isEmpty()) {
            for (Map.Entry<String, String> entry : shuffleRemoteStorageConf.entrySet()) {
                readerHadoopConf.set(entry.getKey(), entry.getValue());
            }
        }
        return readerHadoopConf;
    }

    public static Set<String> getAssignmentTags(SparkConf sparkConf) {
        HashSet<String> assignmentTags = new HashSet<String>();
        String rawTags = sparkConf.get(RssSparkConfig.RSS_CLIENT_ASSIGNMENT_TAGS.key(), "");
        if (StringUtils.isNotEmpty((CharSequence)rawTags)) {
            rawTags = rawTags.trim();
            assignmentTags.addAll(Arrays.asList(rawTags.split(",")));
        }
        assignmentTags.add("ss_v4");
        return assignmentTags;
    }

    public static int estimateTaskConcurrency(SparkConf sparkConf) {
        int taskConcurrency;
        double dynamicAllocationFactor = (Double)sparkConf.get(RssSparkConfig.RSS_ESTIMATE_TASK_CONCURRENCY_DYNAMIC_FACTOR);
        if (dynamicAllocationFactor > 1.0 || dynamicAllocationFactor < 0.0) {
            throw new RssException("dynamicAllocationFactor is not valid: " + dynamicAllocationFactor);
        }
        int executorCores = sparkConf.getInt("spark.executor.cores", 1);
        int taskCpus = sparkConf.getInt("spark.task.cpus", 1);
        int taskConcurrencyPerExecutor = Math.floorDiv(executorCores, taskCpus);
        if (!sparkConf.getBoolean("spark.dynamicAllocation.enabled", false)) {
            int executorInstances = sparkConf.getInt("spark.executor.instances", -1);
            taskConcurrency = executorInstances > 0 ? executorInstances * taskConcurrencyPerExecutor : 0;
        } else {
            int maxExecutors = Math.min(sparkConf.getInt("spark.dynamicAllocation.maxExecutors", 0), 10000);
            int minExecutors = sparkConf.getInt("spark.dynamicAllocation.minExecutors", 0);
            taskConcurrency = (int)((double)(maxExecutors - minExecutors) * dynamicAllocationFactor + (double)minExecutors) * taskConcurrencyPerExecutor;
        }
        return taskConcurrency;
    }

    public static int getRequiredShuffleServerNumber(SparkConf sparkConf) {
        boolean enabledEstimateServer = (Boolean)sparkConf.get(RssSparkConfig.RSS_ESTIMATE_SERVER_ASSIGNMENT_ENABLED);
        int requiredShuffleServerNumber = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_ASSIGNMENT_SHUFFLE_SERVER_NUMBER);
        if (!enabledEstimateServer || requiredShuffleServerNumber > 0) {
            return requiredShuffleServerNumber;
        }
        int estimateTaskConcurrency = RssSparkShuffleUtils.estimateTaskConcurrency(sparkConf);
        int taskConcurrencyPerServer = (Integer)sparkConf.get(RssSparkConfig.RSS_ESTIMATE_TASK_CONCURRENCY_PER_SERVER);
        return (int)Math.ceil((double)estimateTaskConcurrency * 1.0 / (double)taskConcurrencyPerServer);
    }

    public static SparkContext getActiveSparkContext() {
        return SparkContext.getOrCreate();
    }

    public static Broadcast<ShuffleHandleInfo> broadcastShuffleHdlInfo(SparkContext sc, int shuffleId, Map<Integer, List<ShuffleServerInfo>> partitionToServers, RemoteStorageInfo storageInfo) {
        ShuffleHandleInfo handleInfo = new ShuffleHandleInfo(shuffleId, partitionToServers, storageInfo);
        return sc.broadcast((Object)handleInfo, SHUFFLE_HANDLER_INFO_CLASS_TAG);
    }

    private static <T> T instantiateFetchFailedException(BlockManagerId dummy, int shuffleId, int mapIndex, int reduceId, Throwable cause) {
        Object instance;
        Class<?> klass;
        String className = FetchFailedException.class.getName();
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RssException(e);
        }
        try {
            instance = klass.getConstructor(dummy.getClass(), Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Throwable.class).newInstance(dummy, shuffleId, mapIndex, mapIndex, reduceId, cause);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            try {
                instance = klass.getConstructor(dummy.getClass(), Integer.TYPE, Integer.TYPE, Integer.TYPE, Throwable.class).newInstance(dummy, shuffleId, mapIndex, reduceId, cause);
            }
            catch (Exception ae) {
                LOG.error("Fail to new instance.", (Throwable)ae);
                throw new RssException(ae);
            }
        }
        return (T)instance;
    }

    public static FetchFailedException createFetchFailedException(int shuffleId, int mapIndex, int reduceId, Throwable cause) {
        String dummyHost = "dummy_host";
        int dummyPort = 9999;
        BlockManagerId dummy = BlockManagerId.apply((String)"exec-dummy", (String)"dummy_host", (int)9999, (Option)Option.empty());
        cause = cause == null ? new Throwable("No cause") : cause;
        return (FetchFailedException)RssSparkShuffleUtils.instantiateFetchFailedException(dummy, shuffleId, mapIndex, reduceId, cause);
    }

    public static boolean isStageResubmitSupported() {
        return SparkVersionUtils.isSpark3() || SparkVersionUtils.isSpark2() && SparkVersionUtils.MINOR_VERSION >= 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RssException reportRssFetchFailedException(RssFetchFailedException rssFetchFailedException, SparkConf sparkConf, String appId, int shuffleId, int stageAttemptId, Set<Integer> failedPartitions) {
        RssConf rssConf = RssSparkConfig.toRssConf(sparkConf);
        if (!rssConf.getBoolean("rss.resubmit.stage", false)) return rssFetchFailedException;
        if (!RssSparkShuffleUtils.isStageResubmitSupported()) return rssFetchFailedException;
        String driver = rssConf.getString("driver.host", "");
        int port = rssConf.get(RssClientConf.SHUFFLE_MANAGER_GRPC_PORT);
        try (ShuffleManagerGrpcClient client = ShuffleManagerClientFactory.getInstance().createShuffleManagerClient(ClientType.GRPC, driver, port);){
            int partitionId;
            RssReportShuffleFetchFailureRequest req;
            RssReportShuffleFetchFailureResponse response;
            Iterator<Integer> iterator = failedPartitions.iterator();
            do {
                if (!iterator.hasNext()) return rssFetchFailedException;
            } while (!(response = client.reportShuffleFetchFailure(req = new RssReportShuffleFetchFailureRequest(appId, shuffleId, stageAttemptId, partitionId = iterator.next().intValue(), rssFetchFailedException.getMessage()))).getReSubmitWholeStage());
            FetchFailedException ffe = RssSparkShuffleUtils.createFetchFailedException(shuffleId, -1, partitionId, rssFetchFailedException);
            RssException rssException = new RssException((Throwable)ffe);
            return rssException;
        }
        catch (IOException ioe) {
            LOG.info("Error closing shuffle manager client with error:", (Throwable)ioe);
        }
        return rssFetchFailedException;
    }
}

