/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.apache.uniffle.common.netty.buffer.FileSegmentManagedBuffer;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.netty.protocol.Transferable;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;

public class GetLocalShuffleDataResponse
extends RpcResponse
implements Transferable {
    private ManagedBuffer buffer;

    public GetLocalShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, ManagedBuffer data) {
        super(requestId, statusCode, retMessage);
        this.buffer = data;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 4 + this.buffer.size();
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        if (this.buffer instanceof FileSegmentManagedBuffer) {
            buf.writeInt(this.buffer.size());
        } else {
            ByteBufUtils.copyByteBuf(this.buffer.byteBuf(), buf);
            this.buffer.release();
        }
    }

    public static GetLocalShuffleDataResponse decode(ByteBuf byteBuf) {
        long requestId = byteBuf.readLong();
        StatusCode statusCode = StatusCode.fromCode(byteBuf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(byteBuf);
        ByteBuf data = ByteBufUtils.readSlice(byteBuf);
        return new GetLocalShuffleDataResponse(requestId, statusCode, retMessage, new NettyManagedBuffer(data));
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_DATA_RESPONSE;
    }

    public ManagedBuffer getBuffer() {
        return this.buffer;
    }

    public Object getData() {
        return this.buffer.convertToNetty();
    }

    @Override
    public void transferTo(Channel channel) {
        channel.write(this.buffer.convertToNetty());
        this.buffer.release();
    }
}

