/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;

public class ChecksumUtils {
    private static final int LENGTH_PER_CRC = 4096;

    public static long getCrc32(byte[] buf) {
        return ChecksumUtils.getCrc32(buf, 0, buf.length);
    }

    public static long getCrc32(byte[] buf, int offset, int length) {
        int len;
        CRC32 crc32 = new CRC32();
        for (int i = 0; i < length; i += len) {
            len = Math.min(4096, length - i);
            crc32.update(buf, i + offset, len);
        }
        return crc32.getValue();
    }

    public static long getCrc32(ByteBuffer byteBuffer) {
        return ChecksumUtils.getCrc32(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    public static long getCrc32(ByteBuffer byteBuffer, int offset, int length) {
        int len;
        CRC32 crc32 = new CRC32();
        ByteBuffer crcBuffer = byteBuffer.duplicate();
        crcBuffer.position(offset);
        for (int i = 0; i < length; i += len) {
            len = Math.min(4096, length - i);
            crcBuffer.limit(crcBuffer.position() + len);
            crc32.update(crcBuffer);
        }
        return crc32.getValue();
    }
}

