/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uniffle.com.google.common.util.concurrent.SettableFuture;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.netty.client.RpcResponseCallback;
import org.apache.uniffle.common.netty.handle.TransportResponseHandler;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.io.netty.channel.Channel;
import org.apache.uniffle.io.netty.channel.ChannelFuture;
import org.apache.uniffle.io.netty.util.concurrent.Future;
import org.apache.uniffle.io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransportClient.class);
    private Channel channel;
    private TransportResponseHandler handler;
    private volatile boolean timedOut;
    private static final AtomicLong counter = new AtomicLong();

    public TransportClient(Channel channel, TransportResponseHandler handler) {
        this.channel = Objects.requireNonNull(channel);
        this.handler = Objects.requireNonNull(handler);
        this.timedOut = false;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isActive() {
        return !this.timedOut && (this.channel.isOpen() || this.channel.isActive());
    }

    public SocketAddress getSocketAddress() {
        return this.channel.remoteAddress();
    }

    public ChannelFuture sendRpc(Message message, RpcResponseCallback callback) {
        if (logger.isTraceEnabled()) {
            logger.trace("Pushing data to {}", (Object)NettyUtils.getRemoteAddress(this.channel));
        }
        long requestId = message.getRequestId();
        this.handler.addResponseCallback(requestId, callback);
        RpcChannelListener listener = new RpcChannelListener(requestId, callback);
        return this.channel.writeAndFlush(message).addListener(listener);
    }

    public RpcResponse sendRpcSync(Message message, long timeoutMs) {
        final SettableFuture result = SettableFuture.create();
        RpcResponseCallback callback = new RpcResponseCallback(){

            @Override
            public void onSuccess(RpcResponse response) {
                result.set(response);
            }

            @Override
            public void onFailure(Throwable e) {
                result.setException(e);
            }
        };
        this.sendRpc(message, callback);
        try {
            return (RpcResponse)result.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RssException(e);
        }
    }

    public static long requestId() {
        return counter.getAndIncrement();
    }

    @Override
    public void close() throws IOException {
        this.channel.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
    }

    public void timeOut() {
        this.timedOut = true;
    }

    private class RpcChannelListener
    extends StdChannelListener {
        final long rpcRequestId;
        final RpcResponseCallback callback;

        RpcChannelListener(long rpcRequestId, RpcResponseCallback callback) {
            super("RPC " + rpcRequestId);
            this.rpcRequestId = rpcRequestId;
            this.callback = callback;
        }

        @Override
        protected void handleFailure(String errorMsg, Throwable cause) {
            TransportClient.this.handler.removeRpcRequest(this.rpcRequestId);
            this.callback.onFailure(new IOException(errorMsg, cause));
        }
    }

    public class StdChannelListener
    implements GenericFutureListener<Future<? super Void>> {
        final long startTime = System.currentTimeMillis();
        final Object requestId;

        public StdChannelListener(Object requestId) {
            this.requestId = requestId;
        }

        @Override
        public void operationComplete(Future<? super Void> future) throws Exception {
            if (future.isSuccess()) {
                if (logger.isTraceEnabled()) {
                    long timeTaken = System.currentTimeMillis() - this.startTime;
                    logger.trace("Sending request {} to {} took {} ms", new Object[]{this.requestId, NettyUtils.getRemoteAddress(TransportClient.this.channel), timeTaken});
                }
            } else {
                String errorMsg = String.format("Failed to send request %s to %s: %s, channel will be closed", this.requestId, NettyUtils.getRemoteAddress(TransportClient.this.channel), future.cause());
                logger.warn(errorMsg);
                TransportClient.this.channel.close();
                try {
                    this.handleFailure(errorMsg, future.cause());
                }
                catch (Exception e) {
                    logger.error("Uncaught exception in RPC response callback handler!", (Throwable)e);
                }
            }
        }

        protected void handleFailure(String errorMsg, Throwable cause) {
            logger.error("Error encountered " + errorMsg, cause);
        }
    }
}

