/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.uniffle.CustomCommandLine;
import org.apache.uniffle.UniffleCliArgsException;
import org.apache.uniffle.client.UniffleRestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCustomCommandLine
implements CustomCommandLine {
    protected final Option coordinatorHost = new Option("host", "coordinatorHost", true, "This is coordinator server host.");
    protected final Option coordinatorPort = new Option("port", "coordinatorPort", true, "This is coordinator server port.");
    protected final Option ssl = new Option(null, "ssl", false, "use SSL");
    protected UniffleRestClient client;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCustomCommandLine.class);

    protected void printUsage() {
        System.out.println("Usage:");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(200);
        formatter.setLeftPadding(5);
        formatter.setSyntaxPrefix("   Optional");
        Options options = new Options();
        this.addGeneralOptions(options);
        this.addRunOptions(options);
        formatter.printHelp(" ", options);
    }

    public static int handleCliArgsException(UniffleCliArgsException e, Logger logger) {
        logger.error("Could not parse the command line arguments.", (Throwable)e);
        System.out.println(e.getMessage());
        System.out.println();
        System.out.println("Use the help option (-h or --help) to get help on the command.");
        return 1;
    }

    public static int handleError(Throwable t, Logger logger) {
        logger.error("Error while running the Uniffle Command.", t);
        System.err.println();
        System.err.println("------------------------------------------------------------");
        System.err.println(" The program finished with the following exception:");
        System.err.println();
        t.printStackTrace();
        return 1;
    }

    public static CommandLine parse(Options options, String[] args, boolean stopAtNonOptions) throws UniffleCliArgsException {
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args, stopAtNonOptions);
        }
        catch (ParseException e) {
            throw new UniffleCliArgsException(e.getMessage());
        }
    }

    public CommandLine parseCommandLineOptions(String[] args, boolean stopAtNonOptions) throws UniffleCliArgsException {
        Options options = new Options();
        this.addGeneralOptions(options);
        this.addRunOptions(options);
        return AbstractCustomCommandLine.parse(options, args, stopAtNonOptions);
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        baseOptions.addOption(this.coordinatorHost);
        baseOptions.addOption(this.coordinatorPort);
        baseOptions.addOption(this.ssl);
    }

    protected void getUniffleRestClient(CommandLine cmd) {
        String host = cmd.getOptionValue(this.coordinatorHost.getOpt()).trim();
        int port = Integer.parseInt(cmd.getOptionValue(this.coordinatorPort.getOpt()).trim());
        System.out.println("host:" + host + ",port:" + port);
        String hostUrl = cmd.hasOption(this.ssl.getLongOpt()) ? String.format("https://%s:%d", host, port) : String.format("http://%s:%d", host, port);
        LOG.info("connected to coordinator: {}.", (Object)hostUrl);
        this.client = UniffleRestClient.builder(hostUrl).build();
    }
}

