/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.partition;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.strategy.partition.SelectPartitionStrategy;
import org.apache.uniffle.coordinator.util.CoordinatorUtils;
import org.apache.uniffle.guava.collect.Lists;

public class RoundSelectPartitionStrategy
implements SelectPartitionStrategy {
    @Override
    public SortedMap<PartitionRange, List<ServerNode>> assign(int totalPartitionNum, int partitionNumPerRange, int replica, List<ServerNode> candidatesNodes, int estimateTaskConcurrency) {
        TreeMap<PartitionRange, List<ServerNode>> assignments = new TreeMap<PartitionRange, List<ServerNode>>();
        int idx = 0;
        List<PartitionRange> ranges = CoordinatorUtils.generateRanges(totalPartitionNum, partitionNumPerRange);
        for (PartitionRange range : ranges) {
            ArrayList<ServerNode> assignNodes = Lists.newArrayList();
            for (int rc = 0; rc < replica; ++rc) {
                ServerNode node = candidatesNodes.get(idx);
                idx = CoordinatorUtils.nextIdx(idx, candidatesNodes.size());
                assignNodes.add(node);
            }
            assignments.put(range, assignNodes);
        }
        return assignments;
    }
}

